/*
 * Decompiled with CFR 0.152.
 */
package com.alet.client.gui;

import com.alet.ALET;
import com.alet.client.gui.controls.GuiDepressedCheckBox;
import com.alet.client.gui.controls.GuiGlyphSelector;
import com.alet.client.gui.controls.GuiLongTextField;
import com.alet.client.gui.controls.Layer;
import com.alet.client.gui.controls.tutorial.GuiTutorialBox;
import com.alet.client.gui.controls.tutorial.TutorialData;
import com.alet.client.gui.message.SubGuiNoTextInFieldMessage;
import com.alet.common.packet.PacketUpdateStructureFromClient;
import com.alet.common.structure.type.premade.LittleTypeWriter;
import com.alet.common.utils.CopyUtils;
import com.alet.common.utils.photo.PhotoReader;
import com.alet.font.FontReader;
import com.alet.littletiles.gui.controls.GuiAnimationViewerAlet;
import com.alet.littletiles.gui.controls.GuiColorPickerAlet;
import com.creativemd.creativecore.common.gui.CoreControl;
import com.creativemd.creativecore.common.gui.container.SubGui;
import com.creativemd.creativecore.common.gui.controls.gui.GuiAnalogeSlider;
import com.creativemd.creativecore.common.gui.controls.gui.GuiButton;
import com.creativemd.creativecore.common.gui.controls.gui.GuiCheckBox;
import com.creativemd.creativecore.common.gui.controls.gui.GuiComboBox;
import com.creativemd.creativecore.common.gui.controls.gui.GuiComboBoxExtension;
import com.creativemd.creativecore.common.gui.controls.gui.GuiTextfield;
import com.creativemd.creativecore.common.gui.event.gui.GuiControlChangedEvent;
import com.creativemd.creativecore.common.packet.CreativeCorePacket;
import com.creativemd.creativecore.common.packet.PacketHandler;
import com.creativemd.creativecore.common.utils.mc.ColorUtils;
import com.creativemd.littletiles.LittleTiles;
import com.creativemd.littletiles.common.entity.AnimationPreview;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.util.grid.LittleGridContext;
import com.n247s.api.eventapi.eventsystem.CustomEventSubscribe;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.font.TextAttribute;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;
import org.lwjgl.util.Color;

public class SubGuiTypeWriter
extends SubGui {
    public static List<String> names = ALET.fontTypeNames;
    public Map<TextAttribute, Object> textAttributeMap = new HashMap<TextAttribute, Object>();
    public LittleStructure structure;
    public int BLACK = -16777216;
    public GuiCheckBox keepAspect = null;
    public GuiTextfield imgHeight = null;
    public GuiTextfield imgWidth = null;
    public NBTTagCompound nbt = new NBTTagCompound();
    public double aspectRatio = 0.0;

    public SubGuiTypeWriter(LittleStructure structure) {
        super(422, 190);
        this.structure = structure;
    }

    public void openedGui() {
        LittleTypeWriter typeWriter = (LittleTypeWriter)this.structure;
        typeWriter.writeToNBT(this.nbt);
        if (this.nbt.func_74764_b("font")) {
            GuiComboBox fontBox = (GuiComboBox)this.get("fontType");
            fontBox.select(this.nbt.func_74779_i("font"));
        }
        if (this.nbt.func_74764_b("fontSize")) {
            GuiTextfield fontSize = (GuiTextfield)this.get("fontSize");
            fontSize.text = this.nbt.func_74779_i("fontSize");
        }
        if (this.nbt.func_74764_b("color")) {
            GuiColorPickerAlet picker = (GuiColorPickerAlet)this.get("picker");
            picker.setColor(ColorUtils.IntToRGBA((int)this.nbt.func_74762_e("color")));
        }
        if (this.nbt.func_74764_b("grid")) {
            GuiComboBox gridBox = (GuiComboBox)this.get("grid");
            gridBox.select(this.nbt.func_74779_i("grid"));
        }
        if (this.nbt.func_74764_b("rotation")) {
            GuiAnalogeSlider rotation = (GuiAnalogeSlider)this.get("rotation");
            rotation.value = this.nbt.func_74769_h("rotation");
        }
        if (this.nbt.func_74764_b("italic")) {
            GuiDepressedCheckBox italic = (GuiDepressedCheckBox)this.get("italic");
            italic.value = this.nbt.func_74767_n("italic");
            if (italic.value) {
                this.textAttributeMap.put(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE);
            } else {
                this.textAttributeMap.remove(TextAttribute.POSTURE);
            }
        }
        if (this.nbt.func_74764_b("bold")) {
            GuiDepressedCheckBox bold = (GuiDepressedCheckBox)this.get("bold");
            bold.value = this.nbt.func_74767_n("bold");
            if (bold.value) {
                this.textAttributeMap.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
            } else {
                this.textAttributeMap.remove(TextAttribute.WEIGHT);
            }
        }
        if (this.nbt.func_74764_b("underline")) {
            GuiDepressedCheckBox underline = (GuiDepressedCheckBox)this.get("underline");
            underline.value = this.nbt.func_74767_n("underline");
            if (underline.value) {
                this.textAttributeMap.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
            } else {
                this.textAttributeMap.remove(TextAttribute.UNDERLINE);
            }
        }
        if (this.nbt.func_74764_b("strikethrough")) {
            GuiDepressedCheckBox strikethrough = (GuiDepressedCheckBox)this.get("strikethrough");
            strikethrough.value = this.nbt.func_74767_n("strikethrough");
            if (strikethrough.value) {
                this.textAttributeMap.put(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON);
            } else {
                this.textAttributeMap.remove(TextAttribute.STRIKETHROUGH);
            }
        }
    }

    public void onClosed() {
        GuiColorPickerAlet picker = (GuiColorPickerAlet)this.get("picker");
        GuiTextfield fontSize = (GuiTextfield)this.get("fontSize");
        GuiComboBox fontBox = (GuiComboBox)this.get("fontType");
        GuiComboBox gridBox = (GuiComboBox)this.get("grid");
        GuiAnalogeSlider rotation = (GuiAnalogeSlider)this.get("rotation");
        GuiDepressedCheckBox italic = (GuiDepressedCheckBox)this.get("italic");
        GuiDepressedCheckBox bold = (GuiDepressedCheckBox)this.get("bold");
        GuiDepressedCheckBox underline = (GuiDepressedCheckBox)this.get("underline");
        GuiDepressedCheckBox strikethrough = (GuiDepressedCheckBox)this.get("strikethrough");
        LittleTypeWriter typeWriter = (LittleTypeWriter)this.structure;
        this.nbt.func_74778_a("font", fontBox.getCaption());
        this.nbt.func_74778_a("fontSize", fontSize.text);
        this.nbt.func_74768_a("color", ColorUtils.RGBAToInt((Color)picker.color));
        this.nbt.func_74778_a("grid", gridBox.getCaption());
        this.nbt.func_74780_a("rotation", rotation.value);
        this.nbt.func_74757_a("italic", italic.value);
        this.nbt.func_74757_a("bold", bold.value);
        this.nbt.func_74757_a("underline", underline.value);
        this.nbt.func_74757_a("strikethrough", strikethrough.value);
        PacketHandler.sendPacketToServer((CreativeCorePacket)new PacketUpdateStructureFromClient(typeWriter.getStructureLocation(), this.nbt));
        super.onClosed();
    }

    public void createControls() {
        LittleTypeWriter typeWriter = (LittleTypeWriter)this.structure;
        typeWriter.writeToNBT(this.nbt);
        Color color = ColorUtils.IntToRGBA((int)this.BLACK);
        if (this.nbt.func_74764_b("color")) {
            color = ColorUtils.IntToRGBA((int)this.nbt.func_74762_e("color"));
        }
        final GuiAnimationViewerAlet viewer = new GuiAnimationViewerAlet("renderer", 280, 0, 136, 135);
        this.controls.add(viewer);
        viewer.moveViewPort(0, 50);
        this.imgWidth = new GuiTextfield("imgWidth", "0", 347, 170, 30, 14);
        this.imgWidth.setCustomTooltip(new String[]{"Width Of Image"});
        this.imgWidth.setNumbersOnly();
        this.controls.add(this.imgWidth);
        this.imgHeight = new GuiTextfield("imgHeight", "0", 386, 170, 30, 14);
        this.imgHeight.setCustomTooltip(new String[]{"Height Of Image"});
        this.imgHeight.setNumbersOnly();
        this.controls.add(this.imgHeight);
        this.controls.add(new GuiDepressedCheckBox("italic", "I", 140, 44, 19, 19, TextFormatting.ITALIC + "", false));
        this.controls.add(new GuiDepressedCheckBox("bold", "B", 160, 44, 19, 19, TextFormatting.BOLD + "", false));
        this.controls.add(new GuiDepressedCheckBox("underline", "U", 180, 44, 19, 19, TextFormatting.UNDERLINE + "", false));
        this.controls.add(new GuiDepressedCheckBox("strikethrough", "S", 200, 44, 19, 19, TextFormatting.STRIKETHROUGH + "", false));
        this.controls.add(new GuiColorPickerAlet("picker", -2, 42, color, LittleTiles.CONFIG.isTransparencyEnabled(this.getPlayer()), LittleTiles.CONFIG.getMinimumTransparency(this.getPlayer())));
        this.controls.add(new GuiComboBox("grid", 256, 0, 15, LittleGridContext.getNames()){

            protected GuiComboBoxExtension createBox() {
                return new GuiComboBoxExtension(this.name + "extension", (GuiComboBox)this, this.posX, this.posY + this.height, 30 - this.getContentOffset() * 2, 100, this.lines);
            }
        });
        GuiTextfield fontSize = new GuiTextfield("fontSize", "48", 229, 0, 20, 14);
        this.controls.add(fontSize);
        this.controls.add(new GuiLongTextField("input", "", 0, 21, 271, 15));
        this.controls.add(new GuiTextfield("search", "", 0, 0, 115, 14){

            public boolean onKeyPressed(char character, int key) {
                boolean result = super.onKeyPressed(character, key);
                if (!result) {
                    return result;
                }
                GuiComboBox fontType = (GuiComboBox)SubGuiTypeWriter.this.get("fontType");
                ArrayList<String> foundFonts = new ArrayList<String>();
                for (int i = 0; i < ALET.fontTypeNames.size(); ++i) {
                    if (!ALET.fontTypeNames.get(i).toLowerCase().contains(this.text.toLowerCase())) continue;
                    foundFonts.add(ALET.fontTypeNames.get(i));
                }
                if (!foundFonts.isEmpty()) {
                    fontType.lines = foundFonts;
                    int index = ALET.fontTypeNames.indexOf(foundFonts.get(0));
                    fontType.select(ALET.fontTypeNames.get(index));
                }
                return result;
            }
        });
        GuiTextfield fontSearch = (GuiTextfield)this.get("search");
        fontSearch.setCustomTooltip(new String[]{"Search for Font"});
        this.controls.add(new GuiComboBox("fontType", 122, 0, 100, ALET.fontTypeNames){

            protected GuiComboBoxExtension createBox() {
                GuiComboBoxExtension extend = new GuiComboBoxExtension(this.name + "extension", (GuiComboBox)this, this.posX, this.posY + this.height, 200 - this.getContentOffset() * 2, 100, this.lines);
                extend.scrolled.set((double)(15 * this.index));
                return extend;
            }
        });
        GuiComboBox fontCombo = (GuiComboBox)this.get("fontType");
        fontCombo.setCustomTooltip(new String[]{"Font"});
        this.controls.add(new GuiAnalogeSlider("rotation", 0, 96, 150, 10, 0.0, 0.0, 360.0));
        this.controls.add(new GuiButton("refresh", "Refresh Preview", 326, 145, 90){

            public void onClicked(int x, int y, int button) {
                GuiLongTextField input = (GuiLongTextField)SubGuiTypeWriter.this.get("input");
                if (input.text.equals("")) {
                    Layer.addLayer(this.getGui(), new SubGuiNoTextInFieldMessage("for the text that will be exported", "digit(s) and or character(s)"));
                } else {
                    GuiColorPickerAlet picker = (GuiColorPickerAlet)SubGuiTypeWriter.this.get("picker");
                    int color = ColorUtils.RGBAToInt((Color)picker.color);
                    GuiTextfield contextField = (GuiTextfield)SubGuiTypeWriter.this.get("fontSize");
                    int fontSize = Integer.parseInt(contextField.text);
                    GuiComboBox contextBox = (GuiComboBox)SubGuiTypeWriter.this.get("fontType");
                    String font = contextBox.getCaption();
                    GuiComboBox contextBox_2 = (GuiComboBox)SubGuiTypeWriter.this.get("grid");
                    int grid = Integer.parseInt(contextBox_2.getCaption());
                    GuiAnalogeSlider rotation = (GuiAnalogeSlider)SubGuiTypeWriter.this.get("rotation");
                    try {
                        PhotoReader.setScale(Integer.parseInt(SubGuiTypeWriter.this.imgWidth.text), Integer.parseInt(SubGuiTypeWriter.this.imgHeight.text));
                        viewer.onLoaded(new AnimationPreview(FontReader.photoToPreviews(input.text, font, SubGuiTypeWriter.this.textAttributeMap, grid, fontSize, color, rotation.value)));
                    }
                    catch (IOException | NullPointerException exception) {
                        // empty catch block
                    }
                }
            }
        });
        this.controls.add(new GuiButton("Paste", "Paste", 221, 43, 50){

            public void onClicked(int x, int y, int button) {
                GuiLongTextField input = (GuiLongTextField)SubGuiTypeWriter.this.get("input");
                StringSelection stringSelection = new StringSelection(input.text);
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                String path = CopyUtils.getCopiedFilePath(clipboard);
                if (path == null) {
                    return;
                }
                try {
                    input.text = path;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        GuiComboBox contextBox = (GuiComboBox)this.get("fontType");
        String font = contextBox.getCaption();
        GuiAnalogeSlider rotation = (GuiAnalogeSlider)this.get("rotation");
        this.controls.add(new GuiGlyphSelector("glyph", font, this.textAttributeMap, 165, 85, 106));
        this.controls.add(new GuiButton("Print", 243, 64, 28){

            public void onClicked(int x, int y, int button) {
                GuiLongTextField input = (GuiLongTextField)SubGuiTypeWriter.this.get("input");
                if (input.text.equals("")) {
                    Layer.addLayer(this.getGui(), new SubGuiNoTextInFieldMessage("for the text that will be exported", "digit(s) and or character(s)"));
                } else {
                    GuiColorPickerAlet picker = (GuiColorPickerAlet)SubGuiTypeWriter.this.get("picker");
                    int color = ColorUtils.RGBAToInt((Color)picker.color);
                    GuiTextfield contextField = (GuiTextfield)SubGuiTypeWriter.this.get("fontSize");
                    int fontSize = Integer.parseInt(contextField.text);
                    GuiComboBox contextBox = (GuiComboBox)SubGuiTypeWriter.this.get("fontType");
                    String font = contextBox.getCaption();
                    GuiComboBox contextBox_2 = (GuiComboBox)SubGuiTypeWriter.this.get("grid");
                    int grid = Integer.parseInt(contextBox_2.getCaption());
                    GuiAnalogeSlider rotation = (GuiAnalogeSlider)SubGuiTypeWriter.this.get("rotation");
                    try {
                        PhotoReader.setScale(Integer.parseInt(SubGuiTypeWriter.this.imgWidth.text), Integer.parseInt(SubGuiTypeWriter.this.imgHeight.text));
                        NBTTagCompound nbt = FontReader.photoToNBT(input.text, font, SubGuiTypeWriter.this.textAttributeMap, grid, fontSize, color, rotation.value);
                        if (nbt != null) {
                            SubGuiTypeWriter.this.sendPacketToServer(nbt);
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        });
        GuiTutorialBox boxx = new GuiTutorialBox("ih", -110, 0, 180, this.width, this.height);
        GuiColorPickerAlet picker = (GuiColorPickerAlet)this.get("picker");
        boxx.tutorialMap.add(new TutorialData(this.get("fontType"), "right", "Clicking on this will open a dropdown menu that lets you select the type of font your text will print with. You can add custom font(s) by going to your Minecraft directory, the same place you add mods too, and look for a folder called Fonts."));
        boxx.tutorialMap.add(new TutorialData(this.get("fontType"), "right", "The readme.txt file inside will explain further on how to bring your new fonts into the game."));
        boxx.tutorialMap.add(new TutorialData(this.get("search"), "right", "This is the search text field. It allows you to search for specific font(s)."));
        boxx.tutorialMap.add(new TutorialData(this.get("fontSize"), "right", "This is the font size text field. It allows you to change the font size that your text will print in."));
        boxx.tutorialMap.add(new TutorialData(this.get("grid"), "right", "This is the grid drop down menu. Clicking on this will open a dropdown menu that allows you to change the grid size that your text will print with."));
        boxx.tutorialMap.add(new TutorialData(this.get("grid"), "right", "The grid size is how small or large each tile will be. Grid 8 is 1/8th the size of a block. Grid 16 is 1/16th the size of a block. Grid 32 is 1/32nd the size of a block and so on."));
        boxx.tutorialMap.add(new TutorialData(this.get("input"), "right", "This is the input text field where you type whatever text you want to print."));
        boxx.tutorialMap.add(new TutorialData(this.get("Paste"), "right", "This is the paste button. It will allow you to paste text into the text field that you have copied."));
        boxx.tutorialMap.add(new TutorialData(this.get("glyph"), "right", "This is the glyph drop down menu. Clicking on this will open a dropdown menu that displays all glyphs (or characters) that the font you have selected has. You can click on the glyphs to add it into the input text field. However, some glyphs are unusable, such as Wingding."));
        boxx.tutorialMap.add(new TutorialData(this.get("italic"), "right", "This is the italic button. Clicking on this will cause the text to print with the italic attribute."));
        boxx.tutorialMap.add(new TutorialData(this.get("bold"), "right", "This is the bold button. Clicking on this will cause the text to print with the bold attribute."));
        boxx.tutorialMap.add(new TutorialData(this.get("underline"), "right", "This is the underline button. Clicking on this will cause the text to print with the underline attribute."));
        boxx.tutorialMap.add(new TutorialData(this.get("strikethrough"), "right", "This is the strikethrough button. Clicking on this will cause the text to print with the strikethrough attribute."));
        boxx.tutorialMap.add(new TutorialData(this.get("rotation"), "right", "This is the rotation slider. You can click and drag to change the roation of the text."));
        boxx.tutorialMap.add(new TutorialData(this.get("picker"), "right", "This is the color picker. With it you can set the color your font will print in."));
        boxx.tutorialMap.add(new TutorialData(this.get("picker"), "right", "Each color slider can go from 0 to 255. To change the value:            -You can use the arrows on either side of the sliders.            -You can click and drag on a slider. -You can right click a slider and enter a value manualy."));
        boxx.tutorialMap.add(new TutorialData(picker.get("r"), "right", "This is the red color slider."));
        boxx.tutorialMap.add(new TutorialData(picker.get("g"), "right", "This is the green color slider."));
        boxx.tutorialMap.add(new TutorialData(picker.get("b"), "right", "This is the blue color slider."));
        boxx.tutorialMap.add(new TutorialData(picker.get("a"), "right", "This is the alpha slider. How transparent the color is."));
        boxx.tutorialMap.add(new TutorialData(picker.get("s"), "right", "This is the shader slider. It allows you to easly change how dark or light a color is."));
        boxx.tutorialMap.add(new TutorialData(picker.get("more"), "right", "Click on this to open the color palette. It allows you to save your currently selected color for later use."));
        boxx.tutorialMap.add(new TutorialData(this.get("imgWidth"), "left", "This is the width text field. It will display how many tiles the structure's width will be. You can also change the value."));
        boxx.tutorialMap.add(new TutorialData(this.get("imgHeight"), "left", "This is the height text field. It will display how many tiles the structure's height will be. You can also change the value."));
        boxx.tutorialMap.add(new TutorialData(this.get("renderer"), "left", "This is the preview viewer. Here you can view what the structure will look like before placing it into the world."));
        boxx.tutorialMap.add(new TutorialData(this.get("refresh"), "left", "This is the refresh button. Click on this to update the preview in the preview viewer."));
        boxx.tutorialMap.add(new TutorialData(this.get("Print"), "left", "This is the print button. Click on this to print your structure."));
        this.controls.add(boxx);
        this.moveControlToTop((CoreControl)this.get("ih"));
        this.openedGui();
    }

    @CustomEventSubscribe
    public void onChanged(GuiControlChangedEvent event) {
        GuiDepressedCheckBox box;
        GuiComboBox contextBox = (GuiComboBox)this.get("fontType");
        String font = contextBox.getCaption();
        GuiGlyphSelector na = (GuiGlyphSelector)this.get("glyph");
        na.fontr = font;
        if (event.source.is(new String[]{"italic"})) {
            box = (GuiDepressedCheckBox)event.source;
            if (box.value) {
                this.textAttributeMap.put(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE);
            } else {
                this.textAttributeMap.remove(TextAttribute.POSTURE);
            }
        } else if (event.source.is(new String[]{"bold"})) {
            box = (GuiDepressedCheckBox)event.source;
            if (box.value) {
                this.textAttributeMap.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
            } else {
                this.textAttributeMap.remove(TextAttribute.WEIGHT);
            }
        } else if (event.source.is(new String[]{"underline"})) {
            box = (GuiDepressedCheckBox)event.source;
            if (box.value) {
                this.textAttributeMap.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
            } else {
                this.textAttributeMap.remove(TextAttribute.UNDERLINE);
            }
        } else if (event.source.is(new String[]{"strikethrough"})) {
            box = (GuiDepressedCheckBox)event.source;
            if (box.value) {
                this.textAttributeMap.put(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON);
            } else {
                this.textAttributeMap.remove(TextAttribute.STRIKETHROUGH);
            }
        }
        if (event.source.is(new String[]{"searchBar"})) {
            this.refreshControls();
        } else if (event.source.is(new String[]{"input"}) || event.source instanceof GuiDepressedCheckBox) {
            GuiLongTextField text = (GuiLongTextField)this.get("input");
            GuiComboBox fontCombo = (GuiComboBox)this.get("fontType");
            GuiTextfield fontSize = (GuiTextfield)this.get("fontSize");
            GuiColorPickerAlet color = (GuiColorPickerAlet)this.get("picker");
            BufferedImage image = FontReader.fontToPhoto(text.text, fontCombo.getCaption(), this.textAttributeMap, Integer.parseInt(fontSize.text), ColorUtils.RGBAToInt((Color)color.color), this.BLACK);
            this.imgHeight.text = FontReader.getTextPixelHeight(text.text, fontCombo.getCaption(), this.textAttributeMap, Integer.parseInt(fontSize.text)) + "";
            this.imgWidth.text = FontReader.getTextPixelWidth(text.text, fontCombo.getCaption(), this.textAttributeMap, Integer.parseInt(fontSize.text)) + "";
        }
    }
}

