/*
 * Decompiled with CFR 0.152.
 */
package com.alet.client.gui;

import com.alet.common.sounds.Notes;
import com.alet.common.structure.type.LittleMusicComposerALET;
import com.creativemd.creativecore.common.gui.GuiControl;
import com.creativemd.creativecore.common.gui.container.SubGui;
import com.creativemd.creativecore.common.gui.controls.gui.GuiButton;
import com.creativemd.creativecore.common.gui.controls.gui.GuiCheckBox;
import com.creativemd.creativecore.common.gui.controls.gui.GuiLabel;
import com.creativemd.creativecore.common.gui.controls.gui.GuiListBox;
import com.creativemd.creativecore.common.gui.controls.gui.GuiTextfield;
import com.creativemd.creativecore.common.gui.event.ControlEvent;
import com.creativemd.creativecore.common.gui.event.gui.GuiControlChangedEvent;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.Vec3d;

public class SubGuiSoundSettings
extends SubGui {
    public LittleMusicComposerALET.LittleMusicComposerParserALET littleSoundPlayerParserALET;
    public static List<String> soundList = new ArrayList<String>();

    public SubGuiSoundSettings(LittleMusicComposerALET.LittleMusicComposerParserALET littleSoundPlayerParserALET) {
        super(350, 251);
        this.littleSoundPlayerParserALET = littleSoundPlayerParserALET;
    }

    public void createControls() {
        this.controls.add(new GuiButton("Done", 0, 231, 40){

            public void onClicked(int x, int y, int button) {
                SubGuiSoundSettings.this.closeGui();
            }
        });
        String[] channelsounds = this.littleSoundPlayerParserALET.channelSounds;
        int i = 0;
        for (String sound : channelsounds) {
            GuiComboBoxHeight sounds = new GuiComboBoxHeight("sounds" + ++i, 255, (i - 1) * 14, 85, 7, soundList);
            sounds.select(sound);
            this.controls.add(sounds);
            GuiTextfieldSearch search = new GuiTextfieldSearch("search", "", 167, (i - 1) * 14, 80, 7, "sounds" + i);
            this.controls.add(search);
            this.controls.add(new GuiLabel("CH" + i + ":", 140, (i - 1) * 14));
        }
        this.controls.add(new GuiLabel("Volume: ", 0, 0));
        this.controls.add(new GuiTextfield("Volume", this.littleSoundPlayerParserALET.volume + "", 40, 0, 40, 9).setFloatOnly());
        this.controls.add(new GuiCheckBox("local", "Play From Block", 0, 18, this.littleSoundPlayerParserALET.local).setCustomTooltip(new String[]{"True: Play sound from the Structure", "False: Play globally to all players"}));
    }

    public void onClosed() {
        super.onClosed();
    }

    public boolean raiseEvent(ControlEvent event) {
        GuiListBox box;
        String sound;
        if (event.source instanceof GuiListBox && !(sound = (box = (GuiListBox)event.source).get(box.selected)).equals("nosound")) {
            Notes note = Notes.getNoteFromPitch(0);
            SubGuiSoundSettings.playSound((SoundEvent)new SoundEvent(new ResourceLocation(note.getResourceLocation(sound))));
            GuiComboBoxHeight[] comboBoxes = new GuiComboBoxHeight[this.littleSoundPlayerParserALET.channelSounds.length];
            for (int i = 0; i < this.littleSoundPlayerParserALET.channelSounds.length; ++i) {
                comboBoxes[i] = (GuiComboBoxHeight)this.get("sounds" + (i + 1));
            }
            GuiTextfield volume = (GuiTextfield)this.get("volume");
            for (int i = 0; i < this.littleSoundPlayerParserALET.channelSounds.length; ++i) {
                this.littleSoundPlayerParserALET.channelSounds[i] = comboBoxes[i].getCaption();
            }
            this.littleSoundPlayerParserALET.volume = Integer.parseInt(volume.text);
            this.littleSoundPlayerParserALET.updateTimeLine();
        }
        if (event.source.is(new String[]{"local"})) {
            GuiCheckBox local = (GuiCheckBox)this.get("local");
            this.littleSoundPlayerParserALET.local = local.value;
        }
        return super.raiseEvent(event);
    }

    static {
        soundList.add("nosound");
        soundList.add("banjo");
        soundList.add("bdrum");
        soundList.add("bell");
        soundList.add("bit");
        soundList.add("click");
        soundList.add("cow_bell");
        soundList.add("dbass");
        soundList.add("didgeridoo");
        soundList.add("DonK4rmas_Piano");
        soundList.add("flute");
        soundList.add("guitar");
        soundList.add("harp");
        soundList.add("icechime");
        soundList.add("iron_xylophone");
        soundList.add("pling");
        soundList.add("sdrum");
        soundList.add("xylobone");
    }

    private class GuiTextfieldSearch
    extends GuiTextfield {
        String comboBox;

        public GuiTextfieldSearch(String name, String text, int x, int y, int width, int height, String linkToComboBox) {
            super(name, text, x, y, width, height);
            this.comboBox = linkToComboBox;
        }

        public boolean onKeyPressed(char character, int key) {
            boolean result = false;
            if (this.focused) {
                result = super.onKeyPressed(character, key);
                GuiComboBoxHeight sounds = (GuiComboBoxHeight)this.getParent().get(this.comboBox);
                ArrayList<String> foundSounds = new ArrayList<String>();
                for (int i = 0; i < soundList.size(); ++i) {
                    if (!soundList.get(i).toLowerCase().contains(this.text.toLowerCase())) continue;
                    foundSounds.add(soundList.get(i));
                }
                if (!foundSounds.isEmpty()) {
                    sounds.lines = foundSounds;
                    int index = soundList.indexOf(foundSounds.get(0));
                    sounds.select(soundList.get(index));
                }
            }
            return result;
        }
    }

    private class GuiBoxExtension
    extends GuiListBox {
        public GuiComboBoxHeight comboBox;

        public GuiBoxExtension(String name, GuiComboBoxHeight comboBox, int x, int y, int width, int height, List<String> lines) {
            super(name, x, y, width, height, lines);
            this.comboBox = comboBox;
            this.selected = comboBox.index;
            this.reloadControls();
        }

        public Vec3d getCenterOffset() {
            return new Vec3d((double)(this.width / 2), (double)(-this.comboBox.height / 2), 0.0);
        }

        public void onLoseFocus() {
            if (!this.comboBox.isMouseOver() && !this.isMouseOver()) {
                this.comboBox.closeBox();
            }
        }

        public void onSelectionChange() {
            if (this.selected != -1 && this.selected < this.lines.size()) {
                this.comboBox.setCaption(this.comboBox.getDisplay(this.selected));
                this.comboBox.index = this.selected;
                this.comboBox.raiseEvent((ControlEvent)new GuiControlChangedEvent((GuiControl)this.comboBox));
            }
            this.comboBox.closeBox();
        }

        public boolean canOverlap() {
            return true;
        }
    }

    private class GuiComboBoxHeight
    extends GuiLabel {
        public GuiBoxExtension extension;
        public List<String> lines;
        public int index;

        public GuiComboBoxHeight(String name, int x, int y, int width, int height, List<String> lines) {
            super(name, x, y, width, height, -1);
            this.lines = lines;
            if (lines.size() > 0) {
                this.caption = this.getDisplay(0);
                this.index = 0;
            } else {
                this.caption = "";
                this.index = -1;
            }
        }

        public String getDisplay(int index) {
            return this.lines.get(index);
        }

        public void setCaption(String caption) {
            this.caption = caption;
        }

        public boolean select(int index) {
            if (index >= 0 && index < this.lines.size()) {
                this.caption = this.getDisplay(index);
                this.index = index;
                this.raiseEvent((ControlEvent)new GuiControlChangedEvent((GuiControl)this));
                return true;
            }
            return false;
        }

        public boolean select(String line) {
            this.index = this.lines.indexOf(line);
            if (this.index != -1) {
                this.caption = this.lines.get(this.index);
                this.raiseEvent((ControlEvent)new GuiControlChangedEvent((GuiControl)this));
                return true;
            }
            return false;
        }

        public boolean hasBorder() {
            return true;
        }

        public boolean hasBackground() {
            return true;
        }

        public boolean mousePressed(int posX, int posY, int button) {
            if (this.extension == null) {
                this.openBox();
            } else {
                this.closeBox();
            }
            GuiComboBoxHeight.playSound((SoundEvent)SoundEvents.field_187909_gi);
            return true;
        }

        public void openBox() {
            this.extension = this.createBox();
            this.getGui().controls.add(this.extension);
            this.extension.parent = this.getGui();
            this.extension.moveControlToTop();
            this.extension.onOpened();
            this.getGui().refreshControls();
            this.extension.rotation = this.rotation;
            this.extension.posX = this.getPixelOffsetX() - this.getGui().getPixelOffsetX() - this.getContentOffset();
            this.extension.posY = this.getPixelOffsetY() - this.getGui().getPixelOffsetY() - this.getContentOffset() + this.height;
            if (this.extension.posY + this.extension.height > this.getParent().height && this.posY >= this.extension.height) {
                this.extension.posY -= this.height + this.extension.height;
            }
        }

        protected GuiBoxExtension createBox() {
            return new GuiBoxExtension(this.name + "extension", this, this.posX, this.posY + this.height, this.width - this.getContentOffset() * 2, 100, this.lines);
        }

        public void closeBox() {
            if (this.extension != null) {
                this.getGui().controls.remove((Object)this.extension);
                this.extension = null;
            }
        }
    }
}

