/*
 * Decompiled with CFR 0.152.
 */
package com.alet.client.gui;

import com.alet.ALET;
import com.alet.client.gui.LittleItemSelector;
import com.alet.client.gui.controls.GuiDepressedCheckBox;
import com.alet.client.gui.controls.GuiLongTextField;
import com.alet.client.gui.controls.GuiStack;
import com.alet.client.gui.controls.Layer;
import com.alet.client.gui.message.SubGuiErrorMessage;
import com.alet.client.gui.message.SubGuiNoPathMessage;
import com.alet.common.utils.CopyUtils;
import com.alet.common.utils.photo.AtlasSpriteToPath;
import com.alet.common.utils.photo.PhotoReader;
import com.alet.littletiles.gui.controls.GuiAnimationViewerAlet;
import com.creativemd.creativecore.common.gui.GuiControl;
import com.creativemd.creativecore.common.gui.client.style.ColoredDisplayStyle;
import com.creativemd.creativecore.common.gui.client.style.DisplayStyle;
import com.creativemd.creativecore.common.gui.client.style.Style;
import com.creativemd.creativecore.common.gui.container.SubGui;
import com.creativemd.creativecore.common.gui.controls.gui.GuiAnalogeSlider;
import com.creativemd.creativecore.common.gui.controls.gui.GuiButton;
import com.creativemd.creativecore.common.gui.controls.gui.GuiCheckBox;
import com.creativemd.creativecore.common.gui.controls.gui.GuiComboBox;
import com.creativemd.creativecore.common.gui.controls.gui.GuiComboBoxExtension;
import com.creativemd.creativecore.common.gui.controls.gui.GuiProgressBar;
import com.creativemd.creativecore.common.gui.controls.gui.GuiTextfield;
import com.creativemd.creativecore.common.gui.event.gui.GuiControlChangedEvent;
import com.creativemd.littletiles.client.gui.LittleSubGuiUtils;
import com.creativemd.littletiles.common.entity.AnimationPreview;
import com.creativemd.littletiles.common.item.ItemMultiTiles;
import com.creativemd.littletiles.common.tile.preview.LittlePreview;
import com.creativemd.littletiles.common.tile.preview.LittlePreviews;
import com.creativemd.littletiles.common.util.grid.LittleGridContext;
import com.n247s.api.eventapi.eventsystem.CustomEventSubscribe;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.io.IOException;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;

public class SubGuiPhotoImport
extends SubGui {
    private volatile Thread thread;
    public double aspectRatio = 0.0;

    public SubGuiPhotoImport() {
        super(313, 200);
    }

    public void createControls() {
        final GuiAnimationViewerAlet viewer = new GuiAnimationViewerAlet("renderer", 171, 0, 136, 135);
        this.controls.add(viewer);
        viewer.moveViewPort(0, 60);
        ArrayList<String> imageSources = new ArrayList<String>();
        imageSources.add("Print From File");
        if (ALET.CONFIG.isAllowURL()) {
            imageSources.add("Print From URL");
        }
        imageSources.add("Print From Block");
        imageSources.add("Print From Item");
        this.controls.add(new GuiComboBox("imageSource", 50, 0, 90, imageSources));
        this.createPathControl();
        this.controls.add(new GuiButton("refresh", "Refresh Preview", 217, 142, 90){

            public void onClicked(int x, int y, int button) {
                int resizeY;
                GuiTextfield imageWidth = (GuiTextfield)SubGuiPhotoImport.this.get("imageWidth");
                GuiTextfield imageHeight = (GuiTextfield)SubGuiPhotoImport.this.get("imageHeight");
                final GuiComboBox imageSource = (GuiComboBox)SubGuiPhotoImport.this.get("imageSource");
                int resizeX = Integer.parseInt(imageWidth.text);
                if (resizeX * (resizeY = Integer.parseInt(imageHeight.text)) > ALET.CONFIG.getMaxPixelAmount()) {
                    Layer.addLayer(this.getGui(), new SubGuiErrorMessage(resizeX * resizeY));
                } else {
                    PhotoReader.setScale(resizeX, resizeY);
                    GuiComboBox contextBox = (GuiComboBox)SubGuiPhotoImport.this.get("grid");
                    final int grid = Integer.parseInt(contextBox.getCaption());
                    final GuiDepressedCheckBox ignoreAlpha = (GuiDepressedCheckBox)SubGuiPhotoImport.this.get("ignoreAlpha");
                    final GuiAnalogeSlider slider = (GuiAnalogeSlider)SubGuiPhotoImport.this.get("color_acc");
                    final String path = SubGuiPhotoImport.this.getPath();
                    Runnable run = new Runnable(){

                        @Override
                        public void run() {
                            try {
                                LittlePreviews pre = LittlePreview.getPreview((ItemStack)PhotoReader.photoToStack(path, ignoreAlpha.value, imageSource.getCaption(), grid, this.getGui(), slider.value));
                                viewer.onLoaded(new AnimationPreview(pre));
                                if (pre == null) {
                                    Layer.addLayer(this.getGui(), new SubGuiNoPathMessage(".png or .jpeg"));
                                }
                            }
                            catch (IOException | NullPointerException e) {
                                e.printStackTrace();
                            }
                        }
                    };
                    if (SubGuiPhotoImport.this.thread != null) {
                        SubGuiPhotoImport.this.thread.interrupt();
                        SubGuiPhotoImport.this.thread = null;
                    }
                    SubGuiPhotoImport.this.thread = new Thread(run);
                    SubGuiPhotoImport.this.thread.start();
                }
            }
        });
        this.controls.add(new GuiTextfield("imageWidth", "0", 240, 163, 30, 14){

            public boolean onKeyPressed(char character, int key) {
                GuiTextfield imageWidth = (GuiTextfield)SubGuiPhotoImport.this.get("imageWidth");
                GuiTextfield imageHeight = (GuiTextfield)SubGuiPhotoImport.this.get("imageHeight");
                GuiCheckBox keepAspect = (GuiCheckBox)SubGuiPhotoImport.this.get("keepAspect");
                boolean result = super.onKeyPressed(character, key);
                if (result && !this.text.isEmpty() && keepAspect.value) {
                    imageHeight.text = String.valueOf((int)(SubGuiPhotoImport.this.aspectRatio * Double.parseDouble(imageWidth.text)));
                }
                return result;
            }
        });
        final GuiTextfield imageWidth = (GuiTextfield)this.get("imageWidth");
        imageWidth.enabled = false;
        imageWidth.setCustomTooltip(new String[]{"Width Of Image"});
        imageWidth.setNumbersOnly();
        this.controls.add(new GuiTextfield("imageHeight", "0", 277, 163, 30, 14){

            public boolean onKeyPressed(char character, int key) {
                GuiTextfield imageWidth = (GuiTextfield)SubGuiPhotoImport.this.get("imageWidth");
                GuiTextfield imageHeight = (GuiTextfield)SubGuiPhotoImport.this.get("imageHeight");
                GuiCheckBox keepAspect = (GuiCheckBox)SubGuiPhotoImport.this.get("keepAspect");
                boolean result = super.onKeyPressed(character, key);
                if (result && !imageHeight.text.isEmpty() && keepAspect.value) {
                    imageWidth.text = String.valueOf((int)(Double.parseDouble(imageHeight.text) / SubGuiPhotoImport.this.aspectRatio));
                }
                return result;
            }
        });
        final GuiTextfield imageHeight = (GuiTextfield)this.get("imageHeight");
        imageHeight.enabled = false;
        imageHeight.setCustomTooltip(new String[]{"Height Of Image"});
        imageHeight.setNumbersOnly();
        this.controls.add(new GuiDepressedCheckBox("ignoreAlpha", "Ignore Alpha", 0, 47, 70, 16, "", false, false));
        this.controls.add(new GuiDepressedCheckBox("keepAspect", SubGuiPhotoImport.translate((String)"Keep Aspect Ratio?"), 0, 63, 101, 16, "", false, false));
        this.controls.add(new GuiButton("autoScale", "Auto Scale Image?", 0, 80, 90){

            public void onClicked(int x, int y, int button) {
                int ya;
                GuiTextfield imageWidth = (GuiTextfield)SubGuiPhotoImport.this.get("imageWidth");
                GuiTextfield imageHeight = (GuiTextfield)SubGuiPhotoImport.this.get("imageHeight");
                int x1 = (int)((double)ALET.CONFIG.getMaxPixelAmount() * SubGuiPhotoImport.this.aspectRatio);
                int x2 = (int)Math.sqrt(x1);
                int y1 = (int)((double)x2 / SubGuiPhotoImport.this.aspectRatio);
                int xa = Integer.parseInt(imageHeight.text);
                if (xa * (ya = Integer.parseInt(imageWidth.text)) > x1) {
                    if (Integer.parseInt(imageWidth.text) > Integer.parseInt(imageHeight.text)) {
                        imageHeight.text = String.valueOf(x2);
                        imageWidth.text = String.valueOf(y1);
                    } else if (Integer.parseInt(imageWidth.text) < Integer.parseInt(imageHeight.text)) {
                        imageWidth.text = String.valueOf(y1);
                        imageHeight.text = String.valueOf(x2);
                    } else {
                        imageHeight.text = String.valueOf(x2);
                        imageWidth.text = String.valueOf(x2);
                    }
                }
            }
        });
        GuiButton autoScale = (GuiButton)this.get("autoScale");
        autoScale.enabled = false;
        autoScale.setCustomTooltip(new String[]{"Shrinks Image down to max image size."});
        GuiComboBox contextBox = new GuiComboBox("grid", 148, 0, 15, LittleGridContext.getNames()){

            protected GuiComboBoxExtension createBox() {
                return new GuiComboBoxExtension(this.name + "extension", (GuiComboBox)this, this.posX, this.posY + this.height, 35 - this.getContentOffset() * 2, 100, this.lines);
            }
        };
        contextBox.select(ItemMultiTiles.currentContext.size + "");
        this.controls.add(contextBox);
        GuiButton paste = new GuiButton("Paste", 0, 102){

            public void onClicked(int x, int y, int button) {
                GuiLongTextField file = (GuiLongTextField)SubGuiPhotoImport.this.get("file");
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                String path = CopyUtils.getCopiedFilePath(clipboard);
                if (path == null) {
                    return;
                }
                file.text = path;
                SubGuiPhotoImport.this.updatePhotoData();
            }
        };
        this.controls.add(paste);
        GuiButton print = new GuiButton("Print", 38, 102){

            public void onClicked(int x, int y, int button) {
                final GuiComboBox imageSource = (GuiComboBox)SubGuiPhotoImport.this.get("imageSource");
                int resizeX = Integer.parseInt(imageWidth.text);
                int resizeY = Integer.parseInt(imageHeight.text);
                final String path = SubGuiPhotoImport.this.getPath();
                if (PhotoReader.photoExists(path, imageSource.getCaption())) {
                    if (resizeX * resizeY > ALET.CONFIG.getMaxPixelAmount()) {
                        Layer.addLayer(this.getGui(), new SubGuiErrorMessage(resizeX * resizeY));
                    } else {
                        PhotoReader.setScale(resizeX, resizeY);
                        final GuiDepressedCheckBox ignoreAlpha = (GuiDepressedCheckBox)SubGuiPhotoImport.this.get("ignoreAlpha");
                        final GuiAnalogeSlider slider = (GuiAnalogeSlider)SubGuiPhotoImport.this.get("color_acc");
                        GuiComboBox contextBox = (GuiComboBox)SubGuiPhotoImport.this.get("grid");
                        final int grid = Integer.parseInt(contextBox.getCaption());
                        Runnable run = new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    ItemStack stack = PhotoReader.photoToStack(path, ignoreAlpha.value, imageSource.getCaption(), grid, this.getGui(), slider.value);
                                    if (!stack.equals(ItemStack.field_190927_a)) {
                                        this.getGui().sendPacketToServer(stack.func_77978_p());
                                    }
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                            }
                        };
                        if (SubGuiPhotoImport.this.thread != null) {
                            SubGuiPhotoImport.this.thread.interrupt();
                            SubGuiPhotoImport.this.thread = null;
                        }
                        SubGuiPhotoImport.this.thread = new Thread(run);
                        SubGuiPhotoImport.this.thread.start();
                    }
                } else {
                    Layer.addLayer(this.getGui(), new SubGuiNoPathMessage(".png or .jpeg"));
                }
            }
        };
        this.controls.add(print);
        GuiProgressBar progress = new GuiProgressBar("progress", 165, 184, 142, 10, 150.0, 0.0);
        progress.setStyle(new Style("s", (DisplayStyle)new ColoredDisplayStyle(0x11111111), (DisplayStyle)new ColoredDisplayStyle(-572662307), DisplayStyle.emptyDisplay, (DisplayStyle)new ColoredDisplayStyle(2988306), DisplayStyle.emptyDisplay));
        this.controls.add(progress);
        GuiAnalogeSlider slider = new GuiAnalogeSlider("color_acc", 165, 163, 68, 14, 100.0, 0.0, 1.0);
        slider.setCustomTooltip(new String[]{"Color Accuracy"});
        this.controls.add(slider);
    }

    @CustomEventSubscribe
    public void changed(GuiControlChangedEvent event) {
        if (event.source.name.equals("imageSource")) {
            GuiButton paste;
            this.wipeControls();
            GuiComboBox imageSource = (GuiComboBox)this.get("imageSource");
            if (imageSource.getCaption().equals("Print From File") || imageSource.getCaption().equals("Print From URL")) {
                paste = (GuiButton)this.get("Paste");
                paste.setEnabled(true);
                this.createPathControl();
            } else if (imageSource.getCaption().equals("Print From Block")) {
                paste = (GuiButton)this.get("Paste");
                paste.setEnabled(false);
                this.createBlockControl();
                GuiStack listBlock = (GuiStack)this.get("listBlock");
                listBlock.getTexture(listBlock.getSelected());
                this.updatePhotoData();
            } else if (imageSource.getCaption().equals("Print From Item")) {
                paste = (GuiButton)this.get("Paste");
                paste.setEnabled(false);
                this.createItemControl();
                GuiStack listItem = (GuiStack)this.get("listItem");
                listItem.getTexture(listItem.getSelected());
                this.updatePhotoData();
            }
        } else if (event.source.name.equals("listItem")) {
            GuiStack listItem = (GuiStack)this.get("listItem");
            listItem.getTexture(listItem.getSelected());
            this.updatePhotoData();
        } else if (event.source.name.equals("listBlock")) {
            GuiStack listBlock = (GuiStack)this.get("listBlock");
            listBlock.getTexture(listBlock.getSelected());
            this.updatePhotoData();
        }
        if (event.source instanceof GuiDepressedCheckBox) {
            GuiDepressedCheckBox north = (GuiDepressedCheckBox)this.get("north");
            GuiDepressedCheckBox east = (GuiDepressedCheckBox)this.get("east");
            GuiDepressedCheckBox south = (GuiDepressedCheckBox)this.get("south");
            GuiDepressedCheckBox west = (GuiDepressedCheckBox)this.get("west");
            GuiDepressedCheckBox top = (GuiDepressedCheckBox)this.get("top");
            GuiDepressedCheckBox bottom = (GuiDepressedCheckBox)this.get("bottom");
            GuiStack listBlock = (GuiStack)this.get("listBlock");
            if (event.source.name.equals("north")) {
                listBlock.setEnumFacing("north");
                north.value = true;
                east.value = false;
                south.value = false;
                west.value = false;
                top.value = false;
                bottom.value = false;
            }
            if (event.source.name.equals("east")) {
                listBlock.setEnumFacing("east");
                north.value = false;
                east.value = true;
                south.value = false;
                west.value = false;
                top.value = false;
                bottom.value = false;
            }
            if (event.source.name.equals("south")) {
                listBlock.setEnumFacing("south");
                north.value = false;
                east.value = false;
                south.value = true;
                west.value = false;
                top.value = false;
                bottom.value = false;
            }
            if (event.source.name.equals("west")) {
                listBlock.setEnumFacing("west");
                north.value = false;
                east.value = false;
                south.value = false;
                west.value = true;
                top.value = false;
                bottom.value = false;
            }
            if (event.source.name.equals("top")) {
                listBlock.setEnumFacing("up");
                north.value = false;
                east.value = false;
                south.value = false;
                west.value = false;
                top.value = true;
                bottom.value = false;
            }
            if (event.source.name.equals("bottom")) {
                listBlock.setEnumFacing("down");
                north.value = false;
                east.value = false;
                south.value = false;
                west.value = false;
                top.value = false;
                bottom.value = true;
            }
        }
    }

    public void wipeControls() {
        if (this.has("file")) {
            this.removeControl(this.get("file"));
        }
        if (this.has("north")) {
            this.removeControl(this.get("north"));
        }
        if (this.has("east")) {
            this.removeControl(this.get("east"));
        }
        if (this.has("south")) {
            this.removeControl(this.get("south"));
        }
        if (this.has("west")) {
            this.removeControl(this.get("west"));
        }
        if (this.has("bottom")) {
            this.removeControl(this.get("bottom"));
        }
        if (this.has("top")) {
            this.removeControl(this.get("top"));
        }
        if (this.has("listItem")) {
            this.removeControl(this.get("listItem"));
        }
        if (this.has("listBlock")) {
            this.removeControl(this.get("listBlock"));
        }
    }

    public void createPathControl() {
        this.addControl((GuiControl)new GuiLongTextField("file", "", 0, 26, 162, 14){

            @Override
            public boolean onKeyPressed(char character, int key) {
                boolean result = super.onKeyPressed(character, key);
                if (result) {
                    SubGuiPhotoImport.this.updatePhotoData();
                }
                return result;
            }
        });
    }

    public void createBlockControl() {
        this.addControl((GuiControl)new GuiStack("listBlock", 0, 26, 140, this.getPlayer(), LittleSubGuiUtils.getCollector((EntityPlayer)this.getPlayer()), true, true));
        this.addControl((GuiControl)new GuiDepressedCheckBox("north", "N", 119, 67, 17, 17, "", true));
        this.addControl((GuiControl)new GuiDepressedCheckBox("east", "E", 136, 83, 17, 17, "", false));
        this.addControl((GuiControl)new GuiDepressedCheckBox("south", "S", 119, 99, 17, 17, "", false));
        this.addControl((GuiControl)new GuiDepressedCheckBox("west", "W", 102, 83, 17, 17, "", false));
        this.addControl((GuiControl)new GuiDepressedCheckBox("bottom", "B", 119, 83, 17, 17, "", false));
        this.addControl((GuiControl)new GuiDepressedCheckBox("top", "T", 153, 83, 17, 17, "", false));
    }

    public void createItemControl() {
        this.addControl((GuiControl)new GuiStack("listItem", 0, 26, 140, this.getPlayer(), LittleItemSelector.getCollector(this.getPlayer()), true, false));
    }

    public String getPath() {
        GuiComboBox imageSource = (GuiComboBox)this.get("imageSource");
        GuiLongTextField file = (GuiLongTextField)this.get("file");
        String path = "";
        if (imageSource.getCaption().equals("Print From File") || imageSource.getCaption().equals("Print From URL")) {
            path = file.text;
        } else if (imageSource.getCaption().equals("Print From Item")) {
            GuiStack listItem = (GuiStack)this.get("listItem");
            AtlasSpriteToPath texturePath = new AtlasSpriteToPath(listItem.texture);
            path = texturePath.getPath();
        } else if (imageSource.getCaption().equals("Print From Block")) {
            GuiStack listBlock = (GuiStack)this.get("listBlock");
            AtlasSpriteToPath texturePath = new AtlasSpriteToPath(listBlock.texture);
            path = texturePath.getPath();
        }
        return path;
    }

    public void updatePhotoData() {
        GuiTextfield imageWidth = (GuiTextfield)this.get("imageWidth");
        GuiTextfield imageHeight = (GuiTextfield)this.get("imageHeight");
        GuiButton autoScale = (GuiButton)this.get("autoScale");
        GuiComboBox imageSource = (GuiComboBox)this.get("imageSource");
        if (PhotoReader.photoExists(this.getPath(), imageSource.getCaption())) {
            String path = this.getPath();
            imageHeight.text = Integer.toString(PhotoReader.getPixelLength(path, imageSource.getCaption()));
            imageWidth.text = Integer.toString(PhotoReader.getPixelWidth(path, imageSource.getCaption()));
            imageHeight.enabled = true;
            imageWidth.enabled = true;
            autoScale.enabled = true;
            this.aspectRatio = Float.parseFloat(imageHeight.text) / Float.parseFloat(imageWidth.text);
        } else {
            imageHeight.text = "0";
            imageWidth.text = "0";
            imageHeight.enabled = false;
            imageWidth.enabled = false;
            autoScale.enabled = false;
        }
    }

    public void onClosed() {
        if (this.thread != null) {
            this.thread.interrupt();
            this.thread = null;
        }
        super.onClosed();
    }
}

