/*
 * Decompiled with CFR 0.152.
 */
package com.alet.client.gui;

import com.alet.client.gui.GuiRenameFile;
import com.alet.client.gui.SubGuiBlueprintDetails;
import com.alet.client.gui.controls.Layer;
import com.alet.client.gui.controls.menu.GuiMenu;
import com.alet.client.gui.controls.menu.GuiMenuPart;
import com.alet.client.gui.controls.menu.GuiPopupMenu;
import com.alet.client.gui.controls.menu.GuiTree;
import com.alet.client.gui.controls.menu.GuiTreePart;
import com.alet.littletiles.gui.controls.GuiAnimationViewerAlet;
import com.creativemd.creativecore.common.gui.GuiControl;
import com.creativemd.creativecore.common.gui.container.GuiParent;
import com.creativemd.creativecore.common.gui.container.SubContainer;
import com.creativemd.creativecore.common.gui.container.SubGui;
import com.creativemd.creativecore.common.gui.controls.container.SlotControl;
import com.creativemd.creativecore.common.gui.controls.gui.GuiButton;
import com.creativemd.creativecore.common.gui.controls.gui.GuiLabel;
import com.creativemd.creativecore.common.gui.controls.gui.GuiScrollBox;
import com.creativemd.creativecore.common.gui.controls.gui.GuiTextfield;
import com.creativemd.creativecore.common.gui.event.gui.GuiControlChangedEvent;
import com.creativemd.creativecore.common.gui.event.gui.GuiControlClickEvent;
import com.creativemd.littletiles.common.entity.AnimationPreview;
import com.creativemd.littletiles.common.item.ItemLittleRecipe;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.tile.preview.LittlePreviews;
import com.creativemd.littletiles.common.util.converation.StructureStringUtils;
import com.creativemd.littletiles.common.util.grid.LittleGridContext;
import com.creativemd.littletiles.common.util.place.PlacementHelper;
import com.n247s.api.eventapi.eventsystem.CustomEventSubscribe;
import java.awt.Desktop;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;

public class SubGuiFillingCabinet
extends SubGui {
    List<GuiTreePart> listOfRoots = new ArrayList<GuiTreePart>();
    public GuiTreePart selectedFile;

    public SubGuiFillingCabinet(LittleStructure structure) {
        super(382, 282);
        this.createTreeList();
    }

    public void createControls() {
        final SubContainer contain = this.container;
        GuiMenuPart sortBy = new GuiMenuPart("", "Sort by", GuiTreePart.EnumPartType.Branch, true);
        GuiMenuPart name = new GuiMenuPart("", "Name", GuiTreePart.EnumPartType.Leaf);
        GuiMenuPart date = new GuiMenuPart("", "Date modified", GuiTreePart.EnumPartType.Leaf);
        GuiMenuPart structureType = new GuiMenuPart("", "Structure type", GuiTreePart.EnumPartType.Leaf);
        GuiMenuPart size = new GuiMenuPart("", "Size", GuiTreePart.EnumPartType.Leaf, true);
        GuiMenuPart ascending = new GuiMenuPart("", "Ascending", GuiTreePart.EnumPartType.Leaf);
        GuiMenuPart descending = new GuiMenuPart("", "Descending", GuiTreePart.EnumPartType.Leaf);
        GuiMenuPart showFolder = new GuiMenuPart("", "Show in folder", GuiTreePart.EnumPartType.Leaf);
        GuiMenuPart newFolder = new GuiMenuPart("", "New folder", GuiTreePart.EnumPartType.Leaf);
        GuiMenuPart delete = new GuiMenuPart("", "Delete", GuiTreePart.EnumPartType.Leaf);
        GuiMenuPart rename = new GuiMenuPart("", "Rename", GuiTreePart.EnumPartType.Leaf, true);
        GuiMenuPart details = new GuiMenuPart("", "Structure details", GuiTreePart.EnumPartType.Leaf);
        ArrayList<GuiTreePart> listOfMenus = new ArrayList<GuiTreePart>();
        listOfMenus.add(sortBy.addMenu(name).addMenu(date).addMenu(structureType).addMenu(size).addMenu(ascending).addMenu(descending));
        listOfMenus.add(showFolder);
        listOfMenus.add(newFolder);
        listOfMenus.add(delete);
        listOfMenus.add(rename);
        listOfMenus.add(details);
        GuiMenu menu = new GuiMenu("", 0, 0, 500, listOfMenus);
        menu.height = 500;
        this.addControl((GuiControl)new GuiPopupMenu("pop", menu, 0, 0, 0, 0));
        this.createTreeList();
        GuiTree tree = new GuiTree("list", 0, 0, 210, this.listOfRoots, true, 0, 0, 116);
        GuiFillingCabinetScrollBox scrollBox = new GuiFillingCabinetScrollBox("scrollBox", tree, 0, 15, 210, 222);
        scrollBox.addControl((GuiControl)tree);
        tree.height = tree.listOfParts.size() * 14 + 25;
        this.addControl((GuiControl)scrollBox);
        GuiAnimationViewerAlet viewer = new GuiAnimationViewerAlet("renderer", 221, 15, 155, 154);
        viewer.moveViewPort(0, 92);
        this.addControl((GuiControl)viewer);
        this.addControl((GuiControl)new GuiLabel("Selected:", 0, 0));
        this.addControl((GuiControl)new GuiLabel("viewing", TextFormatting.BOLD + "None", 47, 0));
        this.addControl((GuiControl)new GuiTextfield("saveName", "", 20, 246, 142, 10));
        this.addControl((GuiControl)new GuiButton("add", "Add Structure", 0, 265, 75, 10){

            public void onClicked(int x, int y, int button) {
                SlotControl slot = (SlotControl)contain.get("input0");
                ItemStack stack = slot.slot.func_75211_c();
                GuiTextfield text = (GuiTextfield)this.getGui().get("saveName");
                if (stack != null && (PlacementHelper.isLittleBlock((ItemStack)stack) || stack.func_77973_b() instanceof ItemLittleRecipe)) {
                    try {
                        File d = new File("./little_structures");
                        if (!d.exists()) {
                            d.mkdir();
                        }
                        int length = text.text.length();
                        File f1 = SubGuiFillingCabinet.this.getPath(text.text);
                        if (!f1.exists()) {
                            f1.createNewFile();
                        }
                        BufferedWriter writer = new BufferedWriter(new FileWriter(f1));
                        writer.write(StructureStringUtils.exportStructure((ItemStack)stack));
                        writer.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                SubGuiFillingCabinet.this.updateTree();
            }
        });
        this.addControl((GuiControl)new GuiButton("Import", 243, 177){

            public void onClicked(int x, int y, int button) {
                try {
                    String file = SubGuiFillingCabinet.this.getBlueprintFromSelectedFile();
                    if (file != null) {
                        NBTTagCompound nbt = JsonToNBT.func_180713_a((String)file);
                        try {
                            LittleGridContext.get((NBTTagCompound)nbt);
                            SubGuiFillingCabinet.this.sendPacketToServer(nbt);
                        }
                        catch (RuntimeException e) {
                            SubGuiFillingCabinet.this.openButtonDialogDialog("Invalid grid size " + nbt.func_74762_e("grid"), new String[]{"Ok"});
                        }
                    }
                }
                catch (NBTException nBTException) {
                    // empty catch block
                }
            }
        });
    }

    public GuiTreePart validGrid(File file, GuiTreePart part) {
        String data = this.getBlueprintFromFile(part);
        if (data != null) {
            try {
                try {
                    NBTTagCompound nbt = JsonToNBT.func_180713_a((String)data);
                    LittleGridContext.get((NBTTagCompound)nbt);
                }
                catch (RuntimeException e) {
                    part = new GuiTreePart(file.getName(), -65536, GuiTreePart.EnumPartType.Leaf);
                    part.setCustomTooltip(new String[]{"Error: Invalid Grid Size"});
                    return part;
                }
            }
            catch (NBTException nBTException) {
                // empty catch block
            }
        }
        return part;
    }

    public void createTreeList() {
        File d = new File("./little_structures");
        this.listOfRoots.clear();
        for (File file : d.listFiles()) {
            GuiTreePart root = new GuiTreePart(file.getName(), GuiTreePart.EnumPartType.Leaf);
            root = this.validGrid(file, root);
            if (file.isDirectory()) {
                root = new GuiTreePart(file.getName(), GuiTreePart.EnumPartType.Root);
                this.collectFilesInDir(file, root);
            }
            this.listOfRoots.add(root);
        }
    }

    public void collectFilesInDir(File dir, GuiTreePart part) {
        for (File file : dir.listFiles()) {
            if (file.isDirectory()) {
                GuiTreePart branch = new GuiTreePart(file.getName(), GuiTreePart.EnumPartType.Branch);
                part.addMenu(branch);
                this.collectFilesInDir(file, branch);
                continue;
            }
            if (!file.isFile()) continue;
            GuiTreePart newPart = new GuiTreePart(file.getName(), GuiTreePart.EnumPartType.Leaf);
            newPart = this.validGrid(file, newPart);
            part.addMenu(newPart);
        }
    }

    public void updateTree() {
        GuiScrollBox scrollBox = (GuiScrollBox)this.get("scrollBox");
        GuiTree tree = (GuiTree)scrollBox.get("list");
        tree.removeControls(new String[]{"search"});
        this.createTreeList();
        tree.replaceTree(this.listOfRoots);
    }

    public String getBlueprintFromSelectedFile() {
        return this.getBlueprintFromFile(this.selectedFile);
    }

    public String getBlueprintFromFile(GuiTreePart part) {
        String file = "";
        if (part != null) {
            try {
                BufferedReader reader = new BufferedReader(new FileReader(this.getPath(part.caption)));
                file = reader.readLine();
                reader.close();
            }
            catch (IOException e) {
                return null;
            }
            return file;
        }
        return null;
    }

    public File getNewFolder() {
        String newFile = "New Folder";
        int x = 1;
        while (this.getPath(newFile).exists()) {
            newFile = "New Folder (" + ++x + ")";
            if (x <= 100) continue;
            break;
        }
        return this.getPath(newFile);
    }

    public File getPath(String fileName) {
        String path = "";
        GuiTreePart p = this.selectedFile;
        if (p != null) {
            int i = 0;
            while (p.getBranchThisIsIn() != null) {
                path = "/" + p.getBranchThisIsIn().CAPTION + path;
                p = p.getBranchThisIsIn();
                if (++i <= 100) continue;
            }
            String end = "";
            if (this.selectedFile.type.canHold()) {
                end = "/" + this.selectedFile.caption;
                if (!fileName.equals("")) {
                    end = end + "/" + fileName;
                }
            } else if (!fileName.equals("")) {
                end = "/" + fileName;
            }
            return new File("./little_structures" + path + end);
        }
        String end = "";
        if (!fileName.equals("")) {
            end = "/" + fileName;
        }
        return new File("./little_structures" + end);
    }

    @CustomEventSubscribe
    public void clicked(GuiControlClickEvent event) {
        if (event.source instanceof GuiPopupMenu) {
            GuiPopupMenu guiPopupMenu = (GuiPopupMenu)event.source;
        }
    }

    @CustomEventSubscribe
    public void changed(GuiControlChangedEvent event) {
        if (event.source instanceof GuiMenuPart) {
            String file;
            if (((GuiMenuPart)event.source).caption.equals("Show in folder")) {
                try {
                    File f1 = this.getPath("");
                    Desktop.getDesktop().open(f1);
                }
                catch (IOException f1) {}
            } else if (((GuiMenuPart)event.source).caption.equals("Move Up")) {
                File f1 = this.getPath("");
            } else if (((GuiMenuPart)event.source).caption.equals("Delete")) {
                if (this.selectedFile != null) {
                    File f1 = null;
                    f1 = this.selectedFile.type.canHold() ? this.getPath("") : this.getPath(this.selectedFile.caption);
                    f1.delete();
                    this.updateTree();
                    this.updateSelected(null);
                }
            } else if (((GuiMenuPart)event.source).caption.equals("Rename")) {
                if (this.selectedFile.type.canHold()) {
                    Layer.addLayer(this, new GuiRenameFile(this.getPath(""), this));
                } else {
                    Layer.addLayer(this, new GuiRenameFile(this.getPath(this.selectedFile.caption), this));
                }
            } else if (((GuiMenuPart)event.source).caption.equals("New folder")) {
                File f1 = this.getNewFolder();
                f1.mkdir();
                this.updateTree();
            } else if (((GuiMenuPart)event.source).caption.equals("Structure details") && (file = this.getBlueprintFromSelectedFile()) != null) {
                Layer.addLayer(this, new SubGuiBlueprintDetails(file, this.getPath(this.selectedFile.caption)));
            }
        }
        if (event.source instanceof GuiTreePart && !(event.source instanceof GuiMenuPart) && !((Object)((Object)((GuiTreePart)event.source))).equals((Object)this.selectedFile)) {
            this.updateSelected((GuiTreePart)event.source);
        }
    }

    public void updateSelected(@Nullable GuiTreePart control) {
        GuiLabel lable = (GuiLabel)this.get("viewing");
        GuiAnimationViewerAlet viewer = (GuiAnimationViewerAlet)this.get("renderer");
        this.selectedFile = control;
        if (control != null) {
            lable.setCaption(TextFormatting.BOLD + control.CAPTION);
            try {
                String file = this.getBlueprintFromSelectedFile();
                if (file != null) {
                    NBTTagCompound nbt = JsonToNBT.func_180713_a((String)file);
                    ItemStack stack = StructureStringUtils.importStructure((NBTTagCompound)nbt);
                    LittlePreviews pre = LittlePreviews.getPreview((ItemStack)stack, (boolean)false);
                    AnimationPreview anPre = new AnimationPreview(pre);
                    if (anPre != null) {
                        viewer.onLoaded(anPre);
                    }
                    this.refreshControls();
                }
            }
            catch (NullPointerException | NBTException throwable) {}
        } else {
            lable.setCaption(TextFormatting.BOLD + "None");
        }
    }

    public class GuiFillingCabinetScrollBox
    extends GuiScrollBox {
        GuiTree tree;

        public GuiFillingCabinetScrollBox(String name, GuiTree tree, int x, int y, int width, int height) {
            super(name, x, y, width, height);
            this.tree = tree;
        }

        public GuiControl menuOver(int x, int y, int button, ArrayList<GuiControl> controls) {
            for (GuiControl control : controls) {
                GuiControl found;
                if (control instanceof GuiTreePart && control.isMouseOver(x - this.tree.posX, y - 20)) {
                    return control;
                }
                if (!(control instanceof GuiParent) || (found = this.menuOver(x, y, button, ((GuiParent)control).controls)) == null) continue;
                return found;
            }
            return null;
        }

        public boolean mousePressed(int x, int y, int button) {
            GuiTreePart part = (GuiTreePart)this.menuOver(x, y, button, this.controls);
            if (button == 0 && part == null) {
                SubGuiFillingCabinet cabinet = (SubGuiFillingCabinet)this.getParent();
                cabinet.updateSelected(part);
            }
            return super.mousePressed(x, y, button);
        }
    }
}

