/*
 * Decompiled with CFR 0.152.
 */
package com.alet.client.gui;

import com.creativemd.creativecore.client.avatar.Avatar;
import com.creativemd.creativecore.client.avatar.AvatarItemStack;
import com.creativemd.creativecore.common.gui.GuiControl;
import com.creativemd.creativecore.common.gui.container.SubGui;
import com.creativemd.creativecore.common.gui.controls.gui.GuiAvatarLabel;
import com.creativemd.creativecore.common.gui.controls.gui.GuiLabel;
import com.creativemd.creativecore.common.gui.controls.gui.GuiScrollBox;
import com.creativemd.littletiles.client.gui.signal.SubGuiDialogSignal;
import com.creativemd.littletiles.common.action.LittleAction;
import com.creativemd.littletiles.common.structure.registry.LittleStructureType;
import com.creativemd.littletiles.common.structure.signal.component.ISignalComponent;
import com.creativemd.littletiles.common.structure.signal.component.SignalComponentType;
import com.creativemd.littletiles.common.tile.preview.LittlePreviews;
import com.creativemd.littletiles.common.util.converation.StructureStringUtils;
import com.creativemd.littletiles.common.util.ingredient.BlockIngredient;
import com.creativemd.littletiles.common.util.ingredient.BlockIngredientEntry;
import com.creativemd.littletiles.common.util.ingredient.ColorIngredient;
import com.creativemd.littletiles.common.util.ingredient.LittleIngredient;
import com.creativemd.littletiles.common.util.ingredient.LittleIngredients;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;

public class SubGuiBlueprintDetails
extends SubGui {
    LittlePreviews previews;
    File file;
    NBTTagCompound nbt;
    int black;
    int cyan;
    int magenta;
    int yellow;

    public SubGuiBlueprintDetails(String nbtString, File file) {
        super(180, 320);
        try {
            this.nbt = JsonToNBT.func_180713_a((String)nbtString);
            ItemStack stack = StructureStringUtils.importStructure((NBTTagCompound)this.nbt);
            this.previews = LittlePreviews.getPreview((ItemStack)stack, (boolean)false);
            this.file = file;
        }
        catch (NBTException e) {
            e.printStackTrace();
        }
    }

    public void collectIngredients(GuiScrollBox scroll) {
        LittleIngredients ingredients = LittleAction.getIngredients((LittlePreviews)this.previews);
        int i = 0;
        for (LittleIngredient ingredient : ingredients) {
            if (ingredient instanceof BlockIngredient) {
                BlockIngredient block = (BlockIngredient)ingredient;
                for (BlockIngredientEntry entry : block) {
                    ItemStack stack = entry.getItemStack();
                    scroll.addControl((GuiControl)new GuiAvatarLabel("", 0, i * 18, -1, (Avatar)new AvatarItemStack(stack)));
                    scroll.addControl((GuiControl)new GuiLabel(BlockIngredient.printVolume((double)entry.value, (boolean)false) + " " + stack.func_82833_r(), 20, i * 18 + 4));
                    ++i;
                }
            }
            if (!(ingredient instanceof ColorIngredient)) continue;
            ColorIngredient color = (ColorIngredient)ingredient;
            this.black = color.black;
            this.cyan = color.cyan;
            this.magenta = color.magenta;
            this.yellow = color.yellow;
        }
    }

    public void createControls() {
        GuiLabel structureName = new GuiLabel("Structure Name:", 0, 0, -1);
        GuiLabel name = new GuiLabel(this.previews.getStructureName(), 83, 0, -1);
        GuiLabel structureID = new GuiLabel("Structure ID:", 0, 14, -1);
        GuiLabel id = new GuiLabel(this.previews.getStructureId(), 69, 14, -1);
        GuiLabel tileCount = new GuiLabel("Tile Count:", 0, 28, -1);
        GuiLabel tile = new GuiLabel(this.previews.totalSize() + "", 54, 28, -1);
        GuiLabel childCount = new GuiLabel("Child Count:", 0, 42, -1);
        GuiLabel child = new GuiLabel(this.previews.childrenCount() + "", 60, 42, -1);
        GuiLabel hasSignal = new GuiLabel("Uses Signaling:", 0, 56, -1);
        ComponentSearch search = new ComponentSearch(this.previews, this.previews.getStructureType());
        List<SubGuiDialogSignal.GuiSignalComponent> searching = search.search(true, true, false);
        GuiLabel signal = new GuiLabel(!searching.isEmpty() + "", 76, 56, -1);
        GuiLabel fileSize = new GuiLabel("File Size:", 0, 70, -1);
        GuiLabel size = new GuiLabel((double)this.file.length() / 1000.0 + " KB", 47, 70, -1);
        GuiLabel modifyDate = new GuiLabel("Modified Date:", 0, 84, -1);
        SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
        GuiLabel date = new GuiLabel(sdf.format(this.file.lastModified()), 70, 84, -1);
        GuiLabel grid = new GuiLabel("Grid:", 0, 98);
        GuiLabel gridSize = new GuiLabel(this.previews.getContext() + "", 26, 98);
        GuiLabel colors = new GuiLabel("Dyes Required:", 0, 112, -1);
        GuiLabel black = new GuiLabel("Black:", 10, 126, 0x707070);
        GuiLabel cyan = new GuiLabel("Cyan:", 10, 140, 65535);
        GuiLabel megenta = new GuiLabel("Magenta:", 10, 154, -65281);
        GuiLabel yellow = new GuiLabel("Yellow:", 10, 168, -256);
        GuiLabel b = new GuiLabel(this.black + "", 41, 126, 0x707070);
        GuiLabel c = new GuiLabel(this.cyan + "", 39, 140, 65535);
        GuiLabel m = new GuiLabel(this.magenta + "", 55, 154, -65281);
        GuiLabel y = new GuiLabel(this.yellow + "", 45, 168, -256);
        GuiLabel material = new GuiLabel("Material Required:", 0, 200);
        GuiScrollBox scroll = new GuiScrollBox("materialBox", 0, 214, 174, 100);
        this.addControl((GuiControl)scroll);
        this.collectIngredients(scroll);
        this.addControl((GuiControl)structureID);
        this.addControl((GuiControl)id);
        this.addControl((GuiControl)structureName);
        this.addControl((GuiControl)name);
        this.addControl((GuiControl)tileCount);
        this.addControl((GuiControl)tile);
        this.addControl((GuiControl)childCount);
        this.addControl((GuiControl)child);
        this.addControl((GuiControl)hasSignal);
        this.addControl((GuiControl)signal);
        this.addControl((GuiControl)fileSize);
        this.addControl((GuiControl)size);
        this.addControl((GuiControl)modifyDate);
        this.addControl((GuiControl)date);
        this.addControl((GuiControl)grid);
        this.addControl((GuiControl)gridSize);
        this.addControl((GuiControl)colors);
        this.addControl((GuiControl)black);
        this.addControl((GuiControl)cyan);
        this.addControl((GuiControl)megenta);
        this.addControl((GuiControl)yellow);
        this.addControl((GuiControl)b);
        this.addControl((GuiControl)c);
        this.addControl((GuiControl)m);
        this.addControl((GuiControl)y);
        this.addControl((GuiControl)material);
    }

    private static class ComponentSearch {
        public LittlePreviews previews;
        public LittleStructureType type;

        public ComponentSearch(LittlePreviews previews, LittleStructureType type) {
            this.previews = previews;
            this.type = type;
        }

        public List<SubGuiDialogSignal.GuiSignalComponent> search(boolean input, boolean output, boolean includeRelations) {
            ArrayList<SubGuiDialogSignal.GuiSignalComponent> list = new ArrayList<SubGuiDialogSignal.GuiSignalComponent>();
            if (input) {
                this.gatherInputs(this.previews, this.type, "", "", list, includeRelations, true);
            }
            if (output) {
                this.gatherOutputs(this.previews, this.type, "", "", list, includeRelations, true);
            }
            return list;
        }

        protected void addInput(LittlePreviews previews, LittleStructureType type, String prefix, String totalNamePrefix, List<SubGuiDialogSignal.GuiSignalComponent> list, boolean includeRelations) {
            int i;
            String longName = previews.getStructureName();
            if (type != null && type.inputs != null) {
                for (i = 0; i < type.inputs.size(); ++i) {
                    list.add(new SubGuiDialogSignal.GuiSignalComponent(prefix + "a" + i, totalNamePrefix, (LittleStructureType.InternalComponent)type.inputs.get(i), true, false, i, longName));
                }
            }
            for (i = 0; i < previews.childrenCount(); ++i) {
                LittlePreviews child = previews.getChild(i);
                if (child == this.previews) continue;
                LittleStructureType structure = child.getStructureType();
                String name = child.getStructureName();
                if (structure instanceof ISignalComponent && ((ISignalComponent)structure).getType() == SignalComponentType.INPUT) {
                    list.add(new SubGuiDialogSignal.GuiSignalComponent(prefix + "i" + i, totalNamePrefix + (name != null ? name : "i" + i), (ISignalComponent)structure, true, i, longName));
                    continue;
                }
                if (!includeRelations) continue;
                this.gatherInputs(child, child.getStructureType(), prefix + "c" + i + ".", totalNamePrefix + (name != null ? name + "." : "c" + i + "."), list, includeRelations, false);
            }
        }

        protected void gatherInputs(LittlePreviews previews, LittleStructureType type, String prefix, String totalNamePrefix, List<SubGuiDialogSignal.GuiSignalComponent> list, boolean includeRelations, boolean searchForParent) {
            if (previews == this.previews) {
                this.addInput(previews, type, "", "", list, includeRelations);
            }
            if (searchForParent && previews.hasParent() && includeRelations) {
                this.gatherInputs(previews.getParent(), previews.getParent().getStructureType(), "p." + prefix, "p." + totalNamePrefix, list, includeRelations, true);
                return;
            }
            if (previews != this.previews) {
                this.addInput(previews, type, prefix, totalNamePrefix, list, includeRelations);
            }
        }

        protected void addOutput(LittlePreviews previews, LittleStructureType type, String prefix, String totalNamePrefix, List<SubGuiDialogSignal.GuiSignalComponent> list, boolean includeRelations) {
            int i;
            String longName = previews.getStructureName();
            if (type != null && type.outputs != null) {
                for (i = 0; i < type.outputs.size(); ++i) {
                    list.add(new SubGuiDialogSignal.GuiSignalComponent(prefix + "b" + i, totalNamePrefix, (LittleStructureType.InternalComponent)type.outputs.get(i), false, false, i, longName));
                }
            }
            for (i = 0; i < previews.childrenCount(); ++i) {
                LittlePreviews child = previews.getChild(i);
                if (child == this.previews) continue;
                LittleStructureType structure = child.getStructureType();
                String name = child.getStructureName();
                if (structure instanceof ISignalComponent && ((ISignalComponent)structure).getType() == SignalComponentType.OUTPUT) {
                    list.add(new SubGuiDialogSignal.GuiSignalComponent(prefix + "o" + i, totalNamePrefix + (name != null ? name : "o" + i), (ISignalComponent)structure, true, i, longName));
                    continue;
                }
                if (!includeRelations) continue;
                this.gatherOutputs(child, child.getStructureType(), prefix + "c" + i + ".", totalNamePrefix + (name != null ? name + "." : "c" + i + "."), list, includeRelations, false);
            }
        }

        protected void gatherOutputs(LittlePreviews previews, LittleStructureType type, String prefix, String totalNamePrefix, List<SubGuiDialogSignal.GuiSignalComponent> list, boolean includeRelations, boolean searchForParent) {
            if (previews == this.previews) {
                this.addOutput(previews, type, "", "", list, includeRelations);
            }
            if (searchForParent && previews.hasParent() && includeRelations) {
                this.gatherOutputs(previews.getParent(), previews.getParent().getStructureType(), "p." + prefix, "p." + totalNamePrefix, list, includeRelations, searchForParent);
                return;
            }
            if (previews != this.previews) {
                this.addOutput(previews, type, prefix, totalNamePrefix, list, includeRelations);
            }
        }
    }
}

