/*
 * Decompiled with CFR 0.152.
 */
package com.alet.client.gui;

import com.alet.client.gui.controls.GuiTimelineALET;
import com.alet.client.gui.controls.KeyControlALET;
import com.alet.client.gui.controls.TimelineChannelALET;
import com.alet.client.gui.controls.menu.GuiTree;
import com.alet.client.gui.controls.menu.GuiTreePart;
import com.alet.littletiles.gui.controls.GuiAnimationViewerAlet;
import com.creativemd.creativecore.common.gui.GuiControl;
import com.creativemd.creativecore.common.gui.container.GuiParent;
import com.creativemd.creativecore.common.gui.container.SubContainer;
import com.creativemd.creativecore.common.gui.container.SubGui;
import com.creativemd.creativecore.common.gui.controls.container.SlotControl;
import com.creativemd.creativecore.common.gui.controls.gui.GuiButton;
import com.creativemd.creativecore.common.gui.controls.gui.GuiIconButton;
import com.creativemd.creativecore.common.gui.controls.gui.GuiLabel;
import com.creativemd.creativecore.common.gui.controls.gui.GuiScrollBox;
import com.creativemd.creativecore.common.gui.controls.gui.GuiStateButton;
import com.creativemd.creativecore.common.gui.controls.gui.GuiTextfield;
import com.creativemd.creativecore.common.gui.controls.gui.timeline.IAnimationHandler;
import com.creativemd.creativecore.common.gui.controls.gui.timeline.TimelineChannel;
import com.creativemd.creativecore.common.gui.event.gui.GuiControlChangedEvent;
import com.creativemd.creativecore.common.gui.premade.SubContainerEmpty;
import com.creativemd.creativecore.common.packet.CreativeCorePacket;
import com.creativemd.creativecore.common.packet.PacketHandler;
import com.creativemd.creativecore.common.packet.gui.GuiLayerPacket;
import com.creativemd.creativecore.common.utils.type.Pair;
import com.creativemd.creativecore.common.utils.type.PairList;
import com.creativemd.littletiles.LittleTiles;
import com.creativemd.littletiles.client.gui.SubGuiRecipe;
import com.creativemd.littletiles.client.gui.controls.IAnimationControl;
import com.creativemd.littletiles.client.gui.dialogs.SubGuiDoorEvents;
import com.creativemd.littletiles.common.entity.AnimationPreview;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.structure.animation.AnimationGuiHandler;
import com.creativemd.littletiles.common.structure.animation.AnimationKey;
import com.creativemd.littletiles.common.structure.animation.AnimationTimeline;
import com.creativemd.littletiles.common.structure.animation.ValueTimeline;
import com.creativemd.littletiles.common.structure.animation.event.AnimationEvent;
import com.creativemd.littletiles.common.structure.registry.LittleStructureGuiParser;
import com.creativemd.littletiles.common.structure.registry.LittleStructureRegistry;
import com.creativemd.littletiles.common.structure.type.door.LittleAdvancedDoor;
import com.creativemd.littletiles.common.structure.type.door.LittleDoorBase;
import com.creativemd.littletiles.common.tile.parent.StructureTileList;
import com.creativemd.littletiles.common.tile.preview.LittlePreview;
import com.creativemd.littletiles.common.tile.preview.LittlePreviews;
import com.creativemd.littletiles.common.util.grid.LittleGridContext;
import com.n247s.api.eventapi.eventsystem.CustomEventSubscribe;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SubGuiAnimatorsWorkbench
extends SubGui
implements IAnimationControl {
    public LittleStructure structure;
    public AnimationGuiHandler handler = new AnimationGuiHandler();
    private KeyControlALET keySelected = null;
    protected SubGuiRecipe.LoadingThread loadingThread;
    public LittleStructureGuiParser parser;
    public AnimationPreview animationPreview;
    public SubGuiRecipe.StructureHolder selected;

    public SubGuiAnimatorsWorkbench(LittleStructure structure) {
        this.width = 500;
        this.height = 300;
    }

    @CustomEventSubscribe
    public void controlChanged(GuiControlChangedEvent event) {
        if (event.source.name.equals("maxTick")) {
            String dur = ((GuiTextfield)this.get((String)"maxTick")).text;
            int duration = 1;
            if (!dur.equals("")) {
                duration = Integer.parseInt(dur);
            }
            ((GuiTimelineALET)this.get("timeline")).setDuration(duration);
        }
        if (event.source.is(new String[]{"timeline"}) && this.keySelected != null) {
            GuiTextfield tickAt = (GuiTextfield)this.get("tickAt");
            tickAt.text = this.keySelected.tick + "";
        }
        if (event.source instanceof GuiTextfield) {
            GuiTextfield text = (GuiTextfield)event.source;
            if (this.keySelected != null) {
                double[] data = (double[])this.keySelected.value;
                if (!text.text.equals("")) {
                    if (text.name.equals("offX")) {
                        data[0] = Double.parseDouble(text.text);
                    } else if (text.name.equals("offY")) {
                        data[1] = Double.parseDouble(text.text);
                    } else if (text.name.equals("offZ")) {
                        data[2] = Double.parseDouble(text.text);
                    } else if (text.name.equals("rotX")) {
                        data[3] = Double.parseDouble(text.text);
                    } else if (text.name.equals("rotY")) {
                        data[4] = Double.parseDouble(text.text);
                    } else if (text.name.equals("rotZ")) {
                        data[5] = Double.parseDouble(text.text);
                    }
                }
            }
        }
    }

    @CustomEventSubscribe
    @SideOnly(value=Side.CLIENT)
    public void onKeySelected(GuiTimelineALET.KeyALETSelectedEvent event) {
        KeyControlALET key;
        this.keySelected = key = (KeyControlALET)event.source;
        double[] data = (double[])key.value;
        GuiTextfield offX = (GuiTextfield)this.get("offX");
        GuiTextfield offY = (GuiTextfield)this.get("offY");
        GuiTextfield offZ = (GuiTextfield)this.get("offZ");
        GuiTextfield rotX = (GuiTextfield)this.get("rotX");
        GuiTextfield rotY = (GuiTextfield)this.get("rotY");
        GuiTextfield rotZ = (GuiTextfield)this.get("rotZ");
        GuiTextfield tickAt = (GuiTextfield)this.get("tickAt");
        offX.text = data[0] + "";
        offY.text = data[1] + "";
        offZ.text = data[2] + "";
        rotX.text = data[3] + "";
        rotY.text = data[4] + "";
        rotZ.text = data[5] + "";
        tickAt.text = key.tick + "";
        offX.setCursorPositionEnd();
        offY.setCursorPositionEnd();
        offZ.setCursorPositionEnd();
        rotX.setCursorPositionEnd();
        rotY.setCursorPositionEnd();
        rotZ.setCursorPositionEnd();
        offX.enabled = true;
        offY.enabled = true;
        offZ.enabled = true;
        rotX.enabled = true;
        rotY.enabled = true;
        rotZ.enabled = true;
    }

    @CustomEventSubscribe
    @SideOnly(value=Side.CLIENT)
    public void onKeyDeselected(GuiTimelineALET.KeyALETDeselectedEvent event) {
        this.keySelected = null;
        GuiTextfield offX = (GuiTextfield)this.get("offX");
        GuiTextfield offY = (GuiTextfield)this.get("offY");
        GuiTextfield offZ = (GuiTextfield)this.get("offZ");
        GuiTextfield rotX = (GuiTextfield)this.get("rotX");
        GuiTextfield rotY = (GuiTextfield)this.get("rotY");
        GuiTextfield rotZ = (GuiTextfield)this.get("rotZ");
        offX.text = "";
        offY.text = "";
        offZ.text = "";
        rotX.text = "";
        rotY.text = "";
        rotZ.text = "";
        offX.setCursorPositionEnd();
        offY.setCursorPositionEnd();
        offZ.setCursorPositionEnd();
        rotX.setCursorPositionEnd();
        rotY.setCursorPositionEnd();
        rotZ.setCursorPositionEnd();
        offX.enabled = false;
        offY.enabled = false;
        offZ.enabled = false;
        rotX.enabled = false;
        rotY.enabled = false;
        rotZ.enabled = false;
    }

    public void onTick() {
        super.onTick();
        if (this.loadingThread != null && this.loadingThread.result != null) {
            this.animationPreview = this.loadingThread.result;
            this.loadingThread = null;
            this.onLoaded(this.animationPreview);
            if (this.parser != null) {
                this.parser.onLoaded(this.animationPreview);
            }
        }
        if (this.animationPreview != null) {
            this.handler.tick(this.animationPreview.previews, this.animationPreview.animation.structure, this.animationPreview.animation);
        }
    }

    protected static SubGuiRecipe.StructureHolder addPreviews(LittlePreviews previews, SubGuiRecipe.StructureHolder holder) {
        holder = new SubGuiRecipe.StructureHolder(null, -1, 0);
        holder.previews = previews;
        holder.prefix = "";
        ItemStack stack = new ItemStack(LittleTiles.multiTiles);
        LittlePreviews newPreviews = new LittlePreviews(previews.getContext());
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        int minZ = Integer.MAX_VALUE;
        for (LittlePreview preview : previews) {
            newPreviews.addWithoutCheckingPreview(preview.copy());
            minX = Math.min(minX, preview.box.minX);
            minY = Math.min(minY, preview.box.minY);
            minZ = Math.min(minZ, preview.box.minZ);
            minX = Math.min(minX, preview.box.maxX);
            minY = Math.min(minY, preview.box.maxY);
            minZ = Math.min(minZ, preview.box.maxZ);
        }
        for (LittlePreview preview : newPreviews) {
            preview.box.sub(minX, minY, minZ);
        }
        LittlePreview.savePreview((LittlePreviews)newPreviews, (ItemStack)stack);
        holder.explicit = stack;
        return holder;
    }

    public void createControls() {
        final SubContainer container = this.container;
        final GuiAnimationViewerAlet viewer = new GuiAnimationViewerAlet("renderer", 307, 0, 181, 180);
        this.controls.add(viewer);
        viewer.moveViewPort(0, 109);
        GuiScrollBox scroll = new GuiScrollBox("scroll", 0, 0, 135, 180);
        this.controls.add(scroll);
        ArrayList<GuiTreePart> list = new ArrayList<GuiTreePart>();
        scroll.controls.add(new GuiTree("tree", 0, 0, 130, list, true, 0, 0, 50));
        GuiScrollBox scrollTimeline = new GuiScrollBox("scrollTimeline", 20, 187, 468, 101);
        this.controls.add(scrollTimeline);
        ArrayList<TimelineChannelALET> channels = new ArrayList<TimelineChannelALET>();
        scrollTimeline.controls.add(new GuiTimelineALET("timeline", -1, -1, 462, 1000, 10, channels, (IAnimationHandler)this.handler).setSidebarWidth(32));
        this.controls.add(new GuiDoorEventsButtonALET("children_activate", 93, 107, null, null));
        this.controls.add(new GuiLabel("Tick At:", 219, 173));
        this.controls.add(new GuiTextfield("tickAt", "", 258, 174, 40, 6));
        this.controls.add(new GuiLabel("Ticks:", 140, 173));
        this.controls.add(new GuiTextfield("maxTick", "10", 172, 174, 40, 6));
        this.controls.add(new GuiLabel("Offset(X):", 203, 83));
        this.controls.add(new GuiLabel("Offset(Y):", 203, 97));
        this.controls.add(new GuiLabel("Offset(Z):", 203, 110));
        this.controls.add(new GuiTextfield("offX", "", 258, 84, 40, 6).setFloatOnly());
        this.controls.add(new GuiTextfield("offY", "", 258, 98, 40, 6).setFloatOnly());
        this.controls.add(new GuiTextfield("offZ", "", 258, 111, 40, 6).setFloatOnly());
        this.controls.add(new GuiLabel("Rotate(X):", 203, 127));
        this.controls.add(new GuiLabel("Rotate(Y):", 203, 140));
        this.controls.add(new GuiLabel("Rotate(Z):", 203, 153));
        this.controls.add(new GuiTextfield("rotX", "", 258, 128, 40, 6).setFloatOnly());
        this.controls.add(new GuiTextfield("rotY", "", 258, 141, 40, 6).setFloatOnly());
        this.controls.add(new GuiTextfield("rotZ", "", 258, 154, 40, 6).setFloatOnly());
        this.controls.add(new GuiStateButton("interpolation", 0, 140, 107, 40, 7, ValueTimeline.interpolationTypes));
        this.controls.add(new GuiIconButton("play", 0, 228, 10){

            public void onClicked(int x, int y, int button) {
                SubGuiAnimatorsWorkbench.this.handler.play();
            }
        });
        this.controls.add(new GuiIconButton("pause", 0, 252, 9){

            public void onClicked(int x, int y, int button) {
                SubGuiAnimatorsWorkbench.this.handler.pause();
            }
        });
        this.controls.add(new GuiIconButton("stop", 0, 276, 11){

            public void onClicked(int x, int y, int button) {
                SubGuiAnimatorsWorkbench.this.handler.stop();
            }
        });
        this.addControl((GuiControl)new GuiButton("save", "Save", 144, 122, 40){

            public void onClicked(int x, int y, int button) {
            }
        });
        this.addControl((GuiControl)new GuiButton("refresh", "Refresh", 144, 100, 40){

            public void onClicked(int x, int y, int button) {
                LittlePreviews previews;
                SlotControl slot = (SlotControl)container.get("input0");
                ItemStack stack = slot.slot.func_75211_c();
                if (stack != null && !stack.equals(ItemStack.field_190927_a) && !(previews = LittlePreview.getPreview((ItemStack)stack)).isEmpty()) {
                    GuiTree tree = (GuiTree)this.parent.get("tree");
                    GuiTimelineALET timeline = (GuiTimelineALET)this.parent.get("timeline");
                    LittleAdvancedDoor structure = (LittleAdvancedDoor)StructureTileList.create((NBTTagCompound)previews.structureNBT, null);
                    SubGuiAnimatorsWorkbench.this.structure = structure;
                    GuiDoorEventsButtonALET children = (GuiDoorEventsButtonALET)this.parent.get("children_activate");
                    children.update(previews, (LittleDoorBase)structure);
                    String partName = this.addField(previews, timeline, tree, null);
                    GuiTreePart part = new GuiTreePart(partName, GuiTreePart.EnumPartType.Title);
                    for (LittlePreviews child : previews.getChildren()) {
                        String childPartName = this.addField(child, timeline, tree, part);
                        GuiTreePart childPart = new GuiTreePart(childPartName, GuiTreePart.EnumPartType.Branch);
                        part.addMenu(childPart);
                        this.collectStructures(child, timeline, tree, childPart);
                    }
                    ArrayList<GuiTreePart> list = new ArrayList<GuiTreePart>();
                    list.add(part);
                    tree.replaceTree(list);
                    AnimationPreview anim = new AnimationPreview(previews);
                    viewer.onLoaded(anim);
                    SubGuiAnimatorsWorkbench.this.loadStack(SubGuiAnimatorsWorkbench.this.getHolder(previews, stack), previews, anim);
                }
            }

            public String addField(LittlePreviews previews, GuiTimelineALET timeline, GuiTree tree, GuiTreePart part) {
                LittleAdvancedDoor structure = (LittleAdvancedDoor)StructureTileList.create((NBTTagCompound)previews.structureNBT, null);
                PairList<Integer, double[]> keys = this.collectKeys(structure, timeline);
                if (previews.getStructureName() != null) {
                    TimelineChannelALET.TimelineChannelDoorData line = new TimelineChannelALET.TimelineChannelDoorData(previews.getStructureName());
                    line.index = timeline.channels.size();
                    line.addKeys(keys);
                    timeline.channels.add(line);
                    timeline.refreshChannels();
                    this.updateTimeLine(timeline, previews);
                    return previews.getStructureName();
                }
                TimelineChannelALET.TimelineChannelDoorData line = new TimelineChannelALET.TimelineChannelDoorData(previews.getStructureId());
                line.index = timeline.channels.size();
                line.addKeys(keys);
                timeline.channels.add(line);
                timeline.refreshChannels();
                this.updateTimeLine(timeline, previews);
                return previews.getStructureId();
            }

            public void collectStructures(LittlePreviews child, GuiTimelineALET timeline, GuiTree tree, GuiTreePart part) {
                if (child.hasChildren()) {
                    for (LittlePreviews child2 : child.getChildren()) {
                        String childPartName = this.addField(child2, timeline, tree, part);
                        GuiTreePart childPart = new GuiTreePart(childPartName, GuiTreePart.EnumPartType.Leaf);
                        part.addMenu(childPart);
                    }
                }
            }

            public void updateTimeLine(GuiTimelineALET timeline, LittlePreviews previews) {
                LittleGridContext context = previews.getContext();
                GuiDoorEventsButtonALET children = (GuiDoorEventsButtonALET)this.parent.get("children_activate");
                GuiStateButton interpolationButton = (GuiStateButton)this.parent.get("interpolation");
                int interpolation = interpolationButton.getState();
                TimelineChannelALET.TimelineChannelDoorData door = (TimelineChannelALET.TimelineChannelDoorData)timeline.channels.get(0);
                AnimationTimeline animation = new AnimationTimeline(timeline.getDuration(), new PairList());
                if (door.getPairs() != null) {
                    ValueTimeline offZ;
                    ValueTimeline offY;
                    ValueTimeline offX;
                    ValueTimeline rotZ;
                    ValueTimeline rotY;
                    TimelineChannel.TimelineChannelInteger chOffX = new TimelineChannel.TimelineChannelInteger("offX");
                    TimelineChannel.TimelineChannelInteger chOffY = new TimelineChannel.TimelineChannelInteger("offY");
                    TimelineChannel.TimelineChannelInteger chOffZ = new TimelineChannel.TimelineChannelInteger("offZ");
                    TimelineChannel.TimelineChannelDouble chRotX = new TimelineChannel.TimelineChannelDouble("rotX");
                    TimelineChannel.TimelineChannelDouble chRotY = new TimelineChannel.TimelineChannelDouble("rotY");
                    TimelineChannel.TimelineChannelDouble chRotZ = new TimelineChannel.TimelineChannelDouble("rotZ");
                    for (Pair pair : door.getPairs()) {
                        chOffX.addKey(((Integer)pair.key).intValue(), (Object)((int)((double[])pair.value)[0]));
                        chOffY.addKey(((Integer)pair.key).intValue(), (Object)((int)((double[])pair.value)[1]));
                        chOffZ.addKey(((Integer)pair.key).intValue(), (Object)((int)((double[])pair.value)[2]));
                        chRotX.addKey(((Integer)pair.key).intValue(), (Object)((double[])pair.value)[3]);
                        chRotY.addKey(((Integer)pair.key).intValue(), (Object)((double[])pair.value)[4]);
                        chRotZ.addKey(((Integer)pair.key).intValue(), (Object)((double[])pair.value)[5]);
                    }
                    ValueTimeline rotX = ValueTimeline.create((int)interpolation, (PairList)chRotX.getPairs());
                    if (rotX != null) {
                        animation.values.add((Object)AnimationKey.rotX, (Object)rotX);
                    }
                    if ((rotY = ValueTimeline.create((int)interpolation, (PairList)chRotY.getPairs())) != null) {
                        animation.values.add((Object)AnimationKey.rotY, (Object)rotY);
                    }
                    if ((rotZ = ValueTimeline.create((int)interpolation, (PairList)chRotZ.getPairs())) != null) {
                        animation.values.add((Object)AnimationKey.rotZ, (Object)rotZ);
                    }
                    if ((offX = ValueTimeline.create((int)interpolation, (PairList)chOffX.getPairs())) != null) {
                        animation.values.add((Object)AnimationKey.offX, (Object)offX.factor(16.0));
                    }
                    if ((offY = ValueTimeline.create((int)interpolation, (PairList)chOffY.getPairs())) != null) {
                        animation.values.add((Object)AnimationKey.offY, (Object)offY.factor(16.0));
                    }
                    if ((offZ = ValueTimeline.create((int)interpolation, (PairList)chOffZ.getPairs())) != null) {
                        animation.values.add((Object)AnimationKey.offZ, (Object)offZ.factor(16.0));
                    }
                    SubGuiAnimatorsWorkbench.this.handler.setTimeline(animation, children.events);
                    timeline.handler = SubGuiAnimatorsWorkbench.this.handler;
                }
            }

            public PairList<Integer, double[]> collectKeys(LittleAdvancedDoor structure, GuiTimelineALET timeline) {
                double[] data;
                PairList key = new PairList();
                for (Pair point : structure.offX.getPointsCopy()) {
                    data = new double[6];
                    if (key.containsKey(point.key)) {
                        data = (double[])key.getPair((Object)point.key).value;
                        data[0] = (Double)point.value;
                        key.set((Object)new Integer((Integer)point.key), (Object)data);
                        continue;
                    }
                    data[0] = (Double)point.value;
                    key.add((Object)new Integer((Integer)point.key), (Object)data);
                }
                for (Pair point : structure.offY.getPointsCopy()) {
                    data = new double[6];
                    if (key.containsKey(point.key)) {
                        data = (double[])key.getPair((Object)point.key).value;
                        data[1] = (Double)point.value;
                        key.set((Object)new Integer((Integer)point.key), (Object)data);
                        continue;
                    }
                    data[1] = (Double)point.value;
                    key.add((Object)new Integer((Integer)point.key), (Object)data);
                }
                for (Pair point : structure.offZ.getPointsCopy()) {
                    data = new double[6];
                    if (key.containsKey(point.key)) {
                        data = (double[])key.getPair((Object)point.key).value;
                        data[2] = (Double)point.value;
                        key.set((Object)new Integer((Integer)point.key), (Object)data);
                        continue;
                    }
                    data[2] = (Double)point.value;
                    key.add((Object)new Integer((Integer)point.key), (Object)data);
                }
                for (Pair point : structure.rotX.getPointsCopy()) {
                    data = new double[6];
                    if (key.containsKey(point.key)) {
                        data = (double[])key.getPair((Object)point.key).value;
                        data[3] = (Double)point.value;
                        key.set((Object)new Integer((Integer)point.key), (Object)data);
                        continue;
                    }
                    data[3] = (Double)point.value;
                    key.add((Object)new Integer((Integer)point.key), (Object)data);
                }
                for (Pair point : structure.rotY.getPointsCopy()) {
                    data = new double[6];
                    if (key.containsKey(point.key)) {
                        data = (double[])key.getPair((Object)point.key).value;
                        data[4] = (Double)point.value;
                        key.set((Object)new Integer((Integer)point.key), (Object)data);
                        continue;
                    }
                    data[4] = (Double)point.value;
                    key.add((Object)new Integer((Integer)point.key), (Object)data);
                }
                for (Pair point : structure.rotZ.getPointsCopy()) {
                    data = new double[6];
                    if (key.containsKey(point.key)) {
                        data = (double[])key.getPair((Object)point.key).value;
                        data[5] = (Double)point.value;
                        key.set((Object)new Integer((Integer)point.key), (Object)data);
                        continue;
                    }
                    data[5] = (Double)point.value;
                    key.add((Object)new Integer((Integer)point.key), (Object)data);
                }
                return key;
            }
        });
    }

    public SubGuiRecipe.StructureHolder getHolder(LittlePreviews previews, ItemStack stack) {
        SubGuiRecipe.StructureHolder holder = new SubGuiRecipe.StructureHolder(null, -1, 0);
        holder.previews = previews;
        holder.prefix = "";
        holder.explicit = stack;
        return holder;
    }

    public void loadStack(SubGuiRecipe.StructureHolder holder, LittlePreviews previews, AnimationPreview anim) {
        this.selected = holder;
        this.animationPreview = null;
        if (this.loadingThread != null && this.loadingThread.isAlive()) {
            this.loadingThread.stop();
        }
        this.loadingThread = new SubGuiRecipe.LoadingThread(previews);
        this.getParser(previews);
    }

    public void getParser(LittlePreviews previews) {
        if (this.parser != null) {
            this.removeListener(this.parser);
        }
        this.parser = LittleStructureRegistry.getParserNotFound((GuiParent)this, (AnimationGuiHandler)this.handler, (LittleStructure)this.structure);
    }

    public void onLoaded(GuiParent parent, AnimationPreview animationPreview) {
        for (GuiControl control : parent.controls) {
            if (control instanceof IAnimationControl) {
                ((IAnimationControl)control).onLoaded(animationPreview);
            }
            if (!(control instanceof GuiParent)) continue;
            this.onLoaded((GuiParent)control, animationPreview);
        }
    }

    public void onLoaded(AnimationPreview preview) {
        this.onLoaded((GuiParent)this, this.animationPreview);
    }

    public static class GuiDoorEventsButtonALET
    extends SubGuiDoorEvents.GuiDoorEventsButton {
        public SubGuiDoorEvents gui;
        public LittlePreviews previews;
        public LittleDoorBase activator;
        public List<AnimationEvent> events = new ArrayList<AnimationEvent>();

        public GuiDoorEventsButtonALET(String name, int x, int y, LittlePreviews previews, LittleDoorBase door) {
            super(name, x, y, previews, door);
            this.previews = previews;
            this.activator = door;
            if (this.activator != null) {
                this.events = this.activator.events;
            }
        }

        public void update(LittlePreviews previews, LittleDoorBase door) {
            this.previews = previews;
            this.activator = door;
            if (this.activator != null) {
                this.events = this.activator.events;
            }
        }

        public void onClicked(int x, int y, int button) {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74757_a("dialog", true);
            SubGuiDoorEvents dialog = new SubGuiDoorEvents((SubGuiDoorEvents.GuiDoorEventsButton)this);
            dialog.gui = this.getParent().getGui().gui;
            PacketHandler.sendPacketToServer((CreativeCorePacket)new GuiLayerPacket(nbt, dialog.gui.getLayers().size() - 1, false));
            dialog.container = new SubContainerEmpty(this.getPlayer());
            dialog.gui.addLayer((SubGui)dialog);
            dialog.onOpened();
        }
    }
}

