/*
 * Decompiled with CFR 0.152.
 */
package dev.redstudio.alfheim.mixin;

import dev.redstudio.alfheim.api.IChunkLightingData;
import dev.redstudio.alfheim.api.ILightingEngineProvider;
import dev.redstudio.alfheim.lighting.LightUtil;
import dev.redstudio.alfheim.lighting.LightingEngine;
import dev.redstudio.alfheim.utils.EnumBoundaryFacing;
import dev.redstudio.alfheim.utils.WorldChunkSlice;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Chunk.class})
public abstract class ChunkMixin
implements IChunkLightingData,
ILightingEngineProvider {
    @Final
    @Shadow
    private boolean[] field_76639_c;
    @Shadow
    private boolean field_76643_l;
    @Shadow
    private boolean field_76646_k;
    @Shadow
    private boolean field_76650_s;
    @Final
    @Shadow
    public int field_76635_g;
    @Final
    @Shadow
    public int field_76647_h;
    @Shadow
    @Final
    private int[] field_76634_f;
    @Shadow
    private int field_82912_p;
    @Shadow
    @Final
    private World field_76637_e;
    @Shadow
    @Final
    private ExtendedBlockStorage[] field_76652_q;
    @Unique
    private static final EnumFacing[] ENUM_FACING_HORIZONTAL = EnumFacing.Plane.HORIZONTAL.func_179516_a();
    @Unique
    private static final EnumSkyBlock[] ENUM_SKY_BLOCK_VALUES = EnumSkyBlock.values();
    @Unique
    private static final EnumFacing.AxisDirection[] ENUM_AXIS_DIRECTION_VALUES = EnumFacing.AxisDirection.values();
    @Unique
    private boolean alfheim$isLightInitialized;
    @Unique
    private short[] alfheim$neighborLightChecks;
    @Unique
    private LightingEngine alfheim$lightingEngine;

    @Shadow
    protected abstract int func_150808_b(int var1, int var2, int var3);

    @Shadow
    public abstract boolean func_177444_d(BlockPos var1);

    @Shadow
    protected abstract void func_177441_y();

    @Shadow
    public abstract int func_76611_b(int var1, int var2);

    @Inject(method={"<init>*"}, at={@At(value="RETURN")})
    private void onConstructed(CallbackInfo callbackInfo) {
        this.alfheim$lightingEngine = ((ILightingEngineProvider)this.field_76637_e).alfheim$getLightingEngine();
    }

    @Inject(method={"getLightSubtracted"}, at={@At(value="HEAD")})
    private void onGetLightSubtracted(BlockPos blockPos, int amount, CallbackInfoReturnable<Integer> callbackInfoReturnable) {
        this.alfheim$lightingEngine.processLightUpdates();
    }

    @Inject(method={"onLoad"}, at={@At(value="RETURN")})
    private void onLoad(CallbackInfo callbackInfo) {
        Chunk chunk = (Chunk)this;
        for (EnumFacing facing : EnumFacing.field_176754_o) {
            int xOffset = facing.func_82601_c();
            int zOffset = facing.func_82599_e();
            Chunk nChunk = this.field_76637_e.func_72863_F().func_186026_b(chunk.field_76635_g + xOffset, chunk.field_76647_h + zOffset);
            if (nChunk == null) continue;
            for (EnumSkyBlock lightType : ENUM_SKY_BLOCK_VALUES) {
                for (EnumFacing.AxisDirection axisDir : ENUM_AXIS_DIRECTION_VALUES) {
                    ChunkMixin.alfheim$mergeFlags(lightType, chunk, nChunk, facing, axisDir);
                    ChunkMixin.alfheim$mergeFlags(lightType, nChunk, chunk, facing.func_176734_d(), axisDir);
                    this.alfheim$scheduleRelightChecksForBoundary(chunk, nChunk, null, lightType, xOffset, zOffset, axisDir);
                    this.alfheim$scheduleRelightChecksForBoundary(nChunk, chunk, null, lightType, -xOffset, -zOffset, axisDir);
                    this.alfheim$scheduleRelightChecksForBoundary(nChunk, null, chunk, lightType, zOffset != 0 ? axisDir.func_179524_a() : 0, xOffset != 0 ? axisDir.func_179524_a() : 0, facing.func_176743_c() == EnumFacing.AxisDirection.POSITIVE ? EnumFacing.AxisDirection.NEGATIVE : EnumFacing.AxisDirection.POSITIVE);
                }
            }
        }
    }

    @Redirect(method={"setLightFor"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/chunk/Chunk;generateSkylightMap()V"), expect=0)
    private void setLightForRedirectGenerateSkylightMap(Chunk chunk, EnumSkyBlock lightType, BlockPos blockPos, int value) {
        this.alfheim$initSkylightForSection(this.field_76652_q[blockPos.func_177956_o() >> 4]);
    }

    @Overwrite
    private void func_76615_h(int x, int y, int z) {
        int heightMapY1;
        int newHeightMapY;
        int heightMapY = this.field_76634_f[z << 4 | x] & 0xFF;
        for (newHeightMapY = Math.max(y, heightMapY); newHeightMapY > 0 && this.func_150808_b(x, newHeightMapY - 1, z) == 0; --newHeightMapY) {
        }
        if (newHeightMapY == heightMapY) {
            return;
        }
        this.field_76634_f[z << 4 | x] = newHeightMapY;
        if (this.field_76637_e.field_73011_w.func_191066_m()) {
            this.alfheim$relightSkylightColumn(x, z, heightMapY, newHeightMapY);
        }
        if ((heightMapY1 = this.field_76634_f[z << 4 | x]) < this.field_82912_p) {
            this.field_82912_p = heightMapY1;
        }
    }

    @Overwrite
    public int func_177413_a(EnumSkyBlock lightType, BlockPos pos) {
        this.alfheim$lightingEngine.processLightUpdatesForType(lightType);
        return this.alfheim$getCachedLightFor(lightType, pos);
    }

    @Overwrite
    public void func_150809_p() {
        this.field_76646_k = true;
        Chunk chunk = (Chunk)this;
        if (!((IChunkLightingData)chunk).alfheim$isLightInitialized()) {
            ChunkMixin.alfheim$initChunkLighting(chunk, this.field_76637_e);
        }
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                Chunk nChunk;
                if (x == 0 && z == 0 || (nChunk = this.field_76637_e.func_72863_F().func_186026_b(chunk.field_76635_g + x, chunk.field_76647_h + z)) != null && ((IChunkLightingData)nChunk).alfheim$isLightInitialized()) continue;
                return;
            }
        }
        chunk.func_177421_e(true);
    }

    @Overwrite
    private void func_150803_c(boolean onlyOne) {
        if (!this.field_76637_e.func_175697_a(new BlockPos((this.field_76635_g << 4) + 8, 0, (this.field_76647_h << 4) + 8), 16)) {
            return;
        }
        WorldChunkSlice slice = new WorldChunkSlice(this.field_76637_e.func_72863_F(), this.field_76635_g, this.field_76647_h);
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                if (!this.alfheim$recheckGapsForColumn(slice, x, z) || !onlyOne) continue;
                return;
            }
        }
        this.field_76650_s = false;
    }

    @Redirect(method={"setBlockState"}, at=@At(value="NEW", args={"class=net/minecraft/world/chunk/storage/ExtendedBlockStorage"}), expect=0)
    private ExtendedBlockStorage setBlockStateCreateSectionVanilla(int y, boolean hasSkyLight) {
        ExtendedBlockStorage extendedBlockStorage = new ExtendedBlockStorage(y, hasSkyLight);
        this.alfheim$initSkylightForSection(extendedBlockStorage);
        return extendedBlockStorage;
    }

    @ModifyVariable(method={"setBlockState"}, at=@At(value="STORE", ordinal=1), name={"flag"})
    private boolean preventGenerateSkylightMap(boolean original) {
        return false;
    }

    @Redirect(method={"setBlockState"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/chunk/Chunk;propagateSkylightOcclusion(II)V"))
    private void doPropagateSkylight(Chunk chunk, int x, int z) {
    }

    @Redirect(method={"setBlockState"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/chunk/Chunk;getLightFor(Lnet/minecraft/world/EnumSkyBlock;Lnet/minecraft/util/math/BlockPos;)I"))
    private int fakeGetLightFor(Chunk chunk, EnumSkyBlock lightType, BlockPos blockPos) {
        return 0;
    }

    @Unique
    private boolean alfheim$recheckGapsForColumn(WorldChunkSlice slice, int x, int z) {
        int i = x + z * 16;
        if (this.field_76639_c[i]) {
            this.field_76639_c[i] = false;
            int x1 = this.field_76635_g * 16 + x;
            int z1 = this.field_76647_h * 16 + z;
            this.alfheim$recheckGapsSkylightNeighborHeight(slice, x1, z1, this.func_76611_b(x, z), this.alfheim$recheckGapsGetLowestHeight(slice, x1, z1));
            return true;
        }
        return false;
    }

    @Unique
    private int alfheim$recheckGapsGetLowestHeight(WorldChunkSlice slice, int x, int z) {
        int max = Integer.MAX_VALUE;
        for (EnumFacing facing : ENUM_FACING_HORIZONTAL) {
            Chunk chunk = slice.getChunkFromWorldCoords(x + facing.func_82601_c(), z + facing.func_82599_e());
            if (chunk == null) continue;
            max = Math.min(max, chunk.func_177442_v());
        }
        return max;
    }

    @Unique
    private void alfheim$recheckGapsSkylightNeighborHeight(WorldChunkSlice slice, int x, int z, int height, int max) {
        this.alfheim$checkSkylightNeighborHeight(slice, x, z, max);
        for (EnumFacing facing : ENUM_FACING_HORIZONTAL) {
            this.alfheim$checkSkylightNeighborHeight(slice, x + facing.func_82601_c(), z + facing.func_82599_e(), height);
        }
    }

    @Unique
    private void alfheim$checkSkylightNeighborHeight(WorldChunkSlice slice, int x, int z, int maxValue) {
        if (slice.getChunkFromWorldCoords(x, z) == null) {
            return;
        }
        int y = slice.getChunkFromWorldCoords(x, z).func_76611_b(x & 0xF, z & 0xF);
        if (y > maxValue) {
            this.alfheim$updateSkylightNeighborHeight(slice, x, z, maxValue, y + 1);
        } else if (y < maxValue) {
            this.alfheim$updateSkylightNeighborHeight(slice, x, z, y, maxValue + 1);
        }
    }

    @Unique
    private void alfheim$updateSkylightNeighborHeight(WorldChunkSlice slice, int x, int z, int startY, int endY) {
        if (endY < startY) {
            return;
        }
        if (!slice.isLoaded(x, z, 16)) {
            return;
        }
        for (int y = startY; y < endY; ++y) {
            this.field_76637_e.func_180500_c(EnumSkyBlock.SKY, new BlockPos(x, y, z));
        }
        this.field_76643_l = true;
    }

    @Unique
    private static void alfheim$mergeFlags(EnumSkyBlock lightType, Chunk inChunk, Chunk outChunk, EnumFacing dir, EnumFacing.AxisDirection axisDirection) {
        IChunkLightingData outChunkLightingData = (IChunkLightingData)outChunk;
        if (outChunkLightingData.alfheim$getNeighborLightChecks() == null) {
            return;
        }
        ((IChunkLightingData)inChunk).alfheim$initNeighborLightChecks();
        int inIndex = ChunkMixin.alfheim$getFlagIndex(lightType, dir, axisDirection, EnumBoundaryFacing.IN);
        int outIndex = ChunkMixin.alfheim$getFlagIndex(lightType, dir.func_176734_d(), axisDirection, EnumBoundaryFacing.OUT);
        short[] sArray = ((IChunkLightingData)inChunk).alfheim$getNeighborLightChecks();
        int n = inIndex;
        sArray[n] = (short)(sArray[n] | outChunkLightingData.alfheim$getNeighborLightChecks()[outIndex]);
    }

    @Unique
    private void alfheim$scheduleRelightChecksForBoundary(Chunk chunk, Chunk nChunk, Chunk sChunk, EnumSkyBlock lightType, int xOffset, int zOffset, EnumFacing.AxisDirection axisDirection) {
        IChunkLightingData chunkLightingData = (IChunkLightingData)chunk;
        if (chunkLightingData.alfheim$getNeighborLightChecks() == null) {
            return;
        }
        int flagIndex = ChunkMixin.alfheim$getFlagIndex(lightType, xOffset, zOffset, axisDirection, EnumBoundaryFacing.IN);
        short flags = chunkLightingData.alfheim$getNeighborLightChecks()[flagIndex];
        if (flags == 0) {
            return;
        }
        if (nChunk == null && (nChunk = this.field_76637_e.func_72863_F().func_186026_b(chunk.field_76635_g + xOffset, chunk.field_76647_h + zOffset)) == null) {
            return;
        }
        if (sChunk == null && (sChunk = this.field_76637_e.func_72863_F().func_186026_b(chunk.field_76635_g + (zOffset != 0 ? axisDirection.func_179524_a() : 0), chunk.field_76647_h + (xOffset != 0 ? axisDirection.func_179524_a() : 0))) == null) {
            return;
        }
        int reverseIndex = ChunkMixin.alfheim$getFlagIndex(lightType, -xOffset, -zOffset, axisDirection, EnumBoundaryFacing.OUT);
        chunkLightingData.alfheim$getNeighborLightChecks()[flagIndex] = 0;
        IChunkLightingData nChunkLightingData = (IChunkLightingData)nChunk;
        if (nChunkLightingData.alfheim$getNeighborLightChecks() != null) {
            nChunkLightingData.alfheim$getNeighborLightChecks()[reverseIndex] = 0;
        }
        chunk.func_76630_e();
        nChunk.func_76630_e();
        int xMin = chunk.field_76635_g << 4;
        int zMin = chunk.field_76647_h << 4;
        if ((xOffset | zOffset) > 0) {
            xMin += 15 * xOffset;
            zMin += 15 * zOffset;
        }
        if (axisDirection == EnumFacing.AxisDirection.POSITIVE) {
            xMin += 8 * (zOffset & 1);
            zMin += 8 * (xOffset & 1);
        }
        int xMax = xMin + 7 * (zOffset & 1);
        int zMax = zMin + 7 * (xOffset & 1);
        for (int y = 0; y < 16; ++y) {
            if ((flags & 1 << y) == 0) continue;
            for (int x = xMin; x <= xMax; ++x) {
                for (int z = zMin; z <= zMax; ++z) {
                    this.alfheim$scheduleRelightChecksForColumn(lightType, x, z, y << 4, (y << 4) + 15);
                }
            }
        }
    }

    @Unique
    private void alfheim$initSkylightForSection(ExtendedBlockStorage extendedBlockStorage) {
        if (!this.field_76637_e.field_73011_w.func_191066_m()) {
            return;
        }
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                if (((Chunk)this).func_76611_b(x, z) > extendedBlockStorage.func_76662_d()) continue;
                for (int y = 0; y < 16; ++y) {
                    extendedBlockStorage.func_76657_c(x, y, z, EnumSkyBlock.SKY.field_77198_c);
                }
            }
        }
    }

    @Unique
    private void alfheim$scheduleRelightChecksForColumn(EnumSkyBlock lightType, int x, int z, int yMin, int yMax) {
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        for (int y = yMin; y <= yMax; ++y) {
            this.field_76637_e.func_180500_c(lightType, (BlockPos)mutableBlockPos.func_181079_c(x, y, z));
        }
    }

    @Unique
    private static int alfheim$getFlagIndex(EnumSkyBlock lightType, int xOffset, int zOffset, EnumFacing.AxisDirection axisDirection, EnumBoundaryFacing boundaryFacing) {
        return (lightType == EnumSkyBlock.BLOCK ? 0 : 16) | xOffset + 1 << 2 | zOffset + 1 << 1 | axisDirection.func_179524_a() + 1 | boundaryFacing.ordinal();
    }

    @Unique
    private static int alfheim$getFlagIndex(EnumSkyBlock lightType, EnumFacing facing, EnumFacing.AxisDirection axisDirection, EnumBoundaryFacing boundaryFacing) {
        return ChunkMixin.alfheim$getFlagIndex(lightType, facing.func_82601_c(), facing.func_82599_e(), axisDirection, boundaryFacing);
    }

    @Unique
    private static void alfheim$initChunkLighting(Chunk chunk, World world) {
        int xBase = chunk.field_76635_g << 4;
        int zBase = chunk.field_76647_h << 4;
        BlockPos.PooledMutableBlockPos mutableBlockPos = BlockPos.PooledMutableBlockPos.func_185339_c((int)xBase, (int)0, (int)zBase);
        if (world.func_175706_a(mutableBlockPos.func_177982_a(-16, 0, -16), mutableBlockPos.func_177982_a(31, 255, 31), false)) {
            ExtendedBlockStorage[] extendedBlockStorage = chunk.func_76587_i();
            for (int i = 0; i < extendedBlockStorage.length; ++i) {
                ExtendedBlockStorage storage = extendedBlockStorage[i];
                if (storage == Chunk.field_186036_a) continue;
                int yBase = i * 16;
                for (int y = 0; y < 16; ++y) {
                    for (int z = 0; z < 16; ++z) {
                        for (int x = 0; x < 16; ++x) {
                            mutableBlockPos.func_181079_c(xBase + x, yBase + y, zBase + z);
                            if (LightUtil.getLightValueForState(storage.func_186049_g().func_186016_a(x, y, z), (IBlockAccess)world, (BlockPos)mutableBlockPos) <= 0) continue;
                            world.func_180500_c(EnumSkyBlock.BLOCK, (BlockPos)mutableBlockPos);
                        }
                    }
                }
            }
            if (world.field_73011_w.func_191066_m()) {
                ((IChunkLightingData)chunk).alfheim$setSkylightUpdatedPublic();
            }
            ((IChunkLightingData)chunk).alfheim$setLightInitialized(true);
        }
        mutableBlockPos.func_185344_t();
    }

    @Unique
    private void alfheim$relightSkylightColumn(int x, int z, int height1, int height2) {
        int yMin = Math.min(height1, height2);
        int yMax = Math.max(height1, height2) - 1;
        Chunk chunk = (Chunk)this;
        ExtendedBlockStorage[] sections = chunk.func_76587_i();
        int xBase = (chunk.field_76635_g << 4) + x;
        int zBase = (chunk.field_76647_h << 4) + z;
        this.alfheim$scheduleRelightChecksForColumn(EnumSkyBlock.SKY, xBase, zBase, yMin, yMax);
        if (sections[yMin >> 4] == Chunk.field_186036_a && yMin > 0) {
            this.field_76637_e.func_180500_c(EnumSkyBlock.SKY, new BlockPos(xBase, yMin - 1, zBase));
        }
        short emptySections = 0;
        for (int sec = yMax >> 4; sec >= yMin >> 4; --sec) {
            if (sections[sec] != Chunk.field_186036_a) continue;
            emptySections = (short)(emptySections | (short)(1 << sec));
        }
        if (emptySections != 0) {
            for (EnumFacing facing : EnumFacing.field_176754_o) {
                int zOffset;
                boolean neighborColumnExists;
                int xOffset = facing.func_82601_c();
                boolean bl = neighborColumnExists = ((x + xOffset | z + (zOffset = facing.func_82599_e())) & 0x10) == 0 || this.field_76637_e.func_72863_F().func_186026_b(chunk.field_76635_g + xOffset, chunk.field_76647_h + zOffset) != null;
                if (neighborColumnExists) {
                    for (int sec = yMax >> 4; sec >= yMin >> 4; --sec) {
                        if ((emptySections & 1 << sec) == 0) continue;
                        this.alfheim$scheduleRelightChecksForColumn(EnumSkyBlock.SKY, xBase + xOffset, zBase + zOffset, sec << 4, (sec << 4) + 15);
                    }
                    continue;
                }
                ((IChunkLightingData)chunk).alfheim$initNeighborLightChecks();
                EnumFacing.AxisDirection axisDirection = ((facing.func_176740_k() == EnumFacing.Axis.X ? z : x) & 0xF) < 8 ? EnumFacing.AxisDirection.NEGATIVE : EnumFacing.AxisDirection.POSITIVE;
                short[] sArray = ((IChunkLightingData)chunk).alfheim$getNeighborLightChecks();
                int n = ChunkMixin.alfheim$getFlagIndex(EnumSkyBlock.SKY, facing, axisDirection, EnumBoundaryFacing.OUT);
                sArray[n] = (short)(sArray[n] | emptySections);
                chunk.func_76630_e();
            }
        }
    }

    @Override
    public short[] alfheim$getNeighborLightChecks() {
        return this.alfheim$neighborLightChecks;
    }

    @Override
    public void alfheim$setNeighborLightChecks(short[] data) {
        this.alfheim$neighborLightChecks = data;
    }

    @Override
    public LightingEngine alfheim$getLightingEngine() {
        return this.alfheim$lightingEngine;
    }

    @Override
    public boolean alfheim$isLightInitialized() {
        return this.alfheim$isLightInitialized;
    }

    @Override
    public void alfheim$setLightInitialized(boolean lightInitialized) {
        this.alfheim$isLightInitialized = lightInitialized;
    }

    @Override
    public void alfheim$setSkylightUpdatedPublic() {
        this.func_177441_y();
    }

    @Override
    public void alfheim$initNeighborLightChecks() {
        if (this.alfheim$getNeighborLightChecks() == null) {
            this.alfheim$setNeighborLightChecks(new short[32]);
        }
    }

    @Override
    public byte alfheim$getCachedLightFor(EnumSkyBlock lightType, BlockPos blockPos) {
        int x = blockPos.func_177958_n() & 0xF;
        int y = blockPos.func_177956_o();
        int z = blockPos.func_177952_p() & 0xF;
        ExtendedBlockStorage extendedblockstorage = this.field_76652_q[y >> 4];
        if (extendedblockstorage == Chunk.field_186036_a) {
            return this.func_177444_d(blockPos) ? (byte)lightType.field_77198_c : (byte)0;
        }
        if (lightType == EnumSkyBlock.SKY) {
            return this.field_76637_e.field_73011_w.func_191066_m() ? (byte)extendedblockstorage.func_76670_c(x, y & 0xF, z) : (byte)0;
        }
        return lightType == EnumSkyBlock.BLOCK ? (byte)extendedblockstorage.func_76674_d(x, y & 0xF, z) : (byte)lightType.field_77198_c;
    }
}

