/*
 * Decompiled with CFR 0.152.
 */
package dev.redstudio.alfheim.mixin;

import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.ref.LocalBooleanRef;
import dev.redstudio.alfheim.api.ILightInfoProvider;
import dev.redstudio.alfheim.api.ILightLevelProvider;
import dev.redstudio.alfheim.api.ILitBlock;
import dev.redstudio.redcore.math.ClampUtil;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={Block.class})
public abstract class BlockMixin
implements ILitBlock {
    @Shadow
    @Deprecated
    public abstract int func_149750_m(IBlockState var1);

    @Overwrite
    @SideOnly(value=Side.CLIENT)
    public int func_185484_c(IBlockState blockState, IBlockAccess source, BlockPos blockPos) {
        return source.func_175626_b(blockPos, blockState.getLightValue(source, blockPos));
    }

    @Inject(method={"registerBlocks"}, at={@At(value="FIELD", target="Lnet/minecraft/block/Block;useNeighborBrightness:Z", ordinal=1, shift=At.Shift.BEFORE)}, locals=LocalCapture.CAPTURE_FAILEXCEPTION)
    private static void checkForLiquid(CallbackInfo callbackInfo, @Local(ordinal=15) Block block, @Local(ordinal=0) LocalBooleanRef flag) {
        boolean result = flag.get();
        result |= block instanceof BlockFluidBase;
        flag.set(result |= block instanceof BlockLiquid);
    }

    @Overwrite
    @SideOnly(value=Side.CLIENT)
    public float func_185485_f(IBlockState blockState) {
        byte lightValue = (byte)ClampUtil.clampMinFirst((int)(blockState.func_185906_d() - 1), (int)0, (int)15);
        if (lightValue == 0) {
            return blockState.func_185898_k() ? 0.2f : 1.0f;
        }
        return 1.0f;
    }

    @Override
    public int alfheim$getLightFor(IBlockState blockState, IBlockAccess blockAccess, EnumSkyBlock lightType, BlockPos blockPos) {
        int lightLevel = ((ILightLevelProvider)blockAccess).alfheim$getLight(lightType, blockPos);
        if (lightLevel == 15) {
            return lightLevel;
        }
        if (!blockState.func_185916_f()) {
            return lightLevel;
        }
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            if (!((ILightInfoProvider)blockState).alfheim$useNeighborBrightness(facing, blockAccess, blockPos)) continue;
            int opacity = ((ILightInfoProvider)blockState).alfheim$getLightOpacity(facing, blockAccess, blockPos);
            int neighborLightLevel = ((ILightLevelProvider)blockAccess).alfheim$getLight(lightType, blockPos.func_177972_a(facing));
            if (opacity == 0 && (lightType != EnumSkyBlock.SKY || neighborLightLevel != EnumSkyBlock.SKY.field_77198_c)) {
                opacity = 1;
            }
            if ((lightLevel = Math.max(lightLevel, neighborLightLevel - opacity)) != 15) continue;
            return lightLevel;
        }
        return lightLevel;
    }

    @Override
    public boolean alfheim$useNeighborBrightness(IBlockState blockState, EnumFacing facing, IBlockAccess blockAccess, BlockPos blockPos) {
        return facing == EnumFacing.UP;
    }

    @Override
    public int alfheim$getLightOpacity(IBlockState blockState, EnumFacing facing, IBlockAccess blockAccess, BlockPos blockPos) {
        return 0;
    }
}

