/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.packer;

import com.codetaylor.mc.pyrotech.packer.PackedData;
import com.google.gson.Gson;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class PackAPI {
    private static final Logger LOGGER = LogManager.getLogger(PackAPI.class);
    private static final Map<String, PackedData> PACKED_DATA_MAP = new HashMap<String, PackedData>();

    public static PackedData.ImageData getImageData(ResourceLocation resourceLocation) {
        PackedData packedData = PACKED_DATA_MAP.get(resourceLocation.func_110624_b());
        if (packedData == null) {
            throw new RuntimeException("Missing packed data for: " + resourceLocation);
        }
        PackedData.ImageData imageData = packedData.image.get(resourceLocation.func_110623_a());
        if (imageData == null) {
            throw new RuntimeException("Missing packed image data for: " + resourceLocation);
        }
        return imageData;
    }

    public static PackedData.AtlasData getAtlasData(ResourceLocation resourceLocation) {
        PackedData packedData = PACKED_DATA_MAP.get(resourceLocation.func_110624_b());
        if (packedData == null) {
            throw new RuntimeException("Missing packed data for: " + resourceLocation);
        }
        PackedData.AtlasData atlasData = packedData.atlas.get(resourceLocation.func_110623_a());
        if (atlasData == null) {
            throw new RuntimeException("Missing atlas data for: " + resourceLocation);
        }
        return atlasData;
    }

    public static void register(ResourceLocation resourceLocation, Supplier<Optional<InputStream>> streamSupplier) {
        if (PACKED_DATA_MAP.get(resourceLocation.func_110624_b()) != null) {
            throw new RuntimeException("Duplicate packed.json registered for: " + resourceLocation.func_110624_b());
        }
        Optional<InputStream> optionalInputStream = streamSupplier.get();
        if (optionalInputStream.isPresent()) {
            IResourceManager resourceManager = Minecraft.func_71410_x().func_110442_L();
            if (resourceManager instanceof IReloadableResourceManager) {
                ((IReloadableResourceManager)resourceManager).func_110542_a(rm -> ((Optional)streamSupplier.get()).ifPresent(inputStream -> PackAPI.tryLoadPackedData(resourceLocation, inputStream)));
            }
            InputStream inputStream = optionalInputStream.get();
            PackAPI.tryLoadPackedData(resourceLocation, inputStream);
        }
    }

    private static void tryLoadPackedData(ResourceLocation resourceLocation, InputStream inputStream) {
        try {
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
            PackedData packedData = (PackedData)new Gson().fromJson((Reader)inputStreamReader, PackedData.class);
            inputStreamReader.close();
            PACKED_DATA_MAP.put(resourceLocation.func_110624_b(), packedData);
        }
        catch (Exception e) {
            LOGGER.error("Error loading packed data for " + resourceLocation, (Throwable)e);
        }
    }

    private PackAPI() {
    }
}

