/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.worldgen.feature.spi;

import com.codetaylor.mc.pyrotech.modules.worldgen.feature.WorldGenDenseCoal;
import com.codetaylor.mc.pyrotech.modules.worldgen.feature.WorldGenDenseNetherCoal;
import com.codetaylor.mc.pyrotech.modules.worldgen.feature.WorldGenDenseQuartzOre;
import com.codetaylor.mc.pyrotech.modules.worldgen.feature.WorldGenDenseRedstoneOre;
import com.codetaylor.mc.pyrotech.modules.worldgen.feature.WorldGenFossil;
import com.codetaylor.mc.pyrotech.modules.worldgen.feature.WorldGenFreckleberryPlant;
import com.codetaylor.mc.pyrotech.modules.worldgen.feature.WorldGenGloamberryBush;
import com.codetaylor.mc.pyrotech.modules.worldgen.feature.WorldGenLimestone;
import com.codetaylor.mc.pyrotech.modules.worldgen.feature.WorldGenMud;
import com.codetaylor.mc.pyrotech.modules.worldgen.feature.WorldGenPyroberryBush;
import com.codetaylor.mc.pyrotech.modules.worldgen.feature.WorldGenRocks;
import com.codetaylor.mc.pyrotech.modules.worldgen.feature.spi.IWorldGenFeature;
import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;

public class WorldGenerator
implements IWorldGenerator {
    private final List<IWorldGenFeature> featureList = Lists.newArrayList((Object[])new IWorldGenFeature[]{new WorldGenFossil(), new WorldGenLimestone(), new WorldGenDenseCoal(), new WorldGenDenseNetherCoal(), new WorldGenRocks(), new WorldGenDenseRedstoneOre(), new WorldGenDenseQuartzOre(), new WorldGenPyroberryBush(), new WorldGenGloamberryBush(), new WorldGenFreckleberryPlant(), new WorldGenMud()});
    private final Int2ObjectMap<List<IWorldGenFeature>> perDimensionFeatureList = new Int2ObjectOpenHashMap();

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        int dimension = world.field_73011_w.getDimension();
        ArrayList<IWorldGenFeature> features = (ArrayList<IWorldGenFeature>)this.perDimensionFeatureList.get(dimension);
        if (features == null) {
            features = new ArrayList<IWorldGenFeature>();
            for (IWorldGenFeature feature : this.featureList) {
                if (!feature.isAllowed(dimension)) continue;
                features.add(feature);
            }
            this.perDimensionFeatureList.put(dimension, features);
        }
        if (!features.isEmpty()) {
            for (IWorldGenFeature feature : features) {
                feature.generate(random, chunkX, chunkZ, world, chunkGenerator, chunkProvider);
            }
        }
    }
}

