/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.tech.refractory.tile.spi;

import com.codetaylor.mc.athenaeum.inventory.ObservableFluidTank;
import com.codetaylor.mc.athenaeum.network.tile.data.TileDataFluidTank;
import com.codetaylor.mc.athenaeum.network.tile.spi.ITileData;
import com.codetaylor.mc.athenaeum.network.tile.spi.ITileDataFluidTank;
import com.codetaylor.mc.athenaeum.network.tile.spi.TileEntityDataBase;
import com.codetaylor.mc.athenaeum.util.SoundHelper;
import com.codetaylor.mc.athenaeum.util.TickCounter;
import com.codetaylor.mc.pyrotech.modules.core.network.SCPacketParticleCombust;
import com.codetaylor.mc.pyrotech.modules.storage.ModuleStorage;
import com.codetaylor.mc.pyrotech.modules.tech.refractory.ModuleTechRefractory;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.wrappers.BlockLiquidWrapper;
import net.minecraftforge.fluids.capability.wrappers.FluidBlockWrapper;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public abstract class TileTarTankBase
extends TileEntityDataBase
implements ITickable {
    private static final int COLLECT_INTERVAL_TICKS = 20;
    protected Tank fluidTank = new Tank(this, this.getTankCapacity());
    private final TickCounter collectionTickCounter;

    public TileTarTankBase() {
        super(ModuleTechRefractory.TILE_DATA_SERVICE);
        this.fluidTank.addObserver((tank, amount) -> {
            this.func_70296_d();
            this.field_145850_b.func_180500_c(EnumSkyBlock.BLOCK, this.field_174879_c);
        });
        this.collectionTickCounter = new TickCounter(20);
        this.registerTileDataForNetwork(new ITileData[]{new TileDataFluidTank((FluidTank)this.fluidTank)});
    }

    protected abstract int getHotFluidTemperature();

    protected abstract boolean canHoldHotFluids();

    public FluidTank getFluidTank() {
        return this.fluidTank;
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.collectionTickCounter.increment()) {
            this.collect(this.field_174879_c, (FluidTank)this.fluidTank, this.field_145850_b);
        }
    }

    private void collect(BlockPos pos, FluidTank fluidTank, World world) {
        if (fluidTank.getFluidAmount() == fluidTank.getCapacity()) {
            return;
        }
        Set<BlockPos> sourcePositions = this.getCollectionSourcePositions(world, pos);
        for (BlockPos sourcePosition : sourcePositions) {
            IFluidHandler handler = this.getCollectionSourceFluidHandler(world, sourcePosition);
            if (handler == null) continue;
            if (fluidTank.getFluidAmount() >= fluidTank.getCapacity()) break;
            this.collect(handler, fluidTank);
        }
    }

    private void collect(IFluidHandler source, FluidTank target) {
        int filled = target.fillInternal(source.drain(target.getCapacity() - target.getFluidAmount(), false), false);
        if ((source instanceof FluidBlockWrapper || source instanceof BlockLiquidWrapper) && filled < 1000) {
            return;
        }
        if (filled > 0) {
            target.fillInternal(source.drain(filled, true), true);
        }
    }

    @Nonnull
    public NBTTagCompound func_189515_b(@Nonnull NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74782_a("fluidTank", (NBTBase)this.fluidTank.writeToNBT(new NBTTagCompound()));
        return compound;
    }

    public void func_145839_a(@Nonnull NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.fluidTank.readFromNBT(compound.func_74775_l("fluidTank"));
    }

    @Nonnull
    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, -1, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager networkManager, SPacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
    }

    protected abstract Set<BlockPos> getCollectionSourcePositions(World var1, BlockPos var2);

    protected abstract int getTankCapacity();

    @Nullable
    protected abstract IFluidHandler getCollectionSourceFluidHandler(World var1, BlockPos var2);

    public static class Tank
    extends ObservableFluidTank
    implements ITileDataFluidTank {
        private final TileTarTankBase tile;

        Tank(TileTarTankBase tile, int capacity) {
            super(capacity);
            this.tile = tile;
        }

        public int fillInternal(FluidStack resource, boolean doFill) {
            int filled = super.fillInternal(resource, doFill);
            if (!this.tile.canHoldHotFluids()) {
                Fluid fluid;
                World world = this.tile.field_145850_b;
                BlockPos pos = this.tile.field_174879_c;
                if (resource != null && (fluid = resource.getFluid()).getTemperature(resource) >= this.tile.getHotFluidTemperature()) {
                    if (!world.field_72995_K) {
                        world.func_175698_g(pos);
                        SoundHelper.playSoundServer((World)world, (BlockPos)pos, (SoundEvent)SoundEvents.field_187635_cQ, (SoundCategory)SoundCategory.PLAYERS);
                        FluidUtil.tryPlaceFluid(null, (World)world, (BlockPos)pos, (IFluidHandler)this, (FluidStack)resource);
                        ModuleStorage.PACKET_SERVICE.sendToAllAround((IMessage)new SCPacketParticleCombust((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, 0.5, 0.5, 0.5), (TileEntity)this.tile);
                    }
                    world.func_180500_c(EnumSkyBlock.BLOCK, pos);
                }
            }
            return filled;
        }
    }
}

