/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.tech.refractory.tile;

import com.codetaylor.mc.athenaeum.network.tile.spi.TileEntityDataBase;
import com.codetaylor.mc.pyrotech.library.spi.tile.TileBurnableBase;
import com.codetaylor.mc.pyrotech.library.util.FloodFill;
import com.codetaylor.mc.pyrotech.library.util.Util;
import com.codetaylor.mc.pyrotech.modules.core.ModuleCore;
import com.codetaylor.mc.pyrotech.modules.core.block.BlockRefractoryDoor;
import com.codetaylor.mc.pyrotech.modules.tech.refractory.ModuleTechRefractory;
import com.codetaylor.mc.pyrotech.modules.tech.refractory.ModuleTechRefractoryConfig;
import com.codetaylor.mc.pyrotech.modules.tech.refractory.recipe.PitBurnRecipe;
import com.codetaylor.mc.pyrotech.modules.tech.refractory.tile.TilePitAsh;
import com.codetaylor.mc.pyrotech.modules.tech.refractory.tile.spi.TileTarCollectorBase;
import com.google.common.util.concurrent.ListenableFutureTask;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.items.ItemStackHandler;

public class TileActivePile
extends TileBurnableBase {
    private static final int DEFAULT_TOTAL_BURN_TIME_TICKS = 1000;
    private static final int DEFAULT_BURN_STAGES = 1;
    private static final int MAX_FLUID_PUSH_DEPTH = 3;
    private final FluidTank fluidTank = new FluidTank(this.getMaxFluidLevel());
    private ResourceLocation recipeKey;
    private final ItemStackHandler output = new ItemStackHandler(9);

    public TileActivePile() {
        super(ModuleCore.TILE_DATA_SERVICE);
    }

    public FluidTank getFluidTank() {
        return this.fluidTank;
    }

    public ItemStackHandler getOutput() {
        return this.output;
    }

    public void setRecipe(PitBurnRecipe recipe) {
        this.recipeKey = recipe.getRegistryName();
        this.reset();
        this.remainingStages = this.getBurnStages();
    }

    @Override
    protected int getTotalBurnTimeTicks() {
        PitBurnRecipe recipe = (PitBurnRecipe)ModuleTechRefractory.Registries.BURN_RECIPE.getValue(this.recipeKey);
        if (recipe != null) {
            double duration = recipe.getTimeTicks();
            if (recipe.requiresRefractoryBlocks()) {
                duration *= ModuleTechRefractoryConfig.REFRACTORY.REFRACTORY_RECIPE_DURATION_MODIFIER;
            }
            return (int)Math.max(1.0, duration);
        }
        return 1000;
    }

    @Override
    protected int getBurnStages() {
        PitBurnRecipe recipe = (PitBurnRecipe)ModuleTechRefractory.Registries.BURN_RECIPE.getValue(this.recipeKey);
        if (recipe != null) {
            return recipe.getBurnStages();
        }
        return 1;
    }

    protected int getMaxFluidLevel() {
        return ModuleTechRefractoryConfig.REFRACTORY.ACTIVE_PILE_MAX_FLUID_CAPACITY;
    }

    @Override
    protected boolean isActive() {
        return true;
    }

    @Override
    protected void onUpdate() {
    }

    @Override
    protected void onUpdateValid() {
    }

    @Override
    protected void onUpdateInvalid() {
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            BlockPos offset = this.field_174879_c.func_177972_a(facing);
            IBlockState blockState = this.field_145850_b.func_180495_p(offset);
            Block block = blockState.func_177230_c();
            if (!block.isAir(blockState, (IBlockAccess)this.field_145850_b, offset) && !block.func_176200_f((IBlockAccess)this.field_145850_b, offset)) continue;
            this.field_145850_b.func_175656_a(offset, Blocks.field_150480_ab.func_176223_P());
        }
    }

    @Override
    protected void onBurnStageComplete() {
        PitBurnRecipe recipe = (PitBurnRecipe)ModuleTechRefractory.Registries.BURN_RECIPE.getValue(this.recipeKey);
        if (recipe == null) {
            return;
        }
        FluidStack fluidStack = recipe.getFluidProduced();
        if (fluidStack != null) {
            FluidStack fluidProduced = fluidStack.copy();
            if (fluidProduced.amount > 0) {
                this.fluidTank.fill(fluidProduced, true);
            }
        }
        if (this.fluidTank.getFluidAmount() > 0) {
            for (int i = 3; i >= 1; --i) {
                TileEntityDataBase down;
                TileEntity tileEntity = this.field_145850_b.func_175625_s(this.field_174879_c.func_177967_a(EnumFacing.DOWN, i));
                if (tileEntity instanceof TileActivePile) {
                    down = (TileActivePile)tileEntity;
                    this.fluidTank.drain(down.fluidTank.fillInternal(this.fluidTank.getFluid(), true), true);
                } else if (tileEntity instanceof TileTarCollectorBase) {
                    down = (TileTarCollectorBase)tileEntity;
                    this.fluidTank.drain(down.getFluidTank().fillInternal(this.fluidTank.getFluid(), true), true);
                }
                if (this.fluidTank.getFluidAmount() == 0) break;
            }
        }
        ItemStack output = recipe.getOutput();
        float failureChance = recipe.getFailureChance();
        ItemStack[] failureItems = recipe.getFailureItems();
        if (recipe.doesFluidLevelAffectFailureChance()) {
            failureChance += (1.0f - failureChance) * ((float)this.fluidTank.getFluidAmount() / (float)this.fluidTank.getCapacity());
        }
        if (!recipe.requiresRefractoryBlocks()) {
            boolean[] isValidRefractory = new boolean[]{true};
            FloodFill.apply(this.field_145850_b, this.field_174879_c, (w, p) -> w.func_180495_p(p).func_177230_c() == ModuleTechRefractory.Blocks.ACTIVE_PILE || w.func_180495_p(p).func_177230_c() == ModuleTechRefractory.Blocks.PIT_ASH_BLOCK, (w, p) -> {
                for (EnumFacing facing : EnumFacing.field_82609_l) {
                    BlockPos offset = p.func_177972_a(facing);
                    IBlockState blockState = w.func_180495_p(offset);
                    blockState = blockState.func_177230_c().func_176221_a(blockState, (IBlockAccess)w, offset);
                    boolean isValid = false;
                    for (Predicate<IBlockState> predicate : ModuleTechRefractory.Registries.REFRACTORY_BLOCK_LIST) {
                        if (!predicate.test(blockState)) continue;
                        isValid = true;
                        break;
                    }
                    if (!isValid && this.isValidDoor(blockState, facing, ModuleCore.Blocks.REFRACTORY_DOOR)) {
                        isValid = true;
                    }
                    if (isValid) continue;
                    isValidRefractory[0] = false;
                    return false;
                }
                return true;
            }, MathHelper.func_76125_a((int)ModuleTechRefractoryConfig.GENERAL.MAXIMUM_BURN_SIZE_BLOCKS, (int)1, (int)512));
            if (isValidRefractory[0]) {
                failureChance = (float)((double)failureChance * Math.max(0.0, ModuleTechRefractoryConfig.REFRACTORY.REFRACTORY_FAILURE_MODIFIER));
            }
        }
        failureChance = MathHelper.func_76131_a((float)failureChance, (float)((float)ModuleTechRefractoryConfig.REFRACTORY.MIN_FAILURE_CHANCE), (float)((float)ModuleTechRefractoryConfig.REFRACTORY.MAX_FAILURE_CHANCE));
        if (Util.RANDOM.nextFloat() < failureChance) {
            if (failureItems.length > 0) {
                this.insertItem(failureItems[Util.RANDOM.nextInt(failureItems.length)].func_77946_l());
            }
        } else {
            this.insertItem(output.func_77946_l());
        }
    }

    private void insertItem(ItemStack output) {
        for (int i = 0; i < 9 && !output.func_190926_b(); ++i) {
            output = this.output.insertItem(i, output, false);
        }
    }

    @Override
    protected void onAllBurnStagesComplete() {
        ArrayList<ItemStack> itemStackList = new ArrayList<ItemStack>(this.output.getSlots());
        for (int i = 0; i < this.output.getSlots(); ++i) {
            ItemStack stackInSlot = this.output.getStackInSlot(i);
            this.output.setStackInSlot(i, ItemStack.field_190927_a);
            if (stackInSlot.func_190926_b()) continue;
            itemStackList.add(stackInSlot);
        }
        IBlockState state = ModuleTechRefractory.Blocks.PIT_ASH_BLOCK.func_176223_P();
        this.field_145850_b.func_175656_a(this.field_174879_c, state);
        MinecraftServer minecraftServer = this.field_145850_b.func_73046_m();
        if (minecraftServer != null) {
            minecraftServer.field_175589_i.add(ListenableFutureTask.create(() -> this.insertItems(this.field_174879_c, itemStackList), null));
        }
    }

    private void insertItems(BlockPos pos, List<ItemStack> itemStackList) {
        if (itemStackList.isEmpty()) {
            return;
        }
        TileEntity tileEntity = this.field_145850_b.func_175625_s(pos);
        if (tileEntity instanceof TilePitAsh) {
            TilePitAsh tilePitAsh = (TilePitAsh)tileEntity;
            for (ItemStack itemStack : itemStackList) {
                tilePitAsh.insertItem(itemStack);
            }
        }
    }

    @Override
    protected void onInvalidDelayExpired() {
        this.field_145850_b.func_175656_a(this.field_174879_c, Blocks.field_150480_ab.func_176223_P());
    }

    @Override
    protected boolean isValidStructureBlock(World world, BlockPos pos, IBlockState blockState, EnumFacing facing) {
        blockState = blockState.func_185899_b((IBlockAccess)world, pos);
        PitBurnRecipe recipe = (PitBurnRecipe)ModuleTechRefractory.Registries.BURN_RECIPE.getValue(this.recipeKey);
        if (recipe == null) {
            return false;
        }
        for (Predicate<IBlockState> matcher : ModuleTechRefractory.Registries.REFRACTORY_BLOCK_LIST) {
            if (!matcher.test(blockState)) continue;
            return true;
        }
        if (recipe.requiresRefractoryBlocks()) {
            return this.isValidDoor(blockState, facing, ModuleCore.Blocks.REFRACTORY_DOOR);
        }
        if (this.isValidDoor(blockState, facing, ModuleCore.Blocks.REFRACTORY_DOOR) || this.isValidDoor(blockState, facing, ModuleCore.Blocks.STONE_DOOR)) {
            return true;
        }
        return super.isValidStructureBlock(world, pos, blockState, facing);
    }

    private boolean isValidDoor(IBlockState blockState, EnumFacing facing, BlockDoor door) {
        if (facing == EnumFacing.UP || facing == EnumFacing.DOWN) {
            return false;
        }
        if (blockState.func_177230_c() == door) {
            if (!((Boolean)blockState.func_177229_b((IProperty)BlockRefractoryDoor.field_176519_b)).booleanValue() && blockState.func_177229_b((IProperty)BlockRefractoryDoor.field_176520_a) == facing) {
                return true;
            }
            if (((Boolean)blockState.func_177229_b((IProperty)BlockRefractoryDoor.field_176519_b)).booleanValue() && blockState.func_177229_b((IProperty)BlockRefractoryDoor.field_176521_M) == BlockDoor.EnumHingePosition.LEFT && blockState.func_177229_b((IProperty)BlockRefractoryDoor.field_176520_a) == facing.func_176735_f()) {
                return true;
            }
            return (Boolean)blockState.func_177229_b((IProperty)BlockRefractoryDoor.field_176519_b) != false && blockState.func_177229_b((IProperty)BlockRefractoryDoor.field_176521_M) == BlockDoor.EnumHingePosition.RIGHT && blockState.func_177229_b((IProperty)BlockRefractoryDoor.field_176520_a) == facing.func_176746_e();
        }
        return false;
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189515_b(@Nonnull NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74782_a("fluidTank", (NBTBase)this.fluidTank.writeToNBT(new NBTTagCompound()));
        compound.func_74778_a("recipeKey", this.recipeKey.toString());
        compound.func_74782_a("output", (NBTBase)this.output.serializeNBT());
        return compound;
    }

    @Override
    public void func_145839_a(@Nonnull NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.fluidTank.readFromNBT(compound.func_74775_l("fluidTank"));
        this.recipeKey = new ResourceLocation(compound.func_74779_i("recipeKey"));
        this.output.deserializeNBT(compound.func_74775_l("output"));
    }
}

