/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.tech.refractory.block;

import com.codetaylor.mc.athenaeum.util.StackHelper;
import com.codetaylor.mc.pyrotech.modules.tech.refractory.tile.TileActivePile;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.ItemStackHandler;

public class BlockActivePile
extends Block {
    public static final String NAME = "active_pile";

    public BlockActivePile() {
        super(Material.field_151576_e);
        this.func_149711_c(2.0f);
        this.func_149672_a(SoundType.field_185851_d);
        this.setHarvestLevel("pickaxe", 0);
        this.field_149784_t = 7;
    }

    @ParametersAreNonnullByDefault
    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileActivePile) {
            ((TileActivePile)tileEntity).setNeedStructureValidation();
        }
    }

    public void func_180655_c(@Nonnull IBlockState state, World world, BlockPos pos, Random rand) {
        double centerX = (float)pos.func_177958_n() + 0.5f;
        double centerY = (float)pos.func_177956_o() + 2.0f;
        double centerZ = (float)pos.func_177952_p() + 0.5f;
        world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, centerX + (rand.nextDouble() - 0.5), centerY, centerZ + (rand.nextDouble() - 0.5), 0.0, 0.1, 0.0, new int[0]);
        world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, centerX + (rand.nextDouble() - 0.5), centerY, centerZ + (rand.nextDouble() - 0.5), 0.0, 0.15, 0.0, new int[0]);
        world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, centerX + (rand.nextDouble() - 0.5), centerY - 1.0, centerZ + (rand.nextDouble() - 0.5), 0.0, 0.1, 0.0, new int[0]);
        world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, centerX + (rand.nextDouble() - 0.5), centerY - 1.0, centerZ + (rand.nextDouble() - 0.5), 0.0, 0.15, 0.0, new int[0]);
    }

    @ParametersAreNonnullByDefault
    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileActivePile) {
            ItemStackHandler stackHandler = ((TileActivePile)tileEntity).getOutput();
            for (int i = 0; i < stackHandler.getSlots(); ++i) {
                StackHelper.spawnStackOnTop((World)world, (ItemStack)stackHandler.getStackInSlot(i), (BlockPos)pos, (double)0.0);
            }
        }
        super.func_180663_b(world, pos, state);
    }

    @ParametersAreNonnullByDefault
    public boolean canSilkHarvest(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        return false;
    }

    @ParametersAreNonnullByDefault
    public int quantityDropped(IBlockState state, int fortune, Random random) {
        return 0;
    }

    @ParametersAreNonnullByDefault
    public boolean isFireSource(World world, BlockPos pos, EnumFacing side) {
        return true;
    }

    public boolean hasTileEntity(@Nonnull IBlockState state) {
        return true;
    }

    @ParametersAreNonnullByDefault
    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileActivePile();
    }
}

