/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.tech.refractory;

import com.codetaylor.mc.athenaeum.module.ModuleBase;
import com.codetaylor.mc.athenaeum.network.IPacketService;
import com.codetaylor.mc.athenaeum.network.tile.ITileDataService;
import com.codetaylor.mc.athenaeum.registry.Registry;
import com.codetaylor.mc.pyrotech.ModPyrotech;
import com.codetaylor.mc.pyrotech.modules.tech.refractory.block.BlockActivePile;
import com.codetaylor.mc.pyrotech.modules.tech.refractory.block.BlockPitAsh;
import com.codetaylor.mc.pyrotech.modules.tech.refractory.block.BlockTarCollector;
import com.codetaylor.mc.pyrotech.modules.tech.refractory.block.BlockTarDrain;
import com.codetaylor.mc.pyrotech.modules.tech.refractory.event.FurnaceFuelBurnTimeEventHandler;
import com.codetaylor.mc.pyrotech.modules.tech.refractory.event.ItemTooltipEventHandler;
import com.codetaylor.mc.pyrotech.modules.tech.refractory.event.NeighborNotifyEventHandler;
import com.codetaylor.mc.pyrotech.modules.tech.refractory.event.RightClickBlockEventHandler;
import com.codetaylor.mc.pyrotech.modules.tech.refractory.init.BlockInitializer;
import com.codetaylor.mc.pyrotech.modules.tech.refractory.init.FluidInitializer;
import com.codetaylor.mc.pyrotech.modules.tech.refractory.init.RegistryInitializer;
import com.codetaylor.mc.pyrotech.modules.tech.refractory.init.recipe.BurnPitRecipesAdd;
import com.codetaylor.mc.pyrotech.modules.tech.refractory.recipe.PitBurnRecipe;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryModifiable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ModuleTechRefractory
extends ModuleBase {
    public static final String MODULE_ID = "module.tech.refractory";
    public static final String MOD_ID = "pyrotech";
    public static final CreativeTabs CREATIVE_TAB = ModPyrotech.CREATIVE_TAB;
    public static final Logger LOGGER = LogManager.getLogger((String)("pyrotech." + ModuleTechRefractory.class.getSimpleName()));
    public static IPacketService PACKET_SERVICE;
    public static ITileDataService TILE_DATA_SERVICE;

    public ModuleTechRefractory() {
        super(0, MOD_ID);
        String[] craftTweakerPlugins;
        this.setRegistry(new Registry(MOD_ID, CREATIVE_TAB));
        this.enableAutoRegistry();
        PACKET_SERVICE = this.enableNetwork();
        TILE_DATA_SERVICE = this.enableNetworkTileDataService(PACKET_SERVICE);
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)new RightClickBlockEventHandler());
        MinecraftForge.EVENT_BUS.register((Object)new NeighborNotifyEventHandler());
        MinecraftForge.EVENT_BUS.register((Object)new FurnaceFuelBurnTimeEventHandler());
        for (String plugin : craftTweakerPlugins = new String[]{"ZenBurn"}) {
            this.registerIntegrationPlugin("crafttweaker", "com.codetaylor.mc.pyrotech.modules.tech.refractory.plugin.crafttweaker." + plugin);
        }
        this.registerIntegrationPlugin("jei", "com.codetaylor.mc.pyrotech.modules.tech.refractory.plugin.jei.PluginJEI");
    }

    @SubscribeEvent
    public void onNewRegistryEvent(RegistryEvent.NewRegistry event) {
        RegistryInitializer.createRegistries();
    }

    public void onPreInitializationEvent(FMLPreInitializationEvent event) {
        super.onPreInitializationEvent(event);
        FMLInterModComms.sendFunctionMessage((String)"theoneprobe", (String)"getTheOneProbe", (String)"com.codetaylor.mc.pyrotech.modules.tech.refractory.plugin.top.PluginTOP$Callback");
    }

    @SideOnly(value=Side.CLIENT)
    public void onClientPreInitializationEvent(FMLPreInitializationEvent event) {
        super.onClientPreInitializationEvent(event);
        FMLInterModComms.sendMessage((String)"waila", (String)"register", (String)"com.codetaylor.mc.pyrotech.modules.tech.refractory.plugin.waila.PluginWaila.wailaCallback");
        MinecraftForge.EVENT_BUS.register((Object)new ItemTooltipEventHandler());
    }

    public void onRegisterRecipesEvent(RegistryEvent.Register<IRecipe> event) {
        super.onRegisterRecipesEvent(event);
        BurnPitRecipesAdd.apply(Registries.BURN_RECIPE);
    }

    public void onRegister(Registry registry) {
        FluidInitializer.onRegister(registry);
        BlockInitializer.onRegister(registry);
    }

    @SideOnly(value=Side.CLIENT)
    public void onClientRegister(Registry registry) {
        FluidInitializer.onClientRegister(registry);
        BlockInitializer.onClientRegister(registry);
    }

    public void onPostInitializationEvent(FMLPostInitializationEvent event) {
        super.onPostInitializationEvent(event);
        RegistryInitializer.initializeRefractoryBlocks();
    }

    static {
        FluidRegistry.enableUniversalBucket();
    }

    public static class Registries {
        public static final IForgeRegistryModifiable<PitBurnRecipe> BURN_RECIPE = null;
        public static final List<Predicate<IBlockState>> REFRACTORY_BLOCK_LIST = null;
    }

    @GameRegistry.ObjectHolder(value="pyrotech")
    public static class Blocks {
        @GameRegistry.ObjectHolder(value="tar_collector")
        public static final BlockTarCollector TAR_COLLECTOR = null;
        @GameRegistry.ObjectHolder(value="tar_drain")
        public static final BlockTarDrain TAR_DRAIN = null;
        @GameRegistry.ObjectHolder(value="pit_ash_block")
        public static final BlockPitAsh PIT_ASH_BLOCK = null;
        @GameRegistry.ObjectHolder(value="active_pile")
        public static final BlockActivePile ACTIVE_PILE = null;
    }

    public static class Fluids {
        public static final Fluid WOOD_TAR = null;
        public static final Fluid COAL_TAR = null;
    }
}

