/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.tech.machine.tile.spi;

import com.codetaylor.mc.athenaeum.interaction.api.Transform;
import com.codetaylor.mc.athenaeum.interaction.spi.IInteraction;
import com.codetaylor.mc.athenaeum.interaction.spi.InteractionItemStack;
import com.codetaylor.mc.athenaeum.inventory.ObservableStackHandler;
import com.codetaylor.mc.athenaeum.network.tile.data.TileDataBoolean;
import com.codetaylor.mc.athenaeum.network.tile.data.TileDataItemStackHandler;
import com.codetaylor.mc.athenaeum.network.tile.spi.ITileData;
import com.codetaylor.mc.athenaeum.network.tile.spi.ITileDataItemStackHandler;
import com.codetaylor.mc.athenaeum.util.BlockHelper;
import com.codetaylor.mc.athenaeum.util.RandomHelper;
import com.codetaylor.mc.athenaeum.util.StackHelper;
import com.codetaylor.mc.pyrotech.library.util.Util;
import com.codetaylor.mc.pyrotech.modules.core.ModuleCore;
import com.codetaylor.mc.pyrotech.modules.core.block.BlockRock;
import com.codetaylor.mc.pyrotech.modules.tech.machine.ModuleTechMachine;
import com.codetaylor.mc.pyrotech.modules.tech.machine.ModuleTechMachineConfig;
import com.codetaylor.mc.pyrotech.modules.tech.machine.client.render.MillInteractionBladeRenderer;
import com.codetaylor.mc.pyrotech.modules.tech.machine.recipe.spi.MachineRecipeBase;
import com.codetaylor.mc.pyrotech.modules.tech.machine.recipe.spi.MachineRecipeBaseSawmill;
import com.codetaylor.mc.pyrotech.modules.tech.machine.recipe.spi.MachineRecipeItemInItemOutBase;
import com.codetaylor.mc.pyrotech.modules.tech.machine.tile.spi.TileCombustionWorkerStoneItemInItemOutBase;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.ItemStackHandler;

public abstract class TileSawmillBase<E extends MachineRecipeBaseSawmill<E>>
extends TileCombustionWorkerStoneItemInItemOutBase<E> {
    private final BladeStackHandler bladeStackHandler = new BladeStackHandler(this);
    private final TileDataBoolean recipeComplete;
    private int counterIdleSound;

    public TileSawmillBase() {
        this.bladeStackHandler.addObserver((handler, slot) -> this.func_70296_d());
        this.recipeComplete = new TileDataBoolean(false);
        this.registerTileDataForNetwork(new ITileData[]{new TileDataItemStackHandler((ItemStackHandler)this.bladeStackHandler), this.recipeComplete});
        this.addInteractions(new IInteraction[]{new InteractionBlade(this, new ItemStackHandler[]{this.bladeStackHandler})});
    }

    public BladeStackHandler getBladeStackHandler() {
        return this.bladeStackHandler;
    }

    protected ItemStack getBlade() {
        return this.bladeStackHandler.getStackInSlot(0);
    }

    protected abstract boolean isValidSawmillBlade(ItemStack var1);

    protected abstract boolean shouldDamageBlades();

    public abstract double getEntityDamageFromBlade();

    @Override
    public abstract E getRecipe(ItemStack var1);

    @Override
    public void dropContents() {
        super.dropContents();
        StackHelper.spawnStackHandlerContentsOnTop((World)this.field_145850_b, (ItemStackHandler)this.bladeStackHandler, (BlockPos)this.field_174879_c);
    }

    @Override
    protected List<ItemStack> getRecipeOutput(E recipe, ItemStack input, ArrayList<ItemStack> outputItemStacks) {
        ItemStack output = ((MachineRecipeItemInItemOutBase)recipe).getOutput();
        ItemStack copy = output.func_77946_l();
        outputItemStacks.add(copy);
        return outputItemStacks;
    }

    private void trySpawnWoodChips() {
        ArrayList candidates = new ArrayList();
        BlockHelper.forBlocksInCube((World)this.field_145850_b, (BlockPos)this.func_174877_v(), (int)1, (int)1, (int)1, (w, p, bs) -> {
            if (w.func_175623_d(p) && ModuleCore.Blocks.ROCK.func_176196_c(w, p) || bs.func_177230_c() == ModuleCore.Blocks.ROCK && bs.func_177229_b(BlockRock.VARIANT) == BlockRock.EnumType.WOOD_CHIPS || bs.func_177230_c() == ModuleCore.Blocks.PILE_WOOD_CHIPS) {
                candidates.add(p);
            }
            return true;
        });
        if (candidates.size() > 0) {
            Collections.shuffle(candidates);
            BlockPos pos = (BlockPos)candidates.get(0);
            IBlockState blockState = this.field_145850_b.func_180495_p(pos);
            Block block = blockState.func_177230_c();
            if (block == ModuleCore.Blocks.ROCK && blockState.func_177229_b(BlockRock.VARIANT) == BlockRock.EnumType.WOOD_CHIPS) {
                this.field_145850_b.func_175656_a(pos, ModuleCore.Blocks.PILE_WOOD_CHIPS.setLevel(ModuleCore.Blocks.PILE_WOOD_CHIPS.func_176223_P(), 2));
                AxisAlignedBB boundingBox = block.func_185496_a(blockState, (IBlockAccess)this.field_145850_b, pos);
                AxisAlignedBB offsetBoundingBox = new AxisAlignedBB(boundingBox.field_72340_a, 1.0 - boundingBox.field_72337_e, boundingBox.field_72339_c, boundingBox.field_72336_d, 1.0, boundingBox.field_72334_f).func_186670_a(pos);
                for (Entity entity : this.field_145850_b.func_72839_b(null, offsetBoundingBox)) {
                    entity.func_70634_a(entity.field_70165_t, entity.field_70163_u + 0.125 + 0.001, entity.field_70161_v);
                }
            } else if (block == ModuleCore.Blocks.PILE_WOOD_CHIPS) {
                int level = ModuleCore.Blocks.PILE_WOOD_CHIPS.getLevel(blockState);
                if (level < 8) {
                    this.field_145850_b.func_175656_a(pos, ModuleCore.Blocks.PILE_WOOD_CHIPS.setLevel(ModuleCore.Blocks.PILE_WOOD_CHIPS.func_176223_P(), level + 1));
                    AxisAlignedBB boundingBox = block.func_185496_a(blockState, (IBlockAccess)this.field_145850_b, pos);
                    AxisAlignedBB offsetBoundingBox = new AxisAlignedBB(boundingBox.field_72340_a, 1.0 - boundingBox.field_72337_e, boundingBox.field_72339_c, boundingBox.field_72336_d, 1.0, boundingBox.field_72334_f).func_186670_a(pos);
                    for (Entity entity : this.field_145850_b.func_72839_b(null, offsetBoundingBox)) {
                        entity.func_70634_a(entity.field_70165_t, entity.field_70163_u + 0.125 + 0.001, entity.field_70161_v);
                    }
                }
            } else {
                this.field_145850_b.func_175656_a(pos, ModuleCore.Blocks.ROCK.func_176223_P().func_177226_a(BlockRock.VARIANT, (Comparable)((Object)BlockRock.EnumType.WOOD_CHIPS)));
            }
        }
    }

    @Override
    protected void onRecipeComplete() {
        this.recipeComplete.set(true);
        this.onRecipeComplete(this.getInputStackHandler().getStackInSlot(0));
        this.recalculateRemainingTime(this.getInputStackHandler().getStackInSlot(0));
        if (this.shouldDamageBlades()) {
            ItemStack blade = this.bladeStackHandler.extractItem(0, 1, false);
            if (!ModuleTechMachineConfig.isSawbladeIndestructible(blade.func_77973_b()) && blade.func_96631_a(1, this.field_145850_b.field_73012_v, null)) {
                this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_187635_cQ, SoundCategory.BLOCKS, 1.0f, Util.RANDOM.nextFloat() * 0.4f + 0.8f);
            } else {
                this.bladeStackHandler.insertItem(0, blade, false);
            }
        }
    }

    private void onRecipeComplete(ItemStack input) {
        MachineRecipeBase recipe = this.getRecipe(input);
        if (recipe != null) {
            ItemStack copy = input.func_77946_l();
            copy.func_190920_e(copy.func_190916_E() - 1);
            this.getInputStackHandler().setStackInSlot(0, copy);
            List<ItemStack> outputItems = this.getRecipeOutput(recipe, input, new ArrayList<ItemStack>());
            for (ItemStack outputItem : outputItems) {
                this.getOutputStackHandler().insertItem(outputItem, false);
            }
            int woodChips = ((MachineRecipeBaseSawmill)recipe).getWoodChips();
            if (woodChips > 0) {
                for (int i = 0; i < woodChips; ++i) {
                    this.trySpawnWoodChips();
                }
            }
        }
    }

    @Override
    public boolean workerDoWork() {
        this.recipeComplete.set(false);
        return super.workerDoWork();
    }

    @Override
    public void onTileDataUpdate() {
        super.onTileDataUpdate();
        if (ModuleTechMachineConfig.SAWMILL_SOUNDS.RECIPE_COMPLETE_SOUND_ENABLED && this.recipeComplete.isDirty() && this.recipeComplete.get()) {
            double volume = ModuleTechMachineConfig.SAWMILL_SOUNDS.RECIPE_COMPLETE_SOUND_VOLUME;
            double pitch = (RandomHelper.random().nextDouble() * 2.0 - 1.0) * 0.05;
            double select = RandomHelper.random().nextDouble();
            if (this.getInputStackHandler().getStackInSlot(0).func_190926_b()) {
                this.field_145850_b.func_184134_a((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, ModuleTechMachine.Sounds.SAWMILL_ACTIVE, SoundCategory.BLOCKS, (float)volume, (float)(1.0 + pitch), false);
            } else if (select < 0.49) {
                this.field_145850_b.func_184134_a((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, ModuleTechMachine.Sounds.SAWMILL_ACTIVE_SHORT_A, SoundCategory.BLOCKS, (float)volume, (float)(1.0 + pitch), false);
            } else if (select < 0.98) {
                this.field_145850_b.func_184134_a((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, ModuleTechMachine.Sounds.SAWMILL_ACTIVE_SHORT_B, SoundCategory.BLOCKS, (float)volume, (float)(1.0 + pitch), false);
            }
        }
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.field_145850_b.field_72995_K && ModuleTechMachineConfig.SAWMILL_SOUNDS.IDLE_SOUND_ENABLED) {
            if (this.workerIsActive() && !this.getBlade().func_190926_b()) {
                int idleSoundLengthTicks = 40;
                --this.counterIdleSound;
                if (this.counterIdleSound <= 0) {
                    this.counterIdleSound = idleSoundLengthTicks;
                    double volume = ModuleTechMachineConfig.SAWMILL_SOUNDS.IDLE_SOUND_VOLUME;
                    this.field_145850_b.func_184134_a((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, ModuleTechMachine.Sounds.SAWMILL_IDLE, SoundCategory.BLOCKS, (float)volume, 1.0f, false);
                }
            } else {
                this.counterIdleSound = 0;
            }
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.bladeStackHandler.deserializeNBT(compound.func_74775_l("bladeStackHandler"));
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74782_a("bladeStackHandler", (NBTBase)this.bladeStackHandler.serializeNBT());
        return compound;
    }

    @Override
    protected EnumFacing[] getInputInteractionSides() {
        return new EnumFacing[]{EnumFacing.NORTH, EnumFacing.WEST, EnumFacing.EAST, EnumFacing.SOUTH, EnumFacing.UP};
    }

    @Override
    protected AxisAlignedBB getInputInteractionBoundsTop() {
        return new AxisAlignedBB(0.0625, 1.0, 0.0625, 0.9375, 1.25, 0.9375);
    }

    public class BladeStackHandler
    extends ObservableStackHandler
    implements ITileDataItemStackHandler {
        private final TileSawmillBase<E> tile;

        BladeStackHandler(TileSawmillBase<E> tile) {
            super(1);
            this.tile = tile;
        }

        protected int getStackLimit(int slot, @Nonnull ItemStack stack) {
            return 1;
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            if (!this.tile.isValidSawmillBlade(stack)) {
                return stack;
            }
            return super.insertItem(slot, stack, simulate);
        }
    }

    public static class InteractionBlade<E extends MachineRecipeBaseSawmill<E>>
    extends InteractionItemStack<TileSawmillBase<E>> {
        private final TileSawmillBase<E> tile;

        InteractionBlade(TileSawmillBase<E> tile, ItemStackHandler[] stackHandlers) {
            super(stackHandlers, 0, new EnumFacing[]{EnumFacing.NORTH, EnumFacing.WEST, EnumFacing.EAST, EnumFacing.SOUTH, EnumFacing.UP}, new AxisAlignedBB(0.0625, 1.0, 0.0625, 0.9375, 1.25, 0.9375), new Transform(Transform.translate((double)0.5, (double)1.0, (double)0.5), Transform.rotate((double)0.0, (double)1.0, (double)0.0, (double)90.0), Transform.scale((double)0.75, (double)0.75, (double)0.75)));
            this.tile = tile;
        }

        protected void onExtract(IInteraction.EnumType type, World world, EntityPlayer player, BlockPos pos) {
            super.onExtract(type, world, player, pos);
            if (this.tile.workerIsActive() && this.tile.getEntityDamageFromBlade() > 0.0) {
                player.func_70097_a(DamageSource.field_76377_j, (float)this.tile.getEntityDamageFromBlade());
            }
        }

        protected void onInsert(IInteraction.EnumType type, ItemStack itemStack, World world, EntityPlayer player, BlockPos pos) {
            super.onInsert(type, itemStack, world, player, pos);
            if (this.tile.workerIsActive() && this.tile.getEntityDamageFromBlade() > 0.0) {
                player.func_70097_a(DamageSource.field_76377_j, (float)this.tile.getEntityDamageFromBlade());
            }
        }

        protected boolean doItemStackValidation(ItemStack itemStack) {
            return this.tile.isValidSawmillBlade(itemStack);
        }

        public TileSawmillBase<E> getTile() {
            return this.tile;
        }

        @SideOnly(value=Side.CLIENT)
        public void renderSolidPass(World world, RenderItem renderItem, BlockPos pos, IBlockState blockState, float partialTicks) {
            MillInteractionBladeRenderer.INSTANCE.renderSolidPass(this, world, renderItem, pos, blockState, partialTicks);
        }

        @SideOnly(value=Side.CLIENT)
        public boolean renderAdditivePass(World world, RenderItem renderItem, EnumFacing hitSide, Vec3d hitVec, BlockPos hitPos, IBlockState blockState, ItemStack heldItemMainHand, float partialTicks) {
            return MillInteractionBladeRenderer.INSTANCE.renderAdditivePass(this, world, renderItem, hitSide, hitVec, hitPos, blockState, heldItemMainHand, partialTicks);
        }
    }
}

