/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.tech.machine.tile;

import com.codetaylor.mc.athenaeum.integration.gamestages.Stages;
import com.codetaylor.mc.athenaeum.interaction.api.Transform;
import com.codetaylor.mc.athenaeum.util.AABBHelper;
import com.codetaylor.mc.athenaeum.util.Properties;
import com.codetaylor.mc.athenaeum.util.RandomHelper;
import com.codetaylor.mc.athenaeum.util.SoundHelper;
import com.codetaylor.mc.athenaeum.util.TickCounter;
import com.codetaylor.mc.pyrotech.modules.tech.machine.ModuleTechMachine;
import com.codetaylor.mc.pyrotech.modules.tech.machine.ModuleTechMachineConfig;
import com.codetaylor.mc.pyrotech.modules.tech.machine.tile.spi.TileCogWorkerBase;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class TileMechanicalBellowsTop
extends TileCogWorkerBase {
    private final TickCounter pushTickCounter;
    private boolean pushing;

    public TileMechanicalBellowsTop() {
        super(ModuleTechMachine.TILE_DATA_SERVICE);
        this.pushTickCounter = new TickCounter(ModuleTechMachineConfig.MECHANICAL_BELLOWS.TRAVEL_TIME_DOWN_TICKS);
        this.pushing = false;
    }

    @Override
    protected boolean isValidCog(ItemStack itemStack) {
        return ModuleTechMachineConfig.MECHANICAL_BELLOWS.isValidCog(itemStack.func_77973_b().getRegistryName());
    }

    @Override
    protected int getUpdateIntervalTicks() {
        return ModuleTechMachineConfig.MECHANICAL_BELLOWS.TRAVEL_TIME_DOWN_TICKS + ModuleTechMachineConfig.MECHANICAL_BELLOWS.TRAVEL_TIME_UP_TICKS;
    }

    public boolean isPushing() {
        return this.pushing;
    }

    @Override
    protected Transform getCogInteractionTransform() {
        return new Transform(Transform.translate((double)0.5, (double)0.4375, (double)1.0625), Transform.rotate(), Transform.scale((double)0.75, (double)0.75, (double)2.0));
    }

    @Override
    protected AxisAlignedBB getCogInteractionBounds() {
        return AABBHelper.create((double)0.0, (double)0.0, (double)12.0, (double)16.0, (double)16.0, (double)16.0);
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.pushing && this.pushTickCounter.increment()) {
            this.pushing = false;
        }
    }

    @Override
    protected int doWork(ItemStack cog) {
        this.pushing = true;
        SoundHelper.playSoundServer((World)this.field_145850_b, (BlockPos)this.field_174879_c, (SoundEvent)SoundEvents.field_187715_dR, (SoundCategory)SoundCategory.BLOCKS, (float)0.5f, (float)(RandomHelper.random().nextFloat() * 0.2f + 0.8f));
        return ModuleTechMachineConfig.MECHANICAL_BELLOWS.COG_DAMAGE;
    }

    @Override
    protected boolean isPowered() {
        return this.field_145850_b.func_175640_z(this.field_174879_c) || this.field_145850_b.func_175640_z(this.field_174879_c.func_177977_b());
    }

    @Nullable
    public Stages getStages() {
        return ModuleTechMachineConfig.STAGES_MECHANICAL_BELLOWS;
    }

    public EnumFacing getTileFacing(World world, BlockPos pos, IBlockState blockState) {
        if (blockState.func_177230_c() == ModuleTechMachine.Blocks.MECHANICAL_BELLOWS) {
            return (EnumFacing)blockState.func_177229_b((IProperty)Properties.FACING_HORIZONTAL);
        }
        return super.getTileFacing(world, pos, blockState);
    }
}

