/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.tech.machine.plugin.crafttweaker;

import com.codetaylor.mc.athenaeum.tools.ZenDocAppend;
import com.codetaylor.mc.athenaeum.tools.ZenDocArg;
import com.codetaylor.mc.athenaeum.tools.ZenDocClass;
import com.codetaylor.mc.athenaeum.tools.ZenDocMethod;
import com.codetaylor.mc.athenaeum.tools.ZenDocPrepend;
import com.codetaylor.mc.pyrotech.library.crafttweaker.RemoveAllRecipesAction;
import com.codetaylor.mc.pyrotech.modules.tech.basic.ModuleTechBasicConfig;
import com.codetaylor.mc.pyrotech.modules.tech.machine.ModuleTechMachine;
import com.codetaylor.mc.pyrotech.modules.tech.machine.recipe.MechanicalCompactingBinRecipe;
import crafttweaker.IAction;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import crafttweaker.mc1120.CraftTweaker;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenDocClass(value="mods.pyrotech.MechanicalCompactor")
@ZenDocPrepend(value={"docs/include/header.md"})
@ZenDocAppend(value={"docs/include/mechanical_compactor.example.md"})
@ZenClass(value="mods.pyrotech.MechanicalCompactor")
public class ZenMechanicalCompactingBin {
    @ZenDocMethod(order=1, args={@ZenDocArg(arg="name", info="unique recipe name"), @ZenDocArg(arg="output", info="recipe output"), @ZenDocArg(arg="input", info="recipe input"), @ZenDocArg(arg="amount", info="number of input items required")})
    @ZenMethod
    public static void addRecipe(String name, IItemStack output, IIngredient input, int amount) {
        ZenMechanicalCompactingBin.addRecipe(name, output, input, amount, ModuleTechBasicConfig.COMPACTING_BIN.TOOL_USES_REQUIRED_PER_HARVEST_LEVEL);
    }

    @ZenDocMethod(order=2, args={@ZenDocArg(arg="name", info="unique recipe name"), @ZenDocArg(arg="output", info="recipe output"), @ZenDocArg(arg="input", info="recipe input"), @ZenDocArg(arg="amount", info="number of input items required"), @ZenDocArg(arg="toolUsesRequired", info="overrides default provided in config")})
    @ZenMethod
    public static void addRecipe(String name, IItemStack output, IIngredient input, int amount, int[] toolUsesRequired) {
        CraftTweaker.LATE_ACTIONS.add(new AddRecipe(name, CraftTweakerMC.getItemStack((IItemStack)output), CraftTweakerMC.getIngredient((IIngredient)input), amount, toolUsesRequired));
    }

    @ZenDocMethod(order=3, args={@ZenDocArg(arg="output", info="output ingredient to match")})
    @ZenMethod
    public static void removeRecipes(IIngredient output) {
        CraftTweaker.LATE_ACTIONS.add(new RemoveRecipe(CraftTweakerMC.getIngredient((IIngredient)output)));
    }

    @ZenDocMethod(order=4)
    @ZenMethod
    public static void removeAllRecipes() {
        CraftTweaker.LATE_ACTIONS.add(new RemoveAllRecipesAction<MechanicalCompactingBinRecipe>(ModuleTechMachine.Registries.MECHANICAL_COMPACTING_BIN_RECIPES, "mechanical compacting bin"));
    }

    public static class AddRecipe
    implements IAction {
        private final String name;
        private final ItemStack output;
        private final Ingredient input;
        private final int amount;
        private final int[] uses;

        public AddRecipe(String name, ItemStack output, Ingredient input, int amount, int[] uses) {
            this.name = name;
            this.input = input;
            this.output = output;
            this.amount = amount;
            this.uses = uses;
        }

        public void apply() {
            MechanicalCompactingBinRecipe recipe = new MechanicalCompactingBinRecipe(this.output, this.input, this.amount, this.uses);
            ModuleTechMachine.Registries.MECHANICAL_COMPACTING_BIN_RECIPES.register(recipe.setRegistryName(new ResourceLocation("crafttweaker", this.name)));
        }

        public String describe() {
            return "Adding mechanical compacting recipe for " + this.output;
        }
    }

    public static class RemoveRecipe
    implements IAction {
        private final Ingredient output;

        public RemoveRecipe(Ingredient output) {
            this.output = output;
        }

        public void apply() {
            MechanicalCompactingBinRecipe.removeRecipes(this.output);
        }

        public String describe() {
            return "Removing mechanical compacting recipes for " + this.output;
        }
    }
}

