/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.tech.machine.block;

import com.codetaylor.mc.athenaeum.interaction.spi.IBlockInteractable;
import com.codetaylor.mc.athenaeum.interaction.spi.IInteraction;
import com.codetaylor.mc.athenaeum.spi.BlockPartialBase;
import com.codetaylor.mc.athenaeum.spi.IVariant;
import com.codetaylor.mc.athenaeum.util.FacingHelper;
import com.codetaylor.mc.athenaeum.util.Properties;
import com.codetaylor.mc.athenaeum.util.StackHelper;
import com.codetaylor.mc.pyrotech.modules.tech.basic.tile.TileCompactingBin;
import com.codetaylor.mc.pyrotech.modules.tech.machine.tile.TileMechanicalCompactingBin;
import com.codetaylor.mc.pyrotech.modules.tech.machine.tile.TileMechanicalCompactingBinWorker;
import java.util.Comparator;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.items.ItemStackHandler;

public class BlockMechanicalCompactingBin
extends BlockPartialBase
implements IBlockInteractable {
    public static final String NAME = "mechanical_compacting_bin";
    public static final PropertyEnum<EnumType> TYPE = PropertyEnum.func_177709_a((String)"type", EnumType.class);

    public BlockMechanicalCompactingBin() {
        super(Material.field_151576_e);
        this.func_149711_c(4.0f);
        this.func_149752_b(0.5f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)Properties.FACING_HORIZONTAL, (Comparable)EnumFacing.NORTH).func_177226_a(TYPE, (Comparable)((Object)EnumType.BIN)));
    }

    @Nullable
    @ParametersAreNonnullByDefault
    public RayTraceResult func_180636_a(IBlockState blockState, World world, BlockPos pos, Vec3d start, Vec3d end) {
        return this.interactionRayTrace(super.func_180636_a(blockState, world, pos, start, end), blockState, world, pos, start, end);
    }

    @ParametersAreNonnullByDefault
    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        return this.interact(IInteraction.EnumType.MouseClick, world, pos, state, player, hand, facing, hitX, hitY, hitZ);
    }

    @ParametersAreNonnullByDefault
    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        if (state.func_177229_b(TYPE) == EnumType.BIN) {
            if (!world.field_72995_K) {
                EnumFacing facing;
                EnumFacing rotatedFacing;
                BlockPos offset;
                IBlockState blockState;
                TileEntity tileEntity = world.func_175625_s(pos);
                if (tileEntity instanceof TileCompactingBin) {
                    TileCompactingBin.InputStackHandler handler = ((TileCompactingBin)tileEntity).getInputStackHandler();
                    StackHelper.spawnStackHandlerSlotContentsOnTop((World)world, (ItemStackHandler)handler, (int)0, (BlockPos)pos);
                }
                if ((blockState = world.func_180495_p(offset = pos.func_177972_a(rotatedFacing = FacingHelper.rotateFacingCW((EnumFacing)(facing = (EnumFacing)state.func_177229_b((IProperty)Properties.FACING_HORIZONTAL)))))).func_177230_c() == this) {
                    world.func_175655_b(offset, false);
                }
            }
        } else {
            EnumFacing facing;
            BlockPos offset;
            IBlockState blockState;
            TileEntity tileEntity = world.func_175625_s(pos);
            if (tileEntity instanceof TileMechanicalCompactingBinWorker) {
                TileMechanicalCompactingBinWorker tile = (TileMechanicalCompactingBinWorker)tileEntity;
                StackHelper.spawnStackHandlerSlotContentsOnTop((World)world, (ItemStackHandler)tile.getOutputStackHandler(), (int)0, (BlockPos)pos);
                StackHelper.spawnStackHandlerSlotContentsOnTop((World)world, (ItemStackHandler)tile.getCogStackHandler(), (int)0, (BlockPos)pos);
            }
            if ((blockState = world.func_180495_p(offset = pos.func_177972_a(facing = (EnumFacing)state.func_177229_b((IProperty)Properties.FACING_HORIZONTAL)))).func_177230_c() == this) {
                world.func_175655_b(offset, false);
            }
        }
        super.func_180663_b(world, pos, state);
    }

    @ParametersAreNonnullByDefault
    @Nonnull
    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        EnumFacing opposite = placer.func_174811_aO().func_176734_d();
        return this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)EnumType.BIN)).func_177226_a((IProperty)Properties.FACING_HORIZONTAL, (Comparable)opposite);
    }

    public boolean hasTileEntity(@Nonnull IBlockState state) {
        return true;
    }

    @ParametersAreNonnullByDefault
    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        if (state.func_177229_b(TYPE) == EnumType.MACHINE) {
            return new TileMechanicalCompactingBinWorker();
        }
        return new TileMechanicalCompactingBin();
    }

    public boolean isSideSolid(IBlockState base_state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, EnumFacing side) {
        return side == EnumFacing.DOWN;
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{Properties.FACING_HORIZONTAL, TYPE});
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)EnumType.fromMeta(meta >> 2 & 1))).func_177226_a((IProperty)Properties.FACING_HORIZONTAL, (Comparable)EnumFacing.field_176754_o[meta & 3]);
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumType)((Object)state.func_177229_b(TYPE))).getMeta() << 2 | ((EnumFacing)state.func_177229_b((IProperty)Properties.FACING_HORIZONTAL)).func_176736_b();
    }

    public static class Item
    extends ItemBlock {
        public Item(BlockMechanicalCompactingBin block) {
            super((Block)block);
        }

        @Nonnull
        @ParametersAreNonnullByDefault
        public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
            int i;
            IBlockState stateForPlacement;
            EnumFacing placementFacing;
            EnumFacing rotatedFacing;
            BlockPos secondPos;
            ItemStack itemStack;
            IBlockState blockState = world.func_180495_p(pos);
            Block block = blockState.func_177230_c();
            if (!block.func_176200_f((IBlockAccess)world, pos)) {
                pos = pos.func_177972_a(facing);
            }
            if (!(itemStack = player.func_184586_b(hand)).func_190926_b() && player.func_175151_a(pos, facing, itemStack) && world.func_190527_a(this.field_150939_a, pos, false, facing, null) && player.func_175151_a(secondPos = pos.func_177972_a(rotatedFacing = FacingHelper.rotateFacingCW((EnumFacing)(placementFacing = (EnumFacing)(stateForPlacement = this.field_150939_a.getStateForPlacement(world, pos, facing, hitX, hitY, hitZ, i = this.func_77647_b(itemStack.func_77960_j()), (EntityLivingBase)player, hand)).func_177229_b((IProperty)Properties.FACING_HORIZONTAL)))), rotatedFacing, itemStack) && world.func_190527_a(this.field_150939_a, secondPos, false, rotatedFacing, null)) {
                IBlockState secondState = this.field_150939_a.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)EnumType.MACHINE)).func_177226_a((IProperty)Properties.FACING_HORIZONTAL, (Comparable)rotatedFacing.func_176734_d());
                if (this.placeBlockAt(itemStack, player, world, pos, facing, hitX, hitY, hitZ, stateForPlacement) && this.placeSecondBlockAt(itemStack, player, world, secondPos, secondState)) {
                    stateForPlacement = world.func_180495_p(pos);
                    SoundType soundtype = stateForPlacement.func_177230_c().getSoundType(stateForPlacement, world, pos, (Entity)player);
                    world.func_184133_a(player, pos, soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
                    itemStack.func_190918_g(1);
                }
                return EnumActionResult.SUCCESS;
            }
            return EnumActionResult.FAIL;
        }

        public boolean placeSecondBlockAt(@Nonnull ItemStack stack, @Nonnull EntityPlayer player, World world, @Nonnull BlockPos pos, IBlockState newState) {
            if (!world.func_180501_a(pos, newState, 11)) {
                return false;
            }
            IBlockState state = world.func_180495_p(pos);
            if (state.func_177230_c() == this.field_150939_a) {
                ItemBlock.func_179224_a((World)world, (EntityPlayer)player, (BlockPos)pos, (ItemStack)stack);
                this.field_150939_a.func_180633_a(world, pos, state, (EntityLivingBase)player, stack);
            }
            return true;
        }
    }

    public static enum EnumType implements IVariant
    {
        BIN(0, "bin"),
        MACHINE(1, "machine");

        private static final EnumType[] META_LOOKUP;
        private final int meta;
        private final String name;

        private EnumType(int meta, String name) {
            this.meta = meta;
            this.name = name;
        }

        public int getMeta() {
            return this.meta;
        }

        @Nonnull
        public String func_176610_l() {
            return this.name;
        }

        public static EnumType fromMeta(int meta) {
            if (meta < 0 || meta >= META_LOOKUP.length) {
                meta = 0;
            }
            return META_LOOKUP[meta];
        }

        static {
            META_LOOKUP = (EnumType[])Stream.of(EnumType.values()).sorted(Comparator.comparing(EnumType::getMeta)).toArray(EnumType[]::new);
        }
    }
}

