/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.tech.bloomery.util;

import com.codetaylor.mc.athenaeum.util.ArrayHelper;
import com.codetaylor.mc.athenaeum.util.BlockHelper;
import com.codetaylor.mc.athenaeum.util.DistanceHelper;
import com.codetaylor.mc.athenaeum.util.RandomHelper;
import com.codetaylor.mc.athenaeum.util.StackHelper;
import com.codetaylor.mc.pyrotech.modules.core.ModuleCoreConfig;
import com.codetaylor.mc.pyrotech.modules.tech.bloomery.ModuleTechBloomery;
import com.codetaylor.mc.pyrotech.modules.tech.bloomery.ModuleTechBloomeryConfig;
import com.codetaylor.mc.pyrotech.modules.tech.bloomery.item.spi.ItemTongsEmptyBase;
import com.codetaylor.mc.pyrotech.modules.tech.bloomery.item.spi.ItemTongsFullBase;
import com.codetaylor.mc.pyrotech.modules.tech.bloomery.tile.TileBloom;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BloomHelper {
    public static boolean shouldReduceIntegrity(ItemStack toolItemStack, Random random) {
        Map enchantments = EnchantmentHelper.func_82781_a((ItemStack)toolItemStack);
        Integer fortuneLevel = (Integer)enchantments.get(Enchantments.field_185308_t);
        if (fortuneLevel != null) {
            double[] chanceArray = ModuleTechBloomeryConfig.BLOOM.CHANCE_TO_NOT_CONSUME_BLOOM_INTEGRITY_PER_FORTUNE_LEVEL;
            double chance = MathHelper.func_151237_a((double)ArrayHelper.getOrLast((double[])chanceArray, (int)fortuneLevel), (double)0.0, (double)1.0);
            return (double)random.nextFloat() >= chance;
        }
        return true;
    }

    public static double calculateHammerPower(BlockPos anvilPos, Vec3d hammerPos, ItemStack hammerItemStack, @Nullable EntityPlayer player) {
        double originZ;
        double originY;
        ResourceLocation registryName = hammerItemStack.func_77973_b().getRegistryName();
        if (registryName == null) {
            return 0.0;
        }
        int hammerHarvestLevel = ModuleCoreConfig.HAMMERS.getHammerHarvestLevel(registryName);
        if (hammerHarvestLevel == -1) {
            return 0.0;
        }
        double offsetX = 1.0;
        double originX = (double)anvilPos.func_177958_n() + 0.5;
        double distance = DistanceHelper.getDistance((double)originX, (double)(originY = (double)anvilPos.func_177956_o() + 0.25), (double)(originZ = (double)anvilPos.func_177952_p() + 0.5), (double)hammerPos.field_72450_a, (double)hammerPos.field_72448_b, (double)hammerPos.field_72449_c);
        double clampedDistance = Math.max(offsetX, distance);
        double result = Math.max(0.0, 1.0 - 0.25 * Math.pow(clampedDistance - offsetX, 3.0));
        if (result > 0.985) {
            result = 1.0;
        }
        double[] modifier = ModuleTechBloomeryConfig.BLOOM.HAMMER_POWER_MODIFIER_PER_HARVEST_LEVEL;
        result *= ArrayHelper.getOrLast((double[])modifier, (int)hammerHarvestLevel);
        Map enchantments = EnchantmentHelper.func_82781_a((ItemStack)hammerItemStack);
        Integer efficiencyLevel = (Integer)enchantments.get(Enchantments.field_185305_q);
        if (efficiencyLevel != null) {
            double[] bonus = ModuleTechBloomeryConfig.BLOOM.HAMMER_POWER_MODIFIER_PER_EFFICIENCY_LEVEL;
            result *= ArrayHelper.getOrLast((double[])bonus, (int)(efficiencyLevel - 1));
        }
        if (player != null) {
            PotionEffect effectMiningFatigue;
            PotionEffect effectWeakness;
            PotionEffect effectStrength = player.func_70660_b(MobEffects.field_76420_g);
            if (effectStrength != null) {
                result *= ModuleTechBloomeryConfig.BLOOM.HAMMER_POWER_MODIFIER_FOR_STRENGTH_EFFECT;
            }
            if ((effectWeakness = player.func_70660_b(MobEffects.field_76437_t)) != null) {
                result *= ModuleTechBloomeryConfig.BLOOM.HAMMER_POWER_MODIFIER_FOR_WEAKNESS_EFFECT;
            }
            if ((effectMiningFatigue = player.func_70660_b(MobEffects.field_76419_f)) != null) {
                result *= ModuleTechBloomeryConfig.BLOOM.HAMMER_POWER_MODIFIER_FOR_MINING_FATIGUE_EFFECT;
            }
        }
        return Math.max(0.0, result);
    }

    public static ItemStack createBloomAsItemStack(int maxIntegrity, float experiencePerComplete, @Nullable String recipeId, @Nullable String langKey) {
        return BloomHelper.createBloomAsItemStack(new ItemStack((Block)ModuleTechBloomery.Blocks.BLOOM), maxIntegrity, maxIntegrity, experiencePerComplete, recipeId, langKey);
    }

    public static ItemStack createBloomAsItemStack(ItemStack itemStack, int maxIntegrity, int integrity, float experiencePerComplete, @Nullable String recipeId, @Nullable String langKey) {
        NBTTagCompound tileTag = BloomHelper.writeToNBT(new NBTTagCompound(), maxIntegrity, integrity, experiencePerComplete, recipeId, langKey);
        return BloomHelper.createBloomAsItemStack(itemStack, tileTag);
    }

    public static ItemStack createBloomAsItemStack(ItemStack itemStack, NBTTagCompound tileTag) {
        NBTTagCompound itemTag = StackHelper.getTagSafe((ItemStack)itemStack);
        itemTag.func_74782_a("BlockEntityTag", (NBTBase)tileTag);
        return itemStack;
    }

    public static ItemStack toItemStack(TileBloom tile) {
        return BloomHelper.toItemStack(tile, new ItemStack((Block)ModuleTechBloomery.Blocks.BLOOM));
    }

    public static ItemStack toItemStack(TileBloom tile, ItemStack itemStack) {
        return StackHelper.writeTileEntityToItemStack((TileEntity)tile, (ItemStack)itemStack);
    }

    public static NBTTagCompound writeToNBT(NBTTagCompound compound, int maxIntegrity, int integrity, float experiencePerComplete, @Nullable String recipeId, @Nullable String langKey) {
        compound.func_74768_a("maxIntegrity", maxIntegrity);
        compound.func_74768_a("integrity", integrity);
        compound.func_74776_a("experiencePerComplete", experiencePerComplete);
        if (recipeId != null) {
            compound.func_74778_a("recipeId", recipeId);
        }
        if (langKey != null) {
            compound.func_74778_a("langKey", langKey);
        }
        return compound;
    }

    public static void trySpawnFire(World world, BlockPos pos, Random rand, double chance) {
        if ((double)rand.nextFloat() < chance) {
            EntityPlayer closestPlayer = world.func_184137_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, 2.0, false);
            if (closestPlayer != null) {
                BlockPos position = closestPlayer.func_180425_c();
                IBlockState blockState = world.func_180495_p(position.func_177977_b());
                if (!world.func_175623_d(position) || !blockState.func_177230_c().isSideSolid(blockState, (IBlockAccess)world, pos, EnumFacing.UP)) {
                    closestPlayer.func_70015_d((double)rand.nextFloat() < 0.5 ? 1 : 2);
                    int damage = rand.nextInt(5);
                    if (damage > 0) {
                        closestPlayer.func_70097_a(DamageSource.field_190095_e, (float)damage);
                    }
                }
            }
            BlockHelper.forBlocksInCubeShuffled((World)world, (BlockPos)pos, (int)2, (int)1, (int)2, (w, p, bs) -> {
                BlockPos down;
                IBlockState blockState;
                if (w.func_175623_d(p) && (blockState = w.func_180495_p(down = p.func_177977_b())).isSideSolid((IBlockAccess)w, down, EnumFacing.UP)) {
                    w.func_180501_a(p, Blocks.field_150480_ab.func_176223_P(), 3);
                    return false;
                }
                return true;
            });
        }
    }

    public static ItemStack createItemTongsFull(ItemStack emptyTongs, ItemStack bloom) {
        Item item = emptyTongs.func_77973_b();
        if (!(item instanceof ItemTongsEmptyBase)) {
            return emptyTongs;
        }
        ItemTongsEmptyBase tongs = (ItemTongsEmptyBase)item;
        ItemStack itemStack = new ItemStack((Item)tongs.getItemTongsFull(), 1, emptyTongs.func_77960_j());
        NBTTagCompound tag = new NBTTagCompound();
        if (bloom.func_77978_p() != null) {
            tag.func_179237_a(bloom.func_77978_p());
        }
        if (emptyTongs.func_77978_p() != null) {
            tag.func_179237_a(emptyTongs.func_77978_p());
        }
        itemStack.func_77982_d(tag);
        return itemStack;
    }

    public static ItemStack createItemTongsEmpty(ItemStack toEmpty, boolean applyDamage) {
        NBTTagCompound tagCompound = toEmpty.func_77978_p();
        if (tagCompound == null) {
            return toEmpty;
        }
        Item item = toEmpty.func_77973_b();
        if (!(item instanceof ItemTongsFullBase)) {
            return toEmpty;
        }
        if (applyDamage && toEmpty.func_96631_a(1, RandomHelper.random(), null)) {
            return ItemStack.field_190927_a;
        }
        ItemTongsFullBase tongs = (ItemTongsFullBase)item;
        ItemStack itemStack = new ItemStack((Item)tongs.getItemTongsEmpty(), 1, toEmpty.func_77960_j());
        NBTTagCompound copy = tagCompound.func_74737_b();
        copy.func_82580_o("BlockEntityTag");
        itemStack.func_77982_d(copy);
        return itemStack;
    }

    public static String getCompareString(ItemStack itemStack) {
        NBTTagCompound compound = StackHelper.getTagSafe((ItemStack)itemStack);
        NBTTagCompound tileTag = compound.func_74775_l("BlockEntityTag");
        return tileTag.func_74779_i("recipeId");
    }
}

