/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.tech.bloomery.tile;

import com.codetaylor.mc.athenaeum.integration.gamestages.Stages;
import com.codetaylor.mc.athenaeum.interaction.api.Transform;
import com.codetaylor.mc.athenaeum.interaction.spi.IInteraction;
import com.codetaylor.mc.athenaeum.interaction.spi.ITileInteractable;
import com.codetaylor.mc.athenaeum.interaction.spi.InteractionBase;
import com.codetaylor.mc.athenaeum.interaction.spi.InteractionItemStack;
import com.codetaylor.mc.athenaeum.interaction.spi.InteractionUseItemBase;
import com.codetaylor.mc.athenaeum.inventory.DynamicStackHandler;
import com.codetaylor.mc.athenaeum.inventory.ObservableStackHandler;
import com.codetaylor.mc.athenaeum.network.tile.data.TileDataBoolean;
import com.codetaylor.mc.athenaeum.network.tile.data.TileDataFloat;
import com.codetaylor.mc.athenaeum.network.tile.data.TileDataInteger;
import com.codetaylor.mc.athenaeum.network.tile.data.TileDataItemStackHandler;
import com.codetaylor.mc.athenaeum.network.tile.spi.ITileData;
import com.codetaylor.mc.athenaeum.network.tile.spi.ITileDataItemStackHandler;
import com.codetaylor.mc.athenaeum.network.tile.spi.TileEntityDataBase;
import com.codetaylor.mc.athenaeum.util.BlockHelper;
import com.codetaylor.mc.athenaeum.util.Properties;
import com.codetaylor.mc.athenaeum.util.RandomHelper;
import com.codetaylor.mc.athenaeum.util.StackHelper;
import com.codetaylor.mc.pyrotech.IAirflowConsumerCapability;
import com.codetaylor.mc.pyrotech.library.spi.tile.ITileContainer;
import com.codetaylor.mc.pyrotech.library.spi.tile.TileCapabilityDelegate;
import com.codetaylor.mc.pyrotech.library.util.Util;
import com.codetaylor.mc.pyrotech.modules.core.ModuleCore;
import com.codetaylor.mc.pyrotech.modules.core.item.ItemMaterial;
import com.codetaylor.mc.pyrotech.modules.tech.bloomery.ModuleTechBloomery;
import com.codetaylor.mc.pyrotech.modules.tech.bloomery.ModuleTechBloomeryConfig;
import com.codetaylor.mc.pyrotech.modules.tech.bloomery.block.BlockPileSlag;
import com.codetaylor.mc.pyrotech.modules.tech.bloomery.client.particles.ParticleBloomeryDrip;
import com.codetaylor.mc.pyrotech.modules.tech.bloomery.client.render.BloomeryFuelRenderer;
import com.codetaylor.mc.pyrotech.modules.tech.bloomery.recipe.BloomeryRecipe;
import com.codetaylor.mc.pyrotech.modules.tech.bloomery.recipe.BloomeryRecipeBase;
import com.codetaylor.mc.pyrotech.modules.tech.bloomery.tile.TilePileSlag;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.function.BooleanSupplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.ItemStackHandler;

public class TileBloomery
extends TileEntityDataBase
implements ITileInteractable,
ITickable,
ITileContainer,
IAirflowConsumerCapability {
    private static final AxisAlignedBB INTERACTION_BOUNDS_TOP = new AxisAlignedBB(0.125, 1.0, 0.125, 0.875, 1.5, 0.875);
    private static final Transform UPPER_TRANSFORM = new Transform(Transform.translate((double)0.5, (double)1.5, (double)0.5), Transform.rotate(), Transform.scale((double)0.5, (double)0.5, (double)0.5));
    private static final Transform LOWER_TRANSFORM = new Transform(Transform.translate((double)0.5, (double)0.3125, (double)0.5), Transform.rotate(), Transform.scale((double)0.5, (double)0.5, (double)0.5));
    private final InputStackHandler inputStackHandler = new InputStackHandler(this.getInputCapacity());
    private final OutputStackHandler outputStackHandler;
    private final FuelStackHandler fuelStackHandler;
    private final TileDataItemStackHandler<InputStackHandler> tileDataInputStackHandler;
    private final TileDataFloat recipeProgress;
    private final TileDataFloat speed;
    private final TileDataBoolean active;
    private final TileDataInteger fuelCount;
    private final TileDataInteger burnTime;
    private final TileDataFloat airflow;
    private final TileDataInteger ashCount;
    private final IInteraction<?>[] interactions;
    private float airflowBonus;
    private int lastBurnTime;
    private BloomeryRecipeBase<?> currentRecipe;
    private int remainingSlag;
    private boolean checkLight;

    public TileBloomery() {
        super(ModuleTechBloomery.TILE_DATA_SERVICE);
        this.inputStackHandler.addObserver((handler, slot) -> {
            this.updateRecipe();
            this.func_70296_d();
        });
        this.outputStackHandler = new OutputStackHandler();
        this.outputStackHandler.addObserver((handler, slot) -> this.func_70296_d());
        this.fuelStackHandler = new FuelStackHandler(this);
        this.fuelStackHandler.addObserver((handler, slot) -> {
            this.updateAirflow();
            this.func_70296_d();
        });
        this.recipeProgress = new TileDataFloat(0.0f, 20);
        this.speed = new TileDataFloat(0.0f);
        this.active = new TileDataBoolean(false);
        this.fuelCount = new TileDataInteger(0);
        this.burnTime = new TileDataInteger(0);
        this.airflow = new TileDataFloat(-1.0f);
        this.airflowBonus = 0.0f;
        this.ashCount = new TileDataInteger(0);
        this.tileDataInputStackHandler = new TileDataItemStackHandler((ItemStackHandler)this.inputStackHandler);
        this.registerTileDataForNetwork(new ITileData[]{this.tileDataInputStackHandler, new TileDataItemStackHandler((ItemStackHandler)this.outputStackHandler), new TileDataItemStackHandler((ItemStackHandler)this.fuelStackHandler), this.recipeProgress, this.speed, this.active, this.fuelCount, this.burnTime, this.airflow, this.ashCount});
        this.interactions = new IInteraction[]{new InteractionItem(this.getInputInteractionBoundsTop()), new InteractionIgnite(this.getInputInteractionBoundsTop()), new InteractionShovel(this.getInputInteractionBoundsTop()), new InteractionInput(this, new ItemStackHandler[]{this.inputStackHandler, this.outputStackHandler}, this.getInputInteractionBoundsTop(), () -> this.fuelStackHandler.getTotalItemCount() == 0 && !this.isActive() && this.getAshCount() == 0), new InteractionFuel(this, this.fuelStackHandler, this.getInputInteractionBoundsTop(), () -> !this.inputStackHandler.getStackInSlot(0).func_190926_b() && this.getAshCount() == 0)};
    }

    public void setActive() {
        if (!this.active.get() && !this.inputStackHandler.getStackInSlot(0).func_190926_b() && this.burnTime.get() > 0 && this.currentRecipe != null) {
            this.active.set(true);
            this.fuelStackHandler.clearStacks();
            this.remainingSlag = this.currentRecipe.getSlagCount() * this.inputStackHandler.getStackInSlot(0).func_190916_E();
        }
    }

    public boolean isActive() {
        return this.active.get();
    }

    public float getRecipeProgress() {
        return this.recipeProgress.get();
    }

    public InputStackHandler getInputStackHandler() {
        return this.inputStackHandler;
    }

    public OutputStackHandler getOutputStackHandler() {
        return this.outputStackHandler;
    }

    public FuelStackHandler getFuelStackHandler() {
        return this.fuelStackHandler;
    }

    public BloomeryRecipeBase<?> getCurrentRecipe() {
        return this.currentRecipe;
    }

    public boolean isFuelFull() {
        return this.getFuelCount() >= this.getMaxFuelCount() || this.hasSpeedCap() && this.burnTime.get() >= this.getMaxBurnTime();
    }

    public int getFuelCount() {
        return this.fuelCount.get();
    }

    public float getSpeed() {
        return this.speed.get();
    }

    public int getBurnTime() {
        return this.burnTime.get();
    }

    public float getAirflow() {
        return this.airflow.get();
    }

    public int getAshCount() {
        return this.ashCount.get();
    }

    public int getMaxFuelCount() {
        return ModuleTechBloomeryConfig.BLOOMERY.FUEL_CAPACITY_ITEMS;
    }

    public int getMaxBurnTime() {
        return ModuleTechBloomeryConfig.BLOOMERY.FUEL_CAPACITY_BURN_TIME;
    }

    public boolean hasSpeedCap() {
        return ModuleTechBloomeryConfig.BLOOMERY.HAS_SPEED_CAP;
    }

    protected float getAirflowDragModifier() {
        return (float)ModuleTechBloomeryConfig.BLOOMERY.AIRFLOW_DRAG_MODIFIER;
    }

    protected float getAirflowModifier() {
        return (float)ModuleTechBloomeryConfig.BLOOMERY.AIRFLOW_MODIFIER;
    }

    protected double getAshConversionChance() {
        return ModuleTechBloomeryConfig.BLOOMERY.ASH_CONVERSION_CHANCE;
    }

    public int getMaxAshCapacity() {
        return ModuleTechBloomeryConfig.BLOOMERY.MAX_ASH_CAPACITY;
    }

    protected double getSpeedScalar() {
        return ModuleTechBloomeryConfig.BLOOMERY.SPEED_SCALAR;
    }

    protected int getItemBurnTime(ItemStack stack) {
        return (int)((double)StackHelper.getItemBurnTime((ItemStack)stack) * this.getSpecialFuelBurnTimeModifier(stack));
    }

    protected double getSpecialFuelBurnTimeModifier(ItemStack stack) {
        return ModuleTechBloomeryConfig.BLOOMERY.getSpecialFuelBurnTimeModifier(stack);
    }

    protected int getInputCapacity() {
        return Math.min(64, Math.max(0, ModuleTechBloomeryConfig.BLOOMERY.CAPACITY));
    }

    protected boolean dropSlagWhenBroken() {
        return ModuleTechBloomeryConfig.BLOOMERY.DROP_SLAG_WHEN_BROKEN;
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == ModuleCore.CAPABILITY_AIRFLOW_CONSUMER;
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == ModuleCore.CAPABILITY_AIRFLOW_CONSUMER) {
            return (T)this;
        }
        return null;
    }

    private void updateRecipe() {
        this.currentRecipe = this.getRecipe(this.inputStackHandler.getStackInSlot(0));
    }

    protected BloomeryRecipeBase<?> getRecipe(ItemStack stackInSlot) {
        return BloomeryRecipe.getRecipe(stackInSlot);
    }

    private void updateSpeed() {
        float linearSpeed = (float)this.burnTime.get() / (float)this.getMaxBurnTime();
        float speed = (float)(this.getSpeedScalar() * (double)((float)Math.pow(linearSpeed, 0.5)));
        speed = (float)((double)speed * this.calculateSpeedAirflowModifier());
        this.speed.set(speed);
    }

    private double calculateSpeedAirflowModifier() {
        float airflow = this.airflow.get();
        return Math.pow((double)airflow - (double)airflow * 0.19, 0.5) + 0.1;
    }

    protected List<BlockPos> getAirflowCheckPositions() {
        IBlockState tileBlockState = this.field_145850_b.func_180495_p(this.field_174879_c);
        EnumFacing tileFacing = this.getTileFacing(this.field_145850_b, this.field_174879_c, tileBlockState);
        BlockPos offset = this.field_174879_c.func_177972_a(tileFacing);
        return Collections.singletonList(offset);
    }

    public void updateAirflow() {
        IBlockState tileBlockState = this.field_145850_b.func_180495_p(this.field_174879_c);
        EnumFacing tileFacing = this.getTileFacing(this.field_145850_b, this.field_174879_c, tileBlockState);
        List<BlockPos> positions = this.getAirflowCheckPositions();
        this.airflow.set(0.0f);
        for (BlockPos position : positions) {
            IBlockState blockState = this.field_145850_b.func_180495_p(position);
            if (this.field_145850_b.func_175623_d(position)) {
                this.airflow.add(1.0f);
                continue;
            }
            if (blockState.func_177230_c() == ModuleTechBloomery.Blocks.GENERATED_PILE_SLAG) {
                int level = ModuleTechBloomery.Blocks.PILE_SLAG.getLevel(blockState);
                if (level == 1) {
                    this.airflow.add(1.0f);
                    continue;
                }
                if (level == 2) {
                    this.airflow.add(0.66f);
                    continue;
                }
                if (level == 3) {
                    this.airflow.add(0.33f);
                    continue;
                }
                if (level != 4) continue;
                this.airflow.add(0.0f);
                continue;
            }
            if (blockState.func_177230_c().isSideSolid(blockState, (IBlockAccess)this.field_145850_b, position, tileFacing.func_176734_d())) {
                this.airflow.add(0.0f);
                continue;
            }
            this.airflow.add(0.5f);
        }
        double x = (double)this.fuelCount.get() / (double)this.getMaxFuelCount();
        double airflowFuelModifier = 1.0 - 0.75 * Math.pow(x, 2.0);
        this.airflow.set((float)((double)this.airflow.get() * airflowFuelModifier));
        this.airflow.add(this.airflowBonus);
        this.updateSpeed();
    }

    @Override
    public float consumeAirflow(float airflow, boolean simulate) {
        if (!simulate) {
            this.airflowBonus += airflow * this.getAirflowModifier();
            this.updateAirflow();
        }
        return 0.0f;
    }

    public void func_73660_a() {
        if (!this.checkLight) {
            this.checkLight = true;
            this.field_145850_b.func_180500_c(EnumSkyBlock.BLOCK, this.field_174879_c);
        }
        if (this.field_145850_b.field_72995_K) {
            Random rand = RandomHelper.random();
            if (this.isActive() && rand.nextDouble() < 0.5) {
                if (rand.nextDouble() < 0.1) {
                    this.field_145850_b.func_184134_a((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p() + 0.5, SoundEvents.field_187652_bv, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
                }
                IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
                EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)Properties.FACING_HORIZONTAL);
                this.spawnDrip(rand, facing);
            }
            return;
        }
        if (this.airflowBonus > 0.0f) {
            this.airflowBonus -= this.airflowBonus * this.getAirflowDragModifier();
            if (this.airflowBonus < 1.1920929E-7f) {
                this.airflowBonus = 0.0f;
            }
            this.updateAirflow();
        }
        if (this.airflow.get() < 0.0f) {
            this.updateAirflow();
        }
        if (this.lastBurnTime != this.burnTime.get()) {
            this.lastBurnTime = this.burnTime.get();
            this.updateSpeed();
        }
        if (this.isActive()) {
            int slag;
            float nextSlagInterval;
            if (this.currentRecipe == null) {
                this.burnTime.set(0);
                this.recipeProgress.set(0.0f);
                this.active.set(false);
                return;
            }
            float increment = 1.0f / (float)this.currentRecipe.getTimeTicks() * this.speed.get();
            float recipeProgress = this.recipeProgress.add(increment);
            if (recipeProgress >= (nextSlagInterval = (float)((slag = this.currentRecipe.getSlagCount() * this.inputStackHandler.getStackInSlot(0).func_190916_E()) - this.remainingSlag) * (1.0f / (float)slag) + 1.0f / (float)slag * 0.5f)) {
                --this.remainingSlag;
                this.createSlag();
            }
            if ((double)recipeProgress >= 0.9999) {
                int ashCount = this.ashCount.get() + 1;
                Random random = RandomHelper.random();
                int fuelCount = this.fuelCount.get();
                for (int i = 1; i < fuelCount; ++i) {
                    if (!((double)random.nextFloat() < this.getAshConversionChance())) continue;
                    ++ashCount;
                }
                ashCount = Math.min(this.getMaxAshCapacity(), ashCount);
                this.ashCount.set(ashCount);
                int count = this.inputStackHandler.getStackInSlot(0).func_190916_E();
                ItemStack output = this.currentRecipe.getUniqueBloomFromOutput(count);
                this.inputStackHandler.extractItem(0, count, false);
                this.outputStackHandler.insertItem(0, output, false);
                this.burnTime.set(0);
                this.fuelCount.set(0);
                this.recipeProgress.set(0.0f);
                this.active.set(false);
                this.updateAirflow();
            }
        }
    }

    protected void spawnDrip(Random rand, EnumFacing facing) {
        double offsetY = rand.nextDouble() * 6.0 / 16.0;
        double x = (double)this.field_174879_c.func_177958_n() + 0.5;
        double y = (double)this.field_174879_c.func_177956_o() + offsetY;
        double z = (double)this.field_174879_c.func_177952_p() + 0.5;
        double offset = 0.55;
        double lavaOffset = 0.075;
        double dripChance = 0.25;
        switch (facing) {
            case WEST: {
                if (!((double)rand.nextFloat() < dripChance)) break;
                Minecraft.func_71410_x().field_71452_i.func_78873_a(ParticleBloomeryDrip.createParticle(this.field_145850_b, x - offset - lavaOffset, y - offsetY, z));
                break;
            }
            case EAST: {
                if (!((double)rand.nextFloat() < dripChance)) break;
                Minecraft.func_71410_x().field_71452_i.func_78873_a(ParticleBloomeryDrip.createParticle(this.field_145850_b, x + offset + lavaOffset, y - offsetY, z));
                break;
            }
            case NORTH: {
                if (!((double)rand.nextFloat() < dripChance)) break;
                Minecraft.func_71410_x().field_71452_i.func_78873_a(ParticleBloomeryDrip.createParticle(this.field_145850_b, x, y - offsetY, z - offset - lavaOffset));
                break;
            }
            case SOUTH: {
                if (!((double)rand.nextFloat() < dripChance)) break;
                Minecraft.func_71410_x().field_71452_i.func_78873_a(ParticleBloomeryDrip.createParticle(this.field_145850_b, x, y - offsetY, z + offset + lavaOffset));
            }
        }
    }

    protected void createSlag() {
        EnumFacing facing = this.getTileFacing(this.field_145850_b, this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c));
        this.createSlag(this.field_174879_c.func_177972_a(facing));
    }

    protected void createSlag(BlockPos pos) {
        IBlockState blockState = this.field_145850_b.func_180495_p(pos);
        Block block = blockState.func_177230_c();
        if (block == ModuleTechBloomery.Blocks.PILE_SLAG) {
            int level = ModuleTechBloomery.Blocks.PILE_SLAG.getLevel(blockState);
            if (level >= 4) {
                return;
            }
            this.addSlagItemToTileEntity(pos);
            this.field_145850_b.func_175656_a(pos, ModuleTechBloomery.Blocks.PILE_SLAG.setLevel(blockState, level + 1).func_177226_a((IProperty)BlockPileSlag.MOLTEN, (Comparable)Boolean.valueOf(true)));
            return;
        }
        int y = pos.func_177956_o();
        BlockPos startPos = pos;
        for (int i = 0; i < y && this.field_145850_b.func_180495_p(pos = startPos.func_177979_c(i)).func_177230_c().func_176200_f((IBlockAccess)this.field_145850_b, pos); ++i) {
        }
        if (pos.func_177956_o() < y && pos.func_177956_o() > 0) {
            int level;
            int toClear = y - pos.func_177956_o();
            for (int i = 1; i < toClear; ++i) {
                this.field_145850_b.func_175655_b(pos.func_177981_b(i + 1), true);
            }
            IBlockState blockState2 = this.field_145850_b.func_180495_p(pos);
            if (blockState2.func_177230_c() == ModuleTechBloomery.Blocks.PILE_SLAG && (level = ModuleTechBloomery.Blocks.PILE_SLAG.getLevel(blockState2)) < 8) {
                this.addSlagItemToTileEntity(pos);
                this.field_145850_b.func_175656_a(pos, ModuleTechBloomery.Blocks.PILE_SLAG.setLevel(blockState2, level + 1).func_177226_a((IProperty)BlockPileSlag.MOLTEN, (Comparable)Boolean.valueOf(true)));
                return;
            }
            pos = pos.func_177984_a();
            this.field_145850_b.func_175656_a(pos, ModuleTechBloomery.Blocks.PILE_SLAG.setLevel(ModuleTechBloomery.Blocks.PILE_SLAG.func_176223_P(), 1).func_177226_a((IProperty)BlockPileSlag.MOLTEN, (Comparable)Boolean.valueOf(true)));
            this.addSlagItemToTileEntity(pos);
        }
    }

    private void addSlagItemToTileEntity(BlockPos pos) {
        TileEntity tileEntity = this.field_145850_b.func_175625_s(pos);
        if (tileEntity instanceof TilePileSlag) {
            TilePileSlag.StackHandler stackHandler = ((TilePileSlag)tileEntity).getStackHandler();
            ItemStack slagItemStack = this.currentRecipe.getSlagItemStack();
            if (!slagItemStack.func_190926_b()) {
                Item slagItem = slagItemStack.func_77973_b();
                ItemStack itemStack = new ItemStack(slagItem);
                stackHandler.insertItem(0, itemStack, false);
            }
            ((TilePileSlag)tileEntity).setLastMolten(this.field_145850_b.func_82737_E());
        }
    }

    public void onTileDataUpdate() {
        if (this.tileDataInputStackHandler.isDirty()) {
            this.updateRecipe();
        }
        if (this.active.isDirty()) {
            BlockHelper.notifyBlockUpdate((World)this.field_145850_b, (BlockPos)this.field_174879_c);
            this.field_145850_b.func_180500_c(EnumSkyBlock.BLOCK, this.field_174879_c);
        }
    }

    @Nonnull
    public NBTTagCompound func_189515_b(@Nonnull NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74782_a("inputStackHandler", (NBTBase)this.inputStackHandler.serializeNBT());
        compound.func_74782_a("outputStackHandler", (NBTBase)this.outputStackHandler.serializeNBT());
        compound.func_74782_a("fuelStackHandler", (NBTBase)this.fuelStackHandler.serializeNBT());
        compound.func_74776_a("recipeProgress", this.recipeProgress.get());
        compound.func_74757_a("active", this.active.get());
        compound.func_74776_a("speed", this.speed.get());
        compound.func_74768_a("burnTime", this.burnTime.get());
        compound.func_74768_a("fuelCount", this.fuelCount.get());
        compound.func_74776_a("airflow", this.airflow.get());
        compound.func_74768_a("ashCount", this.ashCount.get());
        compound.func_74768_a("remainingSlag", this.remainingSlag);
        return compound;
    }

    public void func_145839_a(@Nonnull NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.inputStackHandler.deserializeNBT(compound.func_74775_l("inputStackHandler"));
        this.outputStackHandler.deserializeNBT(compound.func_74775_l("outputStackHandler"));
        this.fuelStackHandler.deserializeNBT(compound.func_74775_l("fuelStackHandler"));
        this.recipeProgress.set(compound.func_74760_g("recipeProgress"));
        this.active.set(compound.func_74767_n("active"));
        this.speed.set(compound.func_74760_g("speed"));
        this.burnTime.set(compound.func_74762_e("burnTime"));
        this.fuelCount.set(compound.func_74762_e("fuelCount"));
        this.airflow.set(compound.func_74760_g("airflow"));
        this.ashCount.set(compound.func_74762_e("ashCount"));
        this.remainingSlag = compound.func_74762_e("remainingSlag");
        this.updateRecipe();
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 0 || pass == 1;
    }

    @Override
    public void dropContents() {
        ItemStack stackInSlot;
        if (!this.isActive()) {
            StackHelper.spawnStackHandlerSlotContentsOnTop((World)this.field_145850_b, (ItemStackHandler)this.inputStackHandler, (int)0, (BlockPos)this.field_174879_c);
        } else if (this.currentRecipe != null && this.dropSlagWhenBroken() && !(stackInSlot = this.inputStackHandler.getStackInSlot(0)).func_190926_b()) {
            ItemStack slagItemStack = this.currentRecipe.getSlagItemStack().func_77946_l();
            slagItemStack.func_190920_e(this.remainingSlag);
            StackHelper.spawnStackOnTop((World)this.field_145850_b, (ItemStack)slagItemStack, (BlockPos)this.field_174879_c);
        }
        StackHelper.spawnStackHandlerSlotContentsOnTop((World)this.field_145850_b, (ItemStackHandler)this.outputStackHandler, (int)0, (BlockPos)this.field_174879_c);
        StackHelper.spawnStackHandlerContentsOnTop((World)this.field_145850_b, (ItemStackHandler)this.fuelStackHandler, (BlockPos)this.field_174879_c);
    }

    @Nullable
    public Stages getStages() {
        return ModuleTechBloomeryConfig.STAGES_BLOOMERY;
    }

    public IInteraction<?>[] getInteractions() {
        return this.interactions;
    }

    public boolean isExtendedInteraction(World world, BlockPos pos, IBlockState blockState) {
        BlockPos blockPos = this.func_174877_v();
        return blockPos.func_177958_n() == pos.func_177958_n() && blockPos.func_177956_o() + 1 == pos.func_177956_o() && blockPos.func_177952_p() == pos.func_177952_p();
    }

    public EnumFacing getTileFacing(World world, BlockPos pos, IBlockState blockState) {
        if (blockState.func_177230_c() == ModuleTechBloomery.Blocks.BLOOMERY) {
            return (EnumFacing)blockState.func_177229_b((IProperty)Properties.FACING_HORIZONTAL);
        }
        return super.getTileFacing(world, pos, blockState);
    }

    private AxisAlignedBB getInputInteractionBoundsTop() {
        return INTERACTION_BOUNDS_TOP;
    }

    public static class Top
    extends TileCapabilityDelegate
    implements ITileInteractable {
        public Top() {
            super(EnumFacing.DOWN, EnumFacing.UP);
        }
    }

    public static class FuelStackHandler
    extends DynamicStackHandler {
        private final TileBloomery tile;

        FuelStackHandler(TileBloomery tile) {
            super(1);
            this.tile = tile;
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            int insertCount;
            if (this.tile.inputStackHandler.getStackInSlot(0).func_190926_b()) {
                return stack;
            }
            if (stack.func_77973_b().hasContainerItem(stack)) {
                return stack;
            }
            int fuelCount = this.tile.fuelCount.get();
            if (fuelCount >= this.tile.getMaxFuelCount()) {
                return stack;
            }
            int fuelBurnTimeSingle = this.tile.getItemBurnTime(stack);
            if (fuelBurnTimeSingle <= 0) {
                return stack;
            }
            int max = this.tile.getMaxBurnTime();
            int fuelBurnTimeTotal = fuelBurnTimeSingle * stack.func_190916_E();
            if (this.tile.hasSpeedCap() && this.tile.burnTime.get() >= max) {
                return stack;
            }
            if (!(this.tile.hasSpeedCap() && this.tile.burnTime.get() + fuelBurnTimeTotal > max || fuelCount + stack.func_190916_E() > this.tile.getMaxFuelCount())) {
                if (!simulate) {
                    this.tile.burnTime.add(fuelBurnTimeTotal);
                    this.tile.fuelCount.add(stack.func_190916_E());
                    if (!this.tile.isActive()) {
                        this.insertItem(stack, false);
                    }
                }
                return ItemStack.field_190927_a;
            }
            ItemStack toInsert = stack.func_77946_l();
            int itemCountInsertCount = Math.min(toInsert.func_190916_E(), this.tile.getMaxFuelCount() - fuelCount);
            if (this.tile.hasSpeedCap()) {
                int burnTimeInsertCount = Math.min(toInsert.func_190916_E(), (int)((float)(max - this.tile.burnTime.get()) / (float)fuelBurnTimeSingle));
                insertCount = Math.min(burnTimeInsertCount, itemCountInsertCount);
            } else {
                insertCount = itemCountInsertCount;
            }
            toInsert.func_190920_e(insertCount);
            if (!simulate) {
                this.tile.burnTime.add(insertCount * fuelBurnTimeSingle);
                this.tile.fuelCount.add(insertCount);
                if (!this.tile.isActive()) {
                    this.insertItem(toInsert, false);
                }
            }
            ItemStack toReturn = stack.func_77946_l();
            toReturn.func_190920_e(toReturn.func_190916_E() - insertCount);
            return toReturn;
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            for (int i = this.getSlots() - 1; i >= 0; --i) {
                if (this.getStackInSlot(i).func_190926_b()) continue;
                ItemStack extractItem = super.extractItem(i, amount, true);
                if (!simulate) {
                    if (!this.tile.isActive()) {
                        this.tile.burnTime.add(-this.tile.getItemBurnTime(extractItem) * extractItem.func_190916_E());
                        this.tile.fuelCount.add(-extractItem.func_190916_E());
                    }
                    super.extractItem(i, amount, false);
                }
                return extractItem;
            }
            return ItemStack.field_190927_a;
        }
    }

    public static class OutputStackHandler
    extends ObservableStackHandler
    implements ITileDataItemStackHandler {
        OutputStackHandler() {
            super(1);
        }

        public int getSlotLimit(int slot) {
            return 1;
        }
    }

    public class InputStackHandler
    extends ObservableStackHandler
    implements ITileDataItemStackHandler {
        private final int capacity;

        public InputStackHandler(int capacity) {
            super(1);
            this.capacity = capacity;
        }

        public int getSlotLimit(int slot) {
            return this.capacity;
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            if (TileBloomery.this.getRecipe(stack) == null || !TileBloomery.this.outputStackHandler.getStackInSlot(0).func_190926_b()) {
                return stack;
            }
            return super.insertItem(slot, stack, simulate);
        }
    }

    private static class InteractionShovel
    extends InteractionBase<TileBloomery> {
        InteractionShovel(AxisAlignedBB interactionBounds) {
            super(new EnumFacing[]{EnumFacing.UP}, interactionBounds);
        }

        public boolean interact(IInteraction.EnumType type, TileBloomery tile, World world, BlockPos hitPos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing hitSide, float hitX, float hitY, float hitZ) {
            if (type != IInteraction.EnumType.MouseClick) {
                return false;
            }
            ItemStack heldItem = player.func_184614_ca();
            if (tile.ashCount.get() > 0 && heldItem.func_77973_b().getToolClasses(heldItem).contains("shovel")) {
                if (!world.field_72995_K) {
                    tile.ashCount.set(tile.ashCount.get() - 1);
                    StackHelper.spawnStackOnTop((World)world, (ItemStack)ItemMaterial.EnumType.PIT_ASH.asStack(), (BlockPos)hitPos, (double)1.5);
                    heldItem.func_77972_a(1, (EntityLivingBase)player);
                    world.func_184133_a(null, hitPos, SoundEvents.field_187747_eB, SoundCategory.BLOCKS, 1.0f, 1.0f);
                }
                return true;
            }
            return false;
        }
    }

    public static class InteractionFuel
    extends InteractionItemStack<TileBloomery> {
        private final TileBloomery tile;
        private final FuelStackHandler fuelStackHandler;
        private final BooleanSupplier isEnabled;

        InteractionFuel(TileBloomery tile, FuelStackHandler fuelStackHandler, AxisAlignedBB interactionBounds, BooleanSupplier isEnabled) {
            super(new ItemStackHandler[]{fuelStackHandler}, 0, new EnumFacing[]{EnumFacing.UP}, interactionBounds, UPPER_TRANSFORM);
            this.tile = tile;
            this.fuelStackHandler = fuelStackHandler;
            this.isEnabled = isEnabled;
        }

        public FuelStackHandler getFuelStackHandler() {
            return this.fuelStackHandler;
        }

        public TileBloomery getTile() {
            return this.tile;
        }

        public boolean isEnabled() {
            return this.isEnabled.getAsBoolean();
        }

        public ItemStack getStackInSlot() {
            return super.getStackInSlot();
        }

        protected boolean doItemStackValidation(ItemStack itemStack) {
            return StackHelper.isFuel((ItemStack)itemStack) && !itemStack.func_77973_b().hasContainerItem(itemStack);
        }

        @SideOnly(value=Side.CLIENT)
        public void renderSolidPass(World world, RenderItem renderItem, BlockPos pos, IBlockState blockState, float partialTicks) {
            BloomeryFuelRenderer.INSTANCE.renderSolidPass(this, world, renderItem, pos, blockState, partialTicks);
        }

        @SideOnly(value=Side.CLIENT)
        public void renderSolidPassText(World world, FontRenderer fontRenderer, int yaw, Vec3d offset, BlockPos pos, IBlockState blockState, float partialTicks) {
        }

        @SideOnly(value=Side.CLIENT)
        public boolean renderAdditivePass(World world, RenderItem renderItem, EnumFacing hitSide, Vec3d hitVec, BlockPos hitPos, IBlockState blockState, ItemStack heldItemMainHand, float partialTicks) {
            return BloomeryFuelRenderer.INSTANCE.renderAdditivePass(this, world, renderItem, hitSide, hitVec, hitPos, blockState, heldItemMainHand, partialTicks);
        }
    }

    private static class InteractionInput
    extends InteractionItemStack<TileBloomery> {
        private final TileBloomery tile;
        private final BooleanSupplier isEnabled;

        InteractionInput(TileBloomery tile, ItemStackHandler[] stackHandlers, AxisAlignedBB interactionBounds, BooleanSupplier isEnabled) {
            super(stackHandlers, 0, new EnumFacing[]{EnumFacing.UP}, interactionBounds, LOWER_TRANSFORM);
            this.tile = tile;
            this.isEnabled = isEnabled;
        }

        public Transform getTransform(World world, BlockPos pos, IBlockState blockState, ItemStack itemStack, float partialTicks) {
            ItemStack input = this.stackHandlers[0].getStackInSlot(0);
            ItemStack output = this.stackHandlers[1].getStackInSlot(0);
            if (input.func_190926_b() && output.func_190926_b()) {
                return UPPER_TRANSFORM;
            }
            return super.getTransform(world, pos, blockState, itemStack, partialTicks);
        }

        public boolean isEnabled() {
            return this.isEnabled.getAsBoolean();
        }

        protected boolean doItemStackValidation(ItemStack itemStack) {
            return this.tile.getRecipe(itemStack) != null;
        }

        public boolean interact(IInteraction.EnumType type, TileBloomery tile, World world, BlockPos hitPos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing hitSide, float hitX, float hitY, float hitZ) {
            return super.interact(type, (TileEntity)tile, world, hitPos, state, player, hand, hitSide, hitX, hitY, hitZ);
        }
    }

    private static class InteractionIgnite
    extends InteractionUseItemBase<TileBloomery> {
        InteractionIgnite(AxisAlignedBB interactionBounds) {
            super(new EnumFacing[]{EnumFacing.UP}, interactionBounds);
        }

        protected boolean allowInteraction(TileBloomery tile, World world, BlockPos hitPos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing hitSide, float hitX, float hitY, float hitZ) {
            return (player.func_184586_b(hand).func_77973_b() == Items.field_151033_d || player.func_184586_b(hand).func_77973_b() == Items.field_151059_bz) && !tile.isActive();
        }

        protected boolean doInteraction(TileBloomery tile, World world, BlockPos hitPos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing hitSide, float hitX, float hitY, float hitZ) {
            if (!world.field_72995_K) {
                tile.setActive();
                if (player.func_184586_b(hand).func_77973_b() == Items.field_151059_bz) {
                    player.func_184586_b(hand).func_190918_g(1);
                }
                world.func_184133_a(null, hitPos, SoundEvents.field_187649_bu, SoundCategory.BLOCKS, 1.0f, Util.RANDOM.nextFloat() * 0.4f + 0.8f);
            }
            return true;
        }
    }

    private static class InteractionItem
    extends InteractionUseItemBase<TileBloomery> {
        InteractionItem(AxisAlignedBB bounds) {
            super(new EnumFacing[]{EnumFacing.UP}, bounds);
        }
    }
}

