/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.tech.bloomery.tile;

import com.codetaylor.mc.athenaeum.integration.gamestages.Stages;
import com.codetaylor.mc.athenaeum.interaction.spi.IInteraction;
import com.codetaylor.mc.athenaeum.interaction.spi.ITileInteractable;
import com.codetaylor.mc.athenaeum.interaction.spi.InteractionUseItemBase;
import com.codetaylor.mc.athenaeum.network.tile.data.TileDataFloat;
import com.codetaylor.mc.athenaeum.network.tile.data.TileDataInteger;
import com.codetaylor.mc.athenaeum.network.tile.spi.ITileData;
import com.codetaylor.mc.athenaeum.network.tile.spi.TileEntityDataBase;
import com.codetaylor.mc.athenaeum.util.RandomHelper;
import com.codetaylor.mc.athenaeum.util.StackHelper;
import com.codetaylor.mc.pyrotech.library.util.ExperienceHelper;
import com.codetaylor.mc.pyrotech.library.util.Util;
import com.codetaylor.mc.pyrotech.modules.core.ModuleCoreConfig;
import com.codetaylor.mc.pyrotech.modules.core.network.SCPacketNoHunger;
import com.codetaylor.mc.pyrotech.modules.tech.basic.ModuleTechBasic;
import com.codetaylor.mc.pyrotech.modules.tech.bloomery.ModuleTechBloomery;
import com.codetaylor.mc.pyrotech.modules.tech.bloomery.ModuleTechBloomeryConfig;
import com.codetaylor.mc.pyrotech.modules.tech.bloomery.block.BlockBloom;
import com.codetaylor.mc.pyrotech.modules.tech.bloomery.recipe.BloomeryRecipeBase;
import com.codetaylor.mc.pyrotech.modules.tech.bloomery.util.BloomHelper;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class TileBloom
extends TileEntityDataBase
implements ITileInteractable {
    private final TileDataFloat recipeProgress = new TileDataFloat(0.0f);
    private final TileDataInteger integrity = new TileDataInteger(0);
    private final IInteraction<?>[] interactions;
    private String recipeId;
    private String langKey;
    private int maxIntegrity;
    private float experiencePerComplete;

    public TileBloom() {
        super(ModuleTechBloomery.TILE_DATA_SERVICE);
        this.registerTileDataForNetwork(new ITileData[]{this.recipeProgress, this.integrity});
        this.interactions = new IInteraction[]{new InteractionItem(), new InteractionHit()};
    }

    public void setLangKey(String langKey) {
        this.langKey = langKey;
    }

    public String getLangKey() {
        return this.langKey;
    }

    public int getMaxIntegrity() {
        return this.maxIntegrity;
    }

    public int getIntegrity() {
        return this.integrity.get();
    }

    public float getRecipeProgress() {
        return this.recipeProgress.get();
    }

    @Nonnull
    public NBTTagCompound func_189515_b(@Nonnull NBTTagCompound compound) {
        super.func_189515_b(compound);
        BloomHelper.writeToNBT(compound, this.maxIntegrity, this.integrity.get(), this.experiencePerComplete, this.recipeId, this.langKey);
        return compound;
    }

    public void func_145839_a(@Nonnull NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.maxIntegrity = compound.func_74762_e("maxIntegrity");
        this.integrity.set(compound.func_74762_e("integrity"));
        this.experiencePerComplete = compound.func_74760_g("experiencePerComplete");
        if (compound.func_74764_b("recipeId")) {
            this.recipeId = compound.func_74779_i("recipeId");
        }
        if (compound.func_74764_b("langKey")) {
            this.langKey = compound.func_74779_i("langKey");
        }
    }

    @Nullable
    public Stages getStages() {
        return ModuleTechBloomeryConfig.STAGES_BLOOM;
    }

    public IInteraction<?>[] getInteractions() {
        return this.interactions;
    }

    private static class InteractionHit
    extends InteractionUseItemBase<TileBloom> {
        InteractionHit() {
            super(EnumFacing.field_82609_l, BlockBloom.AABB);
        }

        protected boolean allowInteraction(TileBloom tile, World world, BlockPos hitPos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing hitSide, float hitX, float hitY, float hitZ) {
            ItemStack heldItemStack = player.func_184586_b(hand);
            Item heldItem = heldItemStack.func_77973_b();
            ResourceLocation resourceLocation = heldItem.getRegistryName();
            if (resourceLocation == null) {
                return false;
            }
            return ModuleCoreConfig.HAMMERS.getHammerHarvestLevel(resourceLocation) > -1;
        }

        protected boolean doInteraction(TileBloom tile, World world, BlockPos hitPos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing hitSide, float hitX, float hitY, float hitZ) {
            block9: {
                BlockPos tilePos;
                block8: {
                    BlockPos posDown;
                    IBlockState blockStateDown;
                    Block blockDown;
                    float blockDownHardness;
                    BloomeryRecipeBase recipe;
                    if (tile.recipeId == null) {
                        return false;
                    }
                    tilePos = tile.func_174877_v();
                    if (player.func_71024_bL().func_75116_a() < ModuleTechBloomeryConfig.BLOOM.MINIMUM_HUNGER_TO_USE) {
                        if (!world.field_72995_K) {
                            ModuleTechBasic.PACKET_SERVICE.sendTo((IMessage)new SCPacketNoHunger(), (EntityPlayerMP)player);
                        }
                        return false;
                    }
                    if (world.field_72995_K) break block8;
                    if (ModuleTechBloomeryConfig.BLOOM.EXHAUSTION_COST_PER_HIT > 0.0) {
                        player.func_71020_j((float)ModuleTechBloomeryConfig.BLOOM.EXHAUSTION_COST_PER_HIT);
                    }
                    world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187843_fX, SoundCategory.BLOCKS, 0.75f, (float)(1.0 + Util.RANDOM.nextGaussian() * (double)0.4f));
                    ItemStack toolItemStack = player.func_184614_ca();
                    BloomHelper.trySpawnFire(world, tilePos, RandomHelper.random(), ModuleTechBloomeryConfig.BLOOM.FIRE_SPAWN_CHANCE_ON_HIT_RAW);
                    if (tile.recipeProgress.get() < 1.0f) {
                        int hits = Math.max(1, ModuleTechBloomeryConfig.BLOOM.HAMMER_HITS_REQUIRED);
                        Vec3d hammerPos = new Vec3d(player.field_70165_t, player.field_70163_u + (double)player.func_70047_e() * 0.5, player.field_70161_v);
                        float recipeProgressIncrement = (float)((double)(1.0f / (float)hits) * BloomHelper.calculateHammerPower(tilePos, hammerPos, toolItemStack, player));
                        tile.recipeProgress.set(tile.recipeProgress.get() + recipeProgressIncrement);
                    }
                    if (!((double)tile.recipeProgress.get() >= 0.9999)) break block9;
                    if (BloomHelper.shouldReduceIntegrity(toolItemStack, RandomHelper.random())) {
                        tile.integrity.add(-1);
                    }
                    if ((recipe = (BloomeryRecipeBase)ModuleTechBloomery.Registries.BLOOMERY_RECIPE.getValue(new ResourceLocation(tile.recipeId))) != null) {
                        ItemStack output = recipe.getRandomOutput(toolItemStack);
                        StackHelper.spawnStackOnTop((World)world, (ItemStack)output, (BlockPos)tilePos, (double)0.0);
                        ExperienceHelper.spawnXp(world, 1, tile.experiencePerComplete, tile.func_174877_v());
                    }
                    world.func_184148_a(player, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187835_fT, SoundCategory.BLOCKS, 1.0f, (float)(1.0 + Util.RANDOM.nextGaussian() * (double)0.4f));
                    world.func_175655_b(tilePos, true);
                    if (!ModuleTechBloomeryConfig.BLOOM.BREAKS_BLOCKS || !((blockDownHardness = (blockDown = (blockStateDown = world.func_180495_p(posDown = tilePos.func_177977_b())).func_177230_c()).func_176195_g(blockStateDown, world, posDown)) >= 0.0f)) break block9;
                    float clampedBlockDownHardness = MathHelper.func_76131_a((float)blockDownHardness, (float)0.0f, (float)50.0f);
                    float breakChance = (float)(1.0 - Math.pow(clampedBlockDownHardness / 60.0f, 0.125));
                    if (!(RandomHelper.random().nextDouble() < (double)breakChance)) break block9;
                    world.func_175655_b(posDown, false);
                    break block9;
                }
                for (int i = 0; i < 8; ++i) {
                    world.func_175688_a(EnumParticleTypes.LAVA, (double)((float)tilePos.func_177958_n() + hitX), (double)((float)tilePos.func_177956_o() + hitY), (double)((float)tilePos.func_177952_p() + hitZ), 0.0, 0.0, 0.0, new int[0]);
                }
            }
            return true;
        }
    }

    private static class InteractionItem
    extends InteractionUseItemBase<TileBloom> {
        InteractionItem() {
            super(EnumFacing.field_82609_l, BlockBloom.AABB);
        }
    }
}

