/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.tech.bloomery.recipe;

import com.codetaylor.mc.athenaeum.util.BlockHelper;
import com.codetaylor.mc.athenaeum.util.RandomHelper;
import com.codetaylor.mc.athenaeum.util.StackHelper;
import com.codetaylor.mc.pyrotech.library.util.ExperienceHelper;
import com.codetaylor.mc.pyrotech.modules.tech.basic.recipe.AnvilRecipe;
import com.codetaylor.mc.pyrotech.modules.tech.basic.tile.spi.TileAnvilBase;
import com.codetaylor.mc.pyrotech.modules.tech.bloomery.ModuleTechBloomery;
import com.codetaylor.mc.pyrotech.modules.tech.bloomery.ModuleTechBloomeryConfig;
import com.codetaylor.mc.pyrotech.modules.tech.bloomery.block.BlockBloom;
import com.codetaylor.mc.pyrotech.modules.tech.bloomery.recipe.BloomeryRecipeBase;
import com.codetaylor.mc.pyrotech.modules.tech.bloomery.tile.TileBloom;
import com.codetaylor.mc.pyrotech.modules.tech.bloomery.util.BloomHelper;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.items.ItemStackHandler;

public class BloomAnvilRecipe
extends AnvilRecipe
implements AnvilRecipe.IExtendedRecipe<BloomAnvilRecipe> {
    private final BloomeryRecipeBase<?> bloomeryRecipe;

    public BloomAnvilRecipe(ItemStack output, Ingredient input, int hits, AnvilRecipe.EnumType type, AnvilRecipe.EnumTier[] tiers, BloomeryRecipeBase<?> bloomeryRecipe) {
        super(output, input, hits, type, tiers);
        this.bloomeryRecipe = bloomeryRecipe;
    }

    public BloomeryRecipeBase<?> getBloomeryRecipe() {
        return this.bloomeryRecipe;
    }

    @Override
    public boolean matches(ItemStack input, AnvilRecipe.EnumTier tier, AnvilRecipe.EnumType type) {
        if (type != null && this.getType() != type) {
            return false;
        }
        if (input.func_77973_b() != ModuleTechBloomery.Items.BLOOM) {
            return false;
        }
        NBTTagCompound inputTag = input.func_77978_p();
        if (inputTag == null) {
            return false;
        }
        NBTTagCompound inputTileTag = inputTag.func_74775_l("BlockEntityTag");
        if (inputTileTag.func_186856_d() == 0) {
            return false;
        }
        String recipeId = inputTileTag.func_74779_i("recipeId");
        if (recipeId.isEmpty()) {
            return false;
        }
        return this.getRegistryName().toString().equals(recipeId);
    }

    @Override
    public void applyDamage(World world, TileAnvilBase tile) {
        if (tile.useDurability()) {
            int durabilityUntilNextDamage = tile.getDurabilityUntilNextDamage() - 1;
            if ((double)RandomHelper.random().nextFloat() < tile.getBloomAnvilExtraDamageChance()) {
                durabilityUntilNextDamage -= tile.getBloomAnvilExtraDamagePerHit();
            }
            tile.setDurabilityUntilNextDamage(durabilityUntilNextDamage);
        }
        BloomHelper.trySpawnFire(world, tile.func_174877_v(), RandomHelper.random(), ModuleTechBloomeryConfig.BLOOM.FIRE_SPAWN_CHANCE_ON_HIT_IN_ANVIL);
    }

    @Override
    public float getModifiedRecipeProgressIncrement(float increment, BlockPos anvilPos, Vec3d hammerPos, ItemStack hammerItemStack, @Nullable EntityPlayer player) {
        return (float)((double)increment * BloomHelper.calculateHammerPower(anvilPos, hammerPos, hammerItemStack, player));
    }

    @Override
    public List<ItemStack> onRecipeCompleted(TileAnvilBase tile, World world, ItemStackHandler stackHandler, BloomAnvilRecipe recipe, ItemStack toolItemStack) {
        float extraProgress;
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        result.add(this.onRecipeCompleted(tile, world, stackHandler, toolItemStack));
        for (extraProgress = tile.getRecipeProgress() - 1.0f; extraProgress >= 1.0f && !stackHandler.getStackInSlot(0).func_190926_b(); extraProgress -= 1.0f) {
            result.add(this.onRecipeCompleted(tile, world, stackHandler, toolItemStack));
        }
        if (extraProgress > 0.0f) {
            tile.setRecipeProgress(extraProgress);
        }
        return result;
    }

    protected ItemStack onRecipeCompleted(TileAnvilBase tile, World world, ItemStackHandler stackHandler, ItemStack toolItemStack) {
        ItemStack result = this.bloomeryRecipe.getRandomOutput(toolItemStack);
        ItemStack bloom = stackHandler.extractItem(0, stackHandler.getSlotLimit(0), false);
        BlockBloom.ItemBlockBloom item = (BlockBloom.ItemBlockBloom)bloom.func_77973_b();
        int integrity = item.getIntegrity(bloom);
        if (BloomHelper.shouldReduceIntegrity(toolItemStack, RandomHelper.random())) {
            --integrity;
        }
        if (integrity > 0) {
            item.setIntegrity(bloom, integrity);
            stackHandler.insertItem(0, bloom, false);
        }
        ExperienceHelper.spawnXp(world, 1, item.getExperiencePerComplete(bloom), tile.func_174877_v());
        return result;
    }

    @Override
    public void onAnvilHitClient(World world, TileAnvilBase tile, float hitX, float hitY, float hitZ) {
        ItemStack stackInSlot = tile.getStackHandler().getStackInSlot(0);
        if (stackInSlot.func_77973_b() == ModuleTechBloomery.Items.BLOOM) {
            for (int i = 0; i < 8; ++i) {
                world.func_175688_a(EnumParticleTypes.LAVA, (double)((float)tile.func_174877_v().func_177958_n() + hitX), (double)((float)tile.func_174877_v().func_177956_o() + hitY), (double)((float)tile.func_174877_v().func_177952_p() + hitZ), 0.0, 0.0, 0.0, new int[0]);
            }
        }
    }

    @Override
    public void onAnvilDurabilityExpired(World world, TileAnvilBase tile, float hitX, float hitY, float hitZ) {
        ItemStack bloomStack = tile.getStackHandler().getStackInSlot(0).func_77946_l();
        boolean isBloom = bloomStack.func_77973_b() instanceof BlockBloom.ItemBlockBloom;
        BlockPos pos = tile.func_174877_v();
        world.func_175655_b(pos, false);
        if (isBloom) {
            NBTTagCompound tagCompound = bloomStack.func_77978_p();
            if (tagCompound != null) {
                if (ModuleTechBloomery.Blocks.BLOOM.func_176196_c(world, pos)) {
                    if (!world.field_72995_K) {
                        world.func_175656_a(pos, ModuleTechBloomery.Blocks.BLOOM.func_176223_P());
                        TileBloom tileBloom = (TileBloom)world.func_175625_s(pos);
                        if (tileBloom != null) {
                            tileBloom.func_145839_a(tagCompound.func_74775_l("BlockEntityTag"));
                            tileBloom.func_174878_a(pos);
                            BlockHelper.notifyBlockUpdate((World)world, (BlockPos)pos);
                        }
                    }
                } else {
                    StackHelper.spawnStackOnTop((World)world, (ItemStack)bloomStack, (BlockPos)pos);
                }
            }
        } else {
            StackHelper.spawnStackOnTop((World)world, (ItemStack)bloomStack, (BlockPos)pos);
        }
    }
}

