/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.tech.bloomery.init.recipe;

import com.codetaylor.mc.athenaeum.parser.recipe.item.ParseResult;
import com.codetaylor.mc.athenaeum.parser.recipe.item.RecipeItemParser;
import com.codetaylor.mc.athenaeum.util.IngredientHelper;
import com.codetaylor.mc.pyrotech.modules.core.ModuleCore;
import com.codetaylor.mc.pyrotech.modules.core.block.BlockRock;
import com.codetaylor.mc.pyrotech.modules.core.init.CompatInitializerOre;
import com.codetaylor.mc.pyrotech.modules.tech.basic.recipe.AnvilRecipe;
import com.codetaylor.mc.pyrotech.modules.tech.bloomery.ModuleTechBloomery;
import com.codetaylor.mc.pyrotech.modules.tech.bloomery.ModuleTechBloomeryConfig;
import com.codetaylor.mc.pyrotech.modules.tech.bloomery.block.BlockPileSlag;
import com.codetaylor.mc.pyrotech.modules.tech.bloomery.init.SlagInitializer;
import com.codetaylor.mc.pyrotech.modules.tech.bloomery.item.ItemSlag;
import com.codetaylor.mc.pyrotech.modules.tech.bloomery.recipe.BloomAnvilRecipe;
import com.codetaylor.mc.pyrotech.modules.tech.bloomery.recipe.BloomeryRecipe;
import com.codetaylor.mc.pyrotech.modules.tech.bloomery.recipe.BloomeryRecipeBase;
import com.codetaylor.mc.pyrotech.modules.tech.bloomery.recipe.BloomeryRecipeBuilder;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.oredict.OreIngredient;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class BloomeryRecipesAdd {
    public static final int[] DEFAULT_BLOOM_YIELD_MIN_MAX = new int[]{12, 15};
    public static final int[] DEFAULT_SLAG_BLOOM_YIELD_MIN_MAX = new int[]{12, 15};
    private static final int DEFAULT_BURN_TIME_TICKS = 28800;
    private static final float DEFAULT_FAILURE_CHANCE = 0.25f;
    private static final float DEFAULT_EXPERIENCE = 0.25f;
    private static final RecipeItemParser RECIPE_ITEM_PARSER = new RecipeItemParser();

    public static void applyCompatRecipes(Path configurationPath, IForgeRegistry<BloomeryRecipe> registry) {
        CompatInitializerOre.OreCompatData data = CompatInitializerOre.read(configurationPath);
        if (data == null) {
            return;
        }
        for (Map.Entry<String, CompatInitializerOre.OreCompatEntry> entry : data.oredict.entrySet()) {
            int slagBloomYieldMax;
            int slagBloomYieldMin;
            int bloomYieldMax;
            int bloomYieldMin;
            String oreDictKey = entry.getKey();
            ItemSlag itemSlag = SlagInitializer.SLAG_BY_OREDICT.get(oreDictKey);
            BlockPileSlag blockPileSlag = SlagInitializer.SLAG_PILE_BY_OREDICT.get(oreDictKey);
            if (itemSlag == null || blockPileSlag == null) {
                ModuleTechBloomery.LOGGER.error(String.format("[%s] Missing slag for %s, SKIPPING", "pyrotech", oreDictKey));
                continue;
            }
            ItemSlag.Properties properties = ModuleTechBloomery.Items.GENERATED_SLAG.get((Object)itemSlag);
            String langKey = properties.langKey;
            CompatInitializerOre.OreCompatEntry oreCompatEntry = entry.getValue();
            ItemStack outputItemStack = BloomeryRecipesAdd.getFirstValidOutput(oreCompatEntry.output);
            if (outputItemStack.func_190926_b()) {
                ModuleTechBloomery.LOGGER.error(String.format("[%s] Missing valid output item for %s, SKIPPING", "pyrotech", oreDictKey));
                continue;
            }
            if (oreCompatEntry.bloomYieldMinMax == null || oreCompatEntry.bloomYieldMinMax.length != 2) {
                ModuleCore.LOGGER.error(String.format("Invalid value for key %s in oredict %s in file %s, expected integer array of length 2", "bloomYieldMinMax", oreDictKey, "core.compat.Ore-Custom.json"));
                bloomYieldMin = DEFAULT_BLOOM_YIELD_MIN_MAX[0];
                bloomYieldMax = DEFAULT_BLOOM_YIELD_MIN_MAX[1];
            } else {
                bloomYieldMin = oreCompatEntry.bloomYieldMinMax[0];
                bloomYieldMax = oreCompatEntry.bloomYieldMinMax[1];
            }
            if (oreCompatEntry.slagBloomYieldMinMax == null || oreCompatEntry.slagBloomYieldMinMax.length != 2) {
                ModuleCore.LOGGER.error(String.format("Invalid value for key %s in oredict %s in file %s, expected integer array of length 2", "slagBloomYieldMinMax", oreDictKey, "core.compat.Ore-Custom.json"));
                slagBloomYieldMin = DEFAULT_SLAG_BLOOM_YIELD_MIN_MAX[0];
                slagBloomYieldMax = DEFAULT_SLAG_BLOOM_YIELD_MIN_MAX[1];
            } else {
                slagBloomYieldMin = oreCompatEntry.slagBloomYieldMinMax[0];
                slagBloomYieldMax = oreCompatEntry.slagBloomYieldMinMax[1];
            }
            registry.register((IForgeRegistryEntry)((BloomeryRecipeBuilder)((BloomeryRecipeBuilder)((BloomeryRecipeBuilder)((BloomeryRecipeBuilder)((BloomeryRecipeBuilder)((BloomeryRecipeBuilder)((BloomeryRecipeBuilder)((BloomeryRecipeBuilder)new BloomeryRecipeBuilder(new ResourceLocation("pyrotech", "bloom_from_" + oreDictKey.toLowerCase()), outputItemStack.func_77946_l(), (Ingredient)new OreIngredient(oreDictKey)).setBurnTimeTicks(28800)).setExperience(0.25f)).setFailureChance(0.25f)).setBloomYield(bloomYieldMin, bloomYieldMax)).setSlagItem(new ItemStack((Item)itemSlag), 4)).addFailureItem(new ItemStack(ModuleTechBloomery.Items.SLAG), 1)).addFailureItem(new ItemStack((Item)itemSlag), 2)).setLangKey(langKey)).create());
            registry.register((IForgeRegistryEntry)((BloomeryRecipeBuilder)((BloomeryRecipeBuilder)((BloomeryRecipeBuilder)((BloomeryRecipeBuilder)((BloomeryRecipeBuilder)((BloomeryRecipeBuilder)((BloomeryRecipeBuilder)((BloomeryRecipeBuilder)new BloomeryRecipeBuilder(new ResourceLocation("pyrotech", "bloom_from_" + oreDictKey.toLowerCase() + "_slag"), outputItemStack.func_77946_l(), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack((Block)blockPileSlag)})).setBurnTimeTicks(14400)).setExperience(0.25f)).setFailureChance(0.25f)).setBloomYield(slagBloomYieldMin, slagBloomYieldMax)).setSlagItem(new ItemStack((Item)itemSlag), 2)).addFailureItem(new ItemStack((Block)ModuleCore.Blocks.ROCK, 1, BlockRock.EnumType.STONE.getMeta()), 1)).addFailureItem(new ItemStack(ModuleTechBloomery.Items.SLAG, 1, 0), 2)).setLangKey(langKey + ";" + itemSlag.func_77658_a() + ".unique")).create());
        }
    }

    private static ItemStack getFirstValidOutput(String[] outputs) {
        for (String itemString : outputs) {
            try {
                ParseResult parseResult = RECIPE_ITEM_PARSER.parse(itemString);
                Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(parseResult.getDomain(), parseResult.getPath()));
                if (item != null) {
                    return new ItemStack(item, 1, parseResult.getMeta());
                }
                ModuleTechBloomery.LOGGER.error(String.format("[%s] Unable to find registered item for %s", "pyrotech", itemString));
            }
            catch (Exception e) {
                ModuleTechBloomery.LOGGER.error(String.format("[%s] Invalid item string %s", "pyrotech", itemString));
            }
        }
        return ItemStack.field_190927_a;
    }

    public static void registerBloomAnvilRecipes(IForgeRegistry<BloomeryRecipe> registryBloomery, IForgeRegistry<AnvilRecipe> registryAnvil) {
        Collection bloomeryRecipes = registryBloomery.getValuesCollection();
        ArrayList snapshot = new ArrayList(bloomeryRecipes);
        for (BloomeryRecipeBase recipe : snapshot) {
            BloomeryRecipesAdd.registerBloomAnvilRecipe(registryAnvil, recipe);
        }
    }

    public static void registerBloomAnvilRecipe(IForgeRegistry<AnvilRecipe> registryAnvil, BloomeryRecipeBase<?> recipe) {
        ResourceLocation registryName = recipe.getRegistryName();
        if (registryName == null) {
            return;
        }
        registryAnvil.register(new BloomAnvilRecipe(recipe.getOutput(), (Ingredient)IngredientHelper.fromStackWithNBT((ItemStack)recipe.getOutputBloom()), ModuleTechBloomeryConfig.BLOOM.HAMMER_HITS_IN_ANVIL_REQUIRED, AnvilRecipe.EnumType.HAMMER, Arrays.copyOf(recipe.getAnvilTiers(), recipe.getAnvilTiers().length), recipe).setRegistryName(registryName));
    }
}

