/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.tech.basic.tile.spi;

import com.codetaylor.mc.athenaeum.interaction.api.Transform;
import com.codetaylor.mc.athenaeum.interaction.spi.IInteraction;
import com.codetaylor.mc.athenaeum.interaction.spi.ITileInteractable;
import com.codetaylor.mc.athenaeum.interaction.spi.InteractionItemStack;
import com.codetaylor.mc.athenaeum.interaction.spi.InteractionUseItemBase;
import com.codetaylor.mc.athenaeum.inventory.ObservableStackHandler;
import com.codetaylor.mc.athenaeum.network.tile.data.TileDataFloat;
import com.codetaylor.mc.athenaeum.network.tile.data.TileDataItemStackHandler;
import com.codetaylor.mc.athenaeum.network.tile.data.TileDataString;
import com.codetaylor.mc.athenaeum.network.tile.spi.ITileData;
import com.codetaylor.mc.athenaeum.network.tile.spi.ITileDataItemStackHandler;
import com.codetaylor.mc.athenaeum.network.tile.spi.TileEntityDataBase;
import com.codetaylor.mc.athenaeum.util.BlockHelper;
import com.codetaylor.mc.athenaeum.util.StackHelper;
import com.codetaylor.mc.pyrotech.library.util.Util;
import com.codetaylor.mc.pyrotech.modules.core.ModuleCore;
import com.codetaylor.mc.pyrotech.modules.core.network.SCPacketNoHunger;
import com.codetaylor.mc.pyrotech.modules.core.network.SCPacketParticleProgress;
import com.codetaylor.mc.pyrotech.modules.tech.basic.ModuleTechBasic;
import com.codetaylor.mc.pyrotech.modules.tech.basic.ModuleTechBasicConfig;
import com.codetaylor.mc.pyrotech.modules.tech.basic.block.spi.BlockAnvilBase;
import com.codetaylor.mc.pyrotech.modules.tech.basic.network.SCPacketParticleAnvilHit;
import com.codetaylor.mc.pyrotech.modules.tech.basic.recipe.AnvilRecipe;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public abstract class TileAnvilBase
extends TileEntityDataBase
implements ITileInteractable {
    private final TileDataItemStackHandler<InputStackHandler> tileDataItemStackHandler;
    private InputStackHandler stackHandler = new InputStackHandler(this);
    private TileDataFloat recipeProgress;
    private int durabilityUntilNextDamage;
    private IInteraction[] interactions;
    private AxisAlignedBB renderBounds;
    private AnvilRecipe recipe;
    private final TileDataString tileDataRecipeString;

    public TileAnvilBase() {
        super(ModuleTechBasic.TILE_DATA_SERVICE);
        this.stackHandler.addObserver((handler, slot) -> {
            this.recipeProgress.set(0.0f);
            this.func_70296_d();
        });
        this.recipeProgress = new TileDataFloat(0.0f);
        this.tileDataItemStackHandler = new TileDataItemStackHandler((ItemStackHandler)this.stackHandler);
        this.tileDataRecipeString = new TileDataString("");
        this.registerTileDataForNetwork(new ITileData[]{this.tileDataItemStackHandler, this.recipeProgress, this.tileDataRecipeString});
        this.interactions = new IInteraction[]{new InteractionItem(), new Interaction(this, (ItemStackHandler)this.stackHandler), new InteractionHit()};
        this.durabilityUntilNextDamage = this.getHitsPerDamage();
    }

    public boolean shouldRefresh(World world, BlockPos pos, @Nonnull IBlockState oldState, @Nonnull IBlockState newState) {
        if (oldState.func_177230_c() == newState.func_177230_c()) {
            return false;
        }
        return super.shouldRefresh(world, pos, oldState, newState);
    }

    @Nullable
    public AnvilRecipe getRecipe() {
        return this.recipe;
    }

    protected void setRecipe(AnvilRecipe recipe) {
        this.recipe = recipe;
        if (recipe == null) {
            this.tileDataRecipeString.set("");
        } else {
            ResourceLocation resourceLocation = recipe.getRegistryName();
            if (resourceLocation != null) {
                this.tileDataRecipeString.set(resourceLocation.toString());
            } else {
                this.tileDataRecipeString.set("");
            }
        }
    }

    public void setDamage(int damage) {
        this.field_145850_b.func_180501_a(this.field_174879_c, this.getBlock().func_176223_P().func_177226_a(BlockAnvilBase.DAMAGE, (Comparable)Integer.valueOf(damage)), 3);
    }

    public int getDamage() {
        return (Integer)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b(BlockAnvilBase.DAMAGE);
    }

    public void setDurabilityUntilNextDamage(int durabilityUntilNextDamage) {
        this.durabilityUntilNextDamage = durabilityUntilNextDamage;
        this.func_70296_d();
    }

    public int getDurabilityUntilNextDamage() {
        return this.durabilityUntilNextDamage;
    }

    public void setRecipeProgress(float recipeProgress) {
        this.recipeProgress.set(recipeProgress);
    }

    public float getRecipeProgress() {
        return this.recipeProgress.get();
    }

    public ItemStackHandler getStackHandler() {
        return this.stackHandler;
    }

    public abstract int getBloomAnvilExtraDamagePerHit();

    public abstract double getBloomAnvilExtraDamageChance();

    protected abstract int getHitsPerDamage();

    protected abstract double getExhaustionCostPerCraftComplete();

    protected abstract double getExhaustionCostPerHit();

    protected abstract int getMinimumHungerToUse();

    public abstract AnvilRecipe.EnumTier getRecipeTier();

    public abstract boolean useDurability();

    @Nonnull
    protected abstract BlockAnvilBase getBlock();

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return this.allowAutomation() && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (this.allowAutomation() && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)((Object)this.stackHandler);
        }
        return null;
    }

    protected abstract boolean allowAutomation();

    public void onTileDataUpdate() {
        if (this.tileDataItemStackHandler.isDirty()) {
            BlockHelper.notifyBlockUpdate((World)this.field_145850_b, (BlockPos)this.field_174879_c);
            this.field_145850_b.func_180500_c(EnumSkyBlock.BLOCK, this.field_174879_c);
        }
        if (this.tileDataRecipeString.isDirty()) {
            this.recipe = (AnvilRecipe)ModuleTechBasic.Registries.ANVIL_RECIPE.getValue(new ResourceLocation(this.tileDataRecipeString.get()));
        }
    }

    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74782_a("stackHandler", (NBTBase)this.stackHandler.serializeNBT());
        compound.func_74768_a("durabilityUntilNextDamage", this.durabilityUntilNextDamage);
        compound.func_74776_a("recipeProgress", this.recipeProgress.get());
        return compound;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.stackHandler.deserializeNBT(compound.func_74775_l("stackHandler"));
        this.durabilityUntilNextDamage = compound.func_74762_e("durabilityUntilNextDamage");
        this.recipeProgress.set(compound.func_74760_g("recipeProgress"));
    }

    @Nonnull
    public AxisAlignedBB getRenderBoundingBox() {
        if (this.renderBounds == null) {
            this.renderBounds = new AxisAlignedBB(this.func_174877_v()).func_72321_a(0.0, 0.5, 0.0);
        }
        return this.renderBounds;
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 0 || pass == 1;
    }

    public IInteraction[] getInteractions() {
        return this.interactions;
    }

    public List<ItemStack> doInteraction(ItemStack toolItemStack, @Nullable EntityPlayer player, float hitX, float hitY, float hitZ) {
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        if (this.field_145850_b.field_72995_K || this.stackHandler.getStackInSlot(0).func_190926_b() || toolItemStack.func_190926_b()) {
            return Collections.emptyList();
        }
        ItemStack inputItemStack = this.stackHandler.extractItem(0, this.stackHandler.getSlotLimit(0), true);
        AnvilRecipe.EnumType type = AnvilRecipe.getTypeFromItemStack(toolItemStack);
        AnvilRecipe recipe = AnvilRecipe.getRecipe(inputItemStack, this.getRecipeTier(), type);
        boolean isExtendedRecipe = recipe instanceof AnvilRecipe.IExtendedRecipe;
        if (recipe != this.getRecipe()) {
            this.setRecipeProgress(0.0f);
            this.setRecipe(recipe);
        }
        if (player != null && this.getExhaustionCostPerHit() > 0.0) {
            player.func_71020_j((float)this.getExhaustionCostPerHit());
        }
        if (this.useDurability() && this.getDurabilityUntilNextDamage() <= 1) {
            this.setDurabilityUntilNextDamage(this.getHitsPerDamage());
            if (this.getDamage() + 1 < 4) {
                this.setDamage(this.getDamage() + 1);
            } else {
                if (isExtendedRecipe) {
                    ((AnvilRecipe.IExtendedRecipe)((Object)recipe)).onAnvilDurabilityExpired(this.field_145850_b, this, hitX, hitY, hitZ);
                } else {
                    StackHelper.spawnStackHandlerContentsOnTop((World)this.field_145850_b, (ItemStackHandler)this.getStackHandler(), (BlockPos)this.func_174877_v());
                    this.field_145850_b.func_175655_b(this.func_174877_v(), false);
                }
                return Collections.emptyList();
            }
        }
        this.field_145850_b.func_184148_a(null, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), SoundEvents.field_187843_fX, SoundCategory.BLOCKS, 0.75f, (float)(1.0 + Util.RANDOM.nextGaussian() * (double)0.4f));
        if (recipe != null) {
            if (isExtendedRecipe) {
                ((AnvilRecipe.IExtendedRecipe)((Object)recipe)).applyDamage(this.field_145850_b, this);
            } else if (this.useDurability()) {
                this.setDurabilityUntilNextDamage(this.getDurabilityUntilNextDamage() - 1);
            }
            if (this.getRecipeProgress() < 1.0f) {
                Item item = toolItemStack.func_77973_b();
                int hitReduction = item.getToolClasses(toolItemStack).contains("pickaxe") ? item.getHarvestLevel(toolItemStack, "pickaxe", player, null) : ModuleTechBasicConfig.ANVIL_COMMON.getHammerHitReduction(item.getRegistryName());
                int hits = Math.max(1, recipe.getHits() - hitReduction);
                float recipeProgressIncrement = 1.0f / (float)hits;
                if (isExtendedRecipe) {
                    Vec3d hammerPos = player != null ? new Vec3d(player.field_70165_t, player.field_70163_u + (double)player.func_70047_e() * 0.5, player.field_70161_v) : new Vec3d((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p());
                    recipeProgressIncrement = ((AnvilRecipe.IExtendedRecipe)((Object)recipe)).getModifiedRecipeProgressIncrement(recipeProgressIncrement, this.field_174879_c, hammerPos, toolItemStack, player);
                }
                this.setRecipeProgress(this.getRecipeProgress() + recipeProgressIncrement);
                if (recipeProgressIncrement > 0.0f) {
                    ModuleCore.PACKET_SERVICE.sendToAllAround((IMessage)new SCPacketParticleProgress((double)this.field_174879_c.func_177958_n() + 0.5, this.field_174879_c.func_177956_o() + 1, (double)this.field_174879_c.func_177952_p() + 0.5, 2), this.field_145850_b.field_73011_w.getDimension(), this.field_174879_c);
                }
            }
            if ((double)this.getRecipeProgress() >= 0.9999) {
                if (isExtendedRecipe) {
                    result.addAll(((AnvilRecipe.IExtendedRecipe)((Object)recipe)).onRecipeCompleted(this, this.field_145850_b, (ItemStackHandler)this.stackHandler, recipe, toolItemStack));
                } else {
                    this.stackHandler.extractItem(0, this.stackHandler.getSlotLimit(0), false);
                    result.add(recipe.getOutput());
                }
                this.field_145850_b.func_184148_a(null, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), SoundEvents.field_187835_fT, SoundCategory.BLOCKS, 1.0f, (float)(1.0 + Util.RANDOM.nextGaussian() * (double)0.4f));
                if (player != null && this.getExhaustionCostPerCraftComplete() > 0.0) {
                    player.func_71020_j((float)this.getExhaustionCostPerCraftComplete());
                }
                this.setRecipe(null);
                this.func_70296_d();
                BlockHelper.notifyBlockUpdate((World)this.field_145850_b, (BlockPos)this.field_174879_c);
            }
            ModuleTechBasic.PACKET_SERVICE.sendToAllAround((IMessage)new SCPacketParticleAnvilHit(this.field_174879_c, hitX, hitY, hitZ), (TileEntity)this);
        }
        return result;
    }

    private class InputStackHandler
    extends ObservableStackHandler
    implements ITileDataItemStackHandler {
        private final TileAnvilBase tile;

        public InputStackHandler(TileAnvilBase tile) {
            super(1);
            this.tile = tile;
        }

        public int getSlotLimit(int slot) {
            return 1;
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            if (!stack.func_190926_b() && AnvilRecipe.hasRecipe(stack, this.tile.getRecipeTier())) {
                return super.insertItem(slot, stack, simulate);
            }
            return stack;
        }
    }

    private class InteractionHit
    extends InteractionUseItemBase<TileAnvilBase> {
        InteractionHit() {
            super(new EnumFacing[]{EnumFacing.UP}, BlockAnvilBase.AABB);
        }

        protected boolean allowInteraction(TileAnvilBase tile, World world, BlockPos hitPos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing hitSide, float hitX, float hitY, float hitZ) {
            if (player.func_71024_bL().func_75116_a() < tile.getMinimumHungerToUse()) {
                if (!world.field_72995_K) {
                    ModuleTechBasic.PACKET_SERVICE.sendTo((IMessage)new SCPacketNoHunger(), (EntityPlayerMP)player);
                }
                return false;
            }
            ItemStack heldItemStack = player.func_184586_b(hand);
            AnvilRecipe.EnumType type = AnvilRecipe.getTypeFromItemStack(heldItemStack);
            ItemStackHandler stackHandler = tile.getStackHandler();
            ItemStack itemStack = stackHandler.extractItem(0, stackHandler.getSlotLimit(0), true);
            AnvilRecipe recipe = AnvilRecipe.getRecipe(itemStack, tile.getRecipeTier(), type);
            return recipe != null;
        }

        protected boolean doInteraction(TileAnvilBase tile, World world, BlockPos hitPos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing hitSide, float hitX, float hitY, float hitZ) {
            if (!world.field_72995_K) {
                List<ItemStack> itemStackList = tile.doInteraction(player.func_184586_b(hand), player, hitX, hitY, hitZ);
                for (ItemStack itemStack : itemStackList) {
                    StackHelper.spawnStackOnTop((World)world, (ItemStack)itemStack, (BlockPos)hitPos, (double)0.0);
                }
            }
            return true;
        }
    }

    private class Interaction
    extends InteractionItemStack<TileAnvilBase> {
        private final TileAnvilBase tile;

        Interaction(TileAnvilBase tile, ItemStackHandler stackHandler) {
            super(new ItemStackHandler[]{stackHandler}, 0, new EnumFacing[]{EnumFacing.UP}, BlockAnvilBase.AABB, new Transform(Transform.translate((double)0.5, (double)0.75, (double)0.5), Transform.rotate(), Transform.scale((double)0.75, (double)0.75, (double)0.75)));
            this.tile = tile;
        }

        protected boolean doItemStackValidation(ItemStack itemStack) {
            return AnvilRecipe.hasRecipe(itemStack, this.tile.getRecipeTier());
        }

        protected void onInsert(IInteraction.EnumType type, ItemStack itemStack, World world, EntityPlayer player, BlockPos pos) {
            super.onInsert(type, itemStack, world, player, pos);
            if (!world.field_72995_K) {
                this.tile.setRecipe(null);
                world.func_184148_a(null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundEvents.field_187891_gV, SoundCategory.BLOCKS, 0.5f, (float)(1.0 + Util.RANDOM.nextGaussian() * (double)0.4f));
            }
        }

        protected void onExtract(IInteraction.EnumType type, World world, EntityPlayer player, BlockPos pos) {
            super.onExtract(type, world, player, pos);
            if (!world.field_72995_K) {
                this.tile.setRecipe(null);
            }
        }
    }

    private class InteractionItem
    extends InteractionUseItemBase<TileAnvilBase> {
        InteractionItem() {
            super(new EnumFacing[]{EnumFacing.UP}, BlockAnvilBase.AABB);
        }
    }
}

