/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.tech.basic.tile;

import com.codetaylor.mc.athenaeum.integration.gamestages.Stages;
import com.codetaylor.mc.athenaeum.interaction.api.Transform;
import com.codetaylor.mc.athenaeum.interaction.spi.IInteraction;
import com.codetaylor.mc.athenaeum.interaction.spi.ITileInteractable;
import com.codetaylor.mc.athenaeum.interaction.spi.InteractionItemStack;
import com.codetaylor.mc.athenaeum.inventory.ObservableStackHandler;
import com.codetaylor.mc.athenaeum.network.tile.data.TileDataFloat;
import com.codetaylor.mc.athenaeum.network.tile.data.TileDataItemStackHandler;
import com.codetaylor.mc.athenaeum.network.tile.spi.ITileData;
import com.codetaylor.mc.athenaeum.network.tile.spi.ITileDataItemStackHandler;
import com.codetaylor.mc.athenaeum.network.tile.spi.TileEntityDataBase;
import com.codetaylor.mc.athenaeum.util.ParticleHelper;
import com.codetaylor.mc.athenaeum.util.Properties;
import com.codetaylor.mc.pyrotech.modules.core.ModuleCoreConfig;
import com.codetaylor.mc.pyrotech.modules.tech.basic.ModuleTechBasic;
import com.codetaylor.mc.pyrotech.modules.tech.basic.ModuleTechBasicConfig;
import com.codetaylor.mc.pyrotech.modules.tech.basic.block.BlockTanningRack;
import com.codetaylor.mc.pyrotech.modules.tech.basic.recipe.TanningRackRecipe;
import java.util.function.BooleanSupplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.ItemStackHandler;

public class TileTanningRack
extends TileEntityDataBase
implements ITileInteractable,
ITickable {
    private final InputStackHandler inputStackHandler = new InputStackHandler();
    private final OutputStackHandler outputStackHandler = new OutputStackHandler();
    private final TileDataItemStackHandler<InputStackHandler> tileDataInputStackHandler;
    private final TileDataFloat recipeProgress;
    private final IInteraction<?>[] interactions;
    private TanningRackRecipe currentRecipe;
    private int rainTicks;

    public TileTanningRack() {
        super(ModuleTechBasic.TILE_DATA_SERVICE);
        this.inputStackHandler.addObserver((stackHandler, slotIndex) -> {
            this.rainTicks = 0;
            this.updateRecipe();
            this.func_70296_d();
        });
        this.outputStackHandler.addObserver((stackHandler, slotIndex) -> this.func_70296_d());
        this.tileDataInputStackHandler = new TileDataItemStackHandler((ItemStackHandler)this.inputStackHandler);
        this.recipeProgress = new TileDataFloat(0.0f);
        this.registerTileDataForNetwork(new ITileData[]{this.tileDataInputStackHandler, new TileDataItemStackHandler((ItemStackHandler)this.outputStackHandler), this.recipeProgress});
        this.interactions = new IInteraction[]{new InputInteraction((ItemStackHandler)this.inputStackHandler, () -> this.outputStackHandler.getStackInSlot(0).func_190926_b()), new OutputInteraction((ItemStackHandler)this.outputStackHandler)};
    }

    public InputStackHandler getInputStackHandler() {
        return this.inputStackHandler;
    }

    public OutputStackHandler getOutputStackHandler() {
        return this.outputStackHandler;
    }

    public float getRecipeProgress() {
        return this.recipeProgress.get();
    }

    public TanningRackRecipe getCurrentRecipe() {
        return this.currentRecipe;
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            if (ModuleCoreConfig.CLIENT.SHOW_RECIPE_PROGRESSION_PARTICLES && this.currentRecipe != null && this.field_145850_b.func_82737_E() % 40L == 0L && (ModuleTechBasicConfig.TANNING_RACK.RECIPE_RUIN_RAIN_TICKS < 0 || !this.field_145850_b.func_175727_C(this.field_174879_c.func_177984_a())) && this.field_145850_b.func_175678_i(this.field_174879_c) && this.field_145850_b.func_72820_D() % 24000L >= 0L && this.field_145850_b.func_72820_D() % 24000L <= 12000L) {
                ParticleHelper.spawnProgressParticlesClient((int)1, (double)((double)this.field_174879_c.func_177958_n() + 0.5), (double)((double)this.field_174879_c.func_177956_o() + 0.85), (double)((double)this.field_174879_c.func_177952_p() + 0.5), (double)0.5, (double)0.25, (double)0.5);
            }
            return;
        }
        if (this.currentRecipe != null && this.field_145850_b.func_175678_i(this.field_174879_c)) {
            if (ModuleTechBasicConfig.TANNING_RACK.RECIPE_RUIN_RAIN_TICKS >= 0 && this.field_145850_b.func_175727_C(this.field_174879_c.func_177984_a())) {
                if (this.currentRecipe.getRainFailureItem() != null) {
                    ++this.rainTicks;
                    if (this.rainTicks >= ModuleTechBasicConfig.TANNING_RACK.RECIPE_RUIN_RAIN_TICKS) {
                        this.outputStackHandler.setStackInSlot(0, this.currentRecipe.getRainFailureItem());
                        this.inputStackHandler.extractItem(0, 1, false);
                        this.recipeProgress.set(0.0f);
                        this.updateRecipe();
                    }
                }
            } else if (this.field_145850_b.func_72820_D() % 24000L >= 0L && this.field_145850_b.func_72820_D() % 24000L <= 12000L) {
                int timeTicks = Math.max(1, this.currentRecipe.getTimeTicks());
                float increment = 1.0f / (float)timeTicks;
                this.recipeProgress.add(increment);
                if ((double)this.recipeProgress.get() >= 0.9999) {
                    this.outputStackHandler.setStackInSlot(0, this.currentRecipe.getOutput());
                    this.inputStackHandler.extractItem(0, 1, false);
                    this.recipeProgress.set(0.0f);
                    this.updateRecipe();
                }
            }
        } else {
            this.recipeProgress.set(0.0f);
        }
    }

    private void updateRecipe() {
        ItemStack itemStack = this.inputStackHandler.getStackInSlot(0);
        this.currentRecipe = TanningRackRecipe.getRecipe(itemStack);
    }

    public void onTileDataUpdate() {
        if (this.tileDataInputStackHandler.isDirty()) {
            this.updateRecipe();
        }
    }

    public void func_145839_a(@Nonnull NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.inputStackHandler.deserializeNBT(compound.func_74775_l("inputStackHandler"));
        this.outputStackHandler.deserializeNBT(compound.func_74775_l("outputStackHandler"));
        this.recipeProgress.set(compound.func_74760_g("recipeProgress"));
        this.updateRecipe();
    }

    @Nonnull
    public NBTTagCompound func_189515_b(@Nonnull NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74782_a("inputStackHandler", (NBTBase)this.inputStackHandler.serializeNBT());
        compound.func_74782_a("outputStackHandler", (NBTBase)this.outputStackHandler.serializeNBT());
        compound.func_74776_a("recipeProgress", this.recipeProgress.get());
        return compound;
    }

    @Nullable
    public Stages getStages() {
        return ModuleTechBasicConfig.STAGES_TANNING_RACK;
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 0 || pass == 1;
    }

    public IInteraction<?>[] getInteractions() {
        return this.interactions;
    }

    public EnumFacing getTileFacing(World world, BlockPos pos, IBlockState blockState) {
        return (EnumFacing)blockState.func_177229_b((IProperty)Properties.FACING_HORIZONTAL);
    }

    public static class OutputStackHandler
    extends ObservableStackHandler
    implements ITileDataItemStackHandler {
        public OutputStackHandler() {
            super(1);
        }

        public int getSlotLimit(int slot) {
            return 1;
        }
    }

    public static class InputStackHandler
    extends ObservableStackHandler
    implements ITileDataItemStackHandler {
        public InputStackHandler() {
            super(1);
        }

        public int getSlotLimit(int slot) {
            return 1;
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return TanningRackRecipe.getRecipe(stack) != null;
        }
    }

    private static class OutputInteraction
    extends InteractionItemStack<TileTanningRack> {
        public OutputInteraction(ItemStackHandler stackHandler) {
            super(new ItemStackHandler[]{stackHandler}, 0, EnumFacing.field_82609_l, BlockTanningRack.AABB_NORTH_SOUTH, new Transform(Transform.translate((double)0.5, (double)0.525, (double)0.475), Transform.rotate((double)1.0, (double)0.0, (double)0.0, (double)22.5), Transform.scale((double)0.75, (double)0.75, (double)0.75)));
        }

        public boolean isItemStackValid(ItemStack itemStack) {
            return false;
        }
    }

    private static class InputInteraction
    extends InteractionItemStack<TileTanningRack> {
        private final BooleanSupplier isEnabled;

        public InputInteraction(ItemStackHandler stackHandler, BooleanSupplier isEnabled) {
            super(new ItemStackHandler[]{stackHandler}, 0, EnumFacing.field_82609_l, BlockTanningRack.AABB_NORTH_SOUTH, new Transform(Transform.translate((double)0.5, (double)0.525, (double)0.475), Transform.rotate((double)1.0, (double)0.0, (double)0.0, (double)22.5), Transform.scale((double)0.75, (double)0.75, (double)0.75)));
            this.isEnabled = isEnabled;
        }

        public boolean isItemStackValid(ItemStack itemStack) {
            return TanningRackRecipe.getRecipe(itemStack) != null;
        }

        public boolean isEnabled() {
            return this.isEnabled.getAsBoolean();
        }
    }
}

