/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.tech.basic.tile;

import com.codetaylor.mc.athenaeum.integration.gamestages.Stages;
import com.codetaylor.mc.athenaeum.interaction.api.Transform;
import com.codetaylor.mc.athenaeum.interaction.spi.IInteraction;
import com.codetaylor.mc.athenaeum.interaction.spi.ITileInteractable;
import com.codetaylor.mc.athenaeum.interaction.spi.InteractionBucketBase;
import com.codetaylor.mc.athenaeum.interaction.spi.InteractionItemStack;
import com.codetaylor.mc.athenaeum.interaction.spi.InteractionUseItemBase;
import com.codetaylor.mc.athenaeum.inventory.DynamicStackHandler;
import com.codetaylor.mc.athenaeum.inventory.ObservableFluidTank;
import com.codetaylor.mc.athenaeum.network.tile.data.TileDataFloat;
import com.codetaylor.mc.athenaeum.network.tile.data.TileDataFluidTank;
import com.codetaylor.mc.athenaeum.network.tile.data.TileDataInteger;
import com.codetaylor.mc.athenaeum.network.tile.data.TileDataItemStack;
import com.codetaylor.mc.athenaeum.network.tile.data.TileDataItemStackHandler;
import com.codetaylor.mc.athenaeum.network.tile.spi.ITileData;
import com.codetaylor.mc.athenaeum.network.tile.spi.ITileDataFluidTank;
import com.codetaylor.mc.athenaeum.network.tile.spi.TileDataBase;
import com.codetaylor.mc.athenaeum.network.tile.spi.TileEntityDataBase;
import com.codetaylor.mc.athenaeum.util.ArrayHelper;
import com.codetaylor.mc.athenaeum.util.BlockHelper;
import com.codetaylor.mc.athenaeum.util.ParticleHelper;
import com.codetaylor.mc.athenaeum.util.StackHelper;
import com.codetaylor.mc.pyrotech.library.CompostBinRecipeBase;
import com.codetaylor.mc.pyrotech.library.util.Util;
import com.codetaylor.mc.pyrotech.modules.core.ModuleCoreConfig;
import com.codetaylor.mc.pyrotech.modules.tech.basic.ModuleTechBasic;
import com.codetaylor.mc.pyrotech.modules.tech.basic.ModuleTechBasicConfig;
import com.codetaylor.mc.pyrotech.modules.tech.basic.block.BlockCompostBin;
import com.codetaylor.mc.pyrotech.modules.tech.basic.client.render.CompostBinInteractionInputRenderer;
import com.codetaylor.mc.pyrotech.modules.tech.basic.recipe.CompostBinRecipe;
import com.codetaylor.mc.pyrotech.modules.tech.basic.tile.TileSoakingPot;
import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileCompostBin
extends TileEntityDataBase
implements ITileInteractable,
ITickable {
    private static final int UPDATE_INTERVAL_TICKS = 20;
    private int updateIntervalCounter = 0;
    private final List<TileDataFloat> layerProgressList = new ArrayList<TileDataFloat>(this.getMaximumOutputItemCapacity());
    private final InputStackHandler inputStackHandler;
    private final OutputStackHandler outputStackHandler;
    private final TileDataItemStackHandler<?> tileDataInputStackHandler;
    private final TileDataItemStackHandler<?> tileDataOutputStackHandler;
    private final TileDataInteger storedCompostValue;
    private final InputFluidTank inputFluidTank;
    private final TileDataFluidTank<InputFluidTank> tileDataFluidTank;
    private final IInteraction<?>[] interactions;
    private final TileDataItemStack currentRecipeOutput;
    private final IntArrayList layerIndexToOutputIndex = new IntArrayList(this.getMaximumOutputItemCapacity());
    private double accumulatedEvaporation;

    public TileCompostBin() {
        super(ModuleTechBasic.TILE_DATA_SERVICE);
        int i;
        for (i = 0; i < this.getLayerCount(); ++i) {
            this.layerIndexToOutputIndex.add(i);
        }
        this.inputStackHandler = new InputStackHandler(this);
        this.inputStackHandler.addObserver((handler, slot) -> {
            this.updateRecipeOutput();
            this.checkCompostValueAndDrainTank();
            this.func_70296_d();
        });
        this.outputStackHandler = new OutputStackHandler(this.getMaximumOutputItemCapacity());
        this.outputStackHandler.addObserver((stackHandler, slotIndex) -> {
            this.updateRecipeOutput();
            this.checkCompostValueAndDrainTank();
            this.func_70296_d();
        });
        for (i = 0; i < this.getMaximumOutputItemCapacity(); ++i) {
            this.layerProgressList.add(new TileDataFloat(0.0f));
        }
        this.inputFluidTank = new InputFluidTank(1000, this);
        this.currentRecipeOutput = new TileDataItemStack(ItemStack.field_190927_a);
        this.tileDataInputStackHandler = new TileDataItemStackHandler((ItemStackHandler)this.inputStackHandler);
        this.tileDataOutputStackHandler = new TileDataItemStackHandler((ItemStackHandler)this.outputStackHandler);
        this.storedCompostValue = new TileDataInteger(0);
        this.tileDataFluidTank = new TileDataFluidTank((FluidTank)this.inputFluidTank);
        ArrayList<TileDataBase> tileDataList = new ArrayList<TileDataBase>(Arrays.asList(this.tileDataInputStackHandler, this.storedCompostValue, this.tileDataOutputStackHandler, this.tileDataFluidTank, this.currentRecipeOutput));
        tileDataList.addAll(this.layerProgressList);
        this.registerTileDataForNetwork(tileDataList.toArray(new ITileData[0]));
        this.interactions = new IInteraction[]{new InteractionInput(this, (ItemStackHandler)this.inputStackHandler), new InteractionShovel(), new InteractionInputFluid((FluidTank)this.inputFluidTank)};
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return this.allowAutomation() && (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY);
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (this.allowAutomation()) {
            if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
                return (T)((Object)this.inputStackHandler);
            }
            if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
                return (T)((Object)this.inputFluidTank);
            }
        }
        return null;
    }

    public void onTileDataUpdate() {
        if (this.tileDataOutputStackHandler.isDirty() || this.tileDataInputStackHandler.isDirty() || this.tileDataFluidTank.isDirty()) {
            BlockHelper.notifyBlockUpdate((World)this.field_145850_b, (BlockPos)this.field_174879_c);
        }
    }

    private void checkCompostValueAndDrainTank() {
        if (!this.field_145850_b.field_72995_K && this.getTotalCompostValue() == 0) {
            this.inputFluidTank.drainInternal(Integer.MAX_VALUE, true);
        }
    }

    public void func_73660_a() {
        int layerIndex;
        if (this.field_145850_b.field_72995_K) {
            if (ModuleCoreConfig.CLIENT.SHOW_RECIPE_PROGRESSION_PARTICLES && this.getMoistureLevel() > 0.0f && this.getLayerCountActive() - this.getLayerCountComplete() > 0 && this.field_145850_b.func_82737_E() % 20L == 0L) {
                ParticleHelper.spawnProgressParticlesClient((int)1, (double)((double)this.field_174879_c.func_177958_n() + 0.5), (double)((double)this.field_174879_c.func_177956_o() + 1.15), (double)((double)this.field_174879_c.func_177952_p() + 0.5), (double)0.5, (double)0.15, (double)0.5);
            }
            return;
        }
        --this.updateIntervalCounter;
        if (this.updateIntervalCounter > 0) {
            return;
        }
        this.updateIntervalCounter = 20;
        int totalCompostValue = this.getTotalCompostValue();
        if (totalCompostValue == 0) {
            this.inputFluidTank.drainInternal(Integer.MAX_VALUE, true);
        } else if (this.field_145850_b.func_175727_C(this.field_174879_c.func_177984_a())) {
            this.inputFluidTank.fill(new FluidStack(FluidRegistry.WATER, 20), true);
        } else if (this.getMoistureLevel() > 0.0f) {
            int mB = ModuleTechBasicConfig.COMPOST_BIN.MOISTURE_EVAPORATION_RATE_MILLIBUCKETS_PER_TICK[0];
            int tick = ModuleTechBasicConfig.COMPOST_BIN.MOISTURE_EVAPORATION_RATE_MILLIBUCKETS_PER_TICK[1];
            double moistureEvaporationRate = (double)mB / (double)tick * 20.0;
            this.accumulatedEvaporation += moistureEvaporationRate;
            while (this.accumulatedEvaporation >= 1.0) {
                this.accumulatedEvaporation -= 1.0;
                this.inputFluidTank.drainInternal(1, true);
            }
        } else {
            this.accumulatedEvaporation = 0.0;
        }
        int outputCompostValue = this.getOutputCompostValue();
        int activeLayerCount = this.getLayerCountActive();
        float increment = Math.min(1.0f, 1.0f / (float)ModuleTechBasicConfig.COMPOST_BIN.COMPOST_DURATION_TICKS * 20.0f);
        for (layerIndex = this.getLayerCount() - 1; layerIndex >= 0; --layerIndex) {
            if (!this.isLayerProgressComplete(layerIndex) || !this.isLayerOutputEmpty(layerIndex)) continue;
            TileDataFloat dataFloat = this.layerProgressList.remove(layerIndex);
            this.layerProgressList.add(dataFloat);
            dataFloat.set(0.0f);
            int outputIndex = this.layerIndexToOutputIndex.removeInt(layerIndex);
            this.layerIndexToOutputIndex.add(outputIndex);
        }
        for (layerIndex = 0; layerIndex < this.getLayerCount(); ++layerIndex) {
            TileDataFloat layerProgress = this.layerProgressList.get(layerIndex);
            if (this.isLayerProgressComplete(layerIndex)) continue;
            int activeLayersAbove = Math.max(0, activeLayerCount - layerIndex - 1);
            int requiredCompostValue = this.getLayerRequiredCompostValue(layerIndex);
            if (requiredCompostValue <= totalCompostValue) {
                if (this.getMoistureLevel() > 0.0f) {
                    float modifier = 1.0f + (float)((double)activeLayersAbove * ModuleTechBasicConfig.COMPOST_BIN.ADDITIVE_PERCENTILE_SPEED_MODIFIER_PER_LAYER);
                    layerProgress.add(increment * modifier);
                }
                if (layerProgress.get() > 1.0f) {
                    layerProgress.set(1.0f);
                }
                if (this.getStoredCompostValue() + outputCompostValue < requiredCompostValue && (double)layerProgress.get() > 0.3) {
                    ItemStack itemStack;
                    int sanity = 1000;
                    while (this.getStoredCompostValue() + outputCompostValue < requiredCompostValue && !(itemStack = this.inputStackHandler.extractItem(false)).func_190926_b()) {
                        int compostValue = this.getCompostValue(itemStack);
                        this.storedCompostValue.add(compostValue);
                        if (--sanity > 0) continue;
                        throw new RuntimeException("Exceeded safety threshold while converting input to stored compost value");
                    }
                }
                if (this.getStoredCompostValue() + outputCompostValue < requiredCompostValue || !this.isLayerProgressComplete(layerIndex)) continue;
                this.layerProgressList.get(layerIndex).set(1.0f);
                if (layerIndex > this.outputStackHandler.getSlots() || !this.isLayerOutputEmpty(layerIndex)) continue;
                this.storedCompostValue.add(-this.getCompostValueRequiredPerOutputItem());
                this.outputStackHandler.insertItem(this.getLayerOutputIndex(layerIndex), this.currentRecipeOutput.get().func_77946_l(), false);
                continue;
            }
            layerProgress.set(0.0f);
        }
    }

    private void updateRecipeOutput() {
        CompostBinRecipeBase<?> recipe;
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        ItemStack inputItemStack = this.inputStackHandler.getFirstNonEmptyItemStack();
        if (this.isEmpty()) {
            this.currentRecipeOutput.set(ItemStack.field_190927_a);
        } else if (!inputItemStack.func_190926_b() && this.currentRecipeOutput.get().func_190926_b() && (recipe = this.getRecipe(inputItemStack)) != null) {
            this.currentRecipeOutput.set(recipe.getOutput().func_77946_l());
        }
    }

    private boolean isItemValidForInsertion(ItemStack itemStack) {
        CompostBinRecipeBase<?> recipe = this.currentRecipeOutput.get().func_190926_b() ? this.getRecipe(itemStack) : this.getRecipe(itemStack, this.currentRecipeOutput.get());
        if (recipe == null) {
            return false;
        }
        return this.getTotalCompostValue() + this.getCompostValue(itemStack) <= this.getMaxCompostValueCapacity();
    }

    public int getLayerCountComplete() {
        int result = 0;
        for (int layerIndex = 0; layerIndex < this.getLayerCount(); ++layerIndex) {
            if (!this.isLayerProgressComplete(layerIndex)) continue;
            ++result;
        }
        return result;
    }

    public int getLayerCountActive() {
        int totalCompostValue = this.getTotalCompostValue();
        int result = 0;
        for (int layerIndex = 0; layerIndex < this.getLayerCount(); ++layerIndex) {
            int requiredCompostValue = this.getLayerRequiredCompostValue(layerIndex);
            if (requiredCompostValue > totalCompostValue) continue;
            ++result;
        }
        return result;
    }

    public int getLayerCount() {
        return this.getMaximumOutputItemCapacity();
    }

    public boolean isLayerProgressComplete(int layerIndex) {
        Preconditions.checkElementIndex((int)layerIndex, (int)this.getLayerCount());
        return (double)this.layerProgressList.get(layerIndex).get() > 0.9999;
    }

    public int getLayerOutputIndex(int layerIndex) {
        Preconditions.checkElementIndex((int)layerIndex, (int)this.getLayerCount());
        return this.layerIndexToOutputIndex.getInt(layerIndex);
    }

    public ItemStack getLayerOutputItemStack(int layerIndex) {
        Preconditions.checkElementIndex((int)layerIndex, (int)this.getLayerCount());
        return this.getOutputStackHandler().getStackInSlot(this.getLayerOutputIndex(layerIndex));
    }

    public boolean isLayerOutputEmpty(int layerIndex) {
        Preconditions.checkElementIndex((int)layerIndex, (int)this.getLayerCount());
        return this.getLayerOutputItemStack(layerIndex).func_190926_b();
    }

    public int getLayerRequiredCompostValue(int layerIndex) {
        Preconditions.checkElementIndex((int)layerIndex, (int)this.getLayerCount());
        return (layerIndex + 1) * this.getCompostValueRequiredPerOutputItem();
    }

    public boolean isEmpty() {
        return this.inputStackHandler.getTotalItemCount() == 0 && this.outputStackHandler.getTotalItemCount() == 0 && this.storedCompostValue.get() == 0;
    }

    public int getStoredCompostValue() {
        return this.storedCompostValue.get();
    }

    public float getMoistureLevel() {
        return (float)this.inputFluidTank.getFluidAmount() / 1000.0f;
    }

    public int getTotalCompostValue() {
        return this.getInputCompostValue() + this.getStoredCompostValue() + this.getOutputCompostValue();
    }

    public int getOutputCompostValue() {
        if (!this.currentRecipeOutput.get().func_190926_b()) {
            return this.outputStackHandler.getTotalItemCount() / this.currentRecipeOutput.get().func_190916_E() * this.getCompostValueRequiredPerOutputItem();
        }
        return 0;
    }

    public int getInputCompostValue() {
        int result = 0;
        for (int i = 0; i < this.inputStackHandler.getSlots(); ++i) {
            CompostBinRecipe recipe;
            ItemStack itemStack = this.inputStackHandler.getStackInSlot(i);
            if (itemStack.func_190926_b()) continue;
            if (this.currentRecipeOutput.get().func_190926_b()) {
                recipe = CompostBinRecipe.getRecipe(itemStack);
            } else {
                ItemStack output = this.currentRecipeOutput.get();
                recipe = CompostBinRecipe.getRecipe(itemStack, output);
            }
            if (recipe == null) continue;
            result += recipe.getCompostValue() * itemStack.func_190916_E();
        }
        return result;
    }

    public int getMaxCompostValueCapacity() {
        return this.getCompostValueRequiredPerOutputItem() * this.getMaximumOutputItemCapacity();
    }

    public int getCompostValue(ItemStack itemStack) {
        CompostBinRecipeBase<?> recipe = this.currentRecipeOutput.get().func_190926_b() ? this.getRecipe(itemStack) : this.getRecipe(itemStack, this.currentRecipeOutput.get());
        if (recipe == null) {
            return 0;
        }
        return recipe.getCompostValue();
    }

    public CompostBinRecipeBase<?> getRecipe(ItemStack itemStack) {
        return CompostBinRecipe.getRecipe(itemStack);
    }

    public CompostBinRecipeBase<?> getRecipe(ItemStack itemStack, ItemStack output) {
        return CompostBinRecipe.getRecipe(itemStack, output);
    }

    public float getMostCompleteActiveLayerProgress() {
        float result = 0.0f;
        List<TileDataFloat> progressList = this.layerProgressList;
        for (int layerIndex = 0; layerIndex < progressList.size(); ++layerIndex) {
            TileDataFloat tileDataFloat = progressList.get(layerIndex);
            if (!(tileDataFloat.get() > result) || this.isLayerProgressComplete(layerIndex)) continue;
            result = tileDataFloat.get();
        }
        return result;
    }

    public float[] getMostCompleteActiveLayerProgress(float[] result) {
        List<TileDataFloat> progressList = this.layerProgressList;
        block0: for (int layerIndex = 0; layerIndex < progressList.size(); ++layerIndex) {
            if (this.isLayerProgressComplete(layerIndex)) continue;
            TileDataFloat progressData = progressList.get(layerIndex);
            float progress = progressData.get();
            for (int i = 0; i < result.length; ++i) {
                if (!(progress > result[i])) continue;
                if (i != result.length - 1) {
                    for (int j = result.length - 1; j > i; --j) {
                        result[j] = result[j - 1];
                    }
                }
                result[i] = progress;
                continue block0;
            }
        }
        return result;
    }

    public float getLayerProgress(int layer) {
        return this.layerProgressList.get(layer).get();
    }

    public InputStackHandler getInputStackHandler() {
        return this.inputStackHandler;
    }

    public OutputStackHandler getOutputStackHandler() {
        return this.outputStackHandler;
    }

    public ItemStack getCurrentRecipeOutput() {
        return this.currentRecipeOutput.get();
    }

    protected boolean allowAutomation() {
        return ModuleTechBasicConfig.COMPOST_BIN.ALLOW_AUTOMATION;
    }

    protected String[] getShovelBlacklist() {
        return ModuleTechBasicConfig.COMPOST_BIN.SHOVEL_BLACKLIST;
    }

    protected String[] getShovelWhitelist() {
        return ModuleTechBasicConfig.COMPOST_BIN.SHOVEL_WHITELIST;
    }

    protected int getCompostValueRequiredPerOutputItem() {
        return ModuleTechBasicConfig.COMPOST_BIN.COMPOST_VALUE_REQUIRED_PER_OUTPUT_ITEM;
    }

    protected int getMaximumOutputItemCapacity() {
        return ModuleTechBasicConfig.COMPOST_BIN.MAXIMUM_OUTPUT_ITEM_CAPACITY;
    }

    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74782_a("inputStackHandler", (NBTBase)this.inputStackHandler.serializeNBT());
        compound.func_74782_a("inputFluidTank", (NBTBase)this.inputFluidTank.writeToNBT(new NBTTagCompound()));
        compound.func_74782_a("outputStackHandler", (NBTBase)this.outputStackHandler.serializeNBT());
        compound.func_74768_a("storedCompostValue", this.storedCompostValue.get());
        compound.func_74782_a("currentRecipeOutput", (NBTBase)this.currentRecipeOutput.get().serializeNBT());
        compound.func_74780_a("accumulatedEvaporation", this.accumulatedEvaporation);
        int[] recipeProgress = new int[this.getMaximumOutputItemCapacity()];
        for (int i = 0; i < this.getMaximumOutputItemCapacity(); ++i) {
            TileDataFloat data = this.layerProgressList.get(i);
            recipeProgress[i] = Float.floatToIntBits(data.get());
        }
        compound.func_74783_a("recipeProgress", recipeProgress);
        compound.func_74783_a("layerIndexToOutputIndex", this.layerIndexToOutputIndex.elements());
        return compound;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.inputStackHandler.deserializeNBT(compound.func_74775_l("inputStackHandler"));
        this.inputFluidTank.readFromNBT(compound.func_74775_l("inputFluidTank"));
        this.outputStackHandler.deserializeNBT(compound.func_74775_l("outputStackHandler"));
        this.storedCompostValue.set(compound.func_74762_e("storedCompostValue"));
        this.currentRecipeOutput.set(new ItemStack(compound.func_74775_l("currentRecipeOutput")));
        this.accumulatedEvaporation = compound.func_74769_h("accumulatedEvaporation");
        int[] intBitArray = compound.func_74759_k("recipeProgress");
        int capacity = Math.min(intBitArray.length, this.getMaximumOutputItemCapacity());
        for (int i = 0; i < capacity; ++i) {
            TileDataFloat data = this.layerProgressList.get(i);
            data.set(Float.intBitsToFloat(intBitArray[i]));
        }
        this.readIntArray(compound.func_74759_k("layerIndexToOutputIndex"), this.layerIndexToOutputIndex);
        this.updateRecipeOutput();
    }

    protected void func_190201_b(World world) {
        this.func_145834_a(world);
    }

    private IntArrayList readIntArray(int[] intArray, IntArrayList result) {
        for (int i = 0; i < intArray.length; ++i) {
            if (i == result.size()) {
                result.add(intArray[i]);
                continue;
            }
            result.set(i, intArray[i]);
        }
        return result;
    }

    private NBTTagIntArray writeIntArrayList(IntArrayList list) {
        return new NBTTagIntArray(list.toIntArray());
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 0 || pass == 1;
    }

    @Nullable
    public Stages getStages() {
        return ModuleTechBasicConfig.STAGES_COMPOST_BIN;
    }

    public IInteraction[] getInteractions() {
        return this.interactions;
    }

    public static class InputFluidTank
    extends ObservableFluidTank
    implements ITileDataFluidTank {
        private final TileCompostBin tile;

        public InputFluidTank(int capacity, TileCompostBin tile) {
            super(capacity);
            this.tile = tile;
        }

        public boolean canDrain() {
            return false;
        }

        public int fill(FluidStack resource, boolean doFill) {
            if (this.tile.getTotalCompostValue() > 0) {
                return super.fill(resource, doFill);
            }
            return 0;
        }

        public int fillInternal(FluidStack resource, boolean doFill) {
            FluidStack copy = resource.copy();
            copy.amount = Math.min(copy.amount, 1000);
            if (super.fillInternal(copy, doFill) > 0) {
                World world = this.tile.field_145850_b;
                if (!world.field_72995_K && !this.tile.field_145850_b.func_175727_C(this.tile.field_174879_c.func_177984_a())) {
                    for (EnumFacing facing : EnumFacing.field_176754_o) {
                        BlockPos offset = this.tile.field_174879_c.func_177972_a(facing);
                        IBlockState blockState = world.func_180495_p(offset);
                        Block block = blockState.func_177230_c();
                        if (!block.func_176200_f((IBlockAccess)world, offset)) continue;
                        world.func_180501_a(offset, Blocks.field_150358_i.func_176223_P().func_177226_a((IProperty)BlockLiquid.field_176367_b, (Comparable)Integer.valueOf(7)), 3);
                    }
                }
                return copy.amount;
            }
            return 0;
        }

        public boolean canFillFluidType(FluidStack fluid) {
            return fluid.getFluid() == FluidRegistry.WATER;
        }
    }

    public static class OutputStackHandler
    extends DynamicStackHandler {
        public OutputStackHandler(int initialSize) {
            super(initialSize);
        }

        @Nonnull
        public ItemStack getStackInSlot(int slot) {
            while (this.getSlots() - 1 < slot) {
                this.stacks.add((Object)ItemStack.field_190927_a);
            }
            return super.getStackInSlot(slot);
        }

        public ItemStack extractItemStack(boolean simulate) {
            for (int i = this.getSlots() - 1; i >= 0; --i) {
                if (this.getStackInSlot(i).func_190926_b()) continue;
                return this.extractItem(i, Integer.MAX_VALUE, simulate);
            }
            return ItemStack.field_190927_a;
        }
    }

    public class InputStackHandler
    extends DynamicStackHandler {
        private final TileCompostBin tile;

        InputStackHandler(TileCompostBin tile) {
            super(1);
            this.tile = tile;
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            if (!this.tile.isItemValidForInsertion(stack)) {
                return stack;
            }
            CompostBinRecipeBase<?> recipe = this.tile.getRecipe(stack);
            if (recipe == null) {
                return stack;
            }
            int compostValueTotal = this.tile.getTotalCompostValue();
            int compostValueMax = this.tile.getMaxCompostValueCapacity();
            int compostValueItem = this.tile.getCompostValue(stack);
            int compostValueItemTotal = compostValueItem * stack.func_190916_E();
            if (compostValueTotal >= compostValueMax) {
                return stack;
            }
            if (compostValueTotal + compostValueItemTotal <= compostValueMax) {
                this.insertItem(stack, simulate);
                return ItemStack.field_190927_a;
            }
            ItemStack toInsert = stack.func_77946_l();
            int emptyCompostValue = compostValueMax - compostValueTotal;
            int insertCount = emptyCompostValue / compostValueItem;
            if (insertCount > 0) {
                toInsert.func_190920_e(insertCount);
                this.insertItem(toInsert, simulate);
                ItemStack toReturn = stack.func_77946_l();
                toReturn.func_190920_e(toReturn.func_190916_E() - insertCount);
                return toReturn;
            }
            return stack;
        }

        public int removeItems(int amount) {
            int remaining = amount;
            for (int i = this.getSlots() - 1; i >= 0; --i) {
                if (this.getStackInSlot(i).func_190926_b() || (remaining -= super.extractItem(i, remaining, false).func_190916_E()) != 0) continue;
                return amount;
            }
            return amount - remaining;
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            for (int i = this.getSlots() - 1; i >= 0; --i) {
                if (this.getStackInSlot(i).func_190926_b()) continue;
                return super.extractItem(i, amount, simulate);
            }
            return ItemStack.field_190927_a;
        }

        public ItemStack extractItem(boolean simulate) {
            for (int i = this.getSlots() - 1; i >= 0; --i) {
                if (this.getStackInSlot(i).func_190926_b()) continue;
                return super.extractItem(i, 1, simulate);
            }
            return ItemStack.field_190927_a;
        }
    }

    public static class InteractionInputFluid
    extends InteractionBucketBase<TileSoakingPot> {
        private final FluidTank fluidTank;

        InteractionInputFluid(FluidTank fluidTank) {
            super((IFluidHandler)fluidTank, new EnumFacing[]{EnumFacing.UP}, BlockCompostBin.AABB);
            this.fluidTank = fluidTank;
        }

        public FluidTank getFluidTank() {
            return this.fluidTank;
        }
    }

    private class InteractionShovel
    extends InteractionUseItemBase<TileCompostBin> {
        InteractionShovel() {
            super(new EnumFacing[]{EnumFacing.UP}, BlockCompostBin.AABB);
        }

        protected boolean allowInteraction(TileCompostBin tile, World world, BlockPos hitPos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing hitSide, float hitX, float hitY, float hitZ) {
            if (tile.getOutputStackHandler().getTotalItemCount() == 0) {
                return false;
            }
            ItemStack heldItemStack = player.func_184586_b(hand);
            Item heldItem = heldItemStack.func_77973_b();
            ResourceLocation resourceLocation = heldItem.getRegistryName();
            if (resourceLocation == null) {
                return false;
            }
            if (tile.outputStackHandler.extractItemStack(true).func_190926_b()) {
                return false;
            }
            String registryName = resourceLocation.toString();
            if (heldItem.getToolClasses(heldItemStack).contains("shovel")) {
                return !ArrayHelper.contains((Object[])tile.getShovelBlacklist(), (Object)registryName);
            }
            return ArrayHelper.contains((Object[])tile.getShovelWhitelist(), (Object)registryName);
        }

        protected int getItemDamage(ItemStack itemStack) {
            return 1;
        }

        protected boolean doInteraction(TileCompostBin tile, World world, BlockPos hitPos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing hitSide, float hitX, float hitY, float hitZ) {
            if (!world.field_72995_K) {
                ItemStack itemStack = tile.outputStackHandler.extractItemStack(false);
                StackHelper.spawnStackOnTop((World)world, (ItemStack)itemStack, (BlockPos)hitPos, (double)1.0);
            }
            return true;
        }
    }

    public static class InteractionInput
    extends InteractionItemStack<TileCompostBin> {
        private final TileCompostBin tile;

        InteractionInput(TileCompostBin tile, ItemStackHandler stackHandler) {
            super(new ItemStackHandler[]{stackHandler}, 0, new EnumFacing[]{EnumFacing.UP}, BlockCompostBin.AABB, new Transform(Transform.translate((double)0.5, (double)1.0, (double)0.5), Transform.rotate(), Transform.scale((double)0.75, (double)0.75, (double)0.75)));
            this.tile = tile;
        }

        public TileCompostBin getTile() {
            return this.tile;
        }

        protected boolean doItemStackValidation(ItemStack itemStack) {
            return this.tile.isItemValidForInsertion(itemStack);
        }

        protected void onInsert(IInteraction.EnumType type, ItemStack itemStack, World world, EntityPlayer player, BlockPos pos) {
            super.onInsert(type, itemStack, world, player, pos);
            if (!world.field_72995_K && type == IInteraction.EnumType.MouseClick) {
                world.func_184148_a(null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundEvents.field_187891_gV, SoundCategory.BLOCKS, 0.5f, (float)(1.0 + Util.RANDOM.nextGaussian() * (double)0.4f));
            }
        }

        public void renderSolidPass(World world, RenderItem renderItem, BlockPos pos, IBlockState blockState, float partialTicks) {
        }

        public void renderSolidPassText(World world, FontRenderer fontRenderer, int yaw, Vec3d offset, BlockPos pos, IBlockState blockState, float partialTicks) {
        }

        public boolean renderAdditivePass(World world, RenderItem renderItem, EnumFacing hitSide, Vec3d hitVec, BlockPos hitPos, IBlockState blockState, ItemStack heldItemMainHand, float partialTicks) {
            return CompostBinInteractionInputRenderer.INSTANCE.renderAdditivePass(this, world, renderItem, hitSide, hitVec, hitPos, blockState, heldItemMainHand, partialTicks);
        }
    }
}

