/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.tech.basic.tile;

import com.codetaylor.mc.athenaeum.integration.gamestages.Stages;
import com.codetaylor.mc.athenaeum.interaction.api.InteractionBounds;
import com.codetaylor.mc.athenaeum.interaction.api.Transform;
import com.codetaylor.mc.athenaeum.interaction.spi.IInteraction;
import com.codetaylor.mc.athenaeum.interaction.spi.ITileInteractable;
import com.codetaylor.mc.athenaeum.interaction.spi.InteractionBucketBase;
import com.codetaylor.mc.athenaeum.interaction.spi.InteractionItemStack;
import com.codetaylor.mc.athenaeum.inventory.ObservableFluidTank;
import com.codetaylor.mc.athenaeum.inventory.ObservableStackHandler;
import com.codetaylor.mc.athenaeum.network.tile.data.TileDataFloat;
import com.codetaylor.mc.athenaeum.network.tile.data.TileDataFluidTank;
import com.codetaylor.mc.athenaeum.network.tile.data.TileDataItemStackHandler;
import com.codetaylor.mc.athenaeum.network.tile.spi.ITileData;
import com.codetaylor.mc.athenaeum.network.tile.spi.ITileDataFluidTank;
import com.codetaylor.mc.athenaeum.network.tile.spi.ITileDataItemStackHandler;
import com.codetaylor.mc.athenaeum.network.tile.spi.TileEntityDataBase;
import com.codetaylor.mc.athenaeum.util.AABBHelper;
import com.codetaylor.mc.athenaeum.util.ParticleHelper;
import com.codetaylor.mc.athenaeum.util.SoundHelper;
import com.codetaylor.mc.pyrotech.modules.core.ModuleCoreConfig;
import com.codetaylor.mc.pyrotech.modules.core.network.SCPacketParticleCombust;
import com.codetaylor.mc.pyrotech.modules.tech.basic.ModuleTechBasic;
import com.codetaylor.mc.pyrotech.modules.tech.basic.ModuleTechBasicConfig;
import com.codetaylor.mc.pyrotech.modules.tech.basic.block.BlockBarrel;
import com.codetaylor.mc.pyrotech.modules.tech.basic.client.render.BarrelFluidRenderer;
import com.codetaylor.mc.pyrotech.modules.tech.basic.recipe.BarrelRecipe;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileBarrel
extends TileEntityDataBase
implements ITileInteractable,
ITickable {
    private final InputFluidTank inputFluidTank = new InputFluidTank(this, 1000);
    private final InputStackHandler inputStackHandler = new InputStackHandler(this, 4);
    private final LidStackHandler lidStackHandler = new LidStackHandler();
    private final TileDataFluidTank<InputFluidTank> tileDataFluidTank;
    private final TileDataItemStackHandler<InputStackHandler> tileDataItemStackHandler;
    private final ItemStack[] inputItems;
    private final TileDataFloat recipeProgress = new TileDataFloat(0.0f);
    private BarrelRecipe currentRecipe;
    private int waterConversionTickCounter;
    private int waterFillTickCounter;
    private final IInteraction<?>[] interactions;

    public TileBarrel() {
        super(ModuleTechBasic.TILE_DATA_SERVICE);
        this.inputItems = new ItemStack[4];
        this.inputFluidTank.addObserver((fluidTank, amount) -> {
            this.func_70296_d();
            this.updateRecipe();
        });
        this.inputStackHandler.addObserver((stackHandler, slotIndex) -> {
            this.func_70296_d();
            this.updateRecipe();
        });
        this.lidStackHandler.addObserver((stackHandler, slotIndex) -> {
            this.func_70296_d();
            if (!this.field_145850_b.field_72995_K) {
                boolean hasLid;
                boolean bl = hasLid = !stackHandler.getStackInSlot(slotIndex).func_190926_b();
                if (hasLid) {
                    BlockBarrel.setState(true, this.field_145850_b, this.field_174879_c);
                } else {
                    this.recipeProgress.set(0.0f);
                    BlockBarrel.setState(false, this.field_145850_b, this.field_174879_c);
                }
            }
        });
        ITileData[] iTileDataArray = new ITileData[4];
        this.tileDataFluidTank = new TileDataFluidTank((FluidTank)this.inputFluidTank);
        iTileDataArray[0] = this.tileDataFluidTank;
        this.tileDataItemStackHandler = new TileDataItemStackHandler((ItemStackHandler)this.inputStackHandler);
        iTileDataArray[1] = this.tileDataItemStackHandler;
        iTileDataArray[2] = new TileDataItemStackHandler((ItemStackHandler)this.lidStackHandler);
        iTileDataArray[3] = this.recipeProgress;
        this.registerTileDataForNetwork(iTileDataArray);
        ArrayList<Object> interactionList = new ArrayList<Object>();
        interactionList.add((Object)new InteractionInputFluid(this, (FluidTank)this.inputFluidTank));
        interactionList.add((Object)new InteractionLid((ItemStackHandler)this.lidStackHandler));
        for (int slot = 0; slot < 4; ++slot) {
            int x = slot % 2;
            int z = slot / 2;
            interactionList.add((Object)new InteractionInputItem(this, (ItemStackHandler)this.inputStackHandler, slot, x, z));
        }
        this.interactions = interactionList.toArray(new IInteraction[0]);
    }

    public BarrelRecipe getCurrentRecipe() {
        return this.currentRecipe;
    }

    public InputFluidTank getInputFluidTank() {
        return this.inputFluidTank;
    }

    public InputStackHandler getInputStackHandler() {
        return this.inputStackHandler;
    }

    public LidStackHandler getLidStackHandler() {
        return this.lidStackHandler;
    }

    public float getRecipeProgress() {
        return this.recipeProgress.get();
    }

    protected int getHotFluidTemperature() {
        return 450;
    }

    protected boolean canHoldHotFluids() {
        return false;
    }

    protected boolean isSealed() {
        IBlockState blockState = this.field_145850_b.func_180495_p(this.field_174879_c);
        Block block = blockState.func_177230_c();
        return block == ModuleTechBasic.Blocks.BARREL_SEALED;
    }

    public void onTileDataUpdate() {
        if (this.tileDataFluidTank.isDirty() || this.tileDataItemStackHandler.isDirty()) {
            this.updateRecipe();
        }
    }

    public void func_73660_a() {
        if (!this.isSealed()) {
            if (this.field_145850_b.func_175727_C(this.field_174879_c.func_177984_a())) {
                if (ModuleTechBasicConfig.BARREL.RAIN_WATER_FILL_DURATION_TICKS > 0) {
                    ++this.waterFillTickCounter;
                    if (this.waterFillTickCounter >= ModuleTechBasicConfig.BARREL.RAIN_WATER_FILL_DURATION_TICKS) {
                        FluidStack fluid;
                        this.waterFillTickCounter = 0;
                        if (this.inputFluidTank.getFluidAmount() < 1000 && this.inputFluidTank.fill(fluid = new FluidStack(FluidRegistry.WATER, 5), false) > 0) {
                            this.inputFluidTank.fill(fluid, true);
                        }
                    }
                }
                if (ModuleTechBasicConfig.BARREL.RAIN_WATER_CONVERSION_DURATION_TICKS > 0) {
                    ++this.waterConversionTickCounter;
                    if (this.waterConversionTickCounter >= ModuleTechBasicConfig.BARREL.RAIN_WATER_CONVERSION_DURATION_TICKS) {
                        this.waterConversionTickCounter = 0;
                        FluidStack fluidStack = this.inputFluidTank.getFluid();
                        if (fluidStack != null && fluidStack.getFluid() != FluidRegistry.WATER) {
                            int fluidAmount = this.inputFluidTank.getFluidAmount();
                            this.inputFluidTank.drain(fluidAmount, true);
                            this.inputFluidTank.fill(new FluidStack(FluidRegistry.WATER, fluidAmount), true);
                        }
                    }
                }
            } else {
                this.waterConversionTickCounter = 0;
            }
            return;
        }
        this.waterConversionTickCounter = 0;
        if (this.field_145850_b.field_72995_K) {
            if (ModuleCoreConfig.CLIENT.SHOW_RECIPE_PROGRESSION_PARTICLES && this.currentRecipe != null && this.field_145850_b.func_82737_E() % 40L == 0L) {
                ParticleHelper.spawnProgressParticlesClient((int)1, (double)((double)this.field_174879_c.func_177958_n() + 0.5), (double)((double)this.field_174879_c.func_177956_o() + 1.25), (double)((double)this.field_174879_c.func_177952_p() + 0.5), (double)0.5, (double)0.25, (double)0.5);
            }
            return;
        }
        if (this.currentRecipe != null) {
            int timeTicks = Math.max(1, this.currentRecipe.getTimeTicks());
            float increment = 1.0f / (float)timeTicks;
            this.recipeProgress.add(increment);
            if ((double)this.recipeProgress.get() >= 0.9999) {
                BarrelRecipe currentRecipe = this.currentRecipe;
                for (int i = 0; i < this.inputStackHandler.getSlots(); ++i) {
                    this.inputStackHandler.extractItem(i, this.inputStackHandler.getSlotLimit(0), false);
                }
                if (!currentRecipe.getOutput().isFluidEqual(this.inputFluidTank.getFluid())) {
                    FluidStack outputCopy = currentRecipe.getOutput().copy();
                    this.inputFluidTank.drain(this.inputFluidTank.getFluidAmount(), true);
                    this.inputFluidTank.fillInternal(outputCopy, true);
                }
                this.recipeProgress.set(0.0f);
                this.updateRecipe();
            }
        } else {
            this.recipeProgress.set(0.0f);
        }
    }

    private void updateRecipe() {
        for (int i = 0; i < this.inputStackHandler.getSlots(); ++i) {
            this.inputItems[i] = this.inputStackHandler.getStackInSlot(i);
        }
        this.currentRecipe = BarrelRecipe.getRecipe(this.inputItems, this.inputFluidTank.getFluid());
    }

    public boolean shouldRefresh(World world, BlockPos pos, @Nonnull IBlockState oldState, @Nonnull IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        if (!this.allowAutomation() || facing != EnumFacing.UP || this.isSealed()) {
            return false;
        }
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (this.allowAutomation() && facing == EnumFacing.UP && !this.isSealed()) {
            if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
                return (T)((Object)this.inputStackHandler);
            }
            if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
                return (T)((Object)this.inputFluidTank);
            }
        }
        return null;
    }

    protected boolean allowAutomation() {
        return ModuleTechBasicConfig.BARREL.ALLOW_AUTOMATION;
    }

    @Nonnull
    public NBTTagCompound func_189515_b(@Nonnull NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74782_a("inputStackHandler", (NBTBase)this.inputStackHandler.serializeNBT());
        compound.func_74782_a("inputFluidTank", (NBTBase)this.inputFluidTank.writeToNBT(new NBTTagCompound()));
        compound.func_74782_a("lidStackHandler", (NBTBase)this.lidStackHandler.serializeNBT());
        compound.func_74776_a("recipeProgress", this.recipeProgress.get());
        return compound;
    }

    public void func_145839_a(@Nonnull NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.inputStackHandler.deserializeNBT(compound.func_74775_l("inputStackHandler"));
        this.inputFluidTank.readFromNBT(compound.func_74775_l("inputFluidTank"));
        this.lidStackHandler.deserializeNBT(compound.func_74775_l("lidStackHandler"));
        this.recipeProgress.set(compound.func_74760_g("recipeProgress"));
        this.updateRecipe();
    }

    public IInteraction<?>[] getInteractions() {
        return this.interactions;
    }

    @Nullable
    public Stages getStages() {
        return ModuleTechBasicConfig.STAGES_BARREL;
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 0 || pass == 1;
    }

    public static class InputFluidTank
    extends ObservableFluidTank
    implements ITileDataFluidTank {
        private final TileBarrel tile;

        InputFluidTank(TileBarrel tile, int capacity) {
            super(capacity);
            this.tile = tile;
        }

        public int fill(FluidStack resource, boolean doFill) {
            if (this.tile.isSealed()) {
                return 0;
            }
            return super.fill(resource, doFill);
        }

        public int fillInternal(FluidStack resource, boolean doFill) {
            int filled = super.fillInternal(resource, doFill);
            if (!this.tile.canHoldHotFluids()) {
                Fluid fluid;
                World world = this.tile.field_145850_b;
                BlockPos pos = this.tile.field_174879_c;
                if (resource != null && (fluid = resource.getFluid()).getTemperature(resource) >= this.tile.getHotFluidTemperature()) {
                    if (!world.field_72995_K) {
                        world.func_175698_g(pos);
                        SoundHelper.playSoundServer((World)world, (BlockPos)pos, (SoundEvent)SoundEvents.field_187635_cQ, (SoundCategory)SoundCategory.PLAYERS);
                        FluidUtil.tryPlaceFluid(null, (World)world, (BlockPos)pos, (IFluidHandler)this, (FluidStack)resource);
                        ModuleTechBasic.PACKET_SERVICE.sendToAllAround((IMessage)new SCPacketParticleCombust((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, 0.5, 0.5, 0.5), (TileEntity)this.tile);
                    }
                    world.func_180500_c(EnumSkyBlock.BLOCK, pos);
                }
            }
            return filled;
        }

        public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
            if (this.fluid != null) {
                this.fluid.writeToNBT(nbt);
            } else {
                nbt.func_74778_a("Empty", "");
            }
            return nbt;
        }

        public FluidTank readFromNBT(NBTTagCompound nbt) {
            if (nbt.func_74764_b("Empty") && (!nbt.func_74764_b("Amount") || nbt.func_74762_e("Amount") <= 0)) {
                this.setFluid(null);
                return this;
            }
            FluidStack fluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbt);
            this.setFluid(fluid);
            return this;
        }
    }

    public static class InputStackHandler
    extends ObservableStackHandler
    implements ITileDataItemStackHandler {
        private final TileBarrel tile;

        public InputStackHandler(@Nullable TileBarrel tile, int slots) {
            super(slots);
            this.tile = tile;
        }

        public int getSlotLimit(int slot) {
            return 1;
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            if (this.tile != null && this.tile.isSealed()) {
                return stack;
            }
            return super.insertItem(slot, stack, simulate);
        }
    }

    public static class LidStackHandler
    extends ObservableStackHandler
    implements ITileDataItemStackHandler {
        LidStackHandler() {
            super(1);
        }

        public int getSlotLimit(int slot) {
            return 1;
        }
    }

    public static class InteractionInputFluid
    extends InteractionBucketBase<TileBarrel> {
        private final TileBarrel tile;
        private final FluidTank fluidTank;

        InteractionInputFluid(TileBarrel tile, FluidTank fluidTank) {
            super((IFluidHandler)fluidTank, new EnumFacing[]{EnumFacing.UP}, InteractionBounds.BLOCK);
            this.tile = tile;
            this.fluidTank = fluidTank;
        }

        public FluidTank getFluidTank() {
            return this.fluidTank;
        }

        public boolean isEnabled() {
            return !this.tile.isSealed();
        }

        public void renderSolidPass(World world, RenderItem renderItem, BlockPos pos, IBlockState blockState, float partialTicks) {
            BarrelFluidRenderer.INSTANCE.renderSolidPass(this, world, renderItem, pos, blockState, partialTicks);
        }
    }

    private static class InteractionInputItem
    extends InteractionItemStack<TileBarrel> {
        private final TileBarrel tile;

        InteractionInputItem(TileBarrel tile, ItemStackHandler stackHandler, int slot, int x, int z) {
            super(new ItemStackHandler[]{stackHandler}, slot, new EnumFacing[]{EnumFacing.UP}, AABBHelper.create((double)(x == 0 ? 2.0 : 8.0), (double)12.0, (double)(z == 0 ? 2.0 : 8.0), (double)(x == 0 ? 8.0 : 14.0), (double)14.0, (double)(z == 0 ? 8.0 : 14.0)), new Transform(Transform.translate((double)(x == 0 ? 0.3125 : 0.6875), (double)0.875, (double)(z == 0 ? 0.3125 : 0.6875)), Transform.rotate(), Transform.scale((double)0.1875, (double)0.1875, (double)0.1875)));
            this.tile = tile;
        }

        protected boolean doItemStackValidation(ItemStack itemStack) {
            FluidStack fluid = this.tile.inputFluidTank.getFluid();
            if (fluid == null) {
                return false;
            }
            if (this.tile.inputStackHandler.insertItem(this.slot, itemStack, true).func_190916_E() == itemStack.func_190916_E()) {
                return false;
            }
            return BarrelRecipe.isValidItem(itemStack, fluid);
        }

        public boolean isEmpty() {
            return super.isEmpty();
        }

        public boolean isEnabled() {
            return !this.tile.isSealed();
        }

        public void renderSolidPass(World world, RenderItem renderItem, BlockPos pos, IBlockState blockState, float partialTicks) {
            if (!this.tile.isSealed()) {
                super.renderSolidPass(world, renderItem, pos, blockState, partialTicks);
            }
        }

        public boolean renderAdditivePass(World world, RenderItem renderItem, EnumFacing hitSide, Vec3d hitVec, BlockPos hitPos, IBlockState blockState, ItemStack heldItemMainHand, float partialTicks) {
            if (!this.tile.isSealed()) {
                return super.renderAdditivePass(world, renderItem, hitSide, hitVec, hitPos, blockState, heldItemMainHand, partialTicks);
            }
            return false;
        }
    }

    private static class InteractionLid
    extends InteractionItemStack<TileBarrel> {
        InteractionLid(ItemStackHandler stackHandler) {
            super(new ItemStackHandler[]{stackHandler}, 0, new EnumFacing[]{EnumFacing.UP}, InteractionBounds.BLOCK, new Transform(Transform.translate((double)0.5, (double)0.925, (double)0.5), Transform.rotate((double)1.0, (double)0.0, (double)0.0, (double)90.0), Transform.scale()));
        }

        public boolean isItemStackValid(ItemStack itemStack) {
            return itemStack.func_77973_b() == ModuleTechBasic.Items.BARREL_LID;
        }
    }
}

