/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.tech.basic.recipe;

import com.codetaylor.mc.athenaeum.recipe.IRecipeSingleOutput;
import com.codetaylor.mc.athenaeum.util.RecipeHelper;
import com.codetaylor.mc.pyrotech.library.spi.recipe.IRecipeTimed;
import com.codetaylor.mc.pyrotech.modules.tech.basic.ModuleTechBasic;
import com.codetaylor.mc.pyrotech.modules.tech.basic.ModuleTechBasicConfig;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class TanningRackRecipe
extends IForgeRegistryEntry.Impl<TanningRackRecipe>
implements IRecipeSingleOutput,
IRecipeTimed {
    private final ItemStack output;
    private final Ingredient inputItem;
    private final ItemStack rainFailureItem;
    private final int timeTicks;

    @Nullable
    public static TanningRackRecipe getRecipe(ItemStack inputItem) {
        if (inputItem.func_190926_b()) {
            return null;
        }
        for (TanningRackRecipe recipe : ModuleTechBasic.Registries.TANNING_RACK_RECIPE) {
            if (!recipe.matches(inputItem)) continue;
            return recipe;
        }
        return null;
    }

    public static boolean removeRecipes(Ingredient output) {
        return RecipeHelper.removeRecipesByOutput(ModuleTechBasic.Registries.TANNING_RACK_RECIPE, (Ingredient)output);
    }

    public TanningRackRecipe(ItemStack output, Ingredient inputItem, @Nullable ItemStack rainFailureItem, int timeTicks) {
        this.output = output;
        this.inputItem = inputItem;
        this.rainFailureItem = rainFailureItem;
        this.timeTicks = timeTicks;
    }

    public Ingredient getInputItem() {
        return this.inputItem;
    }

    public ItemStack getOutput() {
        return this.output.func_77946_l();
    }

    @Nullable
    public ItemStack getRainFailureItem() {
        if (this.rainFailureItem == null) {
            return null;
        }
        return this.rainFailureItem.func_77946_l();
    }

    @Override
    public int getTimeTicks() {
        return (int)Math.max(1.0, (double)this.timeTicks * ModuleTechBasicConfig.TANNING_RACK.BASE_RECIPE_DURATION_MODIFIER);
    }

    public boolean matches(ItemStack inputItem) {
        return this.inputItem.apply(inputItem);
    }
}

