/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.tech.basic.plugin.waila.provider;

import com.codetaylor.mc.pyrotech.library.spi.plugin.waila.BodyProviderAdapter;
import com.codetaylor.mc.pyrotech.library.util.Util;
import com.codetaylor.mc.pyrotech.library.util.plugin.waila.WailaUtil;
import com.codetaylor.mc.pyrotech.modules.tech.basic.ModuleTechBasic;
import com.codetaylor.mc.pyrotech.modules.tech.basic.plugin.waila.delegate.CompostBinProviderDelegate;
import com.codetaylor.mc.pyrotech.modules.tech.basic.tile.TileCompostBin;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.items.ItemStackHandler;

public class CompostBinProvider
extends BodyProviderAdapter
implements CompostBinProviderDelegate.ICompostBinDisplay {
    private final CompostBinProviderDelegate delegate = new CompostBinProviderDelegate(this);
    private List<String> tooltip;

    @Nonnull
    public List<String> getWailaBody(ItemStack itemStack, List<String> tooltip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        TileEntity tileEntity = accessor.getTileEntity();
        if (tileEntity instanceof TileCompostBin) {
            this.tooltip = tooltip;
            this.delegate.setPlayer((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
            this.delegate.display((TileCompostBin)tileEntity);
            this.tooltip = null;
        }
        return tooltip;
    }

    @Override
    public void setContents(ItemStackHandler inputStackHandler, ItemStack storedCompostValue, ItemStack outputStack) {
        StringBuilder renderString = new StringBuilder();
        for (int i = 0; i < inputStackHandler.getSlots(); ++i) {
            ItemStack stackInSlot = inputStackHandler.getStackInSlot(i);
            if (stackInSlot.func_190926_b()) continue;
            renderString.append(WailaUtil.getStackRenderString(stackInSlot));
        }
        if (!storedCompostValue.func_190926_b()) {
            renderString.append(WailaUtil.getStackRenderString(storedCompostValue));
        }
        if (!outputStack.func_190926_b()) {
            renderString.append(WailaUtil.getStackRenderString(outputStack));
        }
        this.tooltip.add(renderString.toString());
    }

    @Override
    public void setRecipeProgress(ItemStack output, int progress, int maxProgress) {
        String renderString = WailaUtil.getStackRenderString(new ItemStack((Block)ModuleTechBasic.Blocks.COMPOST_BIN)) + WailaUtil.getProgressRenderString(progress, maxProgress) + WailaUtil.getStackRenderString(output);
        this.tooltip.add(renderString);
    }

    @Override
    public void setMoistureLevel(@Nullable TextFormatting formatting, String langKey, int moistureLevel) {
        String formattingString = formatting != null ? formatting.toString() : "";
        this.tooltip.add(formattingString + Util.translateFormatted(langKey, moistureLevel));
    }
}

