/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.tech.basic.plugin.waila.delegate;

import com.codetaylor.mc.athenaeum.util.StringHelper;
import com.codetaylor.mc.pyrotech.library.waila.ProviderDelegateBase;
import com.codetaylor.mc.pyrotech.modules.tech.basic.ModuleTechBasicConfig;
import com.codetaylor.mc.pyrotech.modules.tech.basic.recipe.CampfireRecipe;
import com.codetaylor.mc.pyrotech.modules.tech.basic.tile.TileCampfire;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.ItemStackHandler;

public class CampfireProviderDelegate
extends ProviderDelegateBase<ICampfireDisplay, TileCampfire> {
    public CampfireProviderDelegate(ICampfireDisplay display) {
        super(display);
    }

    @Override
    public void display(TileCampfire tileCampfire) {
        String langKey;
        boolean hasOutput;
        float progress = tileCampfire.workerGetProgress(0);
        ItemStackHandler stackHandler = tileCampfire.getInputStackHandler();
        ItemStackHandler outputStackHandler = tileCampfire.getOutputStackHandler();
        ItemStack input = stackHandler.getStackInSlot(0);
        boolean bl = hasOutput = !outputStackHandler.getStackInSlot(0).func_190926_b();
        if (!input.func_190926_b()) {
            CampfireRecipe recipe = CampfireRecipe.getRecipe(input);
            if (recipe == null) {
                ((ICampfireDisplay)this.display).setRecipeInput(input);
            } else {
                ItemStack recipeOutput = recipe.getOutput();
                recipeOutput.func_190920_e(input.func_190916_E());
                ((ICampfireDisplay)this.display).setRecipeProgress(input, recipeOutput, (int)(100.0f * progress), 100);
            }
        } else if (hasOutput) {
            ItemStack output = outputStackHandler.getStackInSlot(0);
            ((ICampfireDisplay)this.display).setRecipeOutput(output);
        }
        int fuelRemaining = tileCampfire.getFuelRemaining();
        if (tileCampfire.workerIsActive() && tileCampfire.combustionGetBurnTimeRemaining() > 0) {
            langKey = "gui.pyrotech.waila.burn.time";
            String burnTime = StringHelper.ticksToHMS((int)(tileCampfire.combustionGetBurnTimeRemaining() + tileCampfire.getFuelRemaining() * ModuleTechBasicConfig.CAMPFIRE.BURN_TIME_TICKS_PER_LOG));
            ((ICampfireDisplay)this.display).setBurnTime(langKey, burnTime);
        }
        if (fuelRemaining > 0) {
            langKey = "gui.pyrotech.waila.campfire.fuel";
            ((ICampfireDisplay)this.display).setFuelRemaining(langKey, fuelRemaining, 8);
        }
        if (tileCampfire.getAshLevel() > 0) {
            langKey = "gui.pyrotech.waila.ash";
            int ashLevel = tileCampfire.getAshLevel();
            ((ICampfireDisplay)this.display).setAshLevel(langKey, ashLevel, 8);
        }
    }

    public static interface ICampfireDisplay {
        public void setRecipeInput(ItemStack var1);

        public void setRecipeProgress(ItemStack var1, ItemStack var2, int var3, int var4);

        public void setRecipeOutput(ItemStack var1);

        public void setBurnTime(String var1, String var2);

        public void setFuelRemaining(String var1, int var2, int var3);

        public void setAshLevel(String var1, int var2, int var3);
    }
}

