/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.tech.basic.plugin.jei.category;

import com.codetaylor.mc.pyrotech.library.spi.plugin.jei.PyrotechRecipeCategory;
import com.codetaylor.mc.pyrotech.modules.tech.basic.plugin.jei.wrapper.JEIRecipeWrapperCampfire;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.util.Translator;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;

public class JEIRecipeCategoryCampfire
extends PyrotechRecipeCategory<JEIRecipeWrapperCampfire> {
    public static final String UID = "pyrotech.campfire";
    private final IDrawableAnimated animatedFlame;
    private final IDrawableAnimated arrow;
    private final IDrawable background;
    private final String title;

    public JEIRecipeCategoryCampfire(IGuiHelper guiHelper) {
        ResourceLocation resourceLocation = new ResourceLocation("pyrotech", "textures/gui/jei2.png");
        IDrawableStatic arrowDrawable = guiHelper.createDrawable(resourceLocation, 82, 14, 24, 17);
        IDrawableStatic staticFlame = guiHelper.createDrawable(resourceLocation, 82, 0, 14, 14);
        IDrawableAnimated.StartDirection left = IDrawableAnimated.StartDirection.LEFT;
        IDrawableAnimated.StartDirection top = IDrawableAnimated.StartDirection.TOP;
        this.animatedFlame = guiHelper.createAnimatedDrawable(staticFlame, 300, top, true);
        this.arrow = guiHelper.createAnimatedDrawable(arrowDrawable, 200, left, false);
        this.background = guiHelper.createDrawable(resourceLocation, 0, 0, 82, 33);
        this.title = Translator.translateToLocal((String)"gui.pyrotech.jei.category.campfire");
    }

    @Nonnull
    public String getUid() {
        return UID;
    }

    @Nonnull
    public String getTitle() {
        return this.title;
    }

    @Nonnull
    public String getModName() {
        return "pyrotech";
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    public void drawExtras(Minecraft minecraft) {
        this.animatedFlame.draw(minecraft, 1, 19);
        this.arrow.draw(minecraft, 24, 10);
    }

    @Override
    @ParametersAreNonnullByDefault
    public void setRecipe(IRecipeLayout recipeLayout, JEIRecipeWrapperCampfire recipeWrapper, IIngredients ingredients) {
        super.setRecipe(recipeLayout, recipeWrapper, ingredients);
        IGuiItemStackGroup itemStacks = recipeLayout.getItemStacks();
        itemStacks.init(0, true, 0, 0);
        itemStacks.init(1, false, 60, 10);
        itemStacks.set(ingredients);
    }

    @Override
    protected int getOutputSlotIndex() {
        return 1;
    }
}

