/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.tech.basic.plugin.jei;

import com.codetaylor.mc.athenaeum.util.RecipeHelper;
import com.codetaylor.mc.pyrotech.library.CompostBinRecipeBase;
import com.codetaylor.mc.pyrotech.modules.tech.basic.ModuleTechBasic;
import com.codetaylor.mc.pyrotech.modules.tech.basic.ModuleTechBasicConfig;
import com.codetaylor.mc.pyrotech.modules.tech.basic.block.BlockDryingRack;
import com.codetaylor.mc.pyrotech.modules.tech.basic.plugin.jei.category.JEIRecipeCategoryAnvilGranite;
import com.codetaylor.mc.pyrotech.modules.tech.basic.plugin.jei.category.JEIRecipeCategoryAnvilIronclad;
import com.codetaylor.mc.pyrotech.modules.tech.basic.plugin.jei.category.JEIRecipeCategoryAnvilObsidian;
import com.codetaylor.mc.pyrotech.modules.tech.basic.plugin.jei.category.JEIRecipeCategoryBarrel;
import com.codetaylor.mc.pyrotech.modules.tech.basic.plugin.jei.category.JEIRecipeCategoryCampfire;
import com.codetaylor.mc.pyrotech.modules.tech.basic.plugin.jei.category.JEIRecipeCategoryChoppingBlock;
import com.codetaylor.mc.pyrotech.modules.tech.basic.plugin.jei.category.JEIRecipeCategoryCompactingBin;
import com.codetaylor.mc.pyrotech.modules.tech.basic.plugin.jei.category.JEIRecipeCategoryCompostBin;
import com.codetaylor.mc.pyrotech.modules.tech.basic.plugin.jei.category.JEIRecipeCategoryCrudeDryingRack;
import com.codetaylor.mc.pyrotech.modules.tech.basic.plugin.jei.category.JEIRecipeCategoryDryingRack;
import com.codetaylor.mc.pyrotech.modules.tech.basic.plugin.jei.category.JEIRecipeCategoryKilnPit;
import com.codetaylor.mc.pyrotech.modules.tech.basic.plugin.jei.category.JEIRecipeCategorySoakingPot;
import com.codetaylor.mc.pyrotech.modules.tech.basic.plugin.jei.category.JEIRecipeCategoryTanningRack;
import com.codetaylor.mc.pyrotech.modules.tech.basic.plugin.jei.category.JEIRecipeCategoryWorktable;
import com.codetaylor.mc.pyrotech.modules.tech.basic.plugin.jei.wrapper.JEIRecipeWrapperAnvil;
import com.codetaylor.mc.pyrotech.modules.tech.basic.plugin.jei.wrapper.JEIRecipeWrapperBarrel;
import com.codetaylor.mc.pyrotech.modules.tech.basic.plugin.jei.wrapper.JEIRecipeWrapperCampfire;
import com.codetaylor.mc.pyrotech.modules.tech.basic.plugin.jei.wrapper.JEIRecipeWrapperChoppingBlock;
import com.codetaylor.mc.pyrotech.modules.tech.basic.plugin.jei.wrapper.JEIRecipeWrapperCompactingBin;
import com.codetaylor.mc.pyrotech.modules.tech.basic.plugin.jei.wrapper.JEIRecipeWrapperCompostBin;
import com.codetaylor.mc.pyrotech.modules.tech.basic.plugin.jei.wrapper.JEIRecipeWrapperCrudeDryingRack;
import com.codetaylor.mc.pyrotech.modules.tech.basic.plugin.jei.wrapper.JEIRecipeWrapperDryingRack;
import com.codetaylor.mc.pyrotech.modules.tech.basic.plugin.jei.wrapper.JEIRecipeWrapperKilnPit;
import com.codetaylor.mc.pyrotech.modules.tech.basic.plugin.jei.wrapper.JEIRecipeWrapperSoakingPot;
import com.codetaylor.mc.pyrotech.modules.tech.basic.plugin.jei.wrapper.JEIRecipeWrapperTanningRack;
import com.codetaylor.mc.pyrotech.modules.tech.basic.plugin.jei.wrapper.JEIRecipeWrapperWorktableShaped;
import com.codetaylor.mc.pyrotech.modules.tech.basic.plugin.jei.wrapper.JEIRecipeWrapperWorktableShapeless;
import com.codetaylor.mc.pyrotech.modules.tech.basic.recipe.AnvilRecipe;
import com.codetaylor.mc.pyrotech.modules.tech.basic.recipe.BarrelRecipe;
import com.codetaylor.mc.pyrotech.modules.tech.basic.recipe.CampfireRecipe;
import com.codetaylor.mc.pyrotech.modules.tech.basic.recipe.ChoppingBlockRecipe;
import com.codetaylor.mc.pyrotech.modules.tech.basic.recipe.CompactingBinRecipe;
import com.codetaylor.mc.pyrotech.modules.tech.basic.recipe.CompostBinRecipe;
import com.codetaylor.mc.pyrotech.modules.tech.basic.recipe.CrudeDryingRackRecipe;
import com.codetaylor.mc.pyrotech.modules.tech.basic.recipe.DryingRackRecipe;
import com.codetaylor.mc.pyrotech.modules.tech.basic.recipe.KilnPitRecipe;
import com.codetaylor.mc.pyrotech.modules.tech.basic.recipe.SoakingPotRecipe;
import com.codetaylor.mc.pyrotech.modules.tech.basic.recipe.TanningRackRecipe;
import com.codetaylor.mc.pyrotech.modules.tech.basic.recipe.WorktableRecipe;
import crafttweaker.mc1120.recipes.MCRecipeBase;
import crafttweaker.mc1120.recipes.MCRecipeShaped;
import crafttweaker.mc1120.recipes.MCRecipeShapeless;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.IJeiRuntime;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.IRecipeRegistry;
import mezz.jei.api.ingredients.IIngredientBlacklist;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategoryRegistration;
import mezz.jei.api.recipe.IRecipeWrapper;
import mezz.jei.api.recipe.IRecipeWrapperFactory;
import mezz.jei.api.recipe.wrapper.IShapedCraftingRecipeWrapper;
import mezz.jei.plugins.vanilla.crafting.CraftingRecipeChecker;
import mezz.jei.plugins.vanilla.crafting.ShapedOreRecipeWrapper;
import mezz.jei.plugins.vanilla.crafting.ShapedRecipesWrapper;
import mezz.jei.plugins.vanilla.crafting.ShapelessRecipeWrapper;
import mezz.jei.plugins.vanilla.crafting.TippedArrowRecipeMaker;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.IShapedRecipe;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import org.apache.commons.lang3.tuple.Pair;

public class PluginJEI
implements IModPlugin {
    public static IRecipeRegistry RECIPE_REGISTRY;

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
        RECIPE_REGISTRY = jeiRuntime.getRecipeRegistry();
        this.hideRecipes();
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        IJeiHelpers jeiHelpers = registry.getJeiHelpers();
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        registry.addRecipeCategories(new IRecipeCategory[]{new JEIRecipeCategoryKilnPit(guiHelper), new JEIRecipeCategoryCrudeDryingRack(guiHelper), new JEIRecipeCategoryDryingRack(guiHelper), new JEIRecipeCategoryChoppingBlock(guiHelper), new JEIRecipeCategoryAnvilGranite(guiHelper), new JEIRecipeCategoryAnvilIronclad(guiHelper), new JEIRecipeCategoryAnvilObsidian(guiHelper), new JEIRecipeCategoryCompactingBin(guiHelper), new JEIRecipeCategoryCampfire(guiHelper), new JEIRecipeCategoryWorktable(guiHelper), new JEIRecipeCategorySoakingPot(guiHelper), new JEIRecipeCategoryCompostBin(guiHelper), new JEIRecipeCategoryBarrel(guiHelper), new JEIRecipeCategoryTanningRack(guiHelper)});
    }

    public void register(IModRegistry registry) {
        IJeiHelpers jeiHelpers = registry.getJeiHelpers();
        IIngredientBlacklist ingredientBlacklist = jeiHelpers.getIngredientBlacklist();
        ingredientBlacklist.addIngredientToBlacklist((Object)new ItemStack((Item)ModuleTechBasic.Items.MARSHMALLOW_STICK));
        ingredientBlacklist.addIngredientToBlacklist((Object)new ItemStack((Block)ModuleTechBasic.Blocks.BARREL_SEALED));
        registry.addIngredientInfo((Object)new ItemStack((Block)ModuleTechBasic.Blocks.KILN_PIT), ItemStack.class, new String[]{"gui.pyrotech.jei.info.pit.kiln"});
        registry.addIngredientInfo((Object)new ItemStack((Block)ModuleTechBasic.Blocks.CAMPFIRE), VanillaTypes.ITEM, new String[]{"gui.pyrotech.jei.info.campfire"});
        registry.addRecipeCatalyst((Object)new ItemStack((Block)ModuleTechBasic.Blocks.WORKTABLE), new String[]{"pyrotech.worktable"});
        registry.addRecipeCatalyst((Object)new ItemStack((Block)ModuleTechBasic.Blocks.WORKTABLE_STONE), new String[]{"pyrotech.worktable"});
        registry.handleRecipes(ShapedOreRecipe.class, recipe -> new ShapedOreRecipeWrapper(jeiHelpers, recipe), "pyrotech.worktable");
        registry.handleRecipes(ShapedRecipes.class, recipe -> new ShapedRecipesWrapper(jeiHelpers, recipe), "pyrotech.worktable");
        registry.handleRecipes(ShapelessOreRecipe.class, recipe -> new ShapelessRecipeWrapper(jeiHelpers, (IRecipe)recipe), "pyrotech.worktable");
        registry.handleRecipes(ShapelessRecipes.class, recipe -> new ShapelessRecipeWrapper(jeiHelpers, (IRecipe)recipe), "pyrotech.worktable");
        registry.handleRecipes(WorktableRecipe.class, (IRecipeWrapperFactory)new WorktableRecipeFactory(jeiHelpers), "pyrotech.worktable");
        if (Loader.isModLoaded((String)"crafttweaker")) {
            registry.handleRecipes(MCRecipeShapeless.class, recipe -> new ShapelessRecipeWrapper(jeiHelpers, (IRecipe)recipe), "pyrotech.worktable");
            registry.handleRecipes(MCRecipeShaped.class, CraftingRecipeWrapperShaped::new, "pyrotech.worktable");
        }
        List vanillaRecipes = this.getValidRecipeList(jeiHelpers).stream().filter(recipe -> {
            ResourceLocation resourceLocation = recipe.getRegistryName();
            if (Loader.isModLoaded((String)"crafttweaker") && recipe instanceof MCRecipeBase) {
                if (!((MCRecipeBase)recipe).isVisible()) {
                    return false;
                }
                ((MCRecipeBase)recipe).update();
            }
            if (WorktableRecipe.hasWhitelist()) {
                return WorktableRecipe.isWhitelisted(resourceLocation);
            }
            if (WorktableRecipe.hasBlacklist()) {
                return !WorktableRecipe.isBlacklisted(resourceLocation);
            }
            return true;
        }).collect(Collectors.toList());
        registry.addRecipes(vanillaRecipes, "pyrotech.worktable");
        ResourceLocation resourceLocation = new ResourceLocation("minecraft:tipped_arrow");
        if (WorktableRecipe.hasWhitelist()) {
            if (WorktableRecipe.isWhitelisted(resourceLocation)) {
                registry.addRecipes((Collection)TippedArrowRecipeMaker.getTippedArrowRecipes(), "pyrotech.worktable");
            }
        } else if (WorktableRecipe.hasBlacklist()) {
            if (!WorktableRecipe.isBlacklisted(resourceLocation)) {
                registry.addRecipes((Collection)TippedArrowRecipeMaker.getTippedArrowRecipes(), "pyrotech.worktable");
            }
        } else {
            registry.addRecipes((Collection)TippedArrowRecipeMaker.getTippedArrowRecipes(), "pyrotech.worktable");
        }
        ArrayList<JEIRecipeWrapperCompostBin> recipeList = new ArrayList(ModuleTechBasic.Registries.WORKTABLE_RECIPE.getValuesCollection());
        registry.addRecipes(recipeList, "pyrotech.worktable");
        registry.addRecipeCatalyst((Object)new ItemStack((Block)ModuleTechBasic.Blocks.CAMPFIRE), new String[]{"pyrotech.campfire"});
        registry.handleRecipes(CampfireRecipe.class, JEIRecipeWrapperCampfire::new, "pyrotech.campfire");
        List<JEIRecipeWrapperCampfire> furnaceRecipes = PluginJEI.getFurnaceRecipesForCampfire(input -> {
            ItemStack output = FurnaceRecipes.func_77602_a().func_151395_a(input);
            if (output.func_190926_b()) {
                return false;
            }
            if (CampfireRecipe.hasWhitelist()) {
                return CampfireRecipe.isWhitelisted(output);
            }
            if (CampfireRecipe.hasBlacklist()) {
                return !CampfireRecipe.isBlacklisted(output) && RecipeHelper.hasFurnaceFoodRecipe((ItemStack)input);
            }
            return RecipeHelper.hasFurnaceFoodRecipe((ItemStack)input);
        });
        registry.addRecipes(furnaceRecipes, "pyrotech.campfire");
        ArrayList recipeList2 = new ArrayList(ModuleTechBasic.Registries.CAMPFIRE_RECIPE.getValuesCollection());
        registry.addRecipes(recipeList2, "pyrotech.campfire");
        registry.addRecipeCatalyst((Object)new ItemStack((Block)ModuleTechBasic.Blocks.SOAKING_POT), new String[]{"pyrotech.soaking.pot"});
        registry.handleRecipes(SoakingPotRecipe.class, JEIRecipeWrapperSoakingPot::new, "pyrotech.soaking.pot");
        List<Object> recipeList3 = new ArrayList(ModuleTechBasic.Registries.SOAKING_POT_RECIPE.getValuesCollection());
        registry.addRecipes(recipeList3, "pyrotech.soaking.pot");
        registry.addRecipeCatalyst((Object)new ItemStack((Block)ModuleTechBasic.Blocks.COMPACTING_BIN), new String[]{"pyrotech.compacting.bin"});
        registry.handleRecipes(CompactingBinRecipe.class, JEIRecipeWrapperCompactingBin::new, "pyrotech.compacting.bin");
        recipeList3 = new ArrayList(ModuleTechBasic.Registries.COMPACTING_BIN_RECIPE.getValuesCollection());
        registry.addRecipes(recipeList3, "pyrotech.compacting.bin");
        registry.addRecipeCatalyst((Object)new ItemStack((Block)ModuleTechBasic.Blocks.ANVIL_GRANITE), new String[]{"pyrotech.anvil.granite"});
        registry.handleRecipes(AnvilRecipe.class, JEIRecipeWrapperAnvil::new, "pyrotech.anvil.granite");
        recipeList3 = ModuleTechBasic.Registries.ANVIL_RECIPE.getValuesCollection().stream().filter(anvilRecipe -> anvilRecipe.isTier(AnvilRecipe.EnumTier.GRANITE)).collect(Collectors.toList());
        registry.addRecipes(recipeList3, "pyrotech.anvil.granite");
        registry.addRecipeCatalyst((Object)new ItemStack((Block)ModuleTechBasic.Blocks.ANVIL_IRON_PLATED), new String[]{"pyrotech.anvil.ironclad"});
        registry.handleRecipes(AnvilRecipe.class, JEIRecipeWrapperAnvil::new, "pyrotech.anvil.ironclad");
        recipeList3 = ModuleTechBasic.Registries.ANVIL_RECIPE.getValuesCollection().stream().filter(anvilRecipe -> anvilRecipe.isTier(AnvilRecipe.EnumTier.IRONCLAD)).collect(Collectors.toList());
        registry.addRecipes(recipeList3, "pyrotech.anvil.ironclad");
        registry.addRecipeCatalyst((Object)new ItemStack((Block)ModuleTechBasic.Blocks.ANVIL_OBSIDIAN), new String[]{"pyrotech.anvil.obsidian"});
        registry.handleRecipes(AnvilRecipe.class, JEIRecipeWrapperAnvil::new, "pyrotech.anvil.obsidian");
        recipeList3 = ModuleTechBasic.Registries.ANVIL_RECIPE.getValuesCollection().stream().filter(anvilRecipe -> anvilRecipe.isTier(AnvilRecipe.EnumTier.OBSIDIAN)).collect(Collectors.toList());
        registry.addRecipes(recipeList3, "pyrotech.anvil.obsidian");
        registry.addRecipeCatalyst((Object)new ItemStack((Block)ModuleTechBasic.Blocks.CHOPPING_BLOCK), new String[]{"pyrotech.chopping"});
        registry.handleRecipes(ChoppingBlockRecipe.class, JEIRecipeWrapperChoppingBlock::new, "pyrotech.chopping");
        recipeList3 = new ArrayList(ModuleTechBasic.Registries.CHOPPING_BLOCK_RECIPE.getValuesCollection());
        registry.addRecipes(recipeList3, "pyrotech.chopping");
        registry.addRecipeCatalyst((Object)new ItemStack((Block)ModuleTechBasic.Blocks.DRYING_RACK, 1, BlockDryingRack.EnumType.CRUDE.getMeta()), new String[]{"pyrotech.crude.drying"});
        registry.handleRecipes(CrudeDryingRackRecipe.class, JEIRecipeWrapperCrudeDryingRack::new, "pyrotech.crude.drying");
        recipeList3 = new ArrayList(ModuleTechBasic.Registries.CRUDE_DRYING_RACK_RECIPE.getValuesCollection());
        registry.addRecipes(recipeList3, "pyrotech.crude.drying");
        registry.addRecipeCatalyst((Object)new ItemStack((Block)ModuleTechBasic.Blocks.DRYING_RACK, 1, BlockDryingRack.EnumType.NORMAL.getMeta()), new String[]{"pyrotech.drying"});
        registry.handleRecipes(DryingRackRecipe.class, JEIRecipeWrapperDryingRack::new, "pyrotech.drying");
        recipeList3 = new ArrayList(ModuleTechBasic.Registries.DRYING_RACK_RECIPE.getValuesCollection());
        registry.addRecipes(recipeList3, "pyrotech.drying");
        registry.addRecipeCatalyst((Object)new ItemStack((Block)ModuleTechBasic.Blocks.TANNING_RACK, 1), new String[]{"pyrotech.tanning"});
        registry.handleRecipes(TanningRackRecipe.class, JEIRecipeWrapperTanningRack::new, "pyrotech.tanning");
        recipeList3 = new ArrayList(ModuleTechBasic.Registries.TANNING_RACK_RECIPE.getValuesCollection());
        registry.addRecipes(recipeList3, "pyrotech.tanning");
        registry.addRecipeCatalyst((Object)new ItemStack((Block)ModuleTechBasic.Blocks.KILN_PIT), new String[]{"pyrotech.pit.kiln"});
        registry.handleRecipes(KilnPitRecipe.class, JEIRecipeWrapperKilnPit::new, "pyrotech.pit.kiln");
        recipeList3 = new ArrayList(ModuleTechBasic.Registries.KILN_PIT_RECIPE.getValuesCollection());
        registry.addRecipes(recipeList3, "pyrotech.pit.kiln");
        registry.addRecipeCatalyst((Object)new ItemStack((Block)ModuleTechBasic.Blocks.BARREL), new String[]{"pyrotech.barrel"});
        registry.addRecipeCatalyst((Object)new ItemStack((Block)ModuleTechBasic.Blocks.BARREL_SEALED), new String[]{"pyrotech.barrel"});
        registry.handleRecipes(BarrelRecipe.class, JEIRecipeWrapperBarrel::new, "pyrotech.barrel");
        recipeList3 = new ArrayList(ModuleTechBasic.Registries.BARREL_RECIPE.getValuesCollection());
        registry.addRecipes(recipeList3, "pyrotech.barrel");
        registry.addRecipeCatalyst((Object)new ItemStack((Block)ModuleTechBasic.Blocks.COMPOST_BIN), new String[]{"pyrotech.compost.bin"});
        ConcurrentHashMap aggregateRecipes = new ConcurrentHashMap();
        Collection valuesCollection = ModuleTechBasic.Registries.COMPOST_BIN_RECIPE.getValuesCollection();
        for (CompostBinRecipe recipe2 : valuesCollection) {
            ItemStack output = recipe2.getOutput();
            boolean found = false;
            for (Map.Entry entry : aggregateRecipes.entrySet()) {
                if (!ItemStack.func_77989_b((ItemStack)((ItemStack)entry.getKey()), (ItemStack)output)) continue;
                List list = (List)entry.getValue();
                list.add(recipe2);
                found = true;
                break;
            }
            if (found) continue;
            ArrayList<CompostBinRecipe> list = new ArrayList<CompostBinRecipe>();
            list.add(recipe2);
            aggregateRecipes.put(output.func_77946_l(), list);
        }
        recipeList = new ArrayList<JEIRecipeWrapperCompostBin>();
        for (Map.Entry entry : aggregateRecipes.entrySet()) {
            List list = ((List)entry.getValue()).stream().sorted(Comparator.comparingInt(CompostBinRecipeBase::getCompostValue).reversed()).collect(Collectors.toList());
            int pages = (list.size() - 1) / 54 + 1;
            for (int i = 0; i < pages; ++i) {
                int fromIndex = i * 54;
                int toIndex = Math.min((i + 1) * 54, list.size());
                List<ItemStack> subList = list.subList(fromIndex, toIndex).stream().map(compostBinRecipe -> compostBinRecipe.getInput().func_77946_l()).collect(Collectors.toList());
                recipeList.add(new JEIRecipeWrapperCompostBin(subList, (ItemStack)entry.getKey()));
            }
        }
        registry.addRecipes(recipeList, "pyrotech.compost.bin");
    }

    private List<IRecipe> getValidRecipeList(IJeiHelpers jeiHelpers) {
        try {
            Method craftingRecipeChecker$getValidRecipes = CraftingRecipeChecker.class.getMethod("getValidRecipes", IJeiHelpers.class);
            Class<?> returnType = craftingRecipeChecker$getValidRecipes.getReturnType();
            if (returnType.equals(List.class)) {
                return (List)craftingRecipeChecker$getValidRecipes.invoke(null, jeiHelpers);
            }
            if (returnType.equals(Pair.class)) {
                Pair pair = (Pair)craftingRecipeChecker$getValidRecipes.invoke(null, jeiHelpers);
                return (List)pair.getKey();
            }
            throw new RuntimeException("Unexpected return type: " + returnType);
        }
        catch (Exception e) {
            new RuntimeException("Unable to invoke CraftingRecipeChecker$getValidRecipes", e).printStackTrace();
            return Collections.emptyList();
        }
    }

    private static List<JEIRecipeWrapperCampfire> getFurnaceRecipesForCampfire(Predicate<ItemStack> filter) {
        FurnaceRecipes furnaceRecipes = FurnaceRecipes.func_77602_a();
        Map smeltingMap = furnaceRecipes.func_77599_b();
        ArrayList<JEIRecipeWrapperCampfire> recipes = new ArrayList<JEIRecipeWrapperCampfire>();
        for (Map.Entry entry : smeltingMap.entrySet()) {
            ItemStack input = (ItemStack)entry.getKey();
            if (!filter.test(input)) continue;
            ItemStack output = (ItemStack)entry.getValue();
            recipes.add(new JEIRecipeWrapperCampfire(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{input}), output, ModuleTechBasicConfig.CAMPFIRE.COOK_TIME_TICKS));
        }
        return recipes;
    }

    private void hideRecipes() {
        Set entries = ModuleTechBasic.Registries.WORKTABLE_RECIPE.getEntries();
        for (Map.Entry entry : entries) {
            IRecipeWrapper recipeWrapper;
            WorktableRecipe recipe = (WorktableRecipe)((Object)entry.getValue());
            if (!this.shouldHideWorktableRecipe(recipe) || (recipeWrapper = RECIPE_REGISTRY.getRecipeWrapper((Object)recipe, "pyrotech.worktable")) == null) continue;
            RECIPE_REGISTRY.hideRecipe(recipeWrapper, "pyrotech.worktable");
        }
    }

    private boolean shouldHideWorktableRecipe(WorktableRecipe recipe) {
        return Loader.isModLoaded((String)"gamestages") && recipe.getStages() != null;
    }

    public static class CraftingRecipeWrapperShaped
    implements IShapedCraftingRecipeWrapper {
        private final MCRecipeShaped recipe;

        public CraftingRecipeWrapperShaped(MCRecipeShaped recipe) {
            this.recipe = recipe;
        }

        public void getIngredients(IIngredients ingredients) {
            ingredients.setOutput(VanillaTypes.ITEM, (Object)this.recipe.func_77571_b());
            ingredients.setInputLists(VanillaTypes.ITEM, this.recipe.func_192400_c().stream().map(Ingredient::func_193365_a).map(Arrays::asList).collect(Collectors.toList()));
        }

        public int getWidth() {
            return this.recipe.getRecipeWidth();
        }

        public int getHeight() {
            return this.recipe.getRecipeHeight();
        }

        @Nullable
        public ResourceLocation getRegistryName() {
            return this.recipe.getRegistryName();
        }
    }

    private static class WorktableRecipeFactory
    implements IRecipeWrapperFactory<WorktableRecipe> {
        private final IJeiHelpers jeiHelpers;

        public WorktableRecipeFactory(IJeiHelpers jeiHelpers) {
            this.jeiHelpers = jeiHelpers;
        }

        @Nonnull
        public IRecipeWrapper getRecipeWrapper(@Nonnull WorktableRecipe recipe) {
            IRecipe wrappedRecipe = recipe.getRecipe();
            if (wrappedRecipe instanceof IShapedRecipe) {
                return new JEIRecipeWrapperWorktableShaped(this.jeiHelpers, (IShapedRecipe)wrappedRecipe, recipe.getToolList(), recipe.getToolDamage());
            }
            return new JEIRecipeWrapperWorktableShapeless<IRecipe>(this.jeiHelpers, wrappedRecipe, recipe.getToolList(), recipe.getToolDamage());
        }
    }
}

