/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.tech.basic.init.recipe;

import com.codetaylor.mc.athenaeum.parser.recipe.item.MalformedRecipeItemException;
import com.codetaylor.mc.athenaeum.parser.recipe.item.ParseResult;
import com.codetaylor.mc.athenaeum.parser.recipe.item.RecipeItemParser;
import com.codetaylor.mc.pyrotech.modules.core.init.CompatInitializerWood;
import com.codetaylor.mc.pyrotech.modules.tech.basic.ModuleTechBasic;
import com.codetaylor.mc.pyrotech.modules.tech.basic.recipe.ChoppingBlockRecipe;
import java.nio.file.Path;
import java.util.Map;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class ChoppingBlockRecipesAdd {
    public static final RecipeItemParser RECIPE_ITEM_PARSER = new RecipeItemParser();

    public static void applyCompatRecipes(Path configurationPath, IForgeRegistry<ChoppingBlockRecipe> registry) {
        CompatInitializerWood.WoodCompatData woodCompatData = CompatInitializerWood.read(configurationPath);
        if (woodCompatData == null) {
            return;
        }
        for (Map.Entry<String, String> modEntry : woodCompatData.entries.entrySet()) {
            String inputString = modEntry.getKey();
            String outputString = modEntry.getValue();
            ChoppingBlockRecipesAdd.createRecipe(registry, inputString, outputString);
        }
    }

    protected static void createRecipe(IForgeRegistry<ChoppingBlockRecipe> registry, String recipeInput, String recipeOutput) {
        ItemStack inputItemStack = ChoppingBlockRecipesAdd.getItemStack(recipeInput);
        ItemStack outputItemStack = ChoppingBlockRecipesAdd.getItemStack(recipeOutput);
        if (inputItemStack.func_190926_b() || outputItemStack.func_190926_b()) {
            return;
        }
        Item inputItem = inputItemStack.func_77973_b();
        ResourceLocation inputItemRegistryName = inputItem.getRegistryName();
        if (inputItemRegistryName == null) {
            ModuleTechBasic.LOGGER.error("Item missing registry name: " + inputItem);
            return;
        }
        Item outputItem = outputItemStack.func_77973_b();
        ResourceLocation outputItemRegistryName = outputItem.getRegistryName();
        if (outputItemRegistryName == null) {
            ModuleTechBasic.LOGGER.error("Item missing registry name: " + outputItem);
            return;
        }
        String recipeName = outputItemRegistryName.func_110624_b() + "_" + outputItemRegistryName.func_110623_a() + "_" + outputItemStack.func_77960_j() + "_from_" + inputItemRegistryName.func_110624_b() + "_" + inputItemRegistryName.func_110623_a() + "_" + inputItemStack.func_77960_j();
        registry.register(new ChoppingBlockRecipe(outputItemStack, Ingredient.func_193369_a((ItemStack[])new ItemStack[]{inputItemStack})).setRegistryName("pyrotech", recipeName));
    }

    protected static ItemStack getItemStack(String itemString) {
        try {
            ParseResult parse = RECIPE_ITEM_PARSER.parse(itemString);
            Item inputItem = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(parse.getDomain(), parse.getPath()));
            if (inputItem == null) {
                ModuleTechBasic.LOGGER.warn("Can't find registered item for: " + itemString);
                return ItemStack.field_190927_a;
            }
            return new ItemStack(inputItem, 1, parse.getMeta());
        }
        catch (MalformedRecipeItemException e) {
            ModuleTechBasic.LOGGER.error("", (Throwable)e);
            return ItemStack.field_190927_a;
        }
    }
}

