/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.tech.basic.event;

import com.codetaylor.mc.pyrotech.modules.core.ModuleCore;
import com.codetaylor.mc.pyrotech.modules.tech.basic.ModuleTechBasic;
import com.codetaylor.mc.pyrotech.modules.tech.basic.ModuleTechBasicConfig;
import it.unimi.dsi.fastutil.objects.Object2FloatMap;
import it.unimi.dsi.fastutil.objects.Object2FloatOpenHashMap;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemFood;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.FoodStats;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public final class CampfireWellFedEffectEventHandler {
    private static MethodHandle foodStats$foodExhaustionLevelGetter;
    private static MethodHandle foodStats$foodExhaustionLevelSetter;
    private Object2FloatMap<UUID> playerExhaustionMap = new Object2FloatOpenHashMap();
    private Set<UUID> failedSet = new HashSet<UUID>();

    @SubscribeEvent
    public void on(LivingEntityUseItemEvent.Finish event) {
        EntityLivingBase entityLiving = event.getEntityLiving();
        if (!(ModuleTechBasicConfig.CAMPFIRE_EFFECTS.WELL_FED_EFFECT_ENABLED && ModuleTechBasicConfig.CAMPFIRE_EFFECTS.COMFORT_EFFECT_ENABLED && !entityLiving.field_70170_p.field_72995_K && event.getItem().func_77973_b() instanceof ItemFood && entityLiving.func_193076_bZ().containsKey((Object)ModuleTechBasic.Potions.COMFORT))) {
            return;
        }
        if (entityLiving instanceof EntityPlayer) {
            FoodStats foodStats = ((EntityPlayer)entityLiving).func_71024_bL();
            float saturationLevel = foodStats.func_75115_e();
            int duration = Math.max(0, ModuleTechBasicConfig.CAMPFIRE_EFFECTS.WELL_FED_DURATION_TICKS);
            if (duration > 0 && Math.abs(saturationLevel - 20.0f) < 1.1920929E-7f) {
                entityLiving.func_70690_d(new PotionEffect((Potion)ModuleTechBasic.Potions.WELL_FED, duration, 0, false, true));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public void on(TickEvent.PlayerTickEvent event) {
        if (!ModuleTechBasicConfig.CAMPFIRE_EFFECTS.WELL_FED_EFFECT_ENABLED || event.phase != TickEvent.Phase.START || event.player.field_70170_p.field_72995_K) {
            return;
        }
        if (!event.player.func_193076_bZ().containsKey((Object)ModuleTechBasic.Potions.WELL_FED)) {
            return;
        }
        UUID uuid = event.player.func_110124_au();
        boolean failed = false;
        try {
            float previousExhaustionLevel;
            float currentExhaustionLevel = this.getPlayerExhaustionLevel(event.player);
            if (!this.playerExhaustionMap.containsKey((Object)uuid)) {
                this.playerExhaustionMap.put((Object)uuid, currentExhaustionLevel);
            }
            if ((previousExhaustionLevel = this.playerExhaustionMap.getFloat((Object)uuid)) < currentExhaustionLevel) {
                float delta = currentExhaustionLevel - previousExhaustionLevel;
                float newExhaustionLevel = (float)((double)currentExhaustionLevel - (double)delta * MathHelper.func_151237_a((double)ModuleTechBasicConfig.CAMPFIRE_EFFECTS.WELL_FED_EXHAUSTION_MODIFIER, (double)0.0, (double)1.0));
                this.setPlayerExhaustionLevel(event.player, newExhaustionLevel);
                this.playerExhaustionMap.put((Object)uuid, newExhaustionLevel);
            } else {
                this.playerExhaustionMap.put((Object)uuid, currentExhaustionLevel);
            }
        }
        catch (Throwable e) {
            failed = true;
            if (!this.failedSet.contains(uuid)) {
                this.failedSet.add(uuid);
                ModuleCore.LOGGER.error("", e);
            }
        }
        finally {
            if (!failed) {
                this.failedSet.remove(uuid);
            }
        }
    }

    private float getPlayerExhaustionLevel(EntityPlayer player) throws Throwable {
        FoodStats foodStats = player.func_71024_bL();
        return foodStats$foodExhaustionLevelGetter.invokeExact(foodStats);
    }

    private void setPlayerExhaustionLevel(EntityPlayer player, float value) throws Throwable {
        FoodStats foodStats = player.func_71024_bL();
        foodStats$foodExhaustionLevelSetter.invokeExact(foodStats, value);
    }

    static {
        try {
            foodStats$foodExhaustionLevelGetter = MethodHandles.lookup().unreflectGetter(ObfuscationReflectionHelper.findField(FoodStats.class, (String)"field_75126_c"));
            foodStats$foodExhaustionLevelSetter = MethodHandles.lookup().unreflectSetter(ObfuscationReflectionHelper.findField(FoodStats.class, (String)"field_75126_c"));
        }
        catch (IllegalAccessException e) {
            ModuleCore.LOGGER.error("", (Throwable)e);
        }
    }
}

