/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.tech.basic.event;

import com.codetaylor.mc.pyrotech.modules.core.ModuleCore;
import com.codetaylor.mc.pyrotech.modules.core.event.PlayerMovementTracker;
import com.codetaylor.mc.pyrotech.modules.tech.basic.ModuleTechBasic;
import com.codetaylor.mc.pyrotech.modules.tech.basic.ModuleTechBasicConfig;
import com.codetaylor.mc.pyrotech.modules.tech.basic.potion.PotionResting;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public final class CampfireRestingEffectEventHandler {
    @SubscribeEvent
    public void on(TickEvent.PlayerTickEvent event) {
        if (event.player.field_70170_p.field_72995_K || event.phase != TickEvent.Phase.END) {
            return;
        }
        if (PlayerMovementTracker.getTicksSinceLastMove(event.player) == 0 && this.resetRestingEffect((Entity)event.player) && ModuleTechBasicConfig.CAMPFIRE_EFFECTS.DEBUG) {
            String message = "Reset resting effect due to movement";
            ModuleCore.LOGGER.debug(message);
            event.player.func_145747_a((ITextComponent)new TextComponentString(message));
        }
    }

    @SubscribeEvent
    public void on(LivingDamageEvent event) {
        Entity entity = event.getEntity();
        if (!entity.field_70170_p.field_72995_K) {
            EntityPlayer player;
            if (this.resetRestingEffect(entity) && ModuleTechBasicConfig.CAMPFIRE_EFFECTS.DEBUG) {
                String message = "Reset resting effect due to damage taken";
                ModuleCore.LOGGER.debug(message);
                entity.func_145747_a((ITextComponent)new TextComponentString(message));
            }
            if (entity instanceof EntityPlayer && (player = (EntityPlayer)entity).func_110139_bj() == 0.0f && player.func_193076_bZ().containsKey((Object)ModuleTechBasic.Potions.WELL_RESTED)) {
                event.getEntityLiving().func_184589_d((Potion)ModuleTechBasic.Potions.WELL_RESTED);
                if (ModuleTechBasicConfig.CAMPFIRE_EFFECTS.DEBUG) {
                    String message = "Removed Well Rested effect due to loss of absorption hearts";
                    ModuleCore.LOGGER.debug(message);
                    entity.func_145747_a((ITextComponent)new TextComponentString(message));
                }
            }
        }
    }

    @SubscribeEvent
    public void on(AttackEntityEvent event) {
        Entity entity = event.getEntity();
        if (!entity.field_70170_p.field_72995_K && this.resetRestingEffect(entity) && ModuleTechBasicConfig.CAMPFIRE_EFFECTS.DEBUG) {
            String message = "Reset resting effect due to attacking";
            ModuleCore.LOGGER.debug(message);
            entity.func_145747_a((ITextComponent)new TextComponentString(message));
        }
    }

    @SubscribeEvent
    public void on(LivingHurtEvent event) {
        Entity trueSource = event.getSource().func_76346_g();
        if (trueSource != null && !trueSource.field_70170_p.field_72995_K && this.resetRestingEffect(trueSource) && ModuleTechBasicConfig.CAMPFIRE_EFFECTS.DEBUG) {
            String message = "Reset resting effect due to attacking";
            ModuleCore.LOGGER.debug(message);
            trueSource.func_145747_a((ITextComponent)new TextComponentString(message));
        }
    }

    private boolean resetRestingEffect(Entity entity) {
        EntityPlayer player;
        PotionEffect potionEffect;
        if (entity instanceof EntityPlayer && (potionEffect = (player = (EntityPlayer)entity).func_70660_b((Potion)ModuleTechBasic.Potions.RESTING)) != null && potionEffect.func_76458_c() > 0) {
            player.func_184589_d((Potion)ModuleTechBasic.Potions.RESTING);
            PotionResting.addEffect(player);
            return true;
        }
        return false;
    }
}

