/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.tech.basic.client.render;

import com.codetaylor.mc.athenaeum.interaction.spi.IInteractionRenderer;
import com.codetaylor.mc.pyrotech.modules.tech.basic.tile.TileBarrel;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;

public class BarrelFluidRenderer
implements IInteractionRenderer<TileBarrel.InteractionInputFluid> {
    public static final BarrelFluidRenderer INSTANCE = new BarrelFluidRenderer();
    private static final float PX = 0.0625f;
    private static final float INSET = 0.125f;

    public void renderSolidPass(TileBarrel.InteractionInputFluid interaction, World world, RenderItem renderItem, BlockPos pos, IBlockState blockState, float partialTicks) {
        FluidTank fluidTank = interaction.getFluidTank();
        FluidStack fluidStack = fluidTank.getFluid();
        if (fluidStack != null) {
            Fluid fluid = fluidStack.getFluid();
            ResourceLocation resourceLocation = fluid.getStill(fluidStack);
            TextureMap textureMapBlocks = Minecraft.func_71410_x().func_147117_R();
            TextureAtlasSprite sprite = textureMapBlocks.func_110572_b(resourceLocation.toString());
            int color = fluid.getColor(fluidStack);
            float r = (float)(color >> 16 & 0xFF) / 255.0f;
            float g = (float)(color >> 8 & 0xFF) / 255.0f;
            float b = (float)(color >> 0 & 0xFF) / 255.0f;
            BlockPos blockpos = new BlockPos(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            int i = world.func_175667_e(blockpos.func_177984_a()) ? world.func_175626_b(blockpos.func_177984_a(), 0) : 0;
            int j = i >> 16 & 0xFFFF;
            int k = i & 0xFFFF;
            float level = 0.75f * ((float)fluidTank.getFluidAmount() / (float)fluidTank.getCapacity()) + 0.125f;
            Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
            RenderHelper.func_74518_a();
            GlStateManager.func_179112_b((int)770, (int)771);
            GlStateManager.func_179147_l();
            GlStateManager.func_179129_p();
            if (Minecraft.func_71379_u()) {
                GlStateManager.func_179103_j((int)7425);
            } else {
                GlStateManager.func_179103_j((int)7424);
            }
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder buffer = tessellator.func_178180_c();
            buffer.func_181668_a(7, DefaultVertexFormats.field_176600_a);
            buffer.func_181662_b(0.125, (double)level, 0.125).func_181666_a(r, g, b, 1.0f).func_187315_a((double)sprite.func_94209_e(), (double)sprite.func_94206_g()).func_187314_a(j, k).func_181675_d();
            buffer.func_181662_b(0.875, (double)level, 0.125).func_181666_a(r, g, b, 1.0f).func_187315_a((double)sprite.func_94212_f(), (double)sprite.func_94206_g()).func_187314_a(j, k).func_181675_d();
            buffer.func_181662_b(0.875, (double)level, 0.875).func_181666_a(r, g, b, 1.0f).func_187315_a((double)sprite.func_94212_f(), (double)sprite.func_94210_h()).func_187314_a(j, k).func_181675_d();
            buffer.func_181662_b(0.125, (double)level, 0.875).func_181666_a(r, g, b, 1.0f).func_187315_a((double)sprite.func_94209_e(), (double)sprite.func_94210_h()).func_187314_a(j, k).func_181675_d();
            tessellator.func_78381_a();
            RenderHelper.func_74519_b();
        }
    }

    public void renderSolidPassText(TileBarrel.InteractionInputFluid interaction, World world, FontRenderer fontRenderer, int yaw, Vec3d offset, BlockPos pos, IBlockState blockState, float partialTicks) {
    }

    public boolean renderAdditivePass(TileBarrel.InteractionInputFluid interaction, World world, RenderItem renderItem, EnumFacing hitSide, Vec3d hitVec, BlockPos hitPos, IBlockState blockState, ItemStack heldItemMainHand, float partialTicks) {
        return false;
    }
}

