/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.tech.basic.block;

import com.codetaylor.mc.athenaeum.interaction.spi.IBlockInteractable;
import com.codetaylor.mc.athenaeum.interaction.spi.IInteraction;
import com.codetaylor.mc.athenaeum.spi.BlockPartialBase;
import com.codetaylor.mc.athenaeum.util.StackHelper;
import com.codetaylor.mc.pyrotech.Reference;
import com.codetaylor.mc.pyrotech.modules.tech.basic.ModuleTechBasic;
import com.codetaylor.mc.pyrotech.modules.tech.basic.tile.TileBarrel;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.ItemStackHandler;
import org.lwjgl.input.Keyboard;

public class BlockBarrel
extends BlockPartialBase
implements IBlockInteractable {
    public static final String NAME = "barrel";
    public static final String NAME_SEALED = "barrel_sealed";
    private static boolean keepInventory;
    private final boolean sealed;

    public BlockBarrel(boolean sealed) {
        super(Material.field_151575_d);
        this.sealed = sealed;
        this.func_149711_c(1.0f);
        this.func_149752_b(3.0f);
        this.func_149672_a(SoundType.field_185848_a);
        this.setHarvestLevel("axe", 0);
    }

    public boolean isSealed() {
        return this.sealed;
    }

    public static void setState(boolean sealed, World world, BlockPos pos) {
        TileEntity tileentity = world.func_175625_s(pos);
        keepInventory = true;
        if (sealed) {
            world.func_180501_a(pos, ModuleTechBasic.Blocks.BARREL_SEALED.func_176223_P(), 3);
        } else {
            world.func_180501_a(pos, ModuleTechBasic.Blocks.BARREL.func_176223_P(), 3);
        }
        keepInventory = false;
        if (tileentity != null) {
            tileentity.func_145829_t();
            world.func_175690_a(pos, tileentity);
        }
    }

    @Nullable
    public RayTraceResult func_180636_a(@Nonnull IBlockState blockState, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull Vec3d start, @Nonnull Vec3d end) {
        return this.interactionRayTrace(super.func_180636_a(blockState, world, pos, start, end), blockState, world, pos, start, end);
    }

    @ParametersAreNonnullByDefault
    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        return this.interact(IInteraction.EnumType.MouseClick, world, pos, state, playerIn, hand, facing, hitX, hitY, hitZ);
    }

    @ParametersAreNonnullByDefault
    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntity tile;
        if (!keepInventory && !this.isSealed() && (tile = world.func_175625_s(pos)) instanceof TileBarrel) {
            TileBarrel tileBarrel = (TileBarrel)tile;
            StackHelper.spawnStackHandlerContentsOnTop((World)world, (ItemStackHandler)tileBarrel.getInputStackHandler(), (BlockPos)pos);
            StackHelper.spawnStackHandlerContentsOnTop((World)world, (ItemStackHandler)tileBarrel.getLidStackHandler(), (BlockPos)pos);
        }
        super.func_180663_b(world, pos, state);
        world.func_175713_t(pos);
    }

    public boolean removedByPlayer(@Nonnull IBlockState state, World world, @Nonnull BlockPos pos, @Nonnull EntityPlayer player, boolean willHarvest) {
        if (!this.isSealed()) {
            return super.removedByPlayer(state, world, pos, player, willHarvest);
        }
        return willHarvest || super.removedByPlayer(state, world, pos, player, false);
    }

    public void func_180657_a(@Nonnull World world, EntityPlayer player, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nullable TileEntity te, ItemStack stack) {
        super.func_180657_a(world, player, pos, state, te, stack);
        if (!world.field_72995_K && this.isSealed()) {
            world.func_175698_g(pos);
        }
    }

    public void getDrops(@Nonnull NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, @Nonnull IBlockState state, int fortune) {
        if (!this.isSealed()) {
            super.getDrops(drops, world, pos, state, fortune);
            return;
        }
        drops.add((Object)StackHelper.createItemStackFromTileEntity((Block)this, (int)1, (int)0, (TileEntity)world.func_175625_s(pos)));
    }

    public boolean hasTileEntity(@Nonnull IBlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(@Nonnull World world, @Nonnull IBlockState state) {
        return new TileBarrel();
    }

    public CreativeTabs func_149708_J() {
        return this.isSealed() ? null : super.func_149708_J();
    }

    public void func_190948_a(@Nonnull ItemStack stack, @Nullable World world, @Nonnull List<String> tooltip, @Nonnull ITooltipFlag flag) {
        NBTTagCompound stackTag = stack.func_77978_p();
        if (stackTag != null) {
            if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
                if (stackTag.func_74764_b("BlockEntityTag")) {
                    FluidStack fluidStack;
                    NBTTagCompound tankTag;
                    NBTTagCompound tileTag = stackTag.func_74775_l("BlockEntityTag");
                    if (tileTag.func_74764_b("inputFluidTank") && (!(tankTag = tileTag.func_74775_l("inputFluidTank")).func_74764_b("Empty") || tankTag.func_74764_b("Amount") && tankTag.func_74762_e("Amount") > 0) && (fluidStack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)tankTag)) != null) {
                        String localizedName = fluidStack.getLocalizedName();
                        int amount = fluidStack.amount;
                        int capacity = 1000;
                        tooltip.add(Reference.Tooltip.COLOR_EXTENDED_INFO + I18n.func_74837_a((String)"gui.pyrotech.tooltip.fluid", (Object[])new Object[]{localizedName, amount, capacity}));
                    }
                    if (tileTag.func_74764_b("inputStackHandler")) {
                        TileBarrel.InputStackHandler stackHandler = new TileBarrel.InputStackHandler(null, 4);
                        stackHandler.deserializeNBT(tileTag.func_74775_l("inputStackHandler"));
                        for (int i = 0; i < stackHandler.getSlots(); ++i) {
                            ItemStack itemStack = stackHandler.getStackInSlot(i);
                            if (itemStack.func_190926_b()) continue;
                            String name = itemStack.func_77973_b().func_77653_i(itemStack);
                            tooltip.add(" - " + Reference.Tooltip.COLOR_EXTENDED_INFO + name);
                        }
                    }
                }
            } else {
                tooltip.add(I18n.func_74837_a((String)"gui.pyrotech.tooltip.extended.shift", (Object[])new Object[]{Reference.Tooltip.COLOR_EXTENDED_INFO, TextFormatting.GRAY}));
            }
        }
        boolean hotFluids = false;
        tooltip.add((hotFluids ? TextFormatting.GREEN : TextFormatting.RED) + I18n.func_74837_a((String)("gui.pyrotech.tooltip.hot.fluids." + hotFluids), (Object[])new Object[0]));
    }

    public static class ItemBlockBarrelSealed
    extends ItemBlock {
        public ItemBlockBarrelSealed(Block block) {
            super(block);
            this.func_77625_d(1);
        }
    }
}

