/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.storage.block.spi;

import com.codetaylor.mc.athenaeum.interaction.spi.IBlockInteractable;
import com.codetaylor.mc.athenaeum.interaction.spi.IInteraction;
import com.codetaylor.mc.athenaeum.parser.recipe.item.MalformedRecipeItemException;
import com.codetaylor.mc.athenaeum.parser.recipe.item.ParseResult;
import com.codetaylor.mc.athenaeum.parser.recipe.item.RecipeItemParser;
import com.codetaylor.mc.athenaeum.spi.BlockPartialBase;
import com.codetaylor.mc.athenaeum.spi.IVariant;
import com.codetaylor.mc.athenaeum.util.AABBHelper;
import com.codetaylor.mc.athenaeum.util.Properties;
import com.codetaylor.mc.pyrotech.modules.storage.ModuleStorage;
import com.codetaylor.mc.pyrotech.modules.storage.block.item.ItemBlockBag;
import com.codetaylor.mc.pyrotech.modules.storage.tile.spi.TileBagBase;
import java.util.Comparator;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class BlockBagBase
extends BlockPartialBase
implements IBlockInteractable {
    public static final PropertyEnum<EnumType> TYPE = PropertyEnum.func_177709_a((String)"type", EnumType.class);
    public static final AxisAlignedBB AABB_NORTH = AABBHelper.create((double)3.0, (double)0.0, (double)5.0, (double)13.0, (double)10.0, (double)11.0);
    private static final AxisAlignedBB AABB_WEST = AABBHelper.rotateHorizontalCCW90Centered((AxisAlignedBB)AABB_NORTH);
    private static final AxisAlignedBB AABB_SOUTH = AABBHelper.rotateHorizontalCCW90Centered((AxisAlignedBB)AABB_WEST);
    private static final AxisAlignedBB AABB_EAST = AABBHelper.rotateHorizontalCCW90Centered((AxisAlignedBB)AABB_SOUTH);

    public BlockBagBase() {
        super(Material.field_151580_n);
        this.func_149711_c(0.2f);
        this.func_149672_a(SoundType.field_185854_g);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)Properties.FACING_HORIZONTAL, (Comparable)EnumFacing.NORTH).func_177226_a(TYPE, (Comparable)((Object)EnumType.CLOSED)));
    }

    public abstract int getItemCapacity();

    protected abstract String[] getItemWhitelist();

    protected abstract String[] getItemBlacklist();

    public abstract boolean allowAutoPickupMainhand();

    public abstract boolean allowAutoPickupOffhand();

    public abstract boolean allowAutoPickupHotbar();

    public abstract boolean allowAutoPickupInventory();

    public boolean isOpen(IBlockState blockState) {
        return blockState.func_177229_b(TYPE) == EnumType.OPEN;
    }

    public boolean isItemValidForInsertion(ItemStack itemStack) {
        ResourceLocation registryName = itemStack.func_77973_b().getRegistryName();
        if (registryName == null) {
            return false;
        }
        String[] itemWhitelist = this.getItemWhitelist();
        String[] itemBlacklist = this.getItemBlacklist();
        if (itemWhitelist.length > 0) {
            for (String itemString : itemWhitelist) {
                try {
                    ParseResult parseResult = RecipeItemParser.INSTANCE.parse(itemString);
                    if (!parseResult.matches(itemStack, true)) continue;
                    return true;
                }
                catch (MalformedRecipeItemException e) {
                    ModuleStorage.LOGGER.error("Error parsing config string for valid bag item " + itemString, (Throwable)e);
                }
            }
            return false;
        }
        if (itemBlacklist.length > 0) {
            for (String itemString : itemBlacklist) {
                try {
                    ParseResult parseResult = RecipeItemParser.INSTANCE.parse(itemString);
                    if (parseResult.matches(itemStack, true)) {
                        return false;
                    }
                }
                catch (MalformedRecipeItemException e) {
                    ModuleStorage.LOGGER.error("Error parsing config string for valid bag item " + itemString, (Throwable)e);
                }
            }
        }
        return true;
    }

    @Nullable
    public RayTraceResult func_180636_a(IBlockState blockState, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull Vec3d start, @Nonnull Vec3d end) {
        return this.interactionRayTrace(super.func_180636_a(blockState, world, pos, start, end), blockState, world, pos, start, end);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        return this.interact(IInteraction.EnumType.MouseClick, world, pos, state, playerIn, hand, facing, hitX, hitY, hitZ);
    }

    @ParametersAreNonnullByDefault
    @Nonnull
    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        EnumFacing opposite = placer.func_174811_aO().func_176734_d();
        ItemStack heldItem = placer.func_184586_b(hand);
        return this.func_176223_P().func_177226_a((IProperty)Properties.FACING_HORIZONTAL, (Comparable)opposite).func_177226_a(TYPE, (Comparable)((Object)(heldItem.func_77960_j() == 0 ? EnumType.CLOSED : EnumType.OPEN)));
    }

    public boolean removedByPlayer(@Nonnull IBlockState state, World world, @Nonnull BlockPos pos, @Nonnull EntityPlayer player, boolean willHarvest) {
        return willHarvest || super.removedByPlayer(state, world, pos, player, false);
    }

    public void func_180657_a(@Nonnull World world, EntityPlayer player, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nullable TileEntity te, ItemStack stack) {
        super.func_180657_a(world, player, pos, state, te, stack);
        if (!world.field_72995_K) {
            world.func_175698_g(pos);
        }
    }

    public void getDrops(@Nonnull NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, @Nonnull IBlockState state, int fortune) {
        TileEntity tileEntity = world.func_175625_s(pos);
        ItemStack itemStack = new ItemStack(this.getBlock(), 1, this.func_180651_a(state));
        if (tileEntity instanceof TileBagBase) {
            TileBagBase.StackHandler tileStackHandler = ((TileBagBase)tileEntity).getStackHandler();
            for (int i = 0; i < tileStackHandler.getSlots(); ++i) {
                ItemBlockBag.insertItem(itemStack, tileStackHandler.getStackInSlot(i), false);
            }
        }
        drops.add((Object)itemStack);
    }

    protected abstract Block getBlock();

    @Nonnull
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        switch ((EnumFacing)state.func_177229_b((IProperty)Properties.FACING_HORIZONTAL)) {
            case NORTH: {
                return AABB_NORTH;
            }
            case WEST: {
                return AABB_WEST;
            }
            case SOUTH: {
                return AABB_SOUTH;
            }
            case EAST: {
                return AABB_EAST;
            }
        }
        return super.func_185496_a(state, source, pos);
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return this.createTileEntity();
    }

    protected abstract TileEntity createTileEntity();

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{TYPE, Properties.FACING_HORIZONTAL});
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)EnumType.fromMeta(meta >> 2 & 1))).func_177226_a((IProperty)Properties.FACING_HORIZONTAL, (Comparable)EnumFacing.field_176754_o[meta & 3]);
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumType)((Object)state.func_177229_b(TYPE))).getMeta() << 2 | ((EnumFacing)state.func_177229_b((IProperty)Properties.FACING_HORIZONTAL)).func_176736_b();
    }

    public int func_180651_a(IBlockState state) {
        return this.isOpen(state) ? 1 : 0;
    }

    public static enum EnumType implements IVariant
    {
        CLOSED(0, "closed"),
        OPEN(1, "open");

        private static final EnumType[] META_LOOKUP;
        private final int meta;
        private final String name;

        private EnumType(int meta, String name) {
            this.meta = meta;
            this.name = name;
        }

        public int getMeta() {
            return this.meta;
        }

        @Nonnull
        public String func_176610_l() {
            return this.name;
        }

        public static EnumType fromMeta(int meta) {
            if (meta < 0 || meta >= META_LOOKUP.length) {
                meta = 0;
            }
            return META_LOOKUP[meta];
        }

        static {
            META_LOOKUP = (EnumType[])Stream.of(EnumType.values()).sorted(Comparator.comparing(EnumType::getMeta)).toArray(EnumType[]::new);
        }
    }
}

