/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.ignition.tile;

import com.codetaylor.mc.athenaeum.integration.gamestages.Stages;
import com.codetaylor.mc.athenaeum.interaction.api.InteractionBounds;
import com.codetaylor.mc.athenaeum.interaction.spi.IInteraction;
import com.codetaylor.mc.athenaeum.interaction.spi.ITileInteractable;
import com.codetaylor.mc.athenaeum.interaction.spi.InteractionBase;
import com.codetaylor.mc.athenaeum.interaction.spi.InteractionBucketBase;
import com.codetaylor.mc.athenaeum.interaction.spi.InteractionUseItemBase;
import com.codetaylor.mc.athenaeum.inventory.ObservableFluidTank;
import com.codetaylor.mc.athenaeum.network.tile.data.TileDataFluidTank;
import com.codetaylor.mc.athenaeum.network.tile.spi.ITileData;
import com.codetaylor.mc.athenaeum.network.tile.spi.ITileDataFluidTank;
import com.codetaylor.mc.athenaeum.network.tile.spi.TileEntityDataBase;
import com.codetaylor.mc.pyrotech.library.util.Util;
import com.codetaylor.mc.pyrotech.modules.ignition.ModuleIgnition;
import com.codetaylor.mc.pyrotech.modules.ignition.ModuleIgnitionConfig;
import com.codetaylor.mc.pyrotech.modules.ignition.block.BlockLampOil;
import com.codetaylor.mc.pyrotech.modules.storage.tile.spi.TileTankBase;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class TileLampOil
extends TileEntityDataBase
implements ITileInteractable,
ITickable {
    private final TileDataFluidTank<Tank> tileDataFluidTank;
    private final Tank tank = new Tank(this, this.getTankCapacity());
    private final IInteraction<?>[] interactions;
    private float millibucketsUsed;

    public TileLampOil() {
        super(ModuleIgnition.TILE_DATA_SERVICE);
        this.tileDataFluidTank = new TileDataFluidTank((FluidTank)this.tank);
        this.registerTileDataForNetwork(new ITileData[]{this.tileDataFluidTank});
        this.interactions = new IInteraction[]{new InteractionBucket((IFluidHandler)this.tank), new InteractionExtinguish(EnumFacing.field_82609_l), new InteractionUseItemToActivate(Items.field_151033_d, EnumFacing.field_82609_l)};
    }

    public FluidTank getFluidTank() {
        return this.tank;
    }

    public boolean isActive() {
        return (Boolean)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockLampOil.LIT);
    }

    public void setActive(boolean active) {
        if (active && !this.isActive() && this.tank.getFluidAmount() > 0) {
            this.field_145850_b.func_175656_a(this.field_174879_c, ModuleIgnition.Blocks.LAMP_OIL.func_176223_P().func_177226_a((IProperty)BlockLampOil.LIT, (Comparable)Boolean.valueOf(true)));
        } else if (!active && this.isActive()) {
            this.field_145850_b.func_175656_a(this.field_174879_c, ModuleIgnition.Blocks.LAMP_OIL.func_176223_P().func_177226_a((IProperty)BlockLampOil.LIT, (Comparable)Boolean.valueOf(false)));
        }
    }

    protected int getTankCapacity() {
        return ModuleIgnitionConfig.OIL_LAMP.CAPACITY;
    }

    protected boolean allowFluid(FluidStack fluidStack) {
        if (fluidStack == null || fluidStack.getFluid() == null) {
            return false;
        }
        return ModuleIgnitionConfig.OIL_LAMP.ALLOWED_FUEL.containsKey(fluidStack.getFluid().getName());
    }

    protected int getMillibucketsPerMinute(FluidStack fluidStack) {
        if (fluidStack == null || fluidStack.getFluid() == null) {
            return 0;
        }
        return ModuleIgnitionConfig.OIL_LAMP.ALLOWED_FUEL.getOrDefault(fluidStack.getFluid().getName(), 0);
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K || !this.isActive()) {
            return;
        }
        if (this.tank.getFluidAmount() == 0) {
            this.setActive(false);
            this.millibucketsUsed = 0.0f;
            this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_187646_bt, SoundCategory.BLOCKS, 1.0f, Util.RANDOM.nextFloat() * 0.4f + 0.8f);
            return;
        }
        this.millibucketsUsed += (float)this.getMillibucketsPerMinute(this.tank.getFluid()) / 1200.0f;
        int used = (int)Math.floor(this.millibucketsUsed);
        if (used > 0) {
            this.tank.drainInternal(used, true);
            this.millibucketsUsed -= (float)used;
        }
    }

    protected void func_190201_b(@Nonnull World world) {
        this.field_145850_b = world;
    }

    @Nonnull
    public NBTTagCompound func_189515_b(@Nonnull NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74782_a("tank", (NBTBase)this.tank.writeToNBT(new NBTTagCompound()));
        compound.func_74776_a("millibucketsUsed", this.millibucketsUsed);
        return compound;
    }

    public void func_145839_a(@Nonnull NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.tank.readFromNBT(compound.func_74775_l("tank"));
        this.millibucketsUsed = compound.func_74760_g("millibucketsUsed");
    }

    public IInteraction<?>[] getInteractions() {
        return this.interactions;
    }

    @Nullable
    public Stages getStages() {
        return ModuleIgnitionConfig.STAGES_OIL_LAMP;
    }

    private static class Tank
    extends ObservableFluidTank
    implements ITileDataFluidTank {
        private final TileLampOil tile;

        Tank(TileLampOil tile, int capacity) {
            super(capacity);
            this.tile = tile;
        }

        public int fill(FluidStack resource, boolean doFill) {
            if (!this.tile.allowFluid(resource)) {
                return 0;
            }
            return super.fill(resource, doFill);
        }

        public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
            if (this.fluid != null) {
                this.fluid.writeToNBT(nbt);
            } else {
                nbt.func_74778_a("Empty", "");
            }
            return nbt;
        }

        public FluidTank readFromNBT(NBTTagCompound nbt) {
            if (nbt.func_74764_b("Empty") && (!nbt.func_74764_b("Amount") || nbt.func_74762_e("Amount") <= 0)) {
                this.setFluid(null);
                return this;
            }
            FluidStack fluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbt);
            this.setFluid(fluid);
            return this;
        }
    }

    public static class InteractionUseItemToActivate
    extends InteractionUseItemBase<TileLampOil> {
        private final Item item;

        InteractionUseItemToActivate(Item item, EnumFacing[] sides) {
            super(sides, InteractionBounds.BLOCK);
            this.item = item;
        }

        public AxisAlignedBB getInteractionBounds(World world, BlockPos pos, IBlockState blockState) {
            return blockState.func_177230_c().func_185496_a(blockState, (IBlockAccess)world, pos);
        }

        protected boolean allowInteraction(TileLampOil tile, World world, BlockPos hitPos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing hitSide, float hitX, float hitY, float hitZ) {
            return player.func_184586_b(hand).func_77973_b() == this.item;
        }

        protected boolean doInteraction(TileLampOil tile, World world, BlockPos hitPos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing hitSide, float hitX, float hitY, float hitZ) {
            if (!world.field_72995_K) {
                tile.setActive(true);
                world.func_184133_a(null, hitPos, SoundEvents.field_187649_bu, SoundCategory.BLOCKS, 1.0f, Util.RANDOM.nextFloat() * 0.4f + 0.8f);
            }
            return true;
        }
    }

    public static class InteractionExtinguish
    extends InteractionBase<TileLampOil> {
        public InteractionExtinguish(EnumFacing[] sides) {
            super(sides, InteractionBounds.BLOCK);
        }

        public boolean interact(IInteraction.EnumType type, TileLampOil tile, World world, BlockPos hitPos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing hitSide, float hitX, float hitY, float hitZ) {
            if (!player.func_184586_b(hand).func_190926_b() || !tile.isActive()) {
                return false;
            }
            if (!world.field_72995_K) {
                tile.setActive(false);
                world.func_184133_a(null, hitPos, SoundEvents.field_187646_bt, SoundCategory.BLOCKS, 1.0f, Util.RANDOM.nextFloat() * 0.4f + 0.8f);
            }
            return true;
        }
    }

    public static class InteractionBucket
    extends InteractionBucketBase<TileTankBase> {
        InteractionBucket(IFluidHandler fluidHandler) {
            super(fluidHandler, EnumFacing.field_82609_l, InteractionBounds.BLOCK);
        }
    }
}

