/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.ignition.item;

import com.codetaylor.mc.athenaeum.util.SoundHelper;
import com.codetaylor.mc.pyrotech.ModPyrotech;
import com.codetaylor.mc.pyrotech.library.spi.block.IBlockIgnitableWithIgniterItem;
import com.codetaylor.mc.pyrotech.library.util.Util;
import com.codetaylor.mc.pyrotech.modules.tech.refractory.ModuleTechRefractory;
import com.codetaylor.mc.pyrotech.modules.tech.refractory.util.RefractoryIgnitionHelper;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public abstract class ItemIgniterBase
extends Item {
    @Nonnull
    public EnumAction func_77661_b(@Nonnull ItemStack stack) {
        return EnumAction.BOW;
    }

    @ParametersAreNonnullByDefault
    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack heldItem = player.func_184586_b(hand);
        RayTraceResult rayTraceResult = this.func_77621_a(world, player, false);
        if (rayTraceResult != null && rayTraceResult.field_72313_a == RayTraceResult.Type.BLOCK) {
            player.func_184598_c(hand);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)heldItem);
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)heldItem);
    }

    @ParametersAreNonnullByDefault
    public void onUsingTick(ItemStack stack, EntityLivingBase player, int count) {
        if (!(player instanceof EntityPlayer)) {
            return;
        }
        World world = player.field_70170_p;
        RayTraceResult rayTraceResult = this.func_77621_a(world, (EntityPlayer)player, false);
        if (rayTraceResult == null || rayTraceResult.field_72313_a != RayTraceResult.Type.BLOCK) {
            player.func_184597_cx();
            return;
        }
        if (world.field_72995_K) {
            Vec3d hit = rayTraceResult.field_72307_f;
            world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, hit.field_72450_a, hit.field_72448_b, hit.field_72449_c, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    @ParametersAreNonnullByDefault
    @Nonnull
    public ItemStack func_77654_b(ItemStack stack, World world, EntityLivingBase player) {
        RayTraceResult rayTraceResult = this.func_77621_a(world, (EntityPlayer)player, false);
        if (rayTraceResult == null || rayTraceResult.field_72313_a != RayTraceResult.Type.BLOCK) {
            player.func_184597_cx();
            return stack;
        }
        BlockPos pos = rayTraceResult.func_178782_a();
        EnumFacing facing = rayTraceResult.field_178784_b;
        BlockPos offset = pos.func_177972_a(facing);
        IBlockState blockState = world.func_180495_p(pos);
        Block block = blockState.func_177230_c();
        if (block instanceof IBlockIgnitableWithIgniterItem) {
            if (!world.field_72995_K) {
                ((IBlockIgnitableWithIgniterItem)block).igniteWithIgniterItem(world, pos, blockState, facing);
                SoundHelper.playSoundServer((World)world, (BlockPos)pos, (SoundEvent)SoundEvents.field_187649_bu, (SoundCategory)SoundCategory.PLAYERS);
            }
            this.damageItem(stack, player);
        } else if (Util.canSetFire(world, offset)) {
            if (!world.field_72995_K) {
                world.func_180501_a(offset, Blocks.field_150480_ab.func_176223_P(), 3);
                SoundHelper.playSoundServer((World)world, (BlockPos)pos, (SoundEvent)SoundEvents.field_187649_bu, (SoundCategory)SoundCategory.PLAYERS);
            }
            this.damageItem(stack, player);
        } else if (!world.field_72995_K) {
            if (ModPyrotech.INSTANCE.isModuleEnabled(ModuleTechRefractory.class)) {
                RefractoryIgnitionHelper.igniteBlocks(world, pos);
            }
            SoundHelper.playSoundServer((World)world, (BlockPos)pos, (SoundEvent)SoundEvents.field_187649_bu, (SoundCategory)SoundCategory.PLAYERS);
            this.damageItem(stack, player);
        }
        ((EntityPlayer)player).func_184811_cZ().func_185145_a((Item)this, this.getCooldownTicks());
        return stack;
    }

    protected abstract void damageItem(@Nonnull ItemStack var1, EntityLivingBase var2);

    protected abstract int getCooldownTicks();
}

