/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.hunting.tile;

import com.codetaylor.mc.athenaeum.interaction.spi.InteractionUseItemBase;
import com.codetaylor.mc.athenaeum.util.StackHelper;
import com.codetaylor.mc.pyrotech.library.util.Util;
import com.codetaylor.mc.pyrotech.modules.core.ModuleCore;
import com.codetaylor.mc.pyrotech.modules.core.network.SCPacketNoHunger;
import com.codetaylor.mc.pyrotech.modules.core.network.SCPacketParticleProgress;
import com.codetaylor.mc.pyrotech.modules.hunting.ModuleHunting;
import com.codetaylor.mc.pyrotech.modules.tech.basic.ModuleTechBasic;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class InteractionCarcass<T extends TileEntity>
extends InteractionUseItemBase<T> {
    private final IInteractionCarcassDelegate delegate;

    public InteractionCarcass(EnumFacing[] facings, AxisAlignedBB bounds, IInteractionCarcassDelegate delegate) {
        super(facings, bounds);
        this.delegate = delegate;
    }

    protected boolean allowInteraction(T tile, World world, BlockPos hitPos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing hitSide, float hitX, float hitY, float hitZ) {
        if (this.delegate.canUseWithHungerLevel(player.func_71024_bL().func_75116_a())) {
            if (!world.field_72995_K) {
                ModuleTechBasic.PACKET_SERVICE.sendTo((IMessage)new SCPacketNoHunger(), (EntityPlayerMP)player);
            }
            return false;
        }
        ItemStack heldItemStack = player.func_184586_b(hand);
        Item heldItem = heldItemStack.func_77973_b();
        ResourceLocation resourceLocation = heldItem.getRegistryName();
        if (resourceLocation == null) {
            return false;
        }
        String registryName = resourceLocation.toString();
        return this.delegate.canUseWithHeldItem(registryName);
    }

    protected boolean doInteraction(T tile, World world, BlockPos hitPos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing hitSide, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            this.delegate.doExhaustion(player);
            world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187884_fr, SoundCategory.BLOCKS, 0.75f, (float)(1.0 + Util.RANDOM.nextGaussian() * (double)0.4f));
            ItemStack heldItemStack = player.func_184586_b(hand);
            Item heldItem = heldItemStack.func_77973_b();
            ResourceLocation resourceLocation = heldItem.getRegistryName();
            if (resourceLocation == null) {
                return false;
            }
            String registryName = resourceLocation.toString();
            int efficiency = this.delegate.getItemEfficiency(registryName);
            this.delegate.setCurrentProgress(this.delegate.getCurrentProgress() - (float)efficiency);
            ModuleCore.PACKET_SERVICE.sendToAllAround((IMessage)new SCPacketParticleProgress((double)hitPos.func_177958_n() + 0.5, (double)hitPos.func_177956_o() + this.delegate.getProgressParticleOffsetY(), (double)hitPos.func_177952_p() + 0.5, 2), world.field_73011_w.getDimension(), hitPos);
            if (this.delegate.getCurrentProgress() <= 0.0f) {
                ItemStack itemStack = this.delegate.extractItem(resourceLocation);
                if (!itemStack.func_190926_b()) {
                    StackHelper.spawnStackOnTop((World)world, (ItemStack)itemStack, (BlockPos)this.delegate.getPosition());
                }
                if (this.delegate.isEmpty()) {
                    this.delegate.destroyCarcass();
                } else {
                    this.delegate.resetProgress();
                }
            }
        } else {
            IBlockState blockState = ModuleHunting.Blocks.CARCASS.func_176223_P();
            for (int i = 0; i < 8; ++i) {
                world.func_175688_a(EnumParticleTypes.BLOCK_CRACK, (double)((float)this.delegate.getPosition().func_177958_n() + hitX), (double)((float)this.delegate.getPosition().func_177956_o() + hitY), (double)((float)this.delegate.getPosition().func_177952_p() + hitZ), 0.0, 0.0, 0.0, new int[]{Block.func_176210_f((IBlockState)blockState)});
            }
        }
        return true;
    }

    public static interface IInteractionCarcassDelegate {
        public boolean canUseWithHungerLevel(int var1);

        public boolean canUseWithHeldItem(String var1);

        public void doExhaustion(EntityPlayer var1);

        public int getItemEfficiency(String var1);

        public void setCurrentProgress(float var1);

        public float getCurrentProgress();

        public void resetProgress();

        public BlockPos getPosition();

        public ItemStack extractItem(ResourceLocation var1);

        public boolean isEmpty();

        public void destroyCarcass();

        default public double getProgressParticleOffsetY() {
            return 1.0;
        }
    }
}

