/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.hunting.item;

import com.codetaylor.mc.pyrotech.modules.core.network.SCPacketParticleProgress;
import com.codetaylor.mc.pyrotech.modules.hunting.ModuleHunting;
import com.codetaylor.mc.pyrotech.modules.hunting.ModuleHuntingConfig;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class EntityItemHideScraped
extends EntityItem {
    public static final String NAME = "pyrotech." + EntityItemHideScraped.class.getSimpleName();
    private int ticksInWater;
    private ItemStack transformedItem;

    public EntityItemHideScraped(World world) {
        super(world);
        this.lifespan = Integer.MAX_VALUE;
    }

    public EntityItemHideScraped(World world, double x, double y, double z, ItemStack stack, ItemStack transformedItem) {
        super(world, x, y, z, stack);
        NBTTagCompound tagCompound;
        this.transformedItem = transformedItem;
        this.lifespan = Integer.MAX_VALUE;
        if (stack.func_77942_o() && (tagCompound = stack.func_77978_p()) != null) {
            this.ticksInWater = tagCompound.func_74762_e("ticksInWater");
        }
    }

    public void func_70030_z() {
        super.func_70030_z();
        if (this.field_70170_p == null) {
            return;
        }
        if (this.transformedItem == null) {
            return;
        }
        ItemStack itemStack = this.func_92059_d();
        if (itemStack.func_77973_b() == this.transformedItem.func_77973_b()) {
            return;
        }
        if (!this.field_70170_p.field_72995_K) {
            BlockPos pos = this.func_180425_c();
            IBlockState blockState = this.field_70170_p.func_180495_p(pos);
            Block block = blockState.func_177230_c();
            if (block instanceof BlockFluidBase && ((BlockFluidBase)block).getFluid() == FluidRegistry.WATER || block == Blocks.field_150355_j) {
                ++this.ticksInWater;
                if (this.ticksInWater % 40 == 0) {
                    ModuleHunting.PACKET_SERVICE.sendToAllAround((IMessage)new SCPacketParticleProgress((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.0, (double)pos.func_177952_p() + 0.5, 2), this.field_70170_p.field_73011_w.getDimension(), pos);
                }
                if (this.ticksInWater % 200 == 0) {
                    NBTTagCompound tagCompound = itemStack.func_77942_o() ? itemStack.func_77978_p() : new NBTTagCompound();
                    tagCompound.func_74768_a("ticksInWater", this.ticksInWater);
                    itemStack.func_77982_d(tagCompound);
                }
            }
            if (this.ticksInWater >= ModuleHuntingConfig.IN_WORLD_HIDE_SOAK_TICKS) {
                ItemStack copy = this.transformedItem.func_77946_l();
                copy.func_190920_e(itemStack.func_190916_E());
                this.func_92058_a(copy);
            }
        }
    }

    public void func_70014_b(@Nonnull NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("ticksInWater", this.ticksInWater);
        compound.func_74782_a("transformedItem", (NBTBase)this.transformedItem.serializeNBT());
    }

    public void func_70037_a(@Nonnull NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.ticksInWater = compound.func_74762_e("ticksInWater");
        this.transformedItem = new ItemStack(compound.func_74775_l("transformedItem"));
    }
}

