/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.hunting;

import com.codetaylor.mc.athenaeum.integration.gamestages.Stages;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.item.Item;
import net.minecraftforge.common.config.Config;

@Config(modid="pyrotech", name="pyrotech/module.Hunting")
public class ModuleHuntingConfig {
    @Config.Ignore
    public static Stages STAGES_CARCASS = null;
    @Config.Ignore
    public static Stages STAGES_BUTCHERS_BLOCK = null;
    public static Spear SPEAR = new Spear();
    public static FlintArrow FLINT_ARROW = new FlintArrow();
    public static BoneArrow BONE_ARROW = new BoneArrow();
    public static Carcass CARCASS = new Carcass();
    public static Drops DROPS = new Drops();
    public static LeatherKits LEATHER_KITS = new LeatherKits();
    public static ButchersBlock BUTCHERS_BLOCK = new ButchersBlock();
    public static EntityMud ENTITY_MUD = new EntityMud();
    @Config.Comment(value={"The durability of the hunter's knives."})
    public static Map<String, Integer> HUNTERS_KNIFE_DURABILITY = new LinkedHashMap<String, Integer>();
    @Config.Comment(value={"Set to false to disable repair."})
    public static boolean ALLOW_HUNTERS_KNIFE_REPAIR;
    @Config.Comment(value={"The durability of the butcher's knives."})
    public static Map<String, Integer> BUTCHERS_KNIFE_DURABILITY;
    @Config.Comment(value={"Set to false to disable repair."})
    public static boolean ALLOW_BUTCHERS_KNIFE_REPAIR;
    @Config.Comment(value={"How much damage is applied to a Hunter's Knife when scraping a hide.", "Default: 2"})
    public static int HIDE_SCRAPING_TOOL_DAMAGE;
    @Config.Comment(value={"How many ticks are required to in-world soak a hide.", "Default: 12000"})
    public static int IN_WORLD_HIDE_SOAK_TICKS;

    static {
        HUNTERS_KNIFE_DURABILITY.put("bone", 150);
        HUNTERS_KNIFE_DURABILITY.put("flint", 150);
        HUNTERS_KNIFE_DURABILITY.put("stone", Item.ToolMaterial.STONE.func_77997_a());
        HUNTERS_KNIFE_DURABILITY.put("iron", Item.ToolMaterial.IRON.func_77997_a());
        HUNTERS_KNIFE_DURABILITY.put("gold", Item.ToolMaterial.GOLD.func_77997_a());
        HUNTERS_KNIFE_DURABILITY.put("diamond", Item.ToolMaterial.DIAMOND.func_77997_a());
        HUNTERS_KNIFE_DURABILITY.put("obsidian", 1400);
        ALLOW_HUNTERS_KNIFE_REPAIR = true;
        BUTCHERS_KNIFE_DURABILITY = new LinkedHashMap<String, Integer>();
        BUTCHERS_KNIFE_DURABILITY.put("bone", 150);
        BUTCHERS_KNIFE_DURABILITY.put("flint", 150);
        BUTCHERS_KNIFE_DURABILITY.put("stone", Item.ToolMaterial.STONE.func_77997_a());
        BUTCHERS_KNIFE_DURABILITY.put("iron", Item.ToolMaterial.IRON.func_77997_a());
        BUTCHERS_KNIFE_DURABILITY.put("gold", Item.ToolMaterial.GOLD.func_77997_a());
        BUTCHERS_KNIFE_DURABILITY.put("diamond", Item.ToolMaterial.DIAMOND.func_77997_a());
        BUTCHERS_KNIFE_DURABILITY.put("obsidian", 1400);
        ALLOW_BUTCHERS_KNIFE_REPAIR = true;
        HIDE_SCRAPING_TOOL_DAMAGE = 2;
        IN_WORLD_HIDE_SOAK_TICKS = 12000;
    }

    public static class EntityMud {
        @Config.Comment(value={"List of biomes to spawn this mob in."})
        public String[] SPAWN_BIOMES = new String[]{"minecraft:swampland", "minecraft:river"};
        @Config.Comment(value={"Spawn weight.", "Default: 100"})
        public int SPAWN_WEIGHT = 100;
        @Config.Comment(value={"Minimum spawn count.", "Default: 1"})
        public int SPAWN_COUNT_MIN = 1;
        @Config.Comment(value={"Maximum spawn count.", "Default: 3"})
        public int SPAWN_COUNT_MAX = 3;
    }

    public static class ButchersBlock {
        @Config.Comment(value={"Minimum amount of hunger the player needs to use.", "Default: 3"})
        @Config.RangeInt(min=0, max=20)
        public int MINIMUM_HUNGER_TO_USE = 3;
        @Config.Comment(value={"Use this to add items that you want to be valid butcher's knives.", "Items you add are assumed to have durability.", "", "String format is a resource location: (domain):(path)"})
        public String[] ALLOWED_BUTCHERS_KNIVES = new String[]{"pyrotech:bone_butchers_knife", "pyrotech:flint_butchers_knife", "pyrotech:stone_butchers_knife", "pyrotech:iron_butchers_knife", "pyrotech:gold_butchers_knife", "pyrotech:diamond_butchers_knife", "pyrotech:obsidian_butchers_knife"};
        @Config.Comment(value={"Use this to add items that you want to be valid hunter's knives.", "Items you add are assumed to have durability.", "", "String format is a resource location: (domain):(path)"})
        public String[] ALLOWED_HUNTERS_KNIVES = new String[]{"pyrotech:bone_hunters_knife", "pyrotech:flint_hunters_knife", "pyrotech:stone_hunters_knife", "pyrotech:iron_hunters_knife", "pyrotech:gold_hunters_knife", "pyrotech:diamond_hunters_knife", "pyrotech:obsidian_hunters_knife"};
        @Config.Comment(value={"How much exhaustion to apply per knife use.", "Default: 1.5"})
        @Config.RangeDouble(min=0.0, max=40.0)
        public double EXHAUSTION_COST_PER_KNIFE_USE = 0.75;
        @Config.Comment(value={"Total progress required to drop item +/- 10%.", "Default: 100"})
        @Config.RangeInt(min=1)
        public int TOTAL_PROGRESS_REQUIRED = 100;
        @Config.Comment(value={"How fast the progress will be advanced per knife. This number is added", "to the progress until it reaches the total progress required.", "", "String key format is (domain):(path)", "Integer value format is (efficiency)"})
        @Config.RequiresMcRestart
        public Map<String, Integer> KNIFE_EFFICIENCY = new HashMap<String, Integer>(){
            {
                this.put("pyrotech:bone_hunters_knife", 25);
                this.put("pyrotech:flint_hunters_knife", 25);
                this.put("pyrotech:stone_hunters_knife", 17);
                this.put("pyrotech:iron_hunters_knife", 34);
                this.put("pyrotech:gold_hunters_knife", 8);
                this.put("pyrotech:diamond_hunters_knife", 58);
                this.put("pyrotech:obsidian_hunters_knife", 34);
                this.put("pyrotech:bone_butchers_knife", 25);
                this.put("pyrotech:flint_butchers_knife", 25);
                this.put("pyrotech:stone_butchers_knife", 17);
                this.put("pyrotech:iron_butchers_knife", 34);
                this.put("pyrotech:gold_butchers_knife", 8);
                this.put("pyrotech:diamond_butchers_knife", 58);
                this.put("pyrotech:obsidian_butchers_knife", 34);
            }
        };
        @Config.Comment(value={"This map is used when a Butcher's Knife is used at the table.", "", "Transform an item into another item when it comes out of the carcass.", "By default the Butcher's Knife will increase the chance of getting a", "Ruined Pelt instead of a good pelt, increase the chance of getting a", "Bone instead of a Bone Shard, and increase the chance of getting twice", "as much meat.", "", "String key format is (domain):(path):(meta)", "String value format is (domain):(path):(meta);(count);(chance)"})
        @Config.RequiresMcRestart
        public Map<String, String> BUTCHERS_KNIFE_OUTPUT_TRANSFORMERS = new HashMap<String, String>(){
            {
                this.put("pyrotech:hide_pig:0", "pyrotech:pelt_ruined:0;1;0.85");
                this.put("pyrotech:pelt_cow:0", "pyrotech:pelt_ruined:0;1;0.85");
                this.put("pyrotech:pelt_mooshroom:0", "pyrotech:pelt_ruined:0;1;0.85");
                this.put("pyrotech:pelt_polar_bear:0", "pyrotech:pelt_ruined:0;1;0.85");
                this.put("pyrotech:pelt_bat:0", "pyrotech:pelt_ruined:0;1;0.85");
                this.put("pyrotech:pelt_horse:0", "pyrotech:pelt_ruined:0;1;0.85");
                this.put("minecraft:rabbit_hide:0", "pyrotech:pelt_ruined:0;1;0.85");
                this.put("pyrotech:pelt_wolf:0", "pyrotech:pelt_ruined:0;1;0.85");
                this.put("pyrotech:material:11", "minecraft:bone:0;1;0.5");
                this.put("minecraft:beef:0", "minecraft:beef:0;2;0.85");
                this.put("minecraft:chicken:0", "minecraft:chicken:0;2;0.85");
                this.put("minecraft:mutton:0", "minecraft:mutton:0;2;0.85");
                this.put("minecraft:rabbit:0", "minecraft:rabbit:0;2;0.85");
                this.put("minecraft:rabbit_foot:0", "minecraft:rabbit_foot:0;2;0.85");
                this.put("minecraft:porkchop:0", "minecraft:porkchop:0;2;0.85");
                this.put("minecraft:red_mushroom:0", "minecraft:red_mushroom:0;4;0.85");
                this.put("pyrotech:material:49", "pyrotech:material:49;2;0.85");
            }
        };
        @Config.Comment(value={"This map is used when a Hunter's Knife is used at the table.", "", "Transform an item into another item when it comes out of the carcass.", "By default the Hunter's Knife will increase the chance of getting a", "Tainted Meat instead of a good meat, increase the chance of getting more", "Bone Shards, and increase the chance of getting twice as many hides.", "", "String key format is (domain):(path):(meta)", "String value format is (domain):(path):(meta);(count);(chance)"})
        @Config.RequiresMcRestart
        public Map<String, String> HUNTERS_KNIFE_OUTPUT_TRANSFORMERS = new HashMap<String, String>(){
            {
                this.put("pyrotech:hide_pig:0", "pyrotech:hide_pig:0;2;0.85");
                this.put("pyrotech:pelt_cow:0", "pyrotech:pelt_cow:0;2;0.85");
                this.put("pyrotech:pelt_mooshroom:0", "pyrotech:pelt_mooshroom:0;2;0.85");
                this.put("pyrotech:pelt_polar_bear:0", "pyrotech:pelt_polar_bear:0;2;0.85");
                this.put("pyrotech:pelt_bat:0", "pyrotech:pelt_bat:0;2;0.85");
                this.put("pyrotech:pelt_horse:0", "pyrotech:pelt_horse:0;2;0.85");
                this.put("minecraft:rabbit_hide:0", "minecraft:rabbit_hide:0;2;0.85");
                this.put("pyrotech:pelt_wolf:0", "pyrotech:pelt_wolf:0;2;0.85");
                this.put("pyrotech:material:11", "pyrotech:material:11;2;0.5");
                this.put("minecraft:beef:0", "pyrotech:tainted_meat:0;1;0.85");
                this.put("minecraft:chicken:0", "pyrotech:tainted_meat:0;1;0.85");
                this.put("minecraft:mutton:0", "pyrotech:tainted_meat:0;1;0.85");
                this.put("minecraft:rabbit:0", "pyrotech:tainted_meat:0;1;0.85");
                this.put("minecraft:rabbit_foot:0", "minecraft:rabbit_foot:0;2;0.85");
                this.put("minecraft:porkchop:0", "pyrotech:tainted_meat:0;1;0.85");
                this.put("minecraft:red_mushroom:0", "minecraft:red_mushroom:0;4;0.85");
            }
        };
    }

    public static class LeatherKits {
        @Config.Comment(value={"The number of uses per leather repair kit.", "Default: 4"})
        public int LEATHER_REPAIR_KIT_USES = 4;
        @Config.Comment(value={"The number of uses per durable leather repair kit.", "Default: 8"})
        public int LEATHER_DURABLE_REPAIR_KIT_USES = 8;
        @Config.Comment(value={"The damage applied to the hunters knife when repairing leather armor with a kit.", "Default: 4"})
        public int HUNTERS_KNIFE_REPAIR_DAMAGE = 4;
        @Config.Comment(value={"The percentage of durability repaired.", "Default: 0.25"})
        public double PERCENTAGE_DURABILITY_REPAIRED = 0.25;
    }

    public static class Drops {
        @Config.Comment(value={"If true, leather drops will be removed from entity drops.", "Default: true"})
        public boolean REMOVE_LEATHER_DROPS = true;
        @Config.Comment(value={"Drops added here will be added to the mob drops and auto-captured by", "the carcass. The key is the entity resource location and the value", "is the drop. The count is an integer and the chance is a float.", "Meta is optional and defaults to 0.", "", "Sheep require special handling and aren't processed using the drop map.", "Llamas require special handling and aren't processed using the drop map.", "", "String key format is (domain):(path)", "String value format is (domain):(path):(meta);(count);(chance)", "Multiple values can be concatenated with &"})
        @Config.RequiresMcRestart
        public Map<String, String> DROP_MAP = new HashMap<String, String>(){
            {
                this.put("minecraft:pig", "pyrotech:hide_pig:0;1;0.85&pyrotech:material:11;2;0.50&pyrotech:material:49;2;0.50");
                this.put("minecraft:cow", "pyrotech:pelt_cow:0;1;0.85&pyrotech:material:11;2;0.50&pyrotech:material:49;2;0.50");
                this.put("minecraft:mooshroom", "pyrotech:pelt_mooshroom:0;1;0.65&pyrotech:material:11;2;0.50&pyrotech:material:49;2;0.50");
                this.put("minecraft:polar_bear", "pyrotech:pelt_polar_bear:0;1;0.85&pyrotech:material:11;2;0.50&pyrotech:material:49;3;0.50");
                this.put("minecraft:bat", "pyrotech:pelt_bat:0;1;0.65");
                this.put("minecraft:horse", "pyrotech:pelt_horse:0;1;0.85&pyrotech:material:11;2;0.50&pyrotech:material:49;2;0.50");
                this.put("minecraft:donkey", "pyrotech:pelt_horse:0;1;0.85&pyrotech:material:11;2;0.50&pyrotech:material:49;1;0.50");
                this.put("minecraft:rabbit", "minecraft:rabbit_hide:0;1;0.65&pyrotech:material:11;1;0.25&pyrotech:material:49;1;0.50");
                this.put("minecraft:wolf", "pyrotech:pelt_wolf:0;1;0.85&pyrotech:material:11;2;0.50&pyrotech:material:49;1;0.50");
            }
        };
        @Config.Comment(value={"Items added to this list will be captured by the carcass.", "Meta is optional and defaults to 0.", "", "String format is (domain):(path):(meta)"})
        @Config.RequiresMcRestart
        public String[] DROP_CAPTURE_LIST = new String[]{"minecraft:beef", "minecraft:chicken", "minecraft:mutton", "minecraft:rabbit", "minecraft:rabbit_foot", "minecraft:porkchop", "minecraft:red_mushroom"};
        @Config.Comment(value={"Sheep require special handling and aren't processed using the drop map.", "This is the chance that a sheep pelt will drop.", "Default: 0.85"})
        public double SHEEP_PELT_CHANCE = 0.85;
        @Config.Comment(value={"Sheep require special handling and aren't processed using the drop map.", "This is the amount of sheep pelts that will drop.", "Default: 1"})
        public int SHEEP_PELT_COUNT = 1;
        @Config.Comment(value={"Llamas require special handling and aren't processed using the drop map.", "This is the chance that a llama pelt will drop.", "Default: 0.85"})
        public double LLAMA_PELT_CHANCE = 0.85;
        @Config.Comment(value={"Llama require special handling and aren't processed using the drop map.", "This is the amount of llama pelts that will drop.", "Default: 1"})
        public int LLAMA_PELT_COUNT = 1;
    }

    public static class Carcass {
        @Config.Comment(value={"Minimum amount of hunger the player needs to use.", "Default: 3"})
        @Config.RangeInt(min=0, max=20)
        public int MINIMUM_HUNGER_TO_USE = 3;
        @Config.Comment(value={"Use this to add items that you want to be valid knives.", "Items you add are assumed to have durability.", "", "String format is a resource location: (domain):(path)"})
        public String[] ALLOWED_KNIVES = new String[]{"pyrotech:bone_hunters_knife", "pyrotech:flint_hunters_knife", "pyrotech:stone_hunters_knife", "pyrotech:iron_hunters_knife", "pyrotech:gold_hunters_knife", "pyrotech:diamond_hunters_knife", "pyrotech:obsidian_hunters_knife", "pyrotech:bone_butchers_knife", "pyrotech:flint_butchers_knife", "pyrotech:stone_butchers_knife", "pyrotech:iron_butchers_knife", "pyrotech:gold_butchers_knife", "pyrotech:diamond_butchers_knife", "pyrotech:obsidian_butchers_knife"};
        @Config.Comment(value={"How much exhaustion to apply per knife use.", "Default: 1.5"})
        @Config.RangeDouble(min=0.0, max=40.0)
        public double EXHAUSTION_COST_PER_KNIFE_USE = 1.5;
        @Config.Comment(value={"Total progress required to drop item +/- 10%.", "Default: 100"})
        @Config.RangeInt(min=1)
        public int TOTAL_PROGRESS_REQUIRED = 100;
        @Config.Comment(value={"How fast the progress will be advanced per knife. This number is added", "to the progress until it reaches the total progress required.", "", "String key format is (domain):(path)", "Integer value format is (efficiency)"})
        @Config.RequiresMcRestart
        public Map<String, Integer> KNIFE_EFFICIENCY = new HashMap<String, Integer>(){
            {
                this.put("pyrotech:bone_hunters_knife", 15);
                this.put("pyrotech:flint_hunters_knife", 15);
                this.put("pyrotech:stone_hunters_knife", 10);
                this.put("pyrotech:iron_hunters_knife", 20);
                this.put("pyrotech:gold_hunters_knife", 5);
                this.put("pyrotech:diamond_hunters_knife", 35);
                this.put("pyrotech:obsidian_hunters_knife", 20);
                this.put("pyrotech:bone_butchers_knife", 15);
                this.put("pyrotech:flint_butchers_knife", 15);
                this.put("pyrotech:stone_butchers_knife", 10);
                this.put("pyrotech:iron_butchers_knife", 20);
                this.put("pyrotech:gold_butchers_knife", 5);
                this.put("pyrotech:diamond_butchers_knife", 35);
                this.put("pyrotech:obsidian_butchers_knife", 20);
            }
        };
    }

    public static class BoneArrow {
        @Config.Comment(value={"Chance to break when the arrow hits a block.", "This chance is modified by the speed of the arrow.", "Default: 0.75"})
        @Config.RangeDouble(min=0.0, max=1.0)
        public double BREAK_ON_HIT_CHANCE = 0.75;
        @Config.Comment(value={"Chance to drop materials when arrow breaks after hitting a block.", "Default: 0.5"})
        @Config.RangeDouble(min=0.0, max=1.0)
        public double MATERIAL_DROP_CHANCE = 0.5;
        @Config.Comment(value={"Stack size.", "Default: 16"})
        @Config.RangeInt(min=1, max=64)
        public int STACK_SIZE = 16;
        @Config.Comment(value={"Damage.", "For reference, the vanilla arrow does 2.0 damage.", "Default: 1"})
        @Config.RangeDouble(min=0.0)
        public double DAMAGE = 1.0;
    }

    public static class FlintArrow {
        @Config.Comment(value={"Chance to break when the arrow hits a block.", "This chance is modified by the speed of the arrow.", "Default: 0.75"})
        @Config.RangeDouble(min=0.0, max=1.0)
        public double BREAK_ON_HIT_CHANCE = 0.75;
        @Config.Comment(value={"Chance to drop materials when arrow breaks after hitting a block.", "Default: 0.5"})
        @Config.RangeDouble(min=0.0, max=1.0)
        public double MATERIAL_DROP_CHANCE = 0.5;
        @Config.Comment(value={"Stack size.", "Default: 16"})
        @Config.RangeInt(min=1, max=64)
        public int STACK_SIZE = 16;
        @Config.Comment(value={"Damage.", "For reference, the vanilla arrow does 2.0 damage.", "Default: 1"})
        @Config.RangeDouble(min=0.0)
        public double DAMAGE = 1.0;
    }

    public static class Spear {
        @Config.Comment(value={"Durability.", "(Integer)"})
        public Map<String, Integer> DURABILITY = new HashMap<String, Integer>(){
            {
                this.put("crude", 16);
                this.put("flint", 32);
                this.put("bone", 32);
            }
        };
        @Config.Comment(value={"Damage when thrown.", "For reference, the vanilla arrow does 2 damage.", "(Double)"})
        public Map<String, Double> THROWN_DAMAGE = new HashMap<String, Double>(){
            {
                this.put("crude", 2.0);
                this.put("flint", 4.0);
                this.put("bone", 4.0);
            }
        };
        @Config.Comment(value={"Increase this number to decrease the spear's accuracy.", "For reference, the vanilla arrow has an inaccuracy of 1.", "(Double)"})
        public Map<String, Double> INACCURACY = new HashMap<String, Double>(){
            {
                this.put("crude", 2.0);
                this.put("flint", 1.0);
                this.put("bone", 1.0);
            }
        };
        @Config.Comment(value={"The velocity scalar.", "For reference, the vanilla arrow has a velocity scalar of 3.", "(Double)"})
        public Map<String, Double> VELOCITY_SCALAR = new HashMap<String, Double>(){
            {
                this.put("crude", 1.0);
                this.put("flint", 2.0);
                this.put("bone", 2.0);
            }
        };
    }
}

