/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.core.recipe;

import com.codetaylor.mc.athenaeum.util.OreDictHelper;
import com.codetaylor.mc.athenaeum.util.RandomHelper;
import com.codetaylor.mc.pyrotech.modules.tool.ModuleTool;
import com.codetaylor.mc.pyrotech.modules.tool.ModuleToolConfig;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import javax.annotation.Nonnull;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IRecipeFactory;
import net.minecraftforge.common.crafting.JsonContext;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class BoneToolRepairRecipe
extends ShapelessOreRecipe {
    private final double repairPercentage;

    public BoneToolRepairRecipe(ResourceLocation group, NonNullList<Ingredient> input, @Nonnull ItemStack result, double repairPercentage) {
        super(group, input, result);
        this.repairPercentage = repairPercentage;
        this.isSimple = false;
    }

    @Nonnull
    public ItemStack func_77572_b(@Nonnull InventoryCrafting inventoryCrafting) {
        int size = inventoryCrafting.func_70302_i_();
        Item outputItem = this.output.func_77973_b();
        for (int i = 0; i < size; ++i) {
            ItemStack itemStack = inventoryCrafting.func_70301_a(i);
            if (itemStack.func_77973_b() != outputItem) continue;
            if (itemStack.func_77952_i() == 0) {
                return ItemStack.field_190927_a;
            }
            ItemStack copy = itemStack.func_77946_l();
            copy.func_77964_b(Math.max(0, copy.func_77952_i() - (int)((double)copy.func_77958_k() * this.repairPercentage)));
            return copy;
        }
        return ItemStack.field_190927_a;
    }

    @Nonnull
    public NonNullList<ItemStack> func_179532_b(InventoryCrafting inv) {
        ItemStack itemStack;
        int i;
        NonNullList result = NonNullList.func_191197_a((int)inv.func_70302_i_(), (Object)ItemStack.field_190927_a);
        int hammerRepairDamage = 0;
        for (i = 0; i < result.size(); ++i) {
            itemStack = inv.func_70301_a(i);
            Item item = itemStack.func_77973_b();
            if (item != ModuleTool.Items.BONE_TOOL_REPAIR_KIT) continue;
            hammerRepairDamage = ModuleToolConfig.BONE_TOOL_REPAIR_KIT.HAMMER_REPAIR_DAMAGE;
        }
        for (i = 0; i < result.size(); ++i) {
            itemStack = inv.func_70301_a(i);
            if (OreDictHelper.contains((String)"toolHammer", (ItemStack)itemStack)) {
                if ((itemStack = itemStack.func_77946_l()).func_96631_a(hammerRepairDamage, RandomHelper.random(), null)) {
                    itemStack.func_190918_g(1);
                }
                result.set(i, (Object)itemStack);
                continue;
            }
            if (itemStack.func_77973_b() == ModuleTool.Items.BONE_TOOL_REPAIR_KIT) {
                if ((itemStack = itemStack.func_77946_l()).func_96631_a(1, RandomHelper.random(), null)) {
                    itemStack.func_190918_g(1);
                }
                result.set(i, (Object)itemStack);
                continue;
            }
            ItemStack containerItem = ForgeHooks.getContainerItem((ItemStack)itemStack);
            result.set(i, (Object)containerItem);
        }
        return result;
    }

    public static class Factory
    implements IRecipeFactory {
        public IRecipe parse(JsonContext context, JsonObject json) {
            String group = JsonUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
            NonNullList ingredients = NonNullList.func_191196_a();
            for (JsonElement ele : JsonUtils.func_151214_t((JsonObject)json, (String)"ingredients")) {
                ingredients.add((Object)CraftingHelper.getIngredient((JsonElement)ele, (JsonContext)context));
            }
            if (ingredients.isEmpty()) {
                throw new JsonParseException("No ingredients for shapeless recipe");
            }
            ItemStack itemstack = CraftingHelper.getItemStack((JsonObject)JsonUtils.func_152754_s((JsonObject)json, (String)"result"), (JsonContext)context);
            return new BoneToolRepairRecipe(group.isEmpty() ? null : new ResourceLocation(group), (NonNullList<Ingredient>)ingredients, itemstack, ModuleToolConfig.BONE_TOOL_REPAIR_KIT.PERCENTAGE_DURABILITY_REPAIRED);
        }
    }
}

