/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.core.init;

import com.codetaylor.mc.athenaeum.util.OreDictHelper;
import com.codetaylor.mc.pyrotech.library.JsonInitializer;
import com.codetaylor.mc.pyrotech.modules.core.ModuleCore;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public final class CompatInitializerWood {
    public static void create(Path configurationPath) {
        JsonInitializer.create(configurationPath.resolve("pyrotech"), "core.compat.Wood-Generated.json", "core.compat.Wood-Custom.json", () -> CompatInitializerWood.createGeneratedData(new WoodCompatData()), ModuleCore.LOGGER);
    }

    @Nullable
    public static WoodCompatData read(Path configurationPath) {
        return JsonInitializer.read(configurationPath.resolve("pyrotech"), "core.compat.Wood-Custom.json", WoodCompatData.class, null);
    }

    private static WoodCompatData createGeneratedData(WoodCompatData data) {
        Collection recipes = ForgeRegistries.RECIPES.getValuesCollection();
        block0: for (IRecipe recipe : recipes) {
            NonNullList ingredients = recipe.func_192400_c();
            if (ingredients.size() == 1) {
                ItemStack output;
                ItemStack input;
                Ingredient ingredient = (Ingredient)ingredients.get(0);
                ItemStack[] matchingStacks = ingredient.func_193365_a();
                if (matchingStacks.length != 1 || !OreDictHelper.contains((String)"logWood", (ItemStack)(input = matchingStacks[0])) || !OreDictHelper.contains((String)"plankWood", (ItemStack)(output = recipe.func_77571_b()))) continue;
                CompatInitializerWood.generateEntry(data, recipe, input, output);
                continue;
            }
            if (ingredients.size() != 3) continue;
            ItemStack input = null;
            for (int i = 0; i < 3; ++i) {
                Ingredient ingredient = (Ingredient)ingredients.get(i);
                ItemStack[] matchingStacks = ingredient.func_193365_a();
                if (matchingStacks.length != 1 || !OreDictHelper.contains((String)"plankWood", (ItemStack)matchingStacks[0])) continue block0;
                if (input == null) {
                    input = matchingStacks[0];
                    continue;
                }
                if (input.func_77973_b() != matchingStacks[0].func_77973_b() || input.func_77960_j() != matchingStacks[0].func_77960_j()) continue block0;
            }
            ItemStack output = recipe.func_77571_b();
            if (!OreDictHelper.contains((String)"slabWood", (ItemStack)output)) continue;
            CompatInitializerWood.generateEntry(data, recipe, input, output);
        }
        return data;
    }

    private static void generateEntry(WoodCompatData data, IRecipe recipe, ItemStack input, ItemStack output) {
        ResourceLocation recipeRegistryName = recipe.getRegistryName();
        if (recipeRegistryName == null) {
            return;
        }
        ResourceLocation inputRegistryName = input.func_77973_b().getRegistryName();
        if (inputRegistryName == null) {
            return;
        }
        String inputResourcePath = inputRegistryName.func_110623_a();
        String inputResourceDomain = inputRegistryName.func_110624_b();
        ResourceLocation outputRegistryName = output.func_77973_b().getRegistryName();
        if (outputRegistryName == null) {
            return;
        }
        String outputResourcePath = outputRegistryName.func_110623_a();
        String outputResourceDomain = outputRegistryName.func_110624_b();
        String inputString = inputResourceDomain + ":" + inputResourcePath + ":" + input.func_77960_j();
        if (data.entries.containsKey(inputString)) {
            ModuleCore.LOGGER.warn("Duplicate recipe input item found, skipping recipe: " + recipeRegistryName);
            return;
        }
        data.entries.put(inputString, outputResourceDomain + ":" + outputResourcePath + ":" + output.func_77960_j());
    }

    private CompatInitializerWood() {
    }

    public static class WoodCompatData {
        private String[] __comments = new String[]{"WARNING: All changes should be made to the file with the name Custom", "in the title. Changes made to the Generated file will be overwritten.", "", "This file defines input and output pairs for auto-generating recipes", "for the Chopping Block.", "", "Entries are in the format (input): (output)", "Entry item strings are in the format: (domain):(path):(meta)"};
        public Map<String, String> entries = new TreeMap<String, String>();
    }
}

