/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.core.init;

import com.codetaylor.mc.pyrotech.library.JsonInitializer;
import com.codetaylor.mc.pyrotech.modules.core.ModuleCore;
import com.codetaylor.mc.pyrotech.modules.core.ModuleCoreConfig;
import com.codetaylor.mc.pyrotech.modules.tech.bloomery.init.recipe.BloomeryRecipesAdd;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.oredict.OreDictionary;

public final class CompatInitializerOre {
    public static void create(Path configurationPath) {
        JsonInitializer.create(configurationPath.resolve("pyrotech"), "core.compat.Ore-Generated.json", "core.compat.Ore-Custom.json", () -> CompatInitializerOre.createGeneratedData(new OreCompatData()), ModuleCore.LOGGER);
    }

    @Nullable
    public static OreCompatData read(Path configurationPath) {
        return JsonInitializer.read(configurationPath.resolve("pyrotech"), "core.compat.Ore-Custom.json", OreCompatData.class, null);
    }

    private static OreCompatData createGeneratedData(OreCompatData data) {
        for (Map.Entry<String, String> entry : ModuleCoreConfig.ORE_COMPAT.OREDICT_COLOR_MAP.entrySet()) {
            Object itemStack2;
            String nuggetKey;
            NonNullList nuggetItemStacks;
            String oreKey = entry.getKey();
            NonNullList oreItemStacks = OreDictionary.getOres((String)oreKey);
            if (oreItemStacks.isEmpty() || (nuggetItemStacks = OreDictionary.getOres((String)(nuggetKey = oreKey.replaceAll("ore", "nugget")))).isEmpty()) continue;
            ArrayList<String> langKeys = new ArrayList<String>();
            for (Object itemStack2 : oreItemStacks) {
                Item item = itemStack2.func_77973_b();
                ResourceLocation registryName = item.getRegistryName();
                if (registryName == null) continue;
                String unlocalizedName = registryName.func_110624_b() + ":" + item.func_77667_c((ItemStack)itemStack2);
                if (unlocalizedName.endsWith(".name")) {
                    unlocalizedName = unlocalizedName.substring(0, unlocalizedName.length() - 5);
                }
                langKeys.add(unlocalizedName);
            }
            Collections.sort(langKeys);
            ArrayList<String> nuggetItemStrings = new ArrayList<String>();
            itemStack2 = nuggetItemStacks.iterator();
            while (itemStack2.hasNext()) {
                ItemStack itemStack3 = (ItemStack)itemStack2.next();
                Item item = itemStack3.func_77973_b();
                ResourceLocation registryName = item.getRegistryName();
                if (registryName == null) continue;
                String itemString = registryName.func_110624_b() + ":" + registryName.func_110623_a() + ":" + itemStack3.func_77960_j();
                nuggetItemStrings.add(itemString);
            }
            Collections.sort(nuggetItemStrings);
            OreCompatEntry oreCompatEntry = data.oredict.computeIfAbsent(oreKey, s -> new OreCompatEntry());
            oreCompatEntry.slagColor = entry.getValue();
            oreCompatEntry.langKey = langKeys.toArray(new String[0]);
            oreCompatEntry.output = nuggetItemStrings.toArray(new String[0]);
        }
        return data;
    }

    private CompatInitializerOre() {
    }

    public static class OreCompatEntry {
        public String slagColor = "ffffff";
        public String[] langKey = new String[0];
        public String[] output = new String[0];
        public int[] bloomYieldMinMax = BloomeryRecipesAdd.DEFAULT_BLOOM_YIELD_MIN_MAX;
        public int[] slagBloomYieldMinMax = BloomeryRecipesAdd.DEFAULT_SLAG_BLOOM_YIELD_MIN_MAX;
    }

    public static class OreCompatData {
        private String[] __comments = new String[]{"WARNING: All changes should be made to the file with the name Custom", "in the title. Changes made to the Generated file will be overwritten.", "", "This file defines ore compatibility.", "", "Slag content will be generated for each oredict entry.", "", "The first valid key in each langKey list will be chosen; reorder keys", "to change which key is selected.", "", "The first valid nugget in each output list will be chosen; reorder nuggets", "to change which nugget is selected.", "", "Slag color is a hex color code without the #", "", "Lang keys are in the format: (domain):(key)", "", "Output item strings are in the format: (domain):(path):(meta)"};
        public Map<String, OreCompatEntry> oredict = new TreeMap<String, OreCompatEntry>();
    }
}

