/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.core.block;

import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockSlagGlass
extends Block {
    public static final String NAME = "slag_glass";
    public static final PropertyBool CONNECTED_DOWN = PropertyBool.func_177716_a((String)"connected_down");
    public static final PropertyBool CONNECTED_UP = PropertyBool.func_177716_a((String)"connected_up");
    public static final PropertyBool CONNECTED_NORTH = PropertyBool.func_177716_a((String)"connected_north");
    public static final PropertyBool CONNECTED_SOUTH = PropertyBool.func_177716_a((String)"connected_south");
    public static final PropertyBool CONNECTED_WEST = PropertyBool.func_177716_a((String)"connected_west");
    public static final PropertyBool CONNECTED_EAST = PropertyBool.func_177716_a((String)"connected_east");

    public BlockSlagGlass() {
        super(Material.field_151592_s);
        this.func_149672_a(SoundType.field_185853_f);
        this.func_149711_c(0.3f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)CONNECTED_DOWN, (Comparable)Boolean.FALSE).func_177226_a((IProperty)CONNECTED_EAST, (Comparable)Boolean.FALSE).func_177226_a((IProperty)CONNECTED_NORTH, (Comparable)Boolean.FALSE).func_177226_a((IProperty)CONNECTED_SOUTH, (Comparable)Boolean.FALSE).func_177226_a((IProperty)CONNECTED_UP, (Comparable)Boolean.FALSE).func_177226_a((IProperty)CONNECTED_WEST, (Comparable)Boolean.FALSE));
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{CONNECTED_DOWN, CONNECTED_UP, CONNECTED_NORTH, CONNECTED_SOUTH, CONNECTED_WEST, CONNECTED_EAST});
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P();
    }

    @Nonnull
    public IBlockState func_176221_a(@Nonnull IBlockState state, IBlockAccess world, BlockPos position) {
        return state.func_177226_a((IProperty)CONNECTED_DOWN, (Comparable)Boolean.valueOf(this.isConnected(world, position, EnumFacing.DOWN))).func_177226_a((IProperty)CONNECTED_EAST, (Comparable)Boolean.valueOf(this.isConnected(world, position, EnumFacing.EAST))).func_177226_a((IProperty)CONNECTED_NORTH, (Comparable)Boolean.valueOf(this.isConnected(world, position, EnumFacing.NORTH))).func_177226_a((IProperty)CONNECTED_SOUTH, (Comparable)Boolean.valueOf(this.isConnected(world, position, EnumFacing.SOUTH))).func_177226_a((IProperty)CONNECTED_UP, (Comparable)Boolean.valueOf(this.isConnected(world, position, EnumFacing.UP))).func_177226_a((IProperty)CONNECTED_WEST, (Comparable)Boolean.valueOf(this.isConnected(world, position, EnumFacing.WEST)));
    }

    private boolean isConnected(IBlockAccess world, BlockPos pos, EnumFacing side) {
        IBlockState original = world.func_180495_p(pos);
        IBlockState connected = world.func_180495_p(pos.func_177972_a(side));
        return this.canConnect(original, connected);
    }

    private boolean canConnect(IBlockState original, IBlockState connected) {
        return connected.func_177230_c() == original.func_177230_c();
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, @Nonnull IBlockAccess blockAccess, @Nonnull BlockPos pos, EnumFacing side) {
        IBlockState otherBlockState = blockAccess.func_180495_p(pos.func_177972_a(side));
        Block block = otherBlockState.func_177230_c();
        if (block == this) {
            return false;
        }
        return super.func_176225_a(blockState, blockAccess, pos, side);
    }
}

