/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.core.block;

import com.codetaylor.mc.athenaeum.spi.BlockPartialBase;
import com.codetaylor.mc.pyrotech.modules.core.ModuleCore;
import com.codetaylor.mc.pyrotech.modules.core.block.BlockRock;
import com.codetaylor.mc.pyrotech.modules.hunting.entity.EntityMud;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockMudLayer
extends BlockPartialBase {
    public static final String NAME = "mud_layer";
    private static final AxisAlignedBB AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.25, 1.0);
    private static final AxisAlignedBB COLLISION_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.0, 1.0);

    public BlockMudLayer() {
        super(Material.field_151585_k);
        this.func_149672_a(SoundType.field_185859_l);
        this.func_149711_c(0.1f);
        this.setHarvestLevel("shovel", 0);
    }

    @ParametersAreNonnullByDefault
    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        if (entity instanceof EntityMud) {
            entity.field_70159_w *= 1.05;
            entity.field_70179_y *= 1.05;
        } else {
            entity.field_70159_w *= 0.4;
            entity.field_70179_y *= 0.4;
        }
    }

    @ParametersAreNonnullByDefault
    @Nonnull
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB;
    }

    @ParametersAreNonnullByDefault
    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return COLLISION_AABB;
    }

    @ParametersAreNonnullByDefault
    public boolean func_176205_b(IBlockAccess world, BlockPos pos) {
        return true;
    }

    public boolean func_185481_k(@Nonnull IBlockState state) {
        return false;
    }

    @Nonnull
    public BlockFaceShape func_193383_a(IBlockAccess blockAccess, IBlockState state, BlockPos pos, EnumFacing facing) {
        return facing == EnumFacing.DOWN ? BlockFaceShape.SOLID : BlockFaceShape.UNDEFINED;
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos.func_177977_b());
        Block block = state.func_177230_c();
        if (block == this) {
            return false;
        }
        if (block == Blocks.field_180401_cv) {
            return false;
        }
        if (!block.func_149730_j(state) || !block.func_149686_d(state)) {
            return false;
        }
        if (world.func_175623_d(pos.func_177977_b())) {
            return false;
        }
        BlockFaceShape blockfaceshape = state.func_193401_d((IBlockAccess)world, pos.func_177977_b(), EnumFacing.UP);
        return blockfaceshape == BlockFaceShape.SOLID;
    }

    @ParametersAreNonnullByDefault
    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        if (!this.func_176196_c(world, pos)) {
            world.func_175655_b(pos, true);
        }
    }

    @ParametersAreNonnullByDefault
    public void func_180657_a(World world, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity tile, ItemStack stack) {
        super.func_180657_a(world, player, pos, state, tile, stack);
        world.func_175698_g(pos);
    }

    @ParametersAreNonnullByDefault
    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        drops.add((Object)new ItemStack((Item)ModuleCore.Items.ROCK, 2, BlockRock.EnumType.MUD.getMeta()));
    }

    @ParametersAreNonnullByDefault
    public boolean func_176200_f(IBlockAccess world, BlockPos pos) {
        return true;
    }
}

