/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.core.block;

import com.codetaylor.mc.athenaeum.util.RandomHelper;
import com.codetaylor.mc.athenaeum.util.StackHelper;
import com.codetaylor.mc.pyrotech.modules.core.ModuleCore;
import com.codetaylor.mc.pyrotech.modules.core.ModuleCoreConfig;
import com.codetaylor.mc.pyrotech.modules.core.block.spi.BlockBushBase;
import com.codetaylor.mc.pyrotech.modules.core.network.SCPacketParticleBoneMeal;
import com.codetaylor.mc.pyrotech.modules.core.network.SCPacketParticleGloamberry;
import java.util.Random;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class BlockGloamberryBush
extends BlockBushBase {
    public static final String NAME = "gloamberry_bush";

    @Override
    public boolean isValidBlock(IBlockState blockState) {
        return (blockState.func_185904_a() == Material.field_151578_c || blockState.func_185904_a() == Material.field_151577_b) && blockState.func_185913_b();
    }

    @Override
    public Item getSeedItem() {
        return ModuleCore.Items.GLOAMBERRY_SEEDS;
    }

    @ParametersAreNonnullByDefault
    public void func_180663_b(World world, BlockPos pos, IBlockState blockState) {
        super.func_180663_b(world, pos, blockState);
        if (!world.field_72995_K) {
            switch (this.getAge(blockState)) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    break;
                }
                default: {
                    this.spawnParticles(pos, world.field_73011_w.getDimension());
                    this.playSound(world, pos);
                }
            }
        }
    }

    @ParametersAreNonnullByDefault
    public boolean func_180639_a(World world, BlockPos pos, IBlockState blockState, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (hand == EnumHand.MAIN_HAND) {
            ItemStack itemStack = player.func_184614_ca();
            Item item = itemStack.func_77973_b();
            if (item == Items.field_151100_aR && EnumDyeColor.WHITE == EnumDyeColor.func_176766_a((int)itemStack.func_77960_j())) {
                int age = this.getAge(blockState);
                if (!world.func_72935_r() && age < this.getMaxAge() && ForgeHooks.onCropsGrowPre((World)world, (BlockPos)pos, (IBlockState)blockState, (boolean)true)) {
                    if (!player.func_184812_l_() && !player.func_175149_v()) {
                        itemStack.func_190920_e(itemStack.func_190916_E() - 1);
                    }
                } else {
                    return !this.isMaxAge(blockState);
                }
                world.func_180501_a(pos, this.withAge(age + 1), 2);
                ModuleCore.PACKET_SERVICE.sendToAllAround((IMessage)new SCPacketParticleBoneMeal(pos, 4), world.field_73011_w.getDimension(), pos);
                ForgeHooks.onCropsGrowPost((World)world, (BlockPos)pos, (IBlockState)blockState, (IBlockState)world.func_180495_p(pos));
                return true;
            }
            if (item == Items.field_190931_a && this.isMaxAge(blockState)) {
                this.spawnParticles(pos, world.field_73011_w.getDimension());
                if (!world.field_72995_K) {
                    world.func_180501_a(pos, this.withAge(this.getAge(blockState) - 1), 2);
                    StackHelper.spawnStackOnTop((World)world, (ItemStack)new ItemStack((Item)ModuleCore.Items.GLOAMBERRIES), (BlockPos)pos);
                    this.playSound(world, pos);
                }
                return true;
            }
        }
        return super.func_180639_a(world, pos, blockState, player, hand, facing, hitX, hitY, hitZ);
    }

    @ParametersAreNonnullByDefault
    public void func_180649_a(World world, BlockPos pos, EntityPlayer player) {
        super.func_180649_a(world, pos, player);
        if (this.getAge(world.func_180495_p(pos)) == this.getMaxAge()) {
            this.spawnParticles(pos, world.field_73011_w.getDimension());
        }
    }

    @ParametersAreNonnullByDefault
    public void func_176199_a(World world, BlockPos pos, Entity entity) {
        super.func_176199_a(world, pos, entity);
        if ((double)RandomHelper.random().nextFloat() < 0.05 && this.getAge(world.func_180495_p(pos)) == this.getMaxAge()) {
            this.spawnParticles(pos, world.field_73011_w.getDimension());
        }
    }

    private void playSound(World world, BlockPos pos) {
        if ((double)RandomHelper.random().nextFloat() < 0.25) {
            world.func_184148_a(null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundEvents.field_191264_hc, SoundCategory.BLOCKS, 0.75f, 1.0f);
        }
    }

    private void spawnParticles(BlockPos pos, int dimension) {
        ModuleCore.PACKET_SERVICE.sendToAllAround((IMessage)new SCPacketParticleGloamberry((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, 0.5, 0.5, 0.5), dimension, pos);
    }

    @ParametersAreNonnullByDefault
    public void func_180650_b(World world, BlockPos pos, IBlockState blockState, Random rand) {
        this.checkAndDropBlock(world, pos);
        if (world.func_72935_r() && this.isMaxAge(blockState) && (double)RandomHelper.random().nextFloat() < ModuleCoreConfig.GLOAMBERRY_BUSH.DAYTIME_BERRY_LOSS_CHANCE) {
            world.func_180501_a(pos, this.withAge(this.getAge(blockState) - 1), 2);
        } else if (!world.func_72935_r()) {
            int age = this.getAge(blockState);
            boolean grew = false;
            if (age < this.getMaxAge()) {
                double chance;
                double d = chance = age == this.getMaxAge() - 1 ? ModuleCoreConfig.GLOAMBERRY_BUSH.BERRY_GROWTH_CHANCE : ModuleCoreConfig.GLOAMBERRY_BUSH.GROWTH_CHANCE;
                if (!world.func_175678_i(pos)) {
                    chance *= ModuleCoreConfig.GLOAMBERRY_BUSH.OBSTRUCTED_GROWTH_MULTIPLICATIVE_MODIFIER;
                }
                if (ForgeHooks.onCropsGrowPre((World)world, (BlockPos)pos, (IBlockState)blockState, ((double)rand.nextFloat() < chance ? 1 : 0) != 0)) {
                    world.func_180501_a(pos, this.withAge(age + 1), 2);
                    grew = true;
                    ForgeHooks.onCropsGrowPost((World)world, (BlockPos)pos, (IBlockState)blockState, (IBlockState)world.func_180495_p(pos));
                }
            }
            if (age > 2 && grew || this.isMaxAge(blockState) && (double)rand.nextFloat() < 0.5) {
                this.spawnParticles(pos, world.field_73011_w.getDimension());
                this.playSound(world, pos);
            }
        }
    }
}

