/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.library.spi.interaction;

import com.codetaylor.mc.athenaeum.interaction.spi.InteractionBucketBase;
import com.codetaylor.mc.athenaeum.util.ArrayHelper;
import com.codetaylor.mc.athenaeum.util.SoundHelper;
import com.codetaylor.mc.pyrotech.modules.core.ModuleCoreConfig;
import com.codetaylor.mc.pyrotech.modules.tech.basic.block.BlockCampfire;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class InteractionExtinguishable<T extends TileEntity>
extends InteractionBucketBase<T> {
    private final Allow<T> allow;
    private final Action<T> action;
    private final boolean playSound;

    public InteractionExtinguishable(Allow<T> allow, Action<T> action) {
        this(allow, action, true);
    }

    public InteractionExtinguishable(Allow<T> allow, Action<T> action, boolean playSound) {
        super((IFluidHandler)new FluidTank(1000){

            public boolean canFillFluidType(FluidStack fluid) {
                return fluid != null && ArrayHelper.contains((Object[])ModuleCoreConfig.VALID_DOUSING_FLUIDS, (Object)fluid.getFluid().getName());
            }

            public int fillInternal(FluidStack resource, boolean doFill) {
                int filled = super.fillInternal(resource, doFill);
                this.setFluid(null);
                return filled;
            }
        }, EnumFacing.field_82609_l, BlockCampfire.AABB_FULL);
        this.allow = allow;
        this.action = action;
        this.playSound = playSound;
    }

    protected boolean allowInteraction(T tile, World world, BlockPos hitPos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing hitSide, float hitX, float hitY, float hitZ) {
        return super.allowInteraction(tile, world, hitPos, state, player, hand, hitSide, hitX, hitY, hitZ) && this.allow.apply(tile);
    }

    protected boolean doInteraction(T tile, World world, BlockPos hitPos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing hitSide, float hitX, float hitY, float hitZ) {
        if (super.doInteraction(tile, world, hitPos, state, player, hand, hitSide, hitX, hitY, hitZ)) {
            this.action.apply(tile);
            if (this.playSound && !world.field_72995_K) {
                SoundHelper.playSoundServer((World)world, (BlockPos)tile.func_174877_v(), (SoundEvent)SoundEvents.field_187646_bt, (SoundCategory)SoundCategory.BLOCKS);
            }
            return true;
        }
        return false;
    }

    public static interface Action<T> {
        public void apply(T var1);
    }

    public static interface Allow<T> {
        public boolean apply(T var1);
    }
}

